/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import GUI.AuthenticationDialog;
import GUI.ClusteredServersDialog;
import GUI.JLogger;
import GUI.LDAP.LDAPLoginDialog;
import GUI.LDAP.MSMServerDiscovery;
import GUI.MainFrame;
import GUI.RemoteServer;
import GUI.RemoteServerTable;
import GUI.RemoteServerTableModel;
import GUI.TableCellJLabelRenderer;
import GUI.VivaldiStartupDialog;
import GUI.VivaldiStartupSettings;
import KernelExceptions.VKOperationFailedException;
import SASKernel.PluginInfo;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import SASKernel.SASServerInfo;
import Services.FrameworkUtilities;
import Utils.ConfigRepository;
import Utils.CustomJOptionDialog;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteServerPanel
implements ActionListener {
    JPanel mainPanel = new JPanel();
    RemoteServerTableModel tableModel = new RemoteServerTableModel();
    RemoteServerTable serverTable = new RemoteServerTable(this.tableModel);
    private JTextField frameworkIP;
    private String ipAddress = null;
    public static final String LOCAL_HOST_IP_ADDRESS = FrameworkUtilities.getLocalHostAddress();
    private boolean scanInitiated = false;
    private boolean scanStopped = false;
    private AuthenticationDialog auth;
    private LDAPLoginDialog ldapLoginDialog;
    private MSMServerDiscovery connect;
    private String loggedUser;
    public static boolean m_isRelogin = false;
    private static final String LOGINCMD = "Login";
    private static final String STARTDISCOVERCMD = "StartDiscover";
    private static final String STOPDISCOVERCMD = "StopDiscover";
    private static final String CONFIGCMD = "Configure";
    private static boolean startUpFlag = false;
    JPanel ipPanel = new JPanel(new FlowLayout(0));
    JButton startScanButton = new JButton();
    JButton stopScanButton = new JButton(Resource.getString("MSG_STOP_SCAN_TEXT", "Stop Scan"));
    JButton loginButton = new JButton(Resource.getString("MSG_LOGIN_TEXT", "Login"));
    JLabel statusLabel = new JLabel();
    JPanel failedMsgPanel = new JPanel();
    JButton prefrencesButton = new JButton();
    JLabel progressLabel = new JLabel();
    JCheckBox ldapChkBox;
    private static JPanel linkPanel;
    private static JLabel pairedlinkLabel;
    private static JPanel tablePanel;
    private HashMap clusterMap;
    private static ArrayList clusterIds;
    private static SASServerInfo sinfo;
    private static RemoteServer serverHealth;
    private static int discoveryOption;
    private static ArrayList<String> ipAddresses;
    private int discoveryOP;
    private static SASServer currentServer;
    private static boolean isLDAPAuthenticate;
    private boolean showLDAPLoginDialog = true;
    private int returnVal = 1;
    private static HashMap<String, String> ldapProps;
    private static ClusteredServersDialog pairedServerDialog;
    static SwingWorker mainWorker;
    static int mainWorkerCount;
    static ArrayList serverList;
    boolean clusterenableFlag = false;
    RemoteServerPanel remoteobj;

    public RemoteServerPanel(String string, boolean bl) {
        this.ipAddress = string;
        startUpFlag = bl;
        discoveryOption = VivaldiStartupSettings.getDiscoveryOption();
        ipAddresses = VivaldiStartupSettings.getIPAddresses();
        isLDAPAuthenticate = VivaldiStartupSettings.isLDAPAuthenticate();
        this.addComponents();
        if (VivaldiStartupSettings.getLDAPLoginCount() == null) {
            this.setLDAPProperties();
        }
    }

    public RemoteServerPanel(String string) {
        this.ipAddress = string;
        discoveryOption = VivaldiStartupSettings.getDiscoveryOption();
        ipAddresses = VivaldiStartupSettings.getIPAddresses();
        isLDAPAuthenticate = VivaldiStartupSettings.isLDAPAuthenticate();
        this.addComponents();
        if (VivaldiStartupSettings.getLDAPLoginCount() == null) {
            this.setLDAPProperties();
        }
    }

    private void addComponents() {
        this.mainPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Server Details"));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        String string = "<html><br> This dialog lists all the servers that were discovered.  You may select a server and click on Login to start managing that server. You will be prompted for entering host credentials while logging in.Please select Configure Hosts to configure the hosts that you want to view.<br></html>";
        JLabel jLabel = new JLabel(Resource.getString("HOSTVIEW_DESC", string));
        jPanel2.add((Component)jLabel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LDAP_AUTHENTICATE_MODE", "Use LDAP Login"));
        this.ldapChkBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.ldapChkBox.setMnemonic(stringArray[1].charAt(0));
        }
        this.ldapChkBox.setSelected(isLDAPAuthenticate);
        this.ldapChkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    isLDAPAuthenticate = true;
                    RemoteServerPanel.this.frameworkIP.setEnabled(false);
                } else {
                    isLDAPAuthenticate = false;
                    RemoteServerPanel.this.frameworkIP.setEnabled(true);
                }
            }
        });
        JButton jButton = new JButton();
        ImageIcon imageIcon = Resource.getImage("TIPIMAGE", "Help16.png");
        jButton.setOpaque(false);
        jButton.setIcon(imageIcon);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Resource.getString("LDAP_MODE_TIPS_TO_LOGIN", "This login mode is recommended if you have configured an LDAP server in your network.");
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                int n = CustomJOptionDialog.showDialog(Resource.getString("LDAP_DIALOG_TIPS_TO_LOGIN_TITLE", "Tips To Login"), image, string, 1, 99, 99);
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.ldapChkBox);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add(jPanel3);
        this.ipPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_IPADDRESS_TEXT", "IPAddress:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.ipPanel.add(jLabel2);
        this.frameworkIP = new JTextField(15);
        this.frameworkIP.setEnabled(!isLDAPAuthenticate);
        if (this.ipAddress != null && RemoteServerPanel.isValidIPAddress(this.ipAddress.trim())) {
            this.frameworkIP.setText(this.ipAddress);
        } else {
            this.frameworkIP.setText("127.0.0.1");
        }
        this.frameworkIP.setToolTipText(Resource.getString("IP_ADDR_DSC", "Local Host IP address"));
        jLabel2.setLabelFor(this.frameworkIP);
        this.frameworkIP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                String string = jTextField.getText();
                if (string.equals("")) {
                    RemoteServerPanel.this.startScanButton.setEnabled(false);
                } else if (!RemoteServerPanel.this.scanInitiated) {
                    RemoteServerPanel.this.startScanButton.setEnabled(true);
                }
            }
        });
        this.ipPanel.add(this.frameworkIP);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_DISCOVER_HOSTS_TEXT", "Discover Hosts"));
        this.startScanButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.startScanButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.startScanButton.setActionCommand(STARTDISCOVERCMD);
        this.startScanButton.addActionListener(this);
        this.ipPanel.add(this.startScanButton);
        ImageIcon imageIcon2 = Resource.getImage("ICON_SPIN_PROGRESS");
        this.progressLabel.setIcon(imageIcon2);
        this.ipPanel.add(this.progressLabel);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_STOP_DISCOVERY_TEXT", "Stop Discovery"));
        this.stopScanButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.stopScanButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.stopScanButton.setActionCommand(STOPDISCOVERCMD);
        this.stopScanButton.addActionListener(this);
        this.ipPanel.add(this.stopScanButton);
        jPanel4.add((Component)this.ipPanel, "South");
        jPanel2.add((Component)jPanel4, "West");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CONFIGURE_HOSTS_TEXT", "Configure Host..."));
        this.prefrencesButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.prefrencesButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.prefrencesButton.setActionCommand(CONFIGCMD);
        this.prefrencesButton.addActionListener(this);
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)this.prefrencesButton, "South");
        jPanel2.add((Component)jPanel5, "East");
        this.failedMsgPanel.setBackground(new Color(255, 255, 160));
        JLabel jLabel3 = new JLabel();
        this.failedMsgPanel.add(jLabel3);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setText(Resource.getString("FAILURE_DISCOVERY", "<html>Servers could not be found because server may be down or server not installed in the host system<br></html>"));
        this.failedMsgPanel.setVisible(false);
        jPanel2.add((Component)this.failedMsgPanel, "South");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.serverTable);
        this.serverTable.setFillsViewportHeight(true);
        this.serverTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource().equals(RemoteServerPanel.this.serverTable.getSelectionModel()) && RemoteServerPanel.this.serverTable.getRowSelectionAllowed()) {
                    int n = listSelectionEvent.getFirstIndex();
                    if (!RemoteServerPanel.this.scanInitiated && RemoteServerPanel.this.serverTable.getSelectedRows().length > 0) {
                        RemoteServerPanel.this.loginButton.setEnabled(true);
                    }
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.serverTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "doNothing");
        this.serverTable.getActionMap().put("doNothing", abstractAction);
        this.serverTable.setSelectionBackground(Color.LIGHT_GRAY);
        this.serverTable.setSelectionForeground(Color.BLACK);
        this.serverTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!RemoteServerPanel.this.scanInitiated && RemoteServerPanel.this.serverTable.getSelectedRows().length > 0) {
                    RemoteServerPanel.this.loginButton.setEnabled(true);
                    Point point = mouseEvent.getPoint();
                    int n = RemoteServerPanel.this.serverTable.columnAtPoint(point);
                    if (mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() == 1 && n == 1) {
                        RemoteServerPanel.this.doLogin();
                    }
                }
            }
        });
        int n = MainFrame.SCREEN_SIZE.width * 630 / 1024;
        if (n < jPanel2.getPreferredSize().width) {
            n = jPanel2.getPreferredSize().width;
        }
        jScrollPane.setPreferredSize(new Dimension(n, MainFrame.SCREEN_SIZE.height * 210 / 768));
        stringArray = Resource.getResourceMnemonic(Resource.getString("REMOTE_SERVER_TITLE", "Remote Servers"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        jLabel4.setHorizontalAlignment(2);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel4.setLabelFor(this.serverTable);
        this.serverTable.setSelectionMode(0);
        this.serverTable.setAutoResizeMode(4);
        this.serverTable.getColumnModel().getColumn(3).setCellRenderer(new TableCellJLabelRenderer());
        TableRowSorter<RemoteServerTableModel> tableRowSorter = new TableRowSorter<RemoteServerTableModel>(this.tableModel);
        this.serverTable.setRowSorter(tableRowSorter);
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        n = MainFrame.SCREEN_SIZE.width * 630 / 1024;
        if (n < jPanel2.getSize().width) {
            n = jPanel2.getSize().width;
        }
        jLabel4.setPreferredSize(new Dimension(n, jLabel4.getPreferredSize().height));
        jPanel8.setPreferredSize(new Dimension(n, MainFrame.SCREEN_SIZE.height * (230 + (int)jLabel4.getPreferredSize().getHeight() + 10) / 768));
        jPanel8.add(jLabel4);
        jPanel8.add(jScrollPane);
        jPanel7.add((Component)jPanel8, "North");
        jPanel7.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.add((Component)jPanel7, "Center");
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        linkPanel = new JPanel(new FlowLayout(0));
        String string2 = Resource.getString("VIEW_PAIRED_SERVER_TEXT", "View clustered servers");
        pairedlinkLabel = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string2 + "\">" + string2 + "</a></body></html>");
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LOGIN_TEXT", LOGINCMD));
        this.loginButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.loginButton.setEnabled(false);
        jPanel9.add(this.loginButton);
        this.loginButton.addActionListener(this);
        this.loginButton.setActionCommand(LOGINCMD);
        jPanel7.add((Component)jPanel9, "Center");
        jPanel7.add((Component)linkPanel, "East");
        this.mainPanel.add((Component)jPanel, "Center");
        this.statusLabel.setBackground(Color.red);
        this.mainPanel.add((Component)this.statusLabel, "South");
        pairedlinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!RemoteServerPanel.this.scanInitiated) {
                    pairedServerDialog = new ClusteredServersDialog(RemoteServerPanel.this.clusterMap, RemoteServerPanel.this);
                    pairedServerDialog.setModal(true);
                    pairedServerDialog.pack();
                    pairedServerDialog.setSize(410, 350);
                    GUIUtils.centerDialogOnScreen(pairedServerDialog);
                    pairedServerDialog.setVisible(true);
                }
            }
        });
    }

    public void setIpAddress(String string) {
        this.frameworkIP.setText(string);
    }

    public void initiateScan() {
        this.showLDAPLoginDialog = true;
        this.startScanButton.doClick();
    }

    public void initiateScan(boolean bl) {
        this.showLDAPLoginDialog = bl;
        this.startScanButton.doClick();
    }

    public synchronized void scanRemoteServers(int n) {
        Object object;
        if (VivaldiStartupDialog.isStandAloneMode && !VivaldiStartupDialog.isValidCmdIP()) {
            this.frameworkIP.setText("127.0.0.1");
        }
        this.clusterMap = new HashMap();
        if (n != mainWorkerCount) {
            return;
        }
        this.scanStopped = false;
        this.scanInitiated = true;
        this.tableModel.clearRemoteServer();
        try {
            Object object2;
            Object object3;
            int n2;
            String string;
            Object object4;
            Object object5;
            block50: {
                if (discoveryOption != 2) {
                    try {
                        if (VivaldiStartupDialog.kernel == null && (object = this.frameworkIP.getText()) != null && RemoteServerPanel.isValidIPAddress(((String)object).trim())) {
                            VivaldiStartupDialog.kernel = SASKernel.getInstance(((String)object).trim());
                        }
                    }
                    catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                        System.out.println("inside catch kernel null");
                        new CustomMsgBox(Resource.getString("MSG_VERSION_MISMATCH", "Mismatch in versions."));
                        this.scanInitiated = false;
                        return;
                    }
                    catch (Exception exception) {
                        if (VivaldiStartupDialog.kernel != null) break block50;
                        this.scanInitiated = false;
                        return;
                    }
                }
            }
            object = this.frameworkIP.getText() + ":" + 3071 + ":" + 0;
            ArrayList arrayList = new ArrayList();
            if (!VivaldiStartupDialog.isStandAloneMode) {
                if (discoveryOption == 1) {
                    arrayList.add(this.frameworkIP.getText());
                } else if (discoveryOption == 3) {
                    VivaldiStartupDialog.kernel.clearServerArrayList();
                    arrayList = VivaldiStartupDialog.kernel.queryServerList((String)object);
                } else if (discoveryOption == 2) {
                    arrayList.addAll(ipAddresses);
                } else if (discoveryOption == 4) {
                    arrayList.add(this.frameworkIP.getText());
                }
            } else {
                arrayList.add(this.frameworkIP.getText());
            }
            System.out.println("server IP :" + discoveryOption + ":" + (String)object + ":" + arrayList);
            int n3 = 0;
            int n4 = 0;
            ArrayList<SASServer> arrayList2 = new ArrayList<SASServer>();
            for (int i = 0; i < arrayList.size() && n == mainWorkerCount; ++i) {
                object5 = (String)arrayList.get(i);
                try {
                    SASServer sASServer;
                    block51: {
                        sASServer = null;
                        try {
                            if (VivaldiStartupDialog.kernel != null || (object4 = object5) == null || !RemoteServerPanel.isValidIPAddress(((String)object4).trim())) break block51;
                            VivaldiStartupDialog.kernel = SASKernel.getInstance(((String)object4).trim());
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (n != mainWorkerCount) break;
                    if (VivaldiStartupDialog.kernel != null) {
                        if (!VivaldiStartupDialog.isStartupScreen) {
                            object4 = SASKernel.getInstance(((String)object5).trim());
                            sASServer = ((SASKernel)object4).getSpecificServer((String)object5, (short)i);
                        } else {
                            sASServer = VivaldiStartupDialog.kernel.getSpecificServer((String)object5, (short)i);
                        }
                    }
                    if (n != mainWorkerCount) break;
                    if (!this.isSystemInfoPluginPresent(sASServer)) continue;
                    object4 = sASServer.getInformation();
                    string = "";
                    n2 = -1;
                    if (((SASServerInfo)object4).isFailedLogicalDrivePresent()) {
                        string = Resource.getString("PD_STATE_FAILED", "Failed");
                        n2 = 3;
                    } else if (((SASServerInfo)object4).isDegradedLogicalDrivePresent()) {
                        string = Resource.getString("DEGRADED_SERVER", "Degraded");
                        n2 = 2;
                    } else {
                        string = Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
                        n2 = 1;
                    }
                    if (((SASServerInfo)object4).ismaxHaNodes()) {
                        linkPanel.add(pairedlinkLabel);
                    }
                    serverHealth = new RemoteServer(((SASServerInfo)object4).getHostName(), ((SASServerInfo)object4).getIP(), ((SASServerInfo)object4).OperatingSystemName(), string, ((SASServerInfo)object4).getClusterList(), ((SASServerInfo)object4).ismaxHaNodes());
                    serverHealth.setVdHealth(n2);
                    serverHealth.setNoOfVds(((SASServerInfo)object4).getLogicalDriveCount());
                    serverHealth.setVdHealth(n2);
                    serverHealth.setServer(sASServer);
                    serverHealth.getServer().setUseSystemCredential(VivaldiStartupDialog.UseSystemCredential);
                    if (this.isStorageAPIPluginPresent(sASServer)) {
                        this.tableModel.appendRemoteServer(n3, serverHealth);
                        this.serverTable.getColumnModel().getColumn(3).setCellRenderer(new TableCellJLabelRenderer());
                        object3 = new ArrayList();
                        object3 = ((SASServerInfo)object4).getClusterList();
                        object2 = ((ArrayList)object3).iterator();
                        while (object2.hasNext()) {
                            String string2 = (String)object2.next();
                            ArrayList arrayList3 = (ArrayList)this.clusterMap.get(string2);
                            if (arrayList3 != null) {
                                arrayList3.add(serverHealth);
                                this.clusterMap.put(string2, arrayList3);
                                continue;
                            }
                            ArrayList<RemoteServer> arrayList4 = new ArrayList<RemoteServer>();
                            arrayList4.add(serverHealth);
                            this.clusterMap.put(string2, arrayList4);
                        }
                        arrayList2.add(sASServer);
                    }
                    if (this.getIP(sASServer.getSvrWWN()).equals(this.frameworkIP.getText())) {
                        currentServer = sASServer;
                    }
                    ++n3;
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("connection failed to ::" + (String)object5 + exception.getMessage());
                }
            }
            try {
                String string3;
                if (currentServer != null && VivaldiStartupDialog.mainScreen == null && !VivaldiStartupDialog.kernel.getDefaultFrameworkIP().equals(this.frameworkIP.getText()) && (string3 = this.frameworkIP.getText()) != null && RemoteServerPanel.isValidIPAddress(string3.trim())) {
                    VivaldiStartupDialog.kernel.changeDefaultFramework(string3.trim());
                }
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                new CustomMsgBox(Resource.getString("MSG_VERSION_MISMATCH", "Mismatch in versions."));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (currentServer == null && VivaldiStartupDialog.isStandAloneMode) {
                new CustomMsgBox(Resource.getString("MSG_NOSTOARGEAPI", "No Storage Controller Found!"));
                System.exit(0);
            }
            if ((discoveryOption == 3 || discoveryOption == 4) && n == mainWorkerCount) {
                ArrayList<Object> arrayList5 = new ArrayList<Object>();
                if (currentServer != null && currentServer.isCIMPluginPresent()) {
                    object5 = currentServer.getCIMOMServers();
                    for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                        object4 = (SASServer)((ArrayList)object5).get(i);
                        string = ((SASServer)object4).getCIMOMIP();
                        if (this.isCIMOMServerAlreadyAddded(arrayList5, string) || this.isCIMOMServerAlreadyAddedAsNormalServer(arrayList2, string)) continue;
                        arrayList5.add(object4);
                    }
                }
                int n5 = 0;
                while (n5 < arrayList5.size() & n == mainWorkerCount) {
                    SASServer sASServer = (SASServer)arrayList5.get(n5);
                    object4 = sASServer.getInformation();
                    string = "";
                    n2 = -1;
                    if (((SASServerInfo)object4).isFailedLogicalDrivePresent()) {
                        string = Resource.getString("PD_STATE_FAILED", "Failed");
                        n2 = 3;
                    } else if (((SASServerInfo)object4).isDegradedLogicalDrivePresent()) {
                        string = Resource.getString("DEGRADED_SERVER", "Degraded");
                        n2 = 2;
                    } else {
                        string = Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
                        n2 = 1;
                    }
                    object3 = ((SASServerInfo)object4).OperatingSystemName();
                    if (((SASServerInfo)object4).OperatingSystemName() == null || ((SASServerInfo)object4).OperatingSystemName().trim().equals("")) {
                        object3 = Resource.getString("OS_NAME_VMWARE_ESXI", "VMWare ESXi");
                    }
                    object2 = new RemoteServer(((SASServerInfo)object4).getHostName(), ((SASServerInfo)object4).getIP(), (String)object3, string, ((SASServerInfo)object4).getClusterList(), ((SASServerInfo)object4).ismaxHaNodes());
                    ((RemoteServer)object2).setVdHealth(n2);
                    ((RemoteServer)object2).setNoOfVds(((SASServerInfo)object4).getLogicalDriveCount());
                    ((RemoteServer)object2).setVdHealth(n2);
                    ((RemoteServer)object2).setServer(sASServer);
                    ((RemoteServer)object2).getServer().setUseSystemCredential(VivaldiStartupDialog.UseSystemCredential);
                    this.tableModel.appendRemoteServer(n3, (RemoteServer)object2);
                    ++n4;
                    ++n5;
                }
            }
            this.scanStopped = true;
        }
        catch (Exception exception) {
            System.out.println("Fatal Error : Can not create SASKernel object !");
            exception.printStackTrace();
            System.out.println("Terminating ....");
        }
        this.scanInitiated = false;
        if (VivaldiStartupDialog.isStandAloneMode && currentServer != null) {
            object = this.tableModel.getServer(0);
            this.tryToConnect((RemoteServer)object);
        }
        this.serverTable.getColumnModel().getColumn(3).setCellRenderer(new TableCellJLabelRenderer());
    }

    protected static boolean isValidIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean isSystemInfoPluginPresent(SASServer sASServer) {
        PluginInfo[] pluginInfoArray = sASServer.getPluginList();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (pluginInfoArray[i].getMajorGroup() != 0 || pluginInfoArray[i].getMinorGroup() != 4) continue;
            return true;
        }
        return false;
    }

    private boolean isCIMOMServerAlreadyAddded(ArrayList arrayList, String string) {
        if (!arrayList.isEmpty()) {
            for (SASServer sASServer : arrayList) {
                if (!string.equals(sASServer.getCIMOMIP())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCIMOMServerAlreadyAddedAsNormalServer(ArrayList arrayList, String string) {
        if (arrayList != null && !arrayList.isEmpty()) {
            for (SASServer sASServer : arrayList) {
                if (!string.equals(sASServer.getInformation().getIP())) continue;
                return true;
            }
        }
        return false;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void tryToConnect(final RemoteServer remoteServer) {
        if (!remoteServer.getServer().isCIMOMServer()) {
            VivaldiStartupDialog.kernel.setServerIP(remoteServer.getIpAddress());
        }
        if (remoteServer.getServer().isLDAPServer()) {
            remoteServer.setLoginCnt(remoteServer.getLoginCnt() + 1);
            if (remoteServer.getServer().getUserRole().equals("Administrator")) {
                this.login(remoteServer, null, null, (byte)0);
            } else {
                this.login(remoteServer, null, null, (byte)1);
            }
        } else if (VivaldiStartupDialog.UseSystemCredential) {
            if (VivaldiStartupDialog.isadministrator) {
                this.login(remoteServer, null, null, (byte)0);
            } else {
                this.login(remoteServer, null, null, (byte)1);
            }
        } else {
            this.auth = new AuthenticationDialog(remoteServer);
            this.auth.setLocation((MainFrame.SCREEN_SIZE.width - this.auth.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.auth.getHeight()) / 2);
            this.auth.loginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((RemoteServerPanel)RemoteServerPanel.this).auth.loginButton.setEnabled(false);
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    byte by = 0;
                    try {
                        if (remoteServer.getServer().isCIMOMServer()) {
                            byArray = RemoteServerPanel.this.auth.getUserName().getBytes();
                            byArray2 = RemoteServerPanel.this.auth.getPassword().getBytes();
                        } else {
                            byArray = RemoteServerPanel.this.auth.getUserName().getBytes("UTF-16LE");
                            byArray2 = RemoteServerPanel.this.auth.getPassword().getBytes("UTF-16LE");
                        }
                        by = RemoteServerPanel.this.auth.getLoginMode();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    remoteServer.setLoginCnt(remoteServer.getLoginCnt() + 1);
                    RemoteServerPanel.this.login(remoteServer, byArray, byArray2, by);
                }
            });
            this.auth.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RemoteServerPanel.this.auth.dispose();
                    if (SASKernel.isLocalStandAlone) {
                        System.exit(0);
                    }
                }
            });
            this.auth.show();
        }
    }

    private void login(final RemoteServer remoteServer, final byte[] byArray, final byte[] byArray2, final byte by) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                short s;
                if (!remoteServer.getServer().isCIMOMServer()) {
                    if (m_isRelogin) {
                        try {
                            VivaldiStartupDialog.kernel.changeDefaultFramework(remoteServer.getIpAddress());
                            m_isRelogin = false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (!remoteServer.getIpAddress().equals(VivaldiStartupDialog.kernel.getDefaultFrameworkIP())) {
                        try {
                            VivaldiStartupDialog.kernel.changeDefaultFramework(remoteServer.getIpAddress());
                        }
                        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                            System.out.println("Error to change default framework IP - VivaldiFrameworkProtocolErrorException");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if ((s = RemoteServerPanel.this.processLogin(remoteServer, byArray, byArray2, by)) != 1) {
                    VivaldiStartupDialog.spalshScreen.hideSplashScreen();
                    if (!remoteServer.getServer().isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential) {
                        RemoteServerPanel.this.auth.show();
                        ((RemoteServerPanel)RemoteServerPanel.this).auth.loginButton.setEnabled(true);
                    } else if (s == 2) {
                        JOptionPane jOptionPane = new JOptionPane(Resource.getString("LDAP_LOGIN_CONFIRMATION_MSG", "<html>Full Access Mode denied because another user is logged in<br> with full access from IP Address:") + RemoteServerPanel.this.loggedUser + ". Do you want to login with View Only Mode?", 2, 0);
                        JDialog jDialog = jOptionPane.createDialog(VivaldiStartupDialog.getVivaldiStartupDialogObj(), Resource.getString("LDAP_CONFIRMATION", "Confirm View Only Mode"));
                        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                        jDialog.setIconImage(image);
                        jDialog.setVisible(true);
                        Object object = jOptionPane.getValue();
                        if (object instanceof Integer) {
                            if ((Integer)object == 0) {
                                jDialog.dispose();
                                if (RemoteServerPanel.this.processLogin(remoteServer, byArray, byArray2, (byte)1) != 1) {
                                    VivaldiStartupDialog.spalshScreen.hideSplashScreen();
                                } else {
                                    if (VivaldiStartupDialog.mainScreen != null) {
                                        VivaldiStartupDialog.mainScreen.logOut();
                                        VivaldiStartupDialog.mainScreen.hide();
                                        VivaldiStartupDialog.mainScreen.dispose();
                                        VivaldiStartupDialog.mainScreen = null;
                                    }
                                    SASKernel.setSplashNotification(true);
                                    VivaldiStartupDialog.kernel.addObserver(VivaldiStartupDialog.spalshScreen);
                                    VivaldiStartupDialog.hideVivaldiStartupDialog();
                                    if (!remoteServer.getServer().isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential) {
                                        RemoteServerPanel.this.auth.hide();
                                        RemoteServerPanel.this.auth.dispose();
                                    }
                                    VivaldiStartupDialog.mainScreen = new MainFrame(remoteServer.getServer(), 1);
                                    SASKernel.setSplashNotification(false);
                                    VivaldiStartupDialog.kernel.deleteObserver(VivaldiStartupDialog.spalshScreen);
                                    VivaldiStartupDialog.spalshScreen.hideSplashScreen();
                                    VivaldiStartupDialog.mainScreen.displayManagePreservedCache();
                                }
                            } else {
                                jDialog.dispose();
                            }
                        }
                    }
                } else {
                    if (VivaldiStartupDialog.mainScreen != null) {
                        VivaldiStartupDialog.mainScreen.logOut();
                        VivaldiStartupDialog.mainScreen.hide();
                        VivaldiStartupDialog.mainScreen.dispose();
                        VivaldiStartupDialog.mainScreen = null;
                    }
                    SASKernel.setSplashNotification(true);
                    VivaldiStartupDialog.kernel.addObserver(VivaldiStartupDialog.spalshScreen);
                    VivaldiStartupDialog.hideVivaldiStartupDialog();
                    if (pairedServerDialog != null) {
                        pairedServerDialog.dispose();
                        pairedServerDialog.hide();
                    }
                    if (!remoteServer.getServer().isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential) {
                        RemoteServerPanel.this.auth.hide();
                        RemoteServerPanel.this.auth.dispose();
                    }
                    VivaldiStartupDialog.mainScreen = new MainFrame(remoteServer.getServer(), by);
                    SASKernel.setSplashNotification(false);
                    VivaldiStartupDialog.kernel.deleteObserver(VivaldiStartupDialog.spalshScreen);
                    VivaldiStartupDialog.spalshScreen.hideSplashScreen();
                    if (by != 1) {
                        VivaldiStartupDialog.mainScreen.displayManagePreservedCache();
                    }
                }
            }
        });
        thread.start();
    }

    private short processLogin(RemoteServer remoteServer, byte[] byArray, byte[] byArray2, byte by) {
        block20: {
            try {
                if (!remoteServer.getServer().isCIMOMServer()) {
                    remoteServer.getServer().login(byArray, byArray2, by);
                    return 1;
                }
                String string = remoteServer.getServer().getCIMOMIP();
                String string2 = remoteServer.getServer().getCIMOMPort();
                remoteServer.getServer().loginToCIMOM(string.getBytes(), string2.getBytes(), byArray, byArray2, by);
                return 1;
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                if (remoteServer.getLoginCnt() == 3) {
                    new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_FAILURE_THRICE", "<html>You have exceeded the maximum number of login attempts. <br> Please contact the administrator."));
                    System.exit(0);
                }
                switch (vKOperationFailedException.GetErrorCode()) {
                    case 4101: {
                        JLogger jLogger = new JLogger();
                        String[] stringArray = new String[2];
                        stringArray[0] = "";
                        if (remoteServer.getServer().getUsrName() != null) {
                            try {
                                stringArray[0] = stringArray[0] + new String(remoteServer.getServer().getUsrName(), "UTF-16LE");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        stringArray[1] = "127.0.0.1";
                        try {
                            stringArray[1] = LOCAL_HOST_IP_ADDRESS;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        remoteServer.getServer().writeKernelLogRecord(jLogger.getXMLFromTagArray(jLogger.createTagArray("DENY", stringArray)));
                        this.loggedUser = vKOperationFailedException.GetObject().toString().split(":")[0];
                        if (!remoteServer.getServer().isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential) {
                            new CustomMsgBox(this.auth, Resource.getString("MSG_FULLACCESS_DENIED", "<html>Full Access denied because another user is logged in<br> with full access from IP Address : ") + this.loggedUser);
                        }
                        return 2;
                    }
                    case 4096: {
                        if (!remoteServer.getServer().isCIMOMServer() && vKOperationFailedException.GetOperation() != 2 && vKOperationFailedException.GetOperation() != 3) break;
                        new CustomMsgBox(this.auth, Resource.getString("MSG_NOADMIN_RIGHT", "This user does not have Administrator right for this system !"));
                        break;
                    }
                    case 4122: {
                        new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_FAILURE", "Login failed : Invalid username or password !"));
                        break;
                    }
                    case 4127: {
                        new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_CIMOM_FAILURE", "Login failed : Unable to connect to CIMOM server!"));
                        break;
                    }
                    default: {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                        try {
                            remoteServer.getServer().logout();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        vKOperationFailedException.printStackTrace();
                    }
                }
                if (!remoteServer.getServer().isLDAPServer() && !VivaldiStartupDialog.UseSystemCredential) {
                    this.auth.setButtonFocus();
                }
            }
            catch (Exception exception) {
                new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_EXFAILURE", "Login failed : Exception while login !"));
                exception.printStackTrace();
                if (remoteServer.getLoginCnt() != 3) break block20;
                System.exit(0);
            }
        }
        return 3;
    }

    private short processLoginStatus(RemoteServer remoteServer, byte[] byArray, byte[] byArray2, byte by) {
        try {
            if (!remoteServer.getServer().isCIMOMServer()) {
                remoteServer.getServer().login(byArray, byArray2, by);
                return 1;
            }
            String string = remoteServer.getServer().getCIMOMIP();
            String string2 = remoteServer.getServer().getCIMOMPort();
            remoteServer.getServer().loginToCIMOM(string.getBytes(), string2.getBytes(), byArray, byArray2, by);
            return 1;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            switch (vKOperationFailedException.GetErrorCode()) {
                case 4101: {
                    if (VivaldiStartupDialog.mainScreen != null) {
                        if (MainFrame.fullAccess) {
                            return 2;
                        }
                    }
                    return 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int noOfvalidServers() {
        return this.tableModel.getRowCount();
    }

    private void startDiscoveryAction() {
        try {
            if (mainWorker != null) {
                boolean bl = mainWorker.cancel(true);
            }
        }
        catch (Exception exception) {
            System.out.println("got exception in start" + exception.getMessage());
        }
        mainWorker = new SwingWorker(){

            protected String doInBackground() throws InterruptedException {
                if (isLDAPAuthenticate && RemoteServerPanel.this.returnVal == 1) {
                    RemoteServerPanel.this.scanLDAPServers(mainWorkerCount);
                } else {
                    RemoteServerPanel.this.scanRemoteServers(mainWorkerCount);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    String string = (String)this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                RemoteServerPanel.this.stopScanButton.setEnabled(false);
                RemoteServerPanel.this.progressLabel.setVisible(false);
                RemoteServerPanel.this.startScanButton.setEnabled(true);
                RemoteServerPanel.this.prefrencesButton.setEnabled(true);
                if (RemoteServerPanel.this.returnVal != -1) {
                    RemoteServerPanel.this.statusLabel.setText(RemoteServerPanel.this.tableModel.getRowCount() + " " + Resource.getString("DISCOVERY_STATUS_COMPLETE", " Server(s) found.Discovery Completed."));
                    if (RemoteServerPanel.this.tableModel.getRowCount() == 0) {
                        if (VivaldiStartupDialog.isLocalStandAlone) {
                            new CustomMsgBox(Resource.getString("MSG_NOSTOARGEAPI", "No Storage Controller Found!"));
                            System.exit(0);
                        } else {
                            RemoteServerPanel.this.failedMsgPanel.setVisible(true);
                        }
                    } else {
                        RemoteServerPanel.this.failedMsgPanel.setVisible(false);
                    }
                    ConfigRepository.set(new Integer(VivaldiStartupDialog.OEM_TYPE).toString(), "PERSISTENT_REM_FW_IP", RemoteServerPanel.this.frameworkIP.getText());
                }
            }
        };
        mainWorker.execute();
        ++mainWorkerCount;
    }

    private void doLogin() {
        int n = this.serverTable.getSelectedRow();
        n = this.serverTable.convertRowIndexToModel(n);
        RemoteServer remoteServer = this.tableModel.getServer(n);
        boolean bl = false;
        if (VivaldiStartupDialog.mainScreen != null) {
            if (!VivaldiStartupDialog.isStartupScreen) {
                if (remoteServer.getIpAddress().equals(VivaldiStartupDialog.mainScreen.getServerIP())) {
                    String string = Resource.getString("MSG_SAME_SERVER_LOGIN", "<html>You are trying to connect to the same server, which is currently being used. <br>Are you sure you want to continue?<br><br>Note: This will close the current session and will open a new one.</html>");
                    bl = CustomMsgBox.confirmWithCheck(string, VivaldiStartupDialog.getVivaldiStartupDialogObj(), VivaldiStartupDialog.FRAME_TITLE);
                } else {
                    Object[] objectArray = null;
                    objectArray = new Object[]{remoteServer.getIpAddress(), VivaldiStartupDialog.mainScreen.getServerIP()};
                    String string = MessageFormat.format(Resource.getString("MSG_DIFF_SERVER_LOGIN", "<html>If you choose to connect to the server {0}, the existing connection <br>to the server {1} will be disconnected. <br><br>Are you sure you want to continue?</html>"), objectArray);
                    bl = CustomMsgBox.confirmWithCheck(string, VivaldiStartupDialog.getVivaldiStartupDialogObj(), VivaldiStartupDialog.FRAME_TITLE);
                }
            }
            if (bl || VivaldiStartupDialog.isStartupScreen) {
                VivaldiStartupDialog.mainScreen.logOut();
                VivaldiStartupDialog.mainScreen.hide();
                VivaldiStartupDialog.mainScreen.dispose();
                VivaldiStartupDialog.mainScreen = null;
                this.tryToConnect(remoteServer);
            }
        } else {
            this.tryToConnect(remoteServer);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(LOGINCMD)) {
            this.doLogin();
        } else if (string.equals(STARTDISCOVERCMD)) {
            if (this.frameworkIP.getText() == null || this.frameworkIP.getText().trim().equals("")) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("IP_ADDRESS_MSG", "Invalid IPAddress."), 2);
                JDialog jDialog = jOptionPane.createDialog(Resource.getString("IP_ADDRESS_TITLE", "Enter IP Address"));
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                this.frameworkIP.requestFocus();
                return;
            }
            if (!RemoteServerPanel.isValidIPAddress(this.frameworkIP.getText())) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("VALID_IP_ADDRESS_MSG", "Invalid IPAddress."), 2);
                JDialog jDialog = jOptionPane.createDialog(Resource.getString("VALID_IP_ADDRESS_TITLE", "Enter Valid IP Address"));
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                this.frameworkIP.requestFocus();
                return;
            }
            this.tableModel.clearRemoteServer();
            this.stopScanButton.setEnabled(true);
            this.startScanButton.setEnabled(false);
            this.loginButton.setEnabled(false);
            this.prefrencesButton.setEnabled(false);
            this.progressLabel.setVisible(true);
            this.failedMsgPanel.setVisible(false);
            this.statusLabel.setText(Resource.getString("DISCOVERY_STATUS_INPROGRESS", " Discovery is in progress..."));
            this.frameworkIP.setEnabled(!isLDAPAuthenticate);
            this.ldapChkBox.setSelected(isLDAPAuthenticate);
            if (isLDAPAuthenticate && this.showLDAPLoginDialog) {
                boolean bl = VivaldiStartupSettings.promptForCredentials();
                this.ldapLoginDialog = new LDAPLoginDialog();
                this.ldapLoginDialog.loginButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((RemoteServerPanel)RemoteServerPanel.this).ldapLoginDialog.loginButton.setEnabled(false);
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        Short s = 0;
                        try {
                            string = RemoteServerPanel.this.ldapLoginDialog.getServerIP();
                            string2 = RemoteServerPanel.this.ldapLoginDialog.getUserName();
                            string3 = RemoteServerPanel.this.ldapLoginDialog.getPassword();
                            string4 = RemoteServerPanel.this.ldapLoginDialog.getDomain();
                            s = RemoteServerPanel.this.ldapLoginDialog.getPort();
                        }
                        catch (Exception exception) {
                            if (exception instanceof NumberFormatException) {
                                JOptionPane.showMessageDialog(null, "The port number that you have entered is invalid.", null, 0);
                            }
                            ((RemoteServerPanel)RemoteServerPanel.this).ldapLoginDialog.loginButton.setEnabled(true);
                            exception.printStackTrace();
                            return;
                        }
                        if (!RemoteServerPanel.isValidIPAddress(string)) {
                            JOptionPane.showMessageDialog(null, "The IP Address of the LDAP Server that you have entered is incorrect.", null, 0);
                            ((RemoteServerPanel)RemoteServerPanel.this).ldapLoginDialog.loginButton.setEnabled(true);
                            return;
                        }
                        RemoteServerPanel.this.connect = new MSMServerDiscovery(string, string4, string2, string3, s);
                        RemoteServerPanel.this.returnVal = RemoteServerPanel.this.connect.connectToServer();
                        if (((RemoteServerPanel)RemoteServerPanel.this).connect.ldapServerContext == null || RemoteServerPanel.this.returnVal == -1) {
                            ((RemoteServerPanel)RemoteServerPanel.this).ldapLoginDialog.loginButton.setEnabled(true);
                            RemoteServerPanel.this.scanInitiated = false;
                            RemoteServerPanel.this.progressLabel.setVisible(false);
                            RemoteServerPanel.this.statusLabel.setVisible(false);
                            return;
                        }
                        RemoteServerPanel.this.connect.setLDAPUserRole();
                        if (RemoteServerPanel.this.ldapLoginDialog.isRememberCheckBoxSelected()) {
                            RemoteServerPanel.this.ldapLoginDialog.setLDAPProperties();
                        }
                        RemoteServerPanel.this.ldapLoginDialog.dispose();
                        RemoteServerPanel.this.progressLabel.setVisible(true);
                        RemoteServerPanel.this.statusLabel.setVisible(true);
                    }
                });
                this.ldapLoginDialog.cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RemoteServerPanel.this.returnVal = -1;
                        RemoteServerPanel.this.ldapLoginDialog.dispose();
                    }
                });
                if (bl) {
                    this.ldapLoginDialog.setLocation((MainFrame.SCREEN_SIZE.width - this.ldapLoginDialog.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.ldapLoginDialog.getHeight()) / 2);
                    this.ldapLoginDialog.loginButton.setEnabled(this.ldapLoginDialog.getLoginButtonState());
                    this.progressLabel.setVisible(false);
                    this.statusLabel.setVisible(false);
                    this.ldapLoginDialog.show();
                } else {
                    this.ldapLoginDialog.loginButton.doClick();
                }
                if (this.returnVal == 1) {
                    this.startDiscoveryAction();
                } else {
                    this.stopScanButton.setEnabled(false);
                    this.progressLabel.setVisible(false);
                    this.startScanButton.setEnabled(true);
                    this.prefrencesButton.setEnabled(true);
                }
            } else {
                this.startDiscoveryAction();
            }
            this.showLDAPLoginDialog = true;
        } else if (string.equals(STOPDISCOVERCMD)) {
            this.scanInitiated = false;
            ++mainWorkerCount;
            try {
                if (mainWorker != null) {
                    boolean bl = mainWorker.cancel(true);
                    mainWorker = null;
                }
            }
            catch (Exception exception) {
                System.out.println("got exception in stop" + exception.getMessage());
            }
            this.statusLabel.setText(this.tableModel.getRowCount() + " " + Resource.getString("DISCOVERY_STATUS_STOP", " Server(s) Found.Discovery Stopped."));
            this.stopScanButton.setEnabled(false);
            this.startScanButton.setEnabled(true);
            this.prefrencesButton.setEnabled(true);
            this.progressLabel.setVisible(false);
            if (this.failedMsgPanel.isVisible()) {
                this.failedMsgPanel.setVisible(false);
            }
            this.ipPanel.revalidate();
            this.ipPanel.repaint();
        } else if (string.equals(CONFIGCMD)) {
            boolean bl = RemoteServerPanel.isFWSupportedNCPStop();
            boolean bl2 = false;
            if (bl) {
                bl2 = RemoteServerPanel.currentNCPStatus();
            }
            String string2 = this.frameworkIP.getText();
            VivaldiStartupSettings vivaldiStartupSettings = new VivaldiStartupSettings(string2, bl, bl2);
            String string3 = Resource.getString("DIALOG_HOST_CONFIGURE_TITLE", "Host Configure");
            string3 = VivaldiStartupDialog.PRODUCT_INFO + " " + VivaldiStartupDialog.INSTALLER_VERSION + " - " + string3;
            vivaldiStartupSettings.setTitle(string3);
            vivaldiStartupSettings.setModal(true);
            GUIUtils.centerDialogOnScreen(vivaldiStartupSettings);
            vivaldiStartupSettings.setVisible(true);
        }
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    private static boolean isFWSupportedNCPStop() {
        if (currentServer != null) {
            return currentServer.isFWSupportedNCPStop();
        }
        return false;
    }

    private static boolean currentNCPStatus() {
        if (currentServer != null) {
            if (currentServer.isFWSupportedNCPStop()) {
                return currentServer.getFrameworkNCPStatus();
            }
            return false;
        }
        return false;
    }

    public static void applyDiscoverySettings() {
        isLDAPAuthenticate = VivaldiStartupSettings.isLDAPAuthenticate();
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIRMATION_MSG", "Do you want to apply the display changes now?"), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(VivaldiStartupDialog.getVivaldiStartupDialogObj(), "Confirmation");
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer) {
            if ((Integer)object == 0) {
                VivaldiStartupDialog.kernel.clearServerArrayList();
                jDialog.dispose();
                System.out.println("Discovery Start Time:" + new Timestamp(System.currentTimeMillis()));
                VivaldiStartupDialog.getRemoteServerPanel().initiateScan(true);
                System.out.println("Discovery End Time:" + new Timestamp(System.currentTimeMillis()));
            } else {
                jDialog.dispose();
            }
        }
    }

    public static void setDiscoverySettings(int n, int n2) {
        discoveryOption = n;
        VivaldiStartupDialog.getRemoteServerPanel().discoveryOP = n2;
        int n3 = 0;
        if (n2 == 1) {
            if (currentServer != null) {
                n3 = currentServer.stopFWDiscovery(true);
            }
        } else if (n2 == 2 && currentServer != null) {
            n3 = currentServer.stopFWDiscovery(false);
        }
    }

    public static void setDiscoverySettings(int n, ArrayList arrayList, int n2) {
        discoveryOption = n;
        ipAddresses = arrayList;
        VivaldiStartupDialog.getRemoteServerPanel().discoveryOP = n2;
        int n3 = 0;
        if (n2 == 1) {
            n3 = currentServer.stopFWDiscovery(true);
        } else if (n2 == 2) {
            n3 = currentServer.stopFWDiscovery(false);
        }
    }

    private boolean isStorageAPIPluginPresent(SASServer sASServer) {
        PluginInfo[] pluginInfoArray = sASServer.getPluginList();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            int n;
            if (pluginInfoArray[i].getMajorGroup() != 1 || (n = pluginInfoArray[i].getMinorGroup()) != 2 && n != 3) continue;
            return true;
        }
        return false;
    }

    private synchronized void scanLDAPServers(int n) {
        if (n != mainWorkerCount) {
            return;
        }
        this.scanInitiated = true;
        this.tableModel.clearRemoteServer();
        ArrayList<Object> arrayList = new ArrayList();
        arrayList = this.connect.getRegisteredMSMList();
        String string = this.connect.getLDAPUserRole();
        String string2 = this.connect.getLDAPUserName();
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            SASServer sASServer;
            block13: {
                String string3;
                block12: {
                    sASServer = null;
                    string3 = null;
                    try {
                        object = InetAddress.getByName((String)arrayList.get(i));
                        string3 = ((InetAddress)object).getHostAddress();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    try {
                        if (VivaldiStartupDialog.kernel != null || string3 == null || !RemoteServerPanel.isValidIPAddress(string3.trim())) break block12;
                        VivaldiStartupDialog.kernel = SASKernel.getInstance(string3.trim());
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (n != mainWorkerCount) break;
                try {
                    if (VivaldiStartupDialog.kernel == null) break block13;
                    sASServer = VivaldiStartupDialog.kernel.getSpecificServer(string3, (short)i);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            if (sASServer == null || n != mainWorkerCount) break;
            if (!this.isSystemInfoPluginPresent(sASServer) || !this.isStorageAPIPluginPresent(sASServer)) continue;
            object = sASServer.getInformation();
            String string4 = "";
            int n3 = -1;
            if (((SASServerInfo)object).isFailedLogicalDrivePresent()) {
                string4 = Resource.getString("PD_STATE_FAILED", "Failed");
                n3 = 3;
            } else if (((SASServerInfo)object).isDegradedLogicalDrivePresent()) {
                string4 = Resource.getString("DEGRADED_SERVER", "Degraded");
                n3 = 2;
            } else {
                string4 = Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
                n3 = 1;
            }
            serverHealth = new RemoteServer(((SASServerInfo)object).getHostName(), ((SASServerInfo)object).getIP(), ((SASServerInfo)object).OperatingSystemName(), string4, ((SASServerInfo)object).getClusterList(), ((SASServerInfo)object).ismaxHaNodes());
            serverHealth.setVdHealth(n3);
            serverHealth.setNoOfVds(((SASServerInfo)object).getLogicalDriveCount());
            serverHealth.setServer(sASServer);
            serverHealth.getServer().setLDAPServer(true);
            serverHealth.getServer().setUserRole(string);
            serverHealth.getServer().setLDAPUserName(string2);
            serverHealth.getServer().setUseSystemCredential(VivaldiStartupDialog.UseSystemCredential);
            this.tableModel.appendRemoteServer(n2, serverHealth);
            ++n2;
        }
        this.scanInitiated = false;
    }

    public void setLDAPProperties() {
        block5: {
            try {
                this.parseLDAPXML();
            }
            catch (IOException iOException) {
                if (!(iOException instanceof FileNotFoundException)) break block5;
                VivaldiStartupSettings.setLDAPLoginCount("1");
                return;
            }
        }
        if (ldapProps.size() > 0) {
            if (ldapProps.get("DefaultLogin").equals("1")) {
                this.ldapChkBox.setSelected(true);
                VivaldiStartupSettings.setDefaultAuthenticationMode("LDAP");
            } else {
                this.ldapChkBox.setSelected(false);
                VivaldiStartupSettings.setDefaultAuthenticationMode("MULTICAST");
            }
            VivaldiStartupSettings.setLDAPServerIP(ldapProps.get("Server IP") != null ? ldapProps.get("Server IP") : "");
            VivaldiStartupSettings.setLDAPServerUserName(ldapProps.get("User Name") != null ? ldapProps.get("User Name") : "");
            VivaldiStartupSettings.setLDAPServerDomainName(ldapProps.get("Distinguished User Name") != null ? ldapProps.get("Distinguished User Name") : "");
            VivaldiStartupSettings.setLDAPServerPort(ldapProps.get("Port") != null ? ldapProps.get("Port") : "");
        }
        VivaldiStartupSettings.setLDAPLoginCount("1");
    }

    private void parseLDAPXML() throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        ldapProps = new HashMap();
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
            SaxHandler saxHandler = new SaxHandler();
            sAXParser.parse("ldap.properties", (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public RemoteServerTableModel getTableModel() {
        return this.tableModel;
    }

    public RemoteServerTable getServerTable() {
        return this.serverTable;
    }

    static {
        clusterIds = new ArrayList();
        discoveryOption = 1;
        ipAddresses = new ArrayList();
        currentServer = null;
        isLDAPAuthenticate = false;
        mainWorker = null;
        mainWorkerCount = 0;
        serverList = new ArrayList();
    }

    class SaxHandler
    extends DefaultHandler {
        SaxHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("add")) {
                String string4 = attributes.getValue("key");
                String string5 = attributes.getValue("value");
                ldapProps.put(string4, string5);
            }
        }
    }
}

