/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.RemoteServer;
import Utils.Resource;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class RemoteServerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String tableHeaderHost = Resource.getString("LABEL_HOSTNAME_TEXT", "Host");
    private String tableHeaderIP = Resource.getString("SORTBYCOMBO_IPADDRESS_TEXT", "IP Address");
    private String tableHeaderOS = Resource.getString("PROPERTY_HOSTOS_TEXT", "Operating System");
    private String tableHeaderHealth = Resource.getString("LABEL_HEALTH_TEXT", "Health");
    private String tableHeaderCluster = Resource.getString("PROPERTY_CLUSTER_ID", "Domain ID");
    private static Boolean maxHaNodes = false;
    private String[] remoteServerHeader = new String[]{this.tableHeaderHost, this.tableHeaderIP, this.tableHeaderOS, this.tableHeaderHealth, this.tableHeaderCluster};
    private String[] remoteServerHeader1 = null;
    private Class[] m_colTypes = new Class[]{Object.class, Object.class, Object.class, Integer.class, Object.class, Integer.class};
    Vector remoteServer = new Vector();
    private ImageIcon defaultImage = Resource.getImage("DEFAULT_HOST_IMAGE", "host.jpg");
    private ImageIcon degradedImage = Resource.getImage("DEGRADED_IMAGE", "degraded.png");
    private ImageIcon failedImage = Resource.getImage("FAILED_IMAGE", "failed.png");
    public static final int IPADDRESSCOL = 1;
    public static final int HEALTHCOL = 3;

    public RemoteServerTableModel(Vector vector) {
        this.remoteServer = vector;
    }

    public RemoteServerTableModel() {
    }

    public void appendRemoteServer(int n, RemoteServer remoteServer) {
        this.remoteServer.addElement(remoteServer);
        System.out.println("server" + remoteServer);
        this.fireTableRowsInserted(this.remoteServer.size() - 1, this.remoteServer.size() - 1);
        maxHaNodes = remoteServer.ismaxHaNodes();
        if (maxHaNodes.booleanValue()) {
            this.getColumnCount();
            try {
                this.fireTableStructureChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clearRemoteServer() {
        int n = this.remoteServer.size();
        if (n > 0) {
            this.remoteServer.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    @Override
    public int getColumnCount() {
        if (maxHaNodes.booleanValue()) {
            return this.remoteServerHeader.length;
        }
        return this.remoteServerHeader.length - 1;
    }

    @Override
    public int getRowCount() {
        return this.remoteServer.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.remoteServerHeader[n];
    }

    public Class getColumnClass(int n) {
        return this.m_colTypes[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        RemoteServer remoteServer = (RemoteServer)this.remoteServer.elementAt(n);
        switch (n2) {
            case 0: {
                return remoteServer.getHostName();
            }
            case 1: {
                String string = "<html><u><font color=#0000A0>" + remoteServer.getIpAddress() + "<u></html>";
                return string;
            }
            case 2: {
                return remoteServer.getOsName();
            }
            case 3: {
                return "" + remoteServer.getVdHealth();
            }
            case 4: {
                return remoteServer.getClusterId();
            }
        }
        return new String();
    }

    public RemoteServer getServer(int n) {
        return (RemoteServer)this.remoteServer.elementAt(n);
    }

    public Vector getServerVector() {
        return this.remoteServer;
    }
}

