/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CC_SCHEDULE_PROPERTIES;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ScheduleCCAdvanced
extends VivaldiBaseDialog {
    MR_CC_SCHEDULE_PROPERTIES m_ccProp;
    private byte m_opMode;
    private byte m_excludeLdCount;
    private short[] m_excludedLD = new short[64];
    static short[] m_exclude = new short[64];
    static byte m_excludeCount;
    static byte m_mode;
    private JRadioButton seqButton;
    private JRadioButton concurrentButton;
    private ButtonGroup cbGroup;
    private String[] mnemonics;
    private JCheckBox[] checkBox;
    String mnemonicChar;
    private JPanel listPanel = new JPanel();
    JPanel mainPanel;
    AdapterHelper m_adapHelper = null;

    public ScheduleCCAdvanced(GUIHelperInterface gUIHelperInterface, OperationDetails operationDetails) {
        this.m_adapHelper = (AdapterHelper)gUIHelperInterface;
        this.m_ccProp = (MR_CC_SCHEDULE_PROPERTIES)operationDetails.getParam();
        this.setTitle(Resource.getString("SCHEDULE_CC_ADVANCED", "Schedule Consistency Check - Advanced"));
        try {
            MR_CC_SCHEDULE_PROPERTIES mR_CC_SCHEDULE_PROPERTIES = (MR_CC_SCHEDULE_PROPERTIES)operationDetails.getParam();
            this.setexcludeLdCount(mR_CC_SCHEDULE_PROPERTIES.getexcludeLdCount());
            this.setexcludedLD(mR_CC_SCHEDULE_PROPERTIES.getexcludedLD());
            this.setopMode(mR_CC_SCHEDULE_PROPERTIES.getopMode());
            this.mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_CCDRIVE_TEXT", "Virtual Disks")));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_CCMODE_TEXT", "Mode")));
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CCADVANCED_VDSTOCHECK_TEXT", "Select (v)irtual disks to check:"));
            JLabel jLabel = new JLabel(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            }
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 18;
            jPanel.add((Component)jLabel, gridBagConstraints2);
            jLabel.setLabelFor(jPanel);
            this.addLogicaldrivesToCheckBox(this.m_adapHelper.getCCCapableLogicalDrives());
            JScrollPane jScrollPane = new JScrollPane(this.listPanel, 22, 32);
            jScrollPane.setPreferredSize(new Dimension(this.listPanel.getPreferredSize().width, 150));
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            jPanel.add((Component)jScrollPane, gridBagConstraints2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)jPanel, gridBagConstraints);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CCADVANCED_CHECK_MODE_TEXT", "Consistency check (m)ode:"));
            JLabel jLabel2 = new JLabel(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            }
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 18;
            jPanel2.add((Component)jLabel2, gridBagConstraints3);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CCADVANCED_SEQUENTIAL_MODE_TEXT", "(S)equential: Check virtual disks one at a time (slower but less performance impact)."));
            this.cbGroup = new ButtonGroup();
            this.seqButton = new JRadioButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.seqButton.setMnemonic(this.mnemonics[1].charAt(0));
            }
            jLabel2.setLabelFor(this.seqButton);
            this.seqButton.setSelected(true);
            this.seqButton.setOpaque(false);
            this.cbGroup.add(this.seqButton);
            gridBagConstraints3.gridy = 1;
            jPanel2.add((Component)this.seqButton, gridBagConstraints3);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CCADVANCED_CONCURRENT_MODE_TEXT", "(C)oncurrent: Check all selected virtual disks at once (faster but lowers performance)."));
            this.concurrentButton = new JRadioButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.concurrentButton.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.concurrentButton.setOpaque(false);
            this.cbGroup.add(this.concurrentButton);
            gridBagConstraints3.gridy = 2;
            jPanel2.add((Component)this.concurrentButton, gridBagConstraints3);
            if (this.getOpMode() == 2) {
                this.seqButton.setSelected(false);
                this.concurrentButton.setSelected(true);
            }
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)jPanel2, gridBagConstraints);
            JPanel jPanel3 = new JPanel();
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
            JButton jButton = new JButton(this.mnemonics[0]);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
            JButton jButton2 = new JButton(this.mnemonics[0]);
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            this.mainPanel.add((Component)jPanel3, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable;
                    if (ScheduleCCAdvanced.this.listPanel != null) {
                        serializable = ScheduleCCAdvanced.this.getUnSelectedLDs(ScheduleCCAdvanced.this.m_adapHelper.getLogicalDrives());
                        int n = ((ArrayList)serializable).size();
                        ScheduleCCAdvanced.this.setexcludeLdCount((byte)n);
                        short[] sArray = new short[n];
                        for (int i = 0; i < n; ++i) {
                            sArray[i] = ((SASLogicalDrive)((LogicalDriveHelper)((ArrayList)serializable).get(i)).getDeviceObject()).getID();
                        }
                        ScheduleCCAdvanced.this.setexcludedLD(sArray);
                    }
                    if ((serializable = ScheduleCCAdvanced.this.getSelection(ScheduleCCAdvanced.this.cbGroup)) == ScheduleCCAdvanced.this.seqButton) {
                        ScheduleCCAdvanced.this.setopMode((byte)1);
                    }
                    if (serializable == ScheduleCCAdvanced.this.concurrentButton) {
                        ScheduleCCAdvanced.this.setopMode((byte)2);
                    }
                    ScheduleCCAdvanced.this.closeOpt();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScheduleCCAdvanced.this.closeOpt();
                }
            });
            this.add(this.mainPanel);
            this.setModal(true);
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setopMode(byte by) {
        this.m_ccProp.setopMode(by);
        this.m_opMode = by;
        ScheduleCCAdvanced.setMode(by);
    }

    public void setexcludeLdCount(byte by) {
        this.m_ccProp.setexcludeLdCount(by);
        this.m_excludeLdCount = by;
        ScheduleCCAdvanced.setexcludeCount(by);
    }

    public void setexcludedLD(short[] sArray) {
        this.m_ccProp.setexcludedLD(sArray);
        this.m_excludedLD = sArray;
        ScheduleCCAdvanced.setexclude(sArray);
    }

    public static void setexclude(short[] sArray) {
        m_exclude = sArray;
    }

    public static void setexcludeCount(byte by) {
        m_excludeCount = by;
    }

    public static void setMode(byte by) {
        m_mode = by;
    }

    public byte getopMode() {
        return this.m_opMode;
    }

    public byte getexcludeLdCount() {
        return this.m_excludeLdCount;
    }

    public short[] getexcludedLD() {
        return this.m_excludedLD;
    }

    public static byte getOpMode() {
        return m_mode;
    }

    public static byte getexcludedLDCount() {
        return m_excludeCount;
    }

    public static short[] getexcluded() {
        return m_exclude;
    }

    public JRadioButton getSelection(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != buttonGroup.getSelection()) continue;
            return jRadioButton;
        }
        return null;
    }

    private void addLogicaldrivesToCheckBox(LogicalDriveHelper[] logicalDriveHelperArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.listPanel.setLayout(new GridBagLayout());
        int n = logicalDriveHelperArray.length;
        this.checkBox = new JCheckBox[n];
        short[] sArray = this.getexcludedLD();
        int n2 = this.getexcludedLDCount();
        boolean bl = n2 > 0;
        for (int i = 0; i < n; ++i) {
            this.checkBox[i] = new JCheckBox(logicalDriveHelperArray[i].getText());
            this.checkBox[i].setSelected(true);
            this.checkBox[i].setOpaque(false);
            if (bl) {
                for (int j = 0; j < n2; ++j) {
                    if (logicalDriveHelperArray[i].getDeviceObject().getID() != sArray[j]) continue;
                    this.checkBox[i].setSelected(false);
                }
            }
            this.listPanel.add((Component)this.checkBox[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
    }

    public ArrayList<LogicalDriveHelper> getUnSelectedLDs(LogicalDriveHelper[] logicalDriveHelperArray) {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        if (this.checkBox != null) {
            int n = this.checkBox.length;
            for (int i = 0; i < n; ++i) {
                if (this.checkBox[i].isSelected()) continue;
                arrayList.add(logicalDriveHelperArray[i]);
            }
        }
        return arrayList;
    }
}

