/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CCOH.CCOHBaseDialog;
import GUI.DetailPanel;
import GUI.MainFrame;
import GUI.PropertyViewPanel;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ServerObjectHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASServer;
import SASKernel.VirtualAdapter;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ServerDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private GUIHelperInterface obj;
    private boolean viewOnly = false;
    private ServerObjectHelper m_objServerObjectHelper;

    public ServerDetailPanel(GUIHelperInterface gUIHelperInterface, MainFrame mainFrame) {
        super(gUIHelperInterface, mainFrame);
        this.obj = gUIHelperInterface;
        this.m_objServerObjectHelper = (ServerObjectHelper)gUIHelperInterface;
        this.init();
    }

    @Override
    public void init() {
        this.viewOnly = ((SASServer)this.obj.getDeviceObject()).getAccMode() == 1;
        this.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.obj.getPropertyList());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(jPanel), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        jPanel.add((Component)propertyViewPanel, "North");
        this.add((Component)this.tabbedPane, "Center");
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        if (jMenu == null) {
            return;
        }
        String[] stringArray = null;
        if (!this.viewOnly && this.m_objServerObjectHelper.canCreateCacheGroup() && operationDetails.getOpcode() == 1169) {
            final CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper = this.m_objServerObjectHelper.getCCOHVirtualAdapHelper();
            stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_CACHE_GROUP", "(C)reate Cache Group"));
            JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
            if (stringArray.length == 2) {
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
            }
            jMenu.add(jMenuItem);
            jMenuItem.setEnabled(((VirtualAdapter)cCOHVirtualAdapterHelper.getDeviceObject()).isCCOHLicenseFound());
            jMenuItem.setActionCommand("1169");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new CCOHBaseDialog(cCOHVirtualAdapterHelper);
                }
            });
        }
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Server")) continue;
            return jMenu2;
        }
        return jMenu2;
    }
}

