/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBrandingPanel;
import GUI.VivaldiStartupDialog;
import KernelServices.NotifyObject;
import KernelServices.SimpleStatusNotification;
import SASKernel.PluginInfo;
import SASKernel.SASServer;
import SASKernel.SASServerInfo;
import Utils.ImagePanel;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class SplashScreenWindow
extends Window
implements Observer {
    private static Dimension size = null;
    private JPanel topPanel = new JPanel();
    private ImagePanel imagePanel = null;
    private JPanel msgPanel = new JPanel();
    private JTextField msgText = new JTextField();
    private Thread splashThread = null;
    private boolean startThread = false;
    private static final SplashScreenWindow splashScreen = new SplashScreenWindow();

    private SplashScreenWindow() {
        super(new JFrame());
        this.init();
        this.splashThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SplashScreenWindow.this.initScreen();
            }
        });
    }

    public static SplashScreenWindow getSplashScreen() {
        return splashScreen;
    }

    public static Dimension getImageSize() {
        return size;
    }

    private void init() {
        if (VivaldiBrandingPanel.isChannelPartnerPresent("CHANNELSPLASHSCREEN")) {
            String string = VivaldiBrandingPanel.getChannelImageName("CHANNELSPLASHSCREEN");
            this.imagePanel = new ImagePanel(string, true, true, true);
        } else {
            this.imagePanel = new ImagePanel(Resource.getString("SPLASH_ICON", "msm_splash_screen.jpg"), true, true, true);
        }
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            this.imagePanel = new ImagePanel(Resource.getString("SPLASH_ICON_INTEL"), true, true, true);
        }
        this.msgText.setEditable(false);
        this.msgText.setToolTipText(Resource.getString("MSG_DSC", "Message"));
        this.msgPanel.setLayout(new BorderLayout());
        this.msgPanel.add(this.msgText);
        size = this.imagePanel.getDimension();
        this.topPanel.setLayout(new BorderLayout());
        this.imagePanel.setPreferredSize(size);
        this.topPanel.add((Component)this.imagePanel, "Center");
        this.topPanel.add((Component)this.msgPanel, "South");
        this.msgPanel.setBackground(Color.white);
        this.add(this.topPanel);
        this.pack();
    }

    public synchronized void displaySplasScreen(int n) {
        if (n == 2561) {
            return;
        }
        if (!this.startThread) {
            this.startThread = true;
            this.splashThread.start();
        } else {
            super.setVisible(true);
        }
    }

    private void initScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        super.setVisible(true);
    }

    public synchronized void hideSplashScreen() {
        if (!splashScreen.isVisible()) {
            return;
        }
        if (!this.startThread) {
            return;
        }
        if (this.startThread) {
            super.setVisible(false);
        }
    }

    public synchronized void setMessage(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "";
        }
        this.msgText.setText(string);
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        String string = "";
        NotifyObject notifyObject = null;
        SimpleStatusNotification simpleStatusNotification = null;
        if (object instanceof NotifyObject) {
            notifyObject = (NotifyObject)object;
            if (notifyObject.getNotifyCode() != 2101251) {
                return;
            }
        } else {
            return;
        }
        simpleStatusNotification = (SimpleStatusNotification)notifyObject.getNotifyObject();
        int n = simpleStatusNotification.getStatusNotificationType();
        Object object2 = simpleStatusNotification.getSource();
        Object object3 = simpleStatusNotification.getStatusNotificationObject();
        switch (n) {
            case 4097: {
                String string2 = (String)object3;
                string = Resource.getString("SPLASH_MSG_CONNECT_FRAMEWORK", "Connecting Server") + " " + this.getIP(string2) + " " + Resource.getString("SPLASH_MSG_WAIT");
                break;
            }
            case 4099: {
                SASServerInfo sASServerInfo = (SASServerInfo)object3;
                break;
            }
            case 8193: {
                string = Resource.getString("SPLASH_MSG_ADAPTER_FOUND", "Scanning Adapter...");
                break;
            }
            case 4098: {
                PluginInfo pluginInfo = (PluginInfo)object3;
                string = this.getIP(pluginInfo.getWWN()) + " :: " + Resource.getString("SPLASH_MSG_LOADING_PLUGIN", "Loading") + " " + pluginInfo.getDescription().trim();
                break;
            }
            case 8192: {
                return;
            }
            case 4100: {
                Byte by = (Byte)object3;
                if (by == 0) {
                    string = this.getIP(((SASServer)object2).getSvrWWN()) + " :: " + Resource.getString("SPLASH_MSG_LOGIN_FULL_ACCESS_REQUEST", "Logging in with 'Full Access' mode...");
                    break;
                }
                string = this.getIP(((SASServer)object2).getSvrWWN()) + " :: " + Resource.getString("SPLASH_SCREEN_LOGIN_VIEW_ONLY_REQUEST", "Logging in with 'View Only' mode...");
                break;
            }
            default: {
                return;
            }
        }
        this.setMessage(string);
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }
}

