/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PropertyViewPanel;
import GUIHelper.TapeHelper;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import javax.swing.JPanel;

public class TapeDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private JPanel operationTab = new JPanel();
    private JPanel graphicalTab = new JPanel();
    private OperationViewPanel opView;
    private TapeHelper tape;

    public TapeDetailPanel(TapeHelper tapeHelper, MainFrame mainFrame) {
        super(tapeHelper, mainFrame);
        this.tape = tapeHelper;
        this.propertiesTab.setLayout(new BorderLayout());
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, this.propertiesTab, Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.add((Component)this.tabbedPane, "Center");
        this.init();
        tapeHelper.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.tape.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        this.validate();
        this.repaint();
    }

    @Override
    public boolean canClose() {
        this.tape.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

