/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.ListListener;
import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import Utils.PropertiesFileHandler;
import Utils.Resource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ToolBarHandler
implements ActionListener {
    public static final int[] toolBarAdpOperations = new int[]{1100};
    public static final int[] toolBarGrpOperations = new int[]{1002, 1001, 1123};
    public static final int[] toolBarMainOperations = new int[]{1003, 3000};
    public static final int alwaysEnabledOperations = 1002;
    private static ArrayList<Integer> addedToolButtons = new ArrayList();
    public static final String GRPNAME = "Group Operations";
    public static final String CONTROLLERNAME = "Controller";
    private static final String[] mainOperations = new String[]{"Group Operations", "Controller"};
    private static VivaldiBaseDialog optionsDialog = null;
    private static PropertiesFileHandler m_fileHandle = null;
    private static final String ADDEDOPERPROPERTY = "ADDEDOPERATIONS";
    public static final String SERVERSTR = Resource.getString("SERVER_TEXT", "Servers");
    public static final String REFRESHSTR = Resource.getString("BBU_OPERATION_REFRESH", "Refresh");
    public static final String PROGRESSSTR = Resource.getString("GRP_SHOWPROGRESS_TITLE", "Show Progress");
    public static final String EXITSTR = Resource.getString("MENU_EXIT_TEXT", "Exit");
    public static final String CREATEVDSTR = Resource.getString("BUTTON_CREATE_VD", "Create VD");
    public static final String HELPSTR = Resource.getString("MENU_HELP_TEXT", "Help");
    public static final String SERVERIMAGE = "SERVERIMAGE";
    public static final String REFRESHIMAGE = "REFRESHIMAGE";
    public static final String PROGRESSIMAGE = "PROGRESSIMAGE";
    public static final String CREATEVDIMAGE = "CREATEVDIMAGE";
    public static final String EXITIMAGE = "EXITIMAGE";
    public static final String HELPIMAGE = "HELPIMAGE";
    public static final String SEPARATORIMAGE = "SEPARATORIMAGE";
    private static DefaultListModel fullListModel = new DefaultListModel();
    private static DefaultListModel addedGrpListModel = new DefaultListModel();
    private static DefaultListModel addedAdpListModel = new DefaultListModel();
    private static DefaultListModel addedListModel = new DefaultListModel();
    private static JList fullList = new JList(fullListModel);
    private static JList mainList = new JList<String>(mainOperations);
    private static JList addedList = new JList(addedListModel);
    private static final String ADDCMD = "ADDCMD";
    private static final String REMOVECMD = "REMOVECMD";
    private static final String GOCMD = "GOCMD";
    private static ToolBarHandler handleObj = new ToolBarHandler();
    public static ArrayList<String> toAddList = new ArrayList();
    public static String addedToolButtonStr;
    public static int SEPARATOR;
    public static HashMap<Integer, String> toolBarButtonMap;
    public static HashMap<Integer, String> toolBarButtonIconMap;

    public static void main(String[] stringArray) {
        new ToolBarHandler().getToolBarOptionsDialog().setVisible(true);
    }

    public static int[] getToolBarAdpOperations() {
        return toolBarAdpOperations;
    }

    public static int[] getToolBarMainOperations() {
        return toolBarMainOperations;
    }

    public static int[] getToolBarGrpOperations() {
        return toolBarGrpOperations;
    }

    public static ArrayList<Integer> getAddedToolButtons() {
        return addedToolButtons;
    }

    public static void appendToolBarButton(int n) {
        addedToolButtons.add(new Integer(n));
    }

    public static void removeToolBarButton(int n) {
        addedToolButtons.remove(new Integer(n));
    }

    public static JButton createToolBarButton(int n, String string, String string2, String string3, boolean bl, boolean bl2) {
        JButton jButton = new JButton();
        ImageIcon imageIcon = Resource.getImage(string);
        jButton.setIcon(imageIcon);
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        jButton.setEnabled(bl);
        jButton.setFocusable(bl2);
        return jButton;
    }

    public static JButton createToolBarButton(String string, boolean bl, boolean bl2) {
        JButton jButton = new JButton();
        ImageIcon imageIcon = Resource.getImage(string);
        jButton.setIcon(imageIcon);
        jButton.setEnabled(bl);
        jButton.setFocusable(bl2);
        return jButton;
    }

    public JDialog getToolBarOptionsDialog() {
        optionsDialog = new VivaldiBaseDialog();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        mainList.setBorder(BorderFactory.createEtchedBorder());
        mainList.addListSelectionListener(new ListListener(handleObj));
        JScrollPane jScrollPane = new JScrollPane(mainList);
        mainList.setSelectedIndex(0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridx;
        fullList.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane2 = new JScrollPane(fullList);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        JButton jButton = new JButton(Resource.getString("BUTTON_ADD_DSC", "Add"));
        jButton.setActionCommand(ADDCMD);
        jButton.addActionListener(handleObj);
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 1;
        JButton jButton2 = new JButton(Resource.getString("BUTTON_REMOVE_DSC", "Remove"));
        jButton2.setActionCommand(REMOVECMD);
        jButton2.addActionListener(handleObj);
        jPanel.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        addedList.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane3 = new JScrollPane(addedList);
        jPanel.add((Component)jScrollPane3, gridBagConstraints);
        optionsDialog.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_OK", "OK"));
        JButton jButton3 = new JButton(stringArray[0]);
        jButton3.setToolTipText(Resource.getString("ABOUT_OKBUTTON_TEXT_DSC", "OK"));
        if (stringArray.length == 2) {
            jButton3.setMnemonic(stringArray[1].charAt(0));
        }
        jButton3.addActionListener(handleObj);
        jButton3.setActionCommand(GOCMD);
        jPanel2.add(jButton3);
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        JButton jButton4 = new JButton(stringArray2[0]);
        jButton4.setToolTipText(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        if (stringArray2.length == 2) {
            jButton4.setMnemonic(stringArray[1].charAt(0));
        }
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0);
                JDialog jDialog = jOptionPane.createDialog(optionsDialog, optionsDialog.getTitle());
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object instanceof Integer) {
                    if ((Integer)object == 0) {
                        jDialog.dispose();
                        optionsDialog.dispose();
                    } else {
                        jDialog.dispose();
                    }
                }
            }
        });
        jPanel2.add(jButton4);
        optionsDialog.add((Component)jPanel2, "South");
        optionsDialog.pack();
        optionsDialog.setTitle("ToolBar options");
        return optionsDialog;
    }

    private static PropertiesFileHandler getPropertyFileHandler() {
        if (m_fileHandle == null) {
            m_fileHandle = new PropertiesFileHandler("msm.properties");
            return m_fileHandle;
        }
        return m_fileHandle;
    }

    public static void updateAddedOperations() {
        addedToolButtons.clear();
        String string = ToolBarHandler.getPropertyFileHandler().getProperty(ADDEDOPERPROPERTY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = -1;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    System.out.println("Got execption in ToolBarHandler in converting string to int");
                }
                ToolBarHandler.appendToolBarButton(new Integer(n));
            }
        }
    }

    private void appendItem(DefaultListModel defaultListModel, int n) {
        defaultListModel.addElement(ToolBarHandler.getToolBarButtonName(n));
    }

    private void removeItem(DefaultListModel defaultListModel, int n) {
        defaultListModel.removeElement(ToolBarHandler.getToolBarButtonName(n));
    }

    public void updateGrpButtons() {
        fullListModel.clear();
        addedListModel.clear();
        for (int i = 0; i < toolBarGrpOperations.length; ++i) {
            int n = toolBarGrpOperations[i];
            String string = ToolBarHandler.getToolBarButtonName(n);
            if (addedGrpListModel.contains(string)) {
                addedListModel.addElement(string);
                continue;
            }
            fullListModel.addElement(string);
        }
    }

    public void updateAdpButtons() {
        addedListModel.clear();
        fullListModel.clear();
        for (int i = 0; i < toolBarAdpOperations.length; ++i) {
            int n = toolBarAdpOperations[i];
            String string = ToolBarHandler.getToolBarButtonName(n);
            if (addedAdpListModel.contains(string)) {
                addedListModel.addElement(string);
                continue;
            }
            fullListModel.addElement(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ADDCMD)) {
            Object[] objectArray = fullList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                Integer n = ToolBarHandler.getToolBarButtonId(string);
                if (mainList.getSelectedValue().equals(CONTROLLERNAME)) {
                    this.appendItem(addedAdpListModel, n);
                } else if (mainList.getSelectedValue().equals(GRPNAME)) {
                    this.appendItem(addedGrpListModel, n);
                }
                this.appendItem(addedListModel, n);
                this.removeItem(fullListModel, n);
            }
        } else if (actionEvent.getActionCommand().equals(REMOVECMD)) {
            Object[] objectArray = addedList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                Integer n = ToolBarHandler.getToolBarButtonId(string);
                this.appendItem(fullListModel, n);
                if (mainList.getSelectedValue().equals(CONTROLLERNAME)) {
                    this.removeItem(addedAdpListModel, n);
                } else if (mainList.getSelectedValue().equals(GRPNAME)) {
                    this.removeItem(addedGrpListModel, n);
                }
                this.removeItem(addedListModel, n);
            }
        } else if (actionEvent.getActionCommand().equals(GOCMD)) {
            this.updatePropertyFile();
            optionsDialog.dispose();
            MainFrame.updateToolBar();
        }
    }

    public void updatePropertyFile() {
        Integer n;
        int n2;
        addedToolButtons.clear();
        String string = "";
        for (n2 = 0; n2 < addedAdpListModel.size(); ++n2) {
            n = ToolBarHandler.getToolBarButtonId((String)addedAdpListModel.get(n2));
            string = string + n + ";";
            addedToolButtons.add(n);
        }
        for (n2 = 0; n2 < addedGrpListModel.size(); ++n2) {
            n = ToolBarHandler.getToolBarButtonId((String)addedGrpListModel.get(n2));
            string = string + n + ";";
            addedToolButtons.add(n);
        }
        if (string != null) {
            ToolBarHandler.getPropertyFileHandler().setProperty(ADDEDOPERPROPERTY, string);
        }
    }

    public static Integer getToolBarButtonId(String string) {
        for (Map.Entry<Integer, String> entry : toolBarButtonMap.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static String getToolBarButtonName(int n) {
        String string = toolBarButtonMap.get(new Integer(n));
        String[] stringArray = Resource.getResourceMnemonic(string);
        return stringArray[0];
    }

    public static String getToolBarButtonIconStr(int n) {
        return toolBarButtonIconMap.get(new Integer(n));
    }

    static {
        SEPARATOR = -1;
        toolBarButtonMap = new HashMap();
        toolBarButtonIconMap = new HashMap();
        toolBarButtonMap.put(1002, SERVERSTR);
        toolBarButtonMap.put(1123, PROGRESSSTR);
        toolBarButtonMap.put(1001, REFRESHSTR);
        toolBarButtonMap.put(1100, CREATEVDSTR);
        toolBarButtonMap.put(1003, EXITSTR);
        toolBarButtonMap.put(3000, HELPSTR);
        toolBarButtonIconMap.put(1002, SERVERIMAGE);
        toolBarButtonIconMap.put(1123, PROGRESSIMAGE);
        toolBarButtonIconMap.put(1001, REFRESHIMAGE);
        toolBarButtonIconMap.put(1100, CREATEVDIMAGE);
        toolBarButtonIconMap.put(1003, EXITIMAGE);
        toolBarButtonIconMap.put(3000, HELPIMAGE);
        toolBarButtonIconMap.put(SEPARATOR, SEPARATORIMAGE);
    }
}

