/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CapacityNode;
import GUI.DetailPanel;
import GUI.DeviceTree;
import GUI.DeviceTreeNode;
import GUI.MainFrame;
import GUI.SpannedDriveGroupNode;
import GUI.VivaldiStartupDialog;
import GUIHelper.ContainerNodeHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.SpannedDriveGroupHelper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeNodeListener
extends MouseAdapter
implements TreeSelectionListener {
    private GUIHelperInterface helper;
    private MainFrame mainFrame;
    private JMenu opMenu;
    public int rowNumber;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        if (!MainFrame.fullAccess) {
            return;
        }
        if (mouseEvent.getButton() != 1 && mouseEvent.getButton() != 3) {
            return;
        }
        DeviceTree deviceTree = (DeviceTree)mouseEvent.getSource();
        TreePath treePath = deviceTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        deviceTree.setSelectionPath(treePath);
        this.mainFrame = deviceTree.getMainScreen();
        DeviceTreeNode deviceTreeNode = (DeviceTreeNode)treePath.getLastPathComponent();
        if (deviceTreeNode == null) {
            return;
        }
        this.rowNumber = deviceTree.getLeadSelectionRow();
        this.helper = deviceTreeNode.getObjectManager();
        if (this.helper.getType() == 11 && mouseEvent.getButton() == 3) {
            object = (ContainerNodeHelper)deviceTreeNode.getObjectManager();
            if (((ContainerNodeHelper)object).getCallerIdentifier() == 8) {
                CapacityNode capacityNode = new CapacityNode((ContainerNodeHelper)object);
                if (VivaldiStartupDialog.VENUS_FLAG) {
                    JMenu jMenu = new JMenu();
                    JMenuItem jMenuItem = capacityNode.getCreateVDMenuItem();
                    if (jMenuItem == null) return;
                    jMenu.setEnabled(true);
                    jMenu.add(jMenuItem);
                    jMenu.getPopupMenu().show(deviceTree, mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                this.opMenu = this.mainFrame.getDynamicMenu();
                if (this.opMenu.getItemCount() == 0) {
                    return;
                }
            }
        } else if (this.helper.getType() == 13 && mouseEvent.getButton() == 3) {
            JMenuItem jMenuItem;
            object = (SpannedDriveGroupHelper)deviceTreeNode.getObjectManager();
            SpannedDriveGroupNode spannedDriveGroupNode = new SpannedDriveGroupNode((SpannedDriveGroupHelper)object);
            JMenu jMenu = new JMenu();
            JMenuItem jMenuItem2 = spannedDriveGroupNode.getpowerSettingMenuItem();
            if (jMenuItem2 != null) {
                jMenu.add(jMenuItem2);
            }
            if ((jMenuItem = spannedDriveGroupNode.getprotectionDisableMenuItem()) != null) {
                jMenu.add(jMenuItem);
            }
            if (jMenuItem2 != null) {
                jMenu.setEnabled(true);
                jMenu.getPopupMenu().show(deviceTree, mouseEvent.getX(), mouseEvent.getY());
            } else {
                if (jMenuItem == null) return;
                jMenu.setEnabled(true);
                jMenu.getPopupMenu().show(deviceTree, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            this.opMenu = this.mainFrame.getDynamicMenu();
            if (this.opMenu.getItemCount() == 0) {
                return;
            }
        }
        if (this.helper.getType() == 11 || mouseEvent.getButton() != 3) return;
        object = this.mainFrame.getCurrentPanel().getSubMenu(this.opMenu);
        this.mainFrame.updateDetailsPanel(deviceTreeNode);
        if (object == null) return;
        ((JMenu)object).getPopupMenu().show(deviceTree, mouseEvent.getX(), mouseEvent.getY());
        ((JMenu)object).getPopupMenu().setInvoker((Component)object);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DeviceTree deviceTree = (DeviceTree)treeSelectionEvent.getSource();
        DeviceTreeNode deviceTreeNode = deviceTree.getSelectedNode();
        this.mainFrame = deviceTree.getMainScreen();
        if (deviceTreeNode != null) {
            this.helper = deviceTreeNode.getObjectManager();
            this.mainFrame.updateDetailsPanel(deviceTreeNode);
            if (this.helper.getType() == 11) {
                this.opMenu = this.mainFrame.getDynamicMenu();
                DetailPanel.populateWithAllDisabledMenuItems(this.opMenu);
            }
        }
    }
}

