/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import Utils.ColorHash;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VersionDetailsDialog
extends VivaldiBaseDialog {
    private JPanel servInfoPanel = new JPanel(new GridBagLayout());
    private JPanel versionInfoPanel = new JPanel(new GridBagLayout());
    private JButton okButton = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
    private SASServer server;

    public VersionDetailsDialog(SASServer sASServer) {
        JComponent jComponent;
        Serializable serializable;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = -1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(Resource.getString("ABOUT_HOSTNAME_TEXT", "HostName"));
        stringBuffer.append(" : ");
        stringBuffer.append(sASServer.getInformation().getHostName());
        stringBuffer.append("<br><br>");
        stringBuffer.append(Resource.getString("ABOUT_IPADDRESS_TEXT", "IP Address"));
        stringBuffer.append(" : ");
        stringBuffer.append(sASServer.getInformation().getIP());
        stringBuffer.append("<br><br>");
        stringBuffer.append(Resource.getString("ABOUT_OSNAME_TEXT", "Operating System Name"));
        stringBuffer.append(" : ");
        if (!sASServer.isCIMOMServer()) {
            stringBuffer.append(sASServer.getInformation().OperatingSystemName());
            stringBuffer.append("<br><br>");
            stringBuffer.append(Resource.getString("ABOUT_OSVERSION_TEXT", "Operating System Version"));
            stringBuffer.append(" : ");
            stringBuffer.append(sASServer.getInformation().OperatingSystemVersion());
            stringBuffer.append("<br><br>");
            stringBuffer.append(Resource.getString("ABOUT_OSARCHI_TEXT", "Operating System Architecture"));
            stringBuffer.append(" : ");
            stringBuffer.append(sASServer.getInformation().OperatingSystemArch());
            stringBuffer.append("</html>");
        } else {
            stringBuffer.append(Resource.getString("OS_NAME_VMWARE_ESXI", "VMWare ESXi"));
            stringBuffer.append("</html>");
        }
        JLabel jLabel = new JLabel(stringBuffer.toString());
        this.servInfoPanel.add((Component)jLabel, gridBagConstraints);
        this.servInfoPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("SERVERINFO_LABEL_TEXT", "Server Information")));
        if (!VivaldiStartupDialog.isWindows) {
            this.servInfoPanel.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        }
        if (!sASServer.isCIMOMServer()) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("<html>");
            ((StringBuffer)serializable).append(Resource.getString("LABEL_FWVERSION_TEXT", "Framework Version : "));
            ((StringBuffer)serializable).append(sASServer.getFrameworkVersion().trim());
            ((StringBuffer)serializable).append("<br><br>");
            ((StringBuffer)serializable).append(Resource.getString("LABLE_KERNELVERSION_TEXT", "Kernel Version : "));
            ((StringBuffer)serializable).append(((SASKernel)sASServer.parent()).getSASKernelVersion());
            for (int i = 0; i < sASServer.getPluginList().length; ++i) {
                ((StringBuffer)serializable).append("<br><br>");
                ((StringBuffer)serializable).append(sASServer.getPluginList()[i].getDescription().trim());
            }
            ((StringBuffer)serializable).append("</html>");
            jComponent = new JLabel(((StringBuffer)serializable).toString());
            this.versionInfoPanel.add((Component)jComponent, gridBagConstraints);
            this.versionInfoPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("VERSIONINFO_LABEL_TEXT", "Version Information")));
        }
        if (!VivaldiStartupDialog.isWindows) {
            this.versionInfoPanel.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(this.servInfoPanel, "North");
        ((Container)serializable).add(this.versionInfoPanel, "Center");
        this.contentPane.add((Component)serializable, "Center");
        jComponent = new JPanel(new FlowLayout());
        jComponent.add(this.okButton);
        this.contentPane.add((Component)jComponent, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VersionDetailsDialog.this.dispose();
            }
        });
        this.setTitle(VivaldiStartupDialog.FRAME_TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }
}

