/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.EventTable;
import GUI.Localization;
import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VivaldiLogConfiguration
extends VivaldiBaseDialog {
    private JButton okButton;
    private JButton cancelButton;
    public String m_GUI_config_file_name;
    private Properties eventCfgProp = null;
    private Localization m_locObject;
    public static int m_width;
    public static int m_height;
    private JButton m_remove;
    private JButton m_removeAll;
    private JButton m_add;
    private JButton m_addAll;
    private JTable m_enabledTable;
    private JTable m_disabledTable;
    private String[][] m_enabledRow;
    private String[][] m_disabledRow;
    private ArrayList enabledList;
    private ArrayList disabledList;
    private JPanel m_invidualPanel;
    private JPanel m_severityPanel;
    private String oemType = "";

    public VivaldiLogConfiguration(String string) {
        this.m_GUI_config_file_name = string;
        this.loadEvtCfg();
        String[] stringArray = null;
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            this.setTitle("RWC2 " + Resource.getString("VIVALDI_LOG_FILTER", "Event Log Filter"));
            this.oemType = "RWC2";
        } else if (VivaldiStartupDialog.OEM_TYPE == 2561) {
            this.setTitle("SSM " + Resource.getString("VIVALDI_LOG_FILTER", "Event Log Filter"));
            this.oemType = "SSM";
        } else {
            this.setTitle("MSM " + Resource.getString("VIVALDI_LOG_FILTER", "Event Log Filter"));
            this.oemType = "MSM";
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "O(K)"));
        this.okButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.okButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_TEXT", "Remo(v)e"));
        this.m_remove = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_remove.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_ALL_TEXT", "(R)emove All"));
        this.m_removeAll = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeAll.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_TEXT", "A(d)d"));
        this.m_add = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_add.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_ALL_TEXT", "Add (A)ll"));
        this.m_addAll = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addAll.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_add.setIcon(Resource.getImage("MONITOR_ADD_ICON", "monitor_add.png"));
        this.m_addAll.setIcon(Resource.getImage("MONITOR_ADD_ALL_ICON", "monitor_add_all.png"));
        this.m_remove.setIcon(Resource.getImage("MONITOR_REMOVE_ICON", "monitor_rem.png"));
        this.m_removeAll.setIcon(Resource.getImage("MONITOR_REMOVE_ALL_ICON", "monitor_rem_all.png"));
        this.setSize(MainFrame.SCREEN_SIZE.width * 500 / 1024, MainFrame.SCREEN_SIZE.height * 480 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.setDefaultCloseOperation(2);
        m_width = this.getWidth();
        m_height = this.getHeight();
        this.m_invidualPanel = this.getIndividualPaneCenterPanel();
        this.contentPane.add((Component)this.m_invidualPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        stringArray = Resource.getResourceMnemonic(Resource.getString("CANCEL", "Cancel"));
        this.cancelButton = new JButton(stringArray[0]);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.contentPane.add((Component)jPanel, "South");
        this.setModal(true);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VivaldiLogConfiguration.this.m_enabledRow == null && VivaldiLogConfiguration.this.m_disabledRow != null) {
                    VivaldiLogConfiguration.this.dispose();
                }
                System.out.println("File name = " + VivaldiLogConfiguration.this.m_GUI_config_file_name);
                File file = new File(VivaldiLogConfiguration.this.m_GUI_config_file_name);
                BufferedWriter bufferedWriter = null;
                String string = "";
                String string2 = "=";
                int n = -1;
                VivaldiLogConfiguration.this.enabledList = new ArrayList();
                VivaldiLogConfiguration.this.disabledList = new ArrayList();
                try {
                    int n2;
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    Object[] objectArray = new Object[3];
                    if (VivaldiLogConfiguration.this.m_enabledRow != null) {
                        for (n2 = 0; n2 < VivaldiLogConfiguration.this.m_enabledRow.length; ++n2) {
                            objectArray[0] = VivaldiLogConfiguration.this.m_enabledRow[n2][0];
                            objectArray[1] = VivaldiLogConfiguration.this.m_enabledRow[n2][1];
                            objectArray[2] = VivaldiLogConfiguration.this.m_enabledRow[n2][2];
                            string = objectArray[0].toString();
                            string = string + "=1;" + VivaldiLogConfiguration.this.getSeverity(objectArray[1].toString().trim());
                            bufferedWriter.write(string);
                            bufferedWriter.newLine();
                        }
                    }
                    if (VivaldiLogConfiguration.this.m_disabledRow != null) {
                        for (n2 = 0; n2 < VivaldiLogConfiguration.this.m_disabledRow.length; ++n2) {
                            objectArray[0] = VivaldiLogConfiguration.this.m_disabledRow[n2][0];
                            objectArray[1] = VivaldiLogConfiguration.this.m_disabledRow[n2][1];
                            objectArray[2] = VivaldiLogConfiguration.this.m_disabledRow[n2][2];
                            string = objectArray[0].toString();
                            string = string + "=0;" + VivaldiLogConfiguration.this.getSeverity(objectArray[1].toString().trim());
                            bufferedWriter.write(string);
                            bufferedWriter.newLine();
                        }
                    }
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    System.out.println("exception while write the std GUI log file");
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                VivaldiLogConfiguration.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VivaldiLogConfiguration.this.dispose();
            }
        });
        this.m_remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3 = VivaldiLogConfiguration.this.m_enabledTable.getSelectedRow();
                System.out.println("Row = " + n3);
                if (n3 < 0) {
                    VivaldiLogConfiguration.this.m_remove.setEnabled(false);
                    VivaldiLogConfiguration.this.m_removeAll.setEnabled(false);
                    return;
                }
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = new Object[3];
                objectArray[0] = VivaldiLogConfiguration.this.m_enabledRow[n3][0];
                objectArray[1] = VivaldiLogConfiguration.this.m_enabledRow[n3][1];
                objectArray[2] = VivaldiLogConfiguration.this.m_enabledRow[n3][2];
                VivaldiLogConfiguration.this.disabledList.add(objectArray);
                ArrayList arrayList = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.disabledList);
                VivaldiLogConfiguration.this.disabledList = null;
                VivaldiLogConfiguration.this.disabledList = new ArrayList();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    VivaldiLogConfiguration.this.disabledList.add(arrayList.get(n2));
                }
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.disabledList.size()][3]);
                for (n2 = 0; n2 < VivaldiLogConfiguration.this.disabledList.size(); ++n2) {
                    objectArray2 = (Object[])VivaldiLogConfiguration.this.disabledList.get(n2);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n2][0] = objectArray2[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n2][1] = objectArray2[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n2][2] = objectArray2[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_disabledTable).fillTable(VivaldiLogConfiguration.this.m_disabledRow);
                ((EventTable)VivaldiLogConfiguration.this.m_enabledTable).deleteRow(n3);
                VivaldiLogConfiguration.this.enabledList.remove(n3);
                ArrayList arrayList2 = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.enabledList);
                VivaldiLogConfiguration.this.enabledList = null;
                VivaldiLogConfiguration.this.enabledList = new ArrayList();
                for (n = 0; n < arrayList2.size(); ++n) {
                    VivaldiLogConfiguration.this.enabledList.add(arrayList2.get(n));
                }
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.enabledList.size()][3]);
                for (n = 0; n < VivaldiLogConfiguration.this.enabledList.size(); ++n) {
                    objectArray2 = (Object[])VivaldiLogConfiguration.this.enabledList.get(n);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n][0] = objectArray2[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n][1] = objectArray2[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n][2] = objectArray2[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_enabledTable).fillTable(VivaldiLogConfiguration.this.m_enabledRow);
                VivaldiLogConfiguration.this.repaint();
            }
        });
        this.m_removeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VivaldiLogConfiguration.this.m_enabledTable.removeAll();
                if (VivaldiLogConfiguration.this.m_enabledTable.getRowCount() == 0) {
                    VivaldiLogConfiguration.this.m_remove.setEnabled(false);
                    VivaldiLogConfiguration.this.m_removeAll.setEnabled(false);
                }
                for (int i = 0; i < VivaldiLogConfiguration.this.enabledList.size(); ++i) {
                    VivaldiLogConfiguration.this.disabledList.add(VivaldiLogConfiguration.this.enabledList.get(i));
                }
                ArrayList arrayList = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.disabledList);
                VivaldiLogConfiguration.this.disabledList = null;
                VivaldiLogConfiguration.this.disabledList = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    VivaldiLogConfiguration.this.disabledList.add(arrayList.get(i));
                }
                VivaldiLogConfiguration.this.enabledList = null;
                VivaldiLogConfiguration.this.enabledList = new ArrayList();
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.disabledList.size()][3]);
                Object[] objectArray = new Object[3];
                for (int i = 0; i < VivaldiLogConfiguration.this.disabledList.size(); ++i) {
                    objectArray = (Object[])VivaldiLogConfiguration.this.disabledList.get(i);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[i][0] = objectArray[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[i][1] = objectArray[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[i][2] = objectArray[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_disabledTable).fillTable(VivaldiLogConfiguration.this.m_disabledRow);
                ((EventTable)VivaldiLogConfiguration.this.m_enabledTable).deleteAllRow();
                VivaldiLogConfiguration.this.repaint();
            }
        });
        this.m_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3 = VivaldiLogConfiguration.this.m_disabledTable.getSelectedRow();
                System.out.println("Row = " + n3);
                if (n3 < 0) {
                    VivaldiLogConfiguration.this.m_add.setEnabled(false);
                    VivaldiLogConfiguration.this.m_addAll.setEnabled(false);
                    return;
                }
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = new Object[3];
                objectArray[0] = VivaldiLogConfiguration.this.m_disabledRow[n3][0];
                objectArray[1] = VivaldiLogConfiguration.this.m_disabledRow[n3][1];
                objectArray[2] = VivaldiLogConfiguration.this.m_disabledRow[n3][2];
                VivaldiLogConfiguration.this.enabledList.add(objectArray);
                ArrayList arrayList = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.enabledList);
                VivaldiLogConfiguration.this.enabledList = null;
                VivaldiLogConfiguration.this.enabledList = new ArrayList();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    VivaldiLogConfiguration.this.enabledList.add(arrayList.get(n2));
                }
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.enabledList.size()][3]);
                for (n2 = 0; n2 < VivaldiLogConfiguration.this.enabledList.size(); ++n2) {
                    objectArray2 = (Object[])VivaldiLogConfiguration.this.enabledList.get(n2);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n2][0] = objectArray2[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n2][1] = objectArray2[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[n2][2] = objectArray2[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_enabledTable).fillTable(VivaldiLogConfiguration.this.m_enabledRow);
                ((EventTable)VivaldiLogConfiguration.this.m_disabledTable).deleteRow(n3);
                VivaldiLogConfiguration.this.disabledList.remove(n3);
                ArrayList arrayList2 = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.disabledList);
                VivaldiLogConfiguration.this.disabledList = null;
                VivaldiLogConfiguration.this.disabledList = new ArrayList();
                for (n = 0; n < arrayList2.size(); ++n) {
                    VivaldiLogConfiguration.this.disabledList.add(arrayList2.get(n));
                }
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.disabledList.size()][3]);
                for (n = 0; n < VivaldiLogConfiguration.this.disabledList.size(); ++n) {
                    objectArray2 = (Object[])VivaldiLogConfiguration.this.disabledList.get(n);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n][0] = objectArray2[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n][1] = objectArray2[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_disabledRow[n][2] = objectArray2[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_disabledTable).fillTable(VivaldiLogConfiguration.this.m_disabledRow);
                VivaldiLogConfiguration.this.repaint();
            }
        });
        this.m_addAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VivaldiLogConfiguration.this.m_disabledTable.removeAll();
                if (VivaldiLogConfiguration.this.m_disabledTable.getRowCount() == 0) {
                    VivaldiLogConfiguration.this.m_remove.setEnabled(false);
                    VivaldiLogConfiguration.this.m_removeAll.setEnabled(false);
                }
                for (int i = 0; i < VivaldiLogConfiguration.this.disabledList.size(); ++i) {
                    VivaldiLogConfiguration.this.enabledList.add(VivaldiLogConfiguration.this.disabledList.get(i));
                }
                ArrayList arrayList = VivaldiLogConfiguration.this.sortArrayListContent(VivaldiLogConfiguration.this.enabledList);
                VivaldiLogConfiguration.this.enabledList = null;
                VivaldiLogConfiguration.this.enabledList = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    VivaldiLogConfiguration.this.enabledList.add(arrayList.get(i));
                }
                VivaldiLogConfiguration.this.disabledList = null;
                VivaldiLogConfiguration.this.disabledList = new ArrayList();
                VivaldiLogConfiguration.access$102(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, null);
                VivaldiLogConfiguration.access$002(VivaldiLogConfiguration.this, new String[VivaldiLogConfiguration.this.enabledList.size()][3]);
                Object[] objectArray = new Object[3];
                for (int i = 0; i < VivaldiLogConfiguration.this.enabledList.size(); ++i) {
                    objectArray = (Object[])VivaldiLogConfiguration.this.enabledList.get(i);
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[i][0] = objectArray[0].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[i][1] = objectArray[1].toString();
                    ((VivaldiLogConfiguration)VivaldiLogConfiguration.this).m_enabledRow[i][2] = objectArray[2].toString();
                }
                ((EventTable)VivaldiLogConfiguration.this.m_enabledTable).fillTable(VivaldiLogConfiguration.this.m_enabledRow);
                ((EventTable)VivaldiLogConfiguration.this.m_disabledTable).deleteAllRow();
                VivaldiLogConfiguration.this.repaint();
            }
        });
        this.setVisible(true);
    }

    public JPanel getIndividualPaneCenterPanel() {
        int n;
        Object object;
        String string;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.m_remove);
        jPanel2.add(this.m_removeAll);
        jPanel2.add(this.m_add);
        jPanel2.add(this.m_addAll);
        this.m_remove.setEnabled(false);
        this.m_removeAll.setEnabled(false);
        this.m_add.setEnabled(false);
        this.m_addAll.setEnabled(false);
        File file = new File(this.m_GUI_config_file_name);
        BufferedReader bufferedReader = null;
        String string2 = "";
        String string3 = "=";
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.enabledList = new ArrayList();
        this.disabledList = new ArrayList();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.println("MessageFactory.updateGUIConfig() exception while read the std GUI log file");
        }
        if (bufferedReader == null) {
            return null;
        }
        try {
            byte[] byArray = Locale.getDefault().getLanguage().getBytes();
            object3 = new byte[2];
            object2 = Locale.getDefault().getCountry().getBytes();
            System.arraycopy(object2, 0, object3, 0, Math.min(((byte[])object3).length, ((byte[])object2).length));
            this.m_locObject = new Localization(new String(byArray).trim(), new String((byte[])object3).trim());
            string = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                int n5;
                object = new Object[3];
                int n6 = string2.indexOf(string3);
                if (n6 == -1 || (n5 = string2.indexOf("=")) == -1) continue;
                n2 = Integer.parseInt(string2.substring(0, n5).trim());
                string = string2.substring(n5 + 1, string2.length());
                int n7 = string.indexOf(";");
                if (n7 != -1) {
                    n3 = Integer.parseInt(string.substring(0, n7).trim());
                    n4 = Integer.parseInt(string.substring(n7 + 1, string.length()).trim());
                }
                object[0] = n2;
                if (n4 == 0) {
                    object[1] = Resource.getString("INFO", "Information");
                } else if (n4 == 1) {
                    object[1] = Resource.getString("WARN", "Warning");
                } else if (n4 == 2) {
                    object[1] = Resource.getString("CRTL", "Critical");
                } else if (n4 == 3) {
                    object[1] = Resource.getString("FATAL", "Fatal");
                } else if (n4 == 4) {
                    object[1] = Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress");
                }
                object[2] = new String(this.m_locObject.getAlertString(n2));
                if (n3 == 1) {
                    this.enabledList.add(object);
                    continue;
                }
                this.disabledList.add(object);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("MessageFactory.updateGUIConfig() excetion while reading the file");
            exception.printStackTrace();
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.m_enabledRow = new String[this.enabledList.size()][3];
        this.m_disabledRow = new String[this.disabledList.size()][3];
        for (n = 0; n < this.enabledList.size(); ++n) {
            Object[] objectArray = (Object[])this.enabledList.get(n);
            this.m_enabledRow[n][0] = objectArray[0].toString();
            this.m_enabledRow[n][1] = objectArray[1].toString();
            this.m_enabledRow[n][2] = objectArray[2].toString();
        }
        for (n = 0; n < this.disabledList.size(); ++n) {
            Object[] objectArray = (Object[])this.disabledList.get(n);
            this.m_disabledRow[n][0] = objectArray[0].toString();
            this.m_disabledRow[n][1] = objectArray[1].toString();
            this.m_disabledRow[n][2] = objectArray[2].toString();
        }
        this.m_enabledTable = new EventTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((EventTable)this.m_enabledTable).fillTable(this.m_enabledRow);
        this.m_disabledTable = new EventTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((EventTable)this.m_disabledTable).fillTable(this.m_disabledRow);
        JScrollPane jScrollPane = new JScrollPane(this.m_enabledTable);
        object3 = new JScrollPane(this.m_disabledTable);
        this.m_enabledTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.m_enabledTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VivaldiLogConfiguration.this.m_remove.setEnabled(true);
                VivaldiLogConfiguration.this.m_removeAll.setEnabled(true);
                VivaldiLogConfiguration.this.m_add.setEnabled(false);
                VivaldiLogConfiguration.this.m_addAll.setEnabled(false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.m_disabledTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.m_disabledTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VivaldiLogConfiguration.this.m_add.setEnabled(true);
                VivaldiLogConfiguration.this.m_addAll.setEnabled(true);
                VivaldiLogConfiguration.this.m_remove.setEnabled(false);
                VivaldiLogConfiguration.this.m_removeAll.setEnabled(false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        jScrollPane.setAutoscrolls(true);
        ((JComponent)object3).setAutoscrolls(true);
        object2 = new Dimension(m_width - 100, m_height / 4);
        jScrollPane.setPreferredSize((Dimension)object2);
        ((JComponent)object3).setPreferredSize((Dimension)object2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        string = this.oemType;
        object = MessageFormat.format(Resource.getString("VIVALDI_LOG_FILTER_DESC", "Allows you to select the events which can be logged in the vivaldi logger"), string);
        JLabel jLabel = new JLabel((String)object);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jLabel);
        gridBagConstraints.ipady = 15;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.ipady = 0;
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel(Resource.getString("VIVALDI_LOGGED_EVETS_TEXT", "Logged Events:"));
        jPanel4.add(jLabel2);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JLabel jLabel3 = new JLabel(Resource.getString("VIVALDI_EXCLUDED_EVETS_TEXT", "Excluded Events:"));
        jPanel5.add(jLabel3);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)object3, gridBagConstraints);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jScrollPane2, "Center");
        return jPanel6;
    }

    public String[][] copytoArray(ArrayList arrayList) {
        String[][] stringArray = new String[arrayList.size()][3];
        Object[] objectArray = new Object[3];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray = (Object[])arrayList.get(i);
            stringArray[i][0] = objectArray[0].toString();
            stringArray[i][1] = objectArray[1].toString();
            stringArray[i][2] = objectArray[2].toString();
        }
        return stringArray;
    }

    public ArrayList sortArrayListContent(ArrayList arrayList) {
        int n;
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>();
        Object[] objectArray = new Object[3];
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray = (Object[])arrayList.get(n);
            int n2 = Integer.parseInt(objectArray[0].toString().trim());
            arrayList3.add(n2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
        }
        Collections.sort(arrayList3);
        for (n = 0; n < arrayList.size(); ++n) {
            String string;
            int n3;
            Object[] objectArray2 = new Object[]{arrayList3.get(n), (n3 = (string = this.getEvtConfig(arrayList3.get(n).toString().trim())).indexOf(";")) != -1 ? this.getSeverityString(Integer.parseInt(string.substring(n3 + 1, string.length()).trim())) : Resource.getString("INFO", "Information"), this.m_locObject.getAlertString(Integer.parseInt(arrayList3.get(n).toString().trim()))};
            arrayList4.add(objectArray2);
        }
        return arrayList4;
    }

    public int getSeverity(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(Resource.getString("INFO", "Information"))) {
            n = 0;
        } else if (string.equalsIgnoreCase(Resource.getString("WARN", "Warning"))) {
            n = 1;
        } else if (string.equalsIgnoreCase(Resource.getString("CRTL", "Critical"))) {
            n = 2;
        } else if (string.equalsIgnoreCase(Resource.getString("FATAL", "Fatal"))) {
            n = 3;
        } else if (string.equalsIgnoreCase(Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress"))) {
            n = 4;
        }
        return n;
    }

    public String getSeverityString(int n) {
        String string = Resource.getString("INFO", "Information");
        if (n == 0) {
            string = Resource.getString("INFO", "Information");
        } else if (n == 1) {
            string = Resource.getString("WARN", "Warning");
        } else if (n == 2) {
            string = Resource.getString("CRTL", "Critical");
        } else if (n == 3) {
            string = Resource.getString("FATAL", "Fatal");
        } else if (n == 4) {
            string = Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress");
        }
        return string;
    }

    public void loadEvtCfg() {
        this.eventCfgProp = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.m_GUI_config_file_name);
            this.eventCfgProp.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getEvtConfig(String string) {
        if (this.eventCfgProp == null) {
            this.loadEvtCfg();
        }
        return this.eventCfgProp.getProperty(string);
    }

    static /* synthetic */ String[][] access$102(VivaldiLogConfiguration vivaldiLogConfiguration, String[][] stringArray) {
        vivaldiLogConfiguration.m_disabledRow = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[][] access$002(VivaldiLogConfiguration vivaldiLogConfiguration, String[][] stringArray) {
        vivaldiLogConfiguration.m_enabledRow = stringArray;
        return stringArray;
    }
}

