/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import Framework.Configurator.ConfiguratorManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import GUI.AuthenticationDialog;
import GUI.JLogger;
import GUI.MainFrame;
import GUI.RemoteServerPanel;
import GUI.SplashScreenWindow;
import GUI.VivaldiBaseDialog;
import KernelExceptions.VKOperationFailedException;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import Services.FrameworkUtilities;
import Utils.ColorHash;
import Utils.ConfigRepository;
import Utils.CustomMsgBox;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.Resource;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.security.auth.module.NTSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class VivaldiStartupDialog
extends VivaldiBaseDialog {
    private ColorHash colorHash;
    public static boolean isStartupScreen;
    public static boolean isStandAloneMode;
    public static boolean isLocalStandAlone;
    public static boolean isLocalModeWithRemote;
    public static MainFrame mainScreen;
    public static String PRODUCT_INFO;
    public static String VERSION_INFO;
    public static String FRAME_TITLE;
    public static String INSTALLER_VERSION;
    public static final String VERSION_KEY = "INSTALLER_VERSION";
    public static final String LOCAL_HOST_IP_ADDRESS;
    private static String GUI_VERSION;
    private final String MSM_BASE_VERSION = "2.90";
    private final String MSM_BUILD_VERSION = "";
    private final String MSM_BASE_VERSION_LSI = "2.90";
    private final String MSM_BASE_VERSION_DELL = "2.90";
    private final String MSM_BASE_VERSION_INTEL = "2.90-00";
    public static final String OEM_IDENTIFIER_STRING = "ajsgyqkj";
    public static final String OEM_HAMR_STRING = "UseSystemCredential";
    public static final String OEM_HAMR_STRING_EMAIL = "EmailConfigure";
    public static int OEM_TYPE;
    public static String[] cmdLine;
    public static SplashScreenWindow spalshScreen;
    public static final String SIGNATURE_KEY = "signatureKey";
    public static final String SIGNATURE_IP = "signatureIP";
    public static final String SIGNATURE_MODE = "signatureMode";
    public static String[] optExtLunch;
    public static SASKernel kernel;
    private AuthenticationDialog auth;
    private SASServer externalhost = null;
    public static boolean isWindows;
    public static boolean isSolaris;
    public static boolean m_isRelogin;
    private static VivaldiStartupDialog vivaldiObj;
    private static RemoteServerPanel serverPanel;
    public static boolean isadministrator;
    static boolean UseSystemCredential;
    static boolean useEmailCOnfigurator;
    static boolean closeonLogoff;

    public VivaldiStartupDialog(boolean bl) {
        super(mainScreen);
        int n;
        String string = System.getProperty("os.name");
        ConfiguratorManager.initilaize();
        if (string.contains("Windows")) {
            isWindows = true;
        }
        this.colorHash = isWindows ? new ColorHash(isWindows) : new ColorHash();
        if (string.contains("Sun")) {
            isSolaris = true;
        }
        if (OEM_TYPE == 98761) {
            PRODUCT_INFO = Resource.getString("PRODUCT_INFO1", "RAID Web Console 2");
            VERSION_INFO = "2.90-00";
        } else if (OEM_TYPE == 2561) {
            PRODUCT_INFO = Resource.getString("PRODUCT_INFO2", "Dell SAS RAID Storage Manager");
            VERSION_INFO = "2.90";
        } else {
            PRODUCT_INFO = Resource.getString("PRODUCT_INFO", "MegaRAID Storage Manager");
            VERSION_INFO = "2.90";
        }
        INSTALLER_VERSION = ConfigRepository.get(new Integer(OEM_TYPE).toString(), VERSION_KEY, GUI_VERSION);
        FRAME_TITLE = PRODUCT_INFO + " - " + INSTALLER_VERSION;
        String string2 = PRODUCT_INFO + " " + INSTALLER_VERSION + " - " + Resource.getString("HOSTVIEW_SCREEN_TITLE", "Host View");
        SASKernel.setOemType(OEM_TYPE);
        if (closeonLogoff) {
            this.closeOpt();
        }
        this.setLookAndFeel();
        isStartupScreen = bl;
        this.setTitle(string2);
        if (string.contains("Windows")) {
            UIManager.put("TabbedPane.selected", ColorHash.getColor("TAB_BKGROUND"));
        } else {
            UIManager.put("TabbedPane.selected", ColorHash.getColor("TAB_BKGROUND"));
            UIManager.put("TabbedPane.background", ColorHash.getColor("TAB_BKGROUND"));
            UIManager.put("Panel.background", ColorHash.getColor("GENERAL_BKGROUND"));
            UIManager.put("RadioButton.background", ColorHash.getColor("GENERAL_BKGROUND"));
            UIManager.put("RadioButton.disabledText", ColorHash.getColor("DISABLED_TEXT"));
            UIManager.put("OptionPane.background", ColorHash.getColor("GENERAL_BKGROUND"));
            UIManager.put("ScrollBar.thumb", ColorHash.getColor("GENERAL_BKGROUND"));
            UIManager.put("SplitPane.background", ColorHash.getColor("GENERAL_BKGROUND"));
            UIManager.put("TitledBorder.border", BorderFactory.createEtchedBorder());
        }
        this.contentPane.setBackground(ColorHash.getColor("GENERAL_BKGROUND"));
        isadministrator = VivaldiStartupDialog.isAdministrator();
        if (UseSystemCredential) {
            isStandAloneMode = true;
        }
        if ((n = this.getInstallationMode()) == 1) {
            isLocalStandAlone = true;
            SASKernel.setLocalStandAlone(isLocalStandAlone);
        } else if (n == 2) {
            isLocalModeWithRemote = true;
        }
        if (OEM_TYPE == 2561 || isLocalStandAlone || isLocalModeWithRemote) {
            isStandAloneMode = true;
        }
        if (optExtLunch == null) {
            String string3 = "";
            string3 = cmdLine != null && cmdLine.length >= 1 && cmdLine[0] != null && VivaldiStartupDialog.isValidIPAddress(cmdLine[0].trim()) ? cmdLine[0].trim() : LOCAL_HOST_IP_ADDRESS;
            serverPanel = new RemoteServerPanel(string3, true);
            this.contentPane.add((Component)serverPanel.getMainPanel(), "Center");
            this.pack();
            int n2 = MainFrame.SCREEN_SIZE.width * 660 / 1024;
            int n3 = MainFrame.SCREEN_SIZE.height * 530 / 768;
            if ((double)n3 < this.getSize().getHeight()) {
                n3 = (int)this.getSize().getHeight() + 40;
            }
            if ((double)n2 < this.getSize().getWidth()) {
                n2 = (int)this.getSize().getWidth() + 10;
            }
            this.setSize(n2, n3);
            this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
            this.setResizable(false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    VivaldiStartupDialog.this.dispose();
                    System.exit(0);
                }
            });
            spalshScreen.hideSplashScreen();
            if (!isStandAloneMode) {
                this.setVisible(true);
            }
            if (!isStandAloneMode && string3.equals("")) {
                String string4 = ConfigRepository.get(new Integer(OEM_TYPE).toString(), "PERSISTENT_REM_FW_IP");
                if (!string4.equals("")) {
                    serverPanel.setIpAddress(string4);
                    serverPanel.initiateScan();
                } else {
                    serverPanel.initiateScan();
                }
            } else {
                serverPanel.initiateScan();
            }
        } else {
            try {
                this.externalhost = this.findServerExistence();
                if (this.externalhost != null) {
                    this.externalhost.validatePassKey(optExtLunch[0], this.getLoginModeInByte(optExtLunch[2]));
                    spalshScreen.hideSplashScreen();
                }
                mainScreen = new MainFrame(this.externalhost, this.getLoginModeInByte(optExtLunch[2]));
                isStandAloneMode = true;
                mainScreen.setStandAloneMode(isStandAloneMode);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                switch (vKOperationFailedException.GetErrorCode()) {
                    case 4101: {
                        JLogger jLogger = new JLogger();
                        String[] stringArray = new String[2];
                        stringArray[0] = "";
                        if (this.externalhost.getUsrName() != null) {
                            try {
                                stringArray[0] = stringArray[0] + new String(this.externalhost.getUsrName(), "UTF-16LE");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        stringArray[1] = "127.0.0.1";
                        try {
                            stringArray[1] = LOCAL_HOST_IP_ADDRESS;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.externalhost.writeKernelLogRecord(jLogger.getXMLFromTagArray(jLogger.createTagArray("DENY", stringArray)));
                        new CustomMsgBox(this.auth, Resource.getString("MSG_FULLACCESS_DENIED", "<html>Full Access denied because another user is logged in<br> with full access from IP Address : ") + vKOperationFailedException.GetObject().toString().split(":")[0]);
                        break;
                    }
                    case 4096: {
                        if (vKOperationFailedException.GetOperation() != 2 && vKOperationFailedException.GetOperation() != 3) break;
                        new CustomMsgBox(this.auth, Resource.getString("MSG_NOADMIN_RIGHT", "This user does not have Administrator right for this system !"));
                        break;
                    }
                    case 4122: {
                        new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_FAILURE", "Login failed : Invalid username or password !"));
                        break;
                    }
                    case 4127: {
                        new CustomMsgBox(this.auth, Resource.getString("MSG_EXTERNAL_LUNCH_TIMEOUT", "Login failed : Due to timeout!"));
                        break;
                    }
                    default: {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                        try {
                            this.externalhost.logout();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        vKOperationFailedException.printStackTrace();
                    }
                }
                System.exit(0);
            }
            catch (Exception exception) {
                new CustomMsgBox(this.auth, Resource.getString("MSG_LOGIN_EXFAILURE", "Login failed : Exception while login !"));
                exception.printStackTrace();
                System.exit(0);
            }
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        this.setModal(true);
    }

    public static void main(String[] stringArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if ((int)dimension.getWidth() < 800 || (int)dimension.getHeight() < 600) {
            new CustomMsgBox(Resource.getString("MSG_RESOLUTION_NOT_SUPPORTED", "System resolution not supported !"));
            System.exit(0);
        }
        try {
            GUI_VERSION = System.getProperty("GUI_VERSION");
            VENUS_FLAG = new Boolean(System.getProperty("VENUS"));
            System.err.println("VENUS_FLAG " + VENUS_FLAG);
        }
        catch (Exception exception) {
            GUI_VERSION = "8.00-05";
            VENUS_FLAG = false;
            System.err.println("VENUS_FLAG Exception flag " + VENUS_FLAG);
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            StringTokenizer stringTokenizer;
            if (stringArray[i].startsWith(OEM_IDENTIFIER_STRING)) {
                stringTokenizer = new StringTokenizer(stringArray[i], "=");
                stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                bl = true;
                if (string.equals("98761")) {
                    OEM_TYPE = 98761;
                    continue;
                }
                if (string.equals("2561")) {
                    OEM_TYPE = 2561;
                    continue;
                }
                if (string.equals("71244")) {
                    OEM_TYPE = 71244;
                    continue;
                }
                bl = false;
                continue;
            }
            if (stringArray[i].startsWith(OEM_HAMR_STRING)) {
                stringTokenizer = new StringTokenizer(stringArray[i], "=");
                stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                UseSystemCredential = string.equalsIgnoreCase("true");
                System.out.println(OEM_HAMR_STRING + UseSystemCredential);
            } else if (stringArray[i].startsWith(OEM_HAMR_STRING_EMAIL)) {
                stringTokenizer = new StringTokenizer(stringArray[i], "=");
                stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                useEmailCOnfigurator = string.equalsIgnoreCase("true");
                System.out.println("useEmailCOnfigurator" + useEmailCOnfigurator);
            }
            if (stringArray[i].startsWith(SIGNATURE_KEY)) {
                try {
                    if (!stringArray[i + 1].startsWith(SIGNATURE_IP)) continue;
                    try {
                        if (!stringArray[i + 2].startsWith(SIGNATURE_MODE)) continue;
                        VivaldiStartupDialog.parseStringForExternalLunch(stringArray[i], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3]);
                    }
                    catch (Exception exception) {
                        new CustomMsgBox("Invalid input parameter");
                        System.exit(0);
                    }
                }
                catch (Exception exception) {
                    new CustomMsgBox("Invalid input parameter");
                    System.exit(0);
                }
                continue;
            }
            cmdLine = new String[1];
            VivaldiStartupDialog.cmdLine[0] = stringArray[i];
        }
        spalshScreen = SplashScreenWindow.getSplashScreen();
        String string = Resource.getString("SPLASH_MSG_GUI_STARTING", "Starting Vivaldi GUI...");
        VivaldiStartupDialog.setSplashScreenMessage(string);
        if (bl) {
            spalshScreen.displaySplasScreen(OEM_TYPE);
            vivaldiObj = new VivaldiStartupDialog(true);
        } else {
            new CustomMsgBox("Invalid input parameter");
        }
    }

    private void setLookAndFeel() {
        try {
            if (isWindows) {
                UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
            } else {
                UIManager.setLookAndFeel(UIManager.getInstalledLookAndFeels()[0].getClassName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean isValidIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private static void setSplashScreenMessage(String string) {
        if (spalshScreen == null || !spalshScreen.isVisible()) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            string = "";
        }
        spalshScreen.setMessage(string);
    }

    public SASServer findServerExistence() {
        try {
            try {
                if (kernel == null) {
                    kernel = VivaldiStartupDialog.isValidIPAddress(optExtLunch[1].trim()) ? SASKernel.getInstance(optExtLunch[1].trim()) : SASKernel.getInstance();
                }
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                new CustomMsgBox(Resource.getString("MSG_VERSION_MISMATCH", "Mismatch in versions."));
                return null;
            }
            SASServer sASServer = kernel.getSingleServer();
            return sASServer;
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_NO_CONNECTION", "Fatal Error : Cannot connect to Framework !"));
            System.out.println("Fatal Error : Can not create SASKernel object !");
            exception.printStackTrace();
            System.out.println("Terminating ....");
            System.exit(0);
            return null;
        }
    }

    public byte getLoginModeInByte(String string) {
        if (string.trim().equals("0")) {
            return 0;
        }
        return 1;
    }

    public static void parseStringForExternalLunch(String string, String string2, String string3, String string4) {
        optExtLunch = new String[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        stringTokenizer.nextToken();
        VivaldiStartupDialog.optExtLunch[0] = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, "=");
        stringTokenizer.nextToken();
        VivaldiStartupDialog.optExtLunch[1] = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string3, "=");
        stringTokenizer.nextToken();
        VivaldiStartupDialog.optExtLunch[2] = stringTokenizer.nextToken();
        System.out.println("systemcred" + string4);
        VivaldiStartupDialog.optExtLunch[3] = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string4, "=");
        stringTokenizer.nextToken();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("MR_DISCOVERY_AND_LOGIN");
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    @Override
    public void closeOpt() {
        if (isStartupScreen) {
            if (kernel != null) {
                kernel.destroyKernel();
            }
            super.closeOpt();
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public static void hideVivaldiStartupDialog() {
        vivaldiObj.setVisible(false);
    }

    public static void displayVivaldiStartupDialog(boolean bl) {
        if (!isStandAloneMode) {
            isStartupScreen = bl;
            vivaldiObj.getRemoteServerPanel().initiateScan(false);
            vivaldiObj.setVisible(true);
        } else {
            vivaldiObj = new VivaldiStartupDialog(true);
        }
    }

    public static VivaldiStartupDialog getVivaldiStartupDialogObj() {
        return vivaldiObj;
    }

    public static RemoteServerPanel getRemoteServerPanel() {
        return serverPanel;
    }

    private boolean isCIMOMServerAlreadyAddded(ArrayList arrayList, String string) {
        if (!arrayList.isEmpty()) {
            for (SASServer sASServer : arrayList) {
                if (!string.equals(sASServer.getCIMOMIP())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCIMOMServerAlreadyAddedAsNormalServer(ArrayList arrayList, String string) {
        if (arrayList != null && !arrayList.isEmpty()) {
            for (SASServer sASServer : arrayList) {
                if (!string.equals(sASServer.getInformation().getIP())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidCmdIP() {
        return cmdLine != null && cmdLine.length >= 1 && cmdLine[0] != null && VivaldiStartupDialog.isValidIPAddress(cmdLine[0].trim());
    }

    public int getInstallationMode() {
        int n = 0;
        String string = null;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("installationmode.properties");
            properties.load(fileInputStream);
            string = properties.getProperty("INSTALLATION_MODE");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            n = 0;
            System.out.println("got Exception while converting String to int" + exception.getMessage());
        }
        return n;
    }

    public static boolean isAdministrator() {
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            String[] stringArray;
            NTSystem nTSystem = new NTSystem();
            for (String string : stringArray = nTSystem.getGroupIDs()) {
                System.out.println("group" + string);
                if (!string.equals("S-1-5-32-544")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        isStandAloneMode = false;
        isLocalStandAlone = false;
        isLocalModeWithRemote = false;
        LOCAL_HOST_IP_ADDRESS = FrameworkUtilities.getLocalHostAddress();
        cmdLine = null;
        spalshScreen = null;
        optExtLunch = null;
        isWindows = false;
        isSolaris = false;
        m_isRelogin = false;
        isadministrator = false;
        UseSystemCredential = false;
        useEmailCOnfigurator = false;
        closeonLogoff = false;
        UIManager.getDefaults().put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
    }
}

