/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.RemoteServerPanel;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import Services.BlowFishEncoder;
import Utils.HelpContextResourse;
import Utils.PropertiesFileHandler;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class VivaldiStartupSettings
extends VivaldiBaseDialog
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JPanel settingsPanel = new JPanel();
    private JPanel settingsMainPanel = new JPanel();
    private JPanel settingsLDAPPanel = new JPanel();
    private JRadioButton localRadio = new JRadioButton("Display only the local server");
    private JRadioButton IPRadio = new JRadioButton("Display Selected Servers");
    private JRadioButton CIMOMIPRadio = new JRadioButton("Display all the CIMOMServers in the subnet of ");
    private DefaultListModel listModel = new DefaultListModel();
    private JList ipList = new JList(this.listModel);
    private JButton addIp = new JButton(Resource.getString("BUTTON_ADD_DSC", "Add"));
    private JButton removeIp = new JButton(Resource.getString("BUTTON_REMOVE_DSC", "Remove"));
    private JRadioButton nwRadio = new JRadioButton("Display all the servers in the subnet of ");
    private JCheckBox discRadio = new JCheckBox("Stop discovery process of remote servers.");
    private ButtonGroup settingsGrp = new ButtonGroup();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JCheckBox defaultLDAPLogin;
    private JCheckBox ldapPromptChk;
    private JTextField ldapServerIP = new JTextField(20);
    private JTextField port = new JTextField(12);
    private JTextField domainName = new JTextField(20);
    private JTextField userName = new JTextField(20);
    private JPasswordField password = new JPasswordField(20);
    private JPanel navigationPanel = new JPanel();
    private JButton goButton = new JButton();
    private JButton cancelButton = new JButton();
    JTextField ipAddrText = new JTextField(15);
    private VivaldiStartupSettings classObj = null;
    public static final int LOCAL = 1;
    public static final int SELECTEDIP = 2;
    public static final int NW = 3;
    public static final int CIMOM_NW = 4;
    public static final String LOCALRADIOTEXT = "Display only the local server";
    public static final String IPRADIOTEXT = "Display Selected Servers";
    public static final String NWRADIOTEXT = "Display all the servers in the subnet of ";
    public static final String NWCIMOMRADIOTEXT = "Display all the CIMOMServers in the subnet of ";
    public static final String DISRADIOSTOPTEXT = "Stop discovery process of remote servers.";
    private static final String PASSWORD_ENCRYPTION_KEY = "mso5fjq";
    private static final String DEFAULT_PORT = "389";
    public static final String LOCALTEXT = "Local";
    public static final String IPTEXT = "Selected";
    public static final String NWTEXT = "NW";
    public static final String CIMOM_NWTEXT = "CIMOM_NW";
    public static final String DISCTEXT = "DISCOVERY";
    public static final String DEFAULT_AUTH_MODE = "DEFAULTAUTHMODE";
    public static final String PROMPT_LDAP_LOGIN_DIALOG = "PROMPTLDAPLOGIN";
    public static final String LDAP_SERVER_IP_ADDRESS = "LDAPSERVERIPADDRESS";
    public static final String LDAP_SERVER_USER_NAME = "LDAPSERVERUSERNAME";
    public static final String LDAP_SERVER_PASSWORD = "LDAPSERVERPASSWORD";
    public static final String LDAP_SERVER_DOMAIN_NAME = "LDAPSERVERDOMAIN";
    public static final String LDAP_SERVER_PORT_NUMBER = "LDAPSERVERPORT";
    public static final String LDAP_SERVER_LOGIN_COUNT = "LDAPLOGINCOUNT";
    public static final int STOP = 1;
    public static final int START = 2;
    public static final int NOCHANGE = 0;
    private int discoveryOption;
    private int discovery = this.discoveryOption = 0;
    private static PropertiesFileHandler pfh = null;
    private String masterIp;
    private boolean isNCPStopSupport = true;
    private boolean currentNCPStatus = true;

    public VivaldiStartupSettings(String string) {
        this.masterIp = string;
        this.getProperties();
        this.addComponents();
        this.setProperties();
        this.setLDAPProperties();
        this.classObj = this;
    }

    public VivaldiStartupSettings(String string, boolean bl, boolean bl2) {
        this.isNCPStopSupport = bl;
        this.currentNCPStatus = bl2;
        this.masterIp = string;
        this.getProperties();
        this.addComponents();
        this.setProperties();
        this.setLDAPProperties();
        this.classObj = this;
    }

    public VivaldiStartupSettings(Frame frame) {
        super(frame);
    }

    private void addComponents() {
        Container container;
        int n;
        JComponent jComponent;
        Serializable serializable;
        this.settingsMainPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(10, 5, 0, 10);
        Insets insets2 = new Insets(25, 5, 0, 10);
        Insets insets3 = new Insets(0, 25, 5, 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("RADIO_LOCAL_DISPLAY_TEXT", LOCALRADIOTEXT));
        this.localRadio.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.localRadio.setMnemonic(stringArray[1].charAt(0));
        }
        this.localRadio.setActionCommand(LOCALTEXT);
        this.settingsPanel.add((Component)this.localRadio, gridBagConstraints);
        this.settingsGrp.add(this.localRadio);
        this.localRadio.setSelected(true);
        ++gridBagConstraints.gridy;
        String string = "<html>This will display only the local server in the host view screen.This setting will not stop the disocvery process of the remote MSM servers.<br></html>";
        JLabel jLabel = new JLabel(Resource.getString("RADIO_LOCAL_DISPLAY_DESC", string));
        gridBagConstraints.insets = insets3;
        ++gridBagConstraints.gridy;
        this.settingsPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        stringArray = Resource.getResourceMnemonic(Resource.getString("RADIO_FAVORITE_DISPLAY_TEXT", IPRADIOTEXT));
        this.IPRadio.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.IPRadio.setMnemonic(stringArray[1].charAt(0));
        }
        this.IPRadio.setActionCommand(IPTEXT);
        this.settingsPanel.add((Component)this.IPRadio, gridBagConstraints);
        this.settingsGrp.add(this.IPRadio);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = insets3;
        JLabel jLabel2 = new JLabel(Resource.getString("RADIO_FAVORITE_DISPLAY_DESC", string));
        this.settingsPanel.add((Component)jLabel2, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_FAVORITE_IP", "Favorite list:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.ipList.setVisibleRowCount(5);
        this.ipList.setEnabled(false);
        jLabel3.setLabelFor(this.ipList);
        this.ipList.setLayoutOrientation(1);
        this.ipList.setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.ipList, 22, 30);
        jScrollPane.setPreferredSize(new Dimension(100, 80));
        stringArray = Resource.getResourceMnemonic(Resource.getString("TEXT_FAVORITE_IP", "Enter IP Address:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.ipAddrText.setPreferredSize(new Dimension(this.ipList.getPreferredSize().width, this.ipAddrText.getPreferredSize().height));
        this.ipAddrText.setEnabled(false);
        jLabel4.setLabelFor(this.ipAddrText);
        jScrollPane.setPreferredSize(new Dimension(this.ipAddrText.getPreferredSize().width, jScrollPane.getPreferredSize().height));
        ++gridBagConstraints.gridy;
        this.settingsPanel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.settingsPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.settingsPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.settingsPanel.add((Component)this.ipAddrText, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD", "Add"));
        this.addIp = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.addIp.setMnemonic(stringArray[1].charAt(0));
        }
        this.addIp.setEnabled(false);
        jPanel.add(this.addIp);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SSCD_REMOVE", "Remove"));
        this.removeIp = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.removeIp.setMnemonic(stringArray[1].charAt(0));
        }
        this.removeIp.setEnabled(false);
        jPanel.add(this.removeIp);
        this.settingsPanel.add((Component)jPanel, gridBagConstraints);
        this.IPRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (VivaldiStartupSettings.this.IPRadio.isSelected()) {
                    VivaldiStartupSettings.this.ipAddrText.setEnabled(true);
                    VivaldiStartupSettings.this.ipList.setEnabled(true);
                    VivaldiStartupSettings.this.addIp.setEnabled(true);
                    VivaldiStartupSettings.this.removeIp.setEnabled(true);
                } else {
                    VivaldiStartupSettings.this.ipAddrText.setEnabled(false);
                    VivaldiStartupSettings.this.ipList.setEnabled(false);
                    VivaldiStartupSettings.this.addIp.setEnabled(false);
                    VivaldiStartupSettings.this.removeIp.setEnabled(false);
                }
            }
        });
        this.addIp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = VivaldiStartupSettings.this.ipAddrText.getText();
                if (string != null && string.length() > 0 && VivaldiStartupSettings.isValidIPAddress(string)) {
                    if (!VivaldiStartupSettings.this.listModel.contains(string)) {
                        VivaldiStartupSettings.this.listModel.addElement(string);
                    }
                    return;
                }
                if (string == null || string.trim().equals("")) {
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("IP_ADDRESS_MSG", "Invalid IPAddress."), 2);
                    JDialog jDialog = jOptionPane.createDialog(Resource.getString("IP_ADDRESS_TITLE", "Enter IP Address"));
                    Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                    jDialog.setIconImage(image);
                    jDialog.setVisible(true);
                    VivaldiStartupSettings.this.ipAddrText.requestFocus();
                    return;
                }
                if (!VivaldiStartupSettings.isValidIPAddress(string)) {
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("VALID_IP_ADDRESS_MSG", "Invalid IPAddress."), 2);
                    JDialog jDialog = jOptionPane.createDialog(Resource.getString("VALID_IP_ADDRESS_TITLE", "Enter Valid IP Address"));
                    Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                    jDialog.setIconImage(image);
                    jDialog.setVisible(true);
                    VivaldiStartupSettings.this.ipAddrText.requestFocus();
                    return;
                }
            }
        });
        this.removeIp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = VivaldiStartupSettings.this.ipList.getSelectedValues();
                if (objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        VivaldiStartupSettings.this.listModel.removeElement((String)objectArray[i]);
                    }
                } else {
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("IP_ADDR_MSG", "Select IP Address(es) from the above list to remove"), 2);
                    JDialog jDialog = jOptionPane.createDialog(Resource.getString("IP_ADDR_TITLE", "Select IP Address"));
                    Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                    jDialog.setIconImage(image);
                    jDialog.setVisible(true);
                    return;
                }
            }
        });
        if (VivaldiStartupDialog.OEM_TYPE != 2561) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("RADIO_NW_DISPLAY_TEXT", "Display all the systems in the network of the local server"));
            this.nwRadio.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.nwRadio.setMnemonic(stringArray[1].charAt(0));
            }
            this.nwRadio.setActionCommand(NWTEXT);
            this.nwRadio.setEnabled(true);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = insets;
            this.settingsPanel.add((Component)this.nwRadio, gridBagConstraints);
            this.settingsGrp.add(this.nwRadio);
            serializable = new JLabel(Resource.getString("RADIO_NW_DISPLAY_DESC", "Display all the systems in the network of the local server"));
            gridBagConstraints.insets = insets3;
            ++gridBagConstraints.gridy;
            this.settingsPanel.add((Component)serializable, gridBagConstraints);
            stringArray = Resource.getResourceMnemonic(Resource.getString("RADIO_CIMOM_NW_DISPLAY_TEXT", "Display all the ESXi-(C)IMOM servers in the network of local server"));
            this.CIMOMIPRadio.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.CIMOMIPRadio.setMnemonic(stringArray[1].charAt(0));
            }
            this.CIMOMIPRadio.setActionCommand(CIMOM_NWTEXT);
            this.CIMOMIPRadio.setEnabled(true);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = insets;
            this.settingsPanel.add((Component)this.CIMOMIPRadio, gridBagConstraints);
            this.settingsGrp.add(this.CIMOMIPRadio);
            jComponent = new JLabel(Resource.getString("RADIO_CIMOM_NW_DISPLAY_DESC", "This will display local MSM server and all the available CIMOM server(s) in the subnet of the mentioned local MSM server in the host view screen"));
            gridBagConstraints.insets = insets3;
            ++gridBagConstraints.gridy;
            this.settingsPanel.add((Component)jComponent, gridBagConstraints);
        }
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("PANEL_DISPLAY_TITLE", "Display Preferences")));
        this.settingsMainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        serializable = new GridBagConstraints();
        serializable.gridx = 0;
        serializable.gridy = 0;
        this.settingsMainPanel.add((Component)this.settingsPanel, serializable);
        if (VivaldiStartupDialog.OEM_TYPE != 2561) {
            jComponent = new JPanel(new GridBagLayout());
            stringArray = Resource.getResourceMnemonic(Resource.getString("RADIO_NCP_DISPLAY_TEXT", DISRADIOSTOPTEXT));
            this.discRadio.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.discRadio.setMnemonic(stringArray[1].charAt(0));
            }
            if (!this.currentNCPStatus) {
                this.discRadio.setSelected(true);
            }
            this.discRadio.setActionCommand(DISCTEXT);
            this.discRadio.addItemListener(this);
            n = 0;
            if (VivaldiStartupDialog.kernel != null) {
                n = this.masterIp.equals(VivaldiStartupDialog.kernel.getDefaultFrameworkIP()) ? 1 : 0;
            }
            this.discRadio.setEnabled(this.isNCPStopSupport && n != 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = insets;
            jComponent.add((Component)this.discRadio, gridBagConstraints);
            ++serializable.gridy;
            jComponent.setBorder(BorderFactory.createTitledBorder(Resource.getString("PANEL_DISCOVER_TITLE", "Server Discovery Setting")));
            this.discRadio.setPreferredSize(new Dimension(this.settingsPanel.getPreferredSize().width - 45, this.discRadio.getPreferredSize().height));
            container = new JLabel(Resource.getString("RADIO_NCP_DISPLAY_DESC", "Use this check bocx to  manage the remote server discovery process at the local MSM server"));
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = insets3;
            jComponent.add((Component)container, gridBagConstraints);
            jComponent.setPreferredSize(new Dimension(this.settingsPanel.getPreferredSize().width, jComponent.getPreferredSize().height));
            this.settingsMainPanel.add((Component)jComponent, serializable);
        }
        int n2 = this.settingsMainPanel.getPreferredSize().width;
        n = this.settingsMainPanel.getPreferredSize().height;
        if (n + 200 > MainFrame.SCREEN_SIZE.height || n2 + 100 > MainFrame.SCREEN_SIZE.width) {
            if (n2 + 100 > MainFrame.SCREEN_SIZE.width) {
                n2 = MainFrame.SCREEN_SIZE.width - 100;
            }
            if (n + 200 > MainFrame.SCREEN_SIZE.height) {
                n = MainFrame.SCREEN_SIZE.height - 200;
            }
            container = new ScrollPane(0);
            container.add(this.settingsMainPanel);
            container.setPreferredSize(new Dimension(n2, n));
            this.tabbedPane.add("Configure Host", container);
        } else {
            this.tabbedPane.add("Configure Host", this.settingsMainPanel);
        }
        container = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.settingsLDAPPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DEFAULT_AUTHENTICATE_MODE", "Use LDAP login as default login mode"));
        this.defaultLDAPLogin = new JCheckBox(stringArray[0]);
        this.defaultLDAPLogin.setSelected(false);
        if (stringArray.length == 2) {
            this.defaultLDAPLogin.setMnemonic(stringArray[1].charAt(0));
        }
        container.add((Component)this.defaultLDAPLogin, "North");
        stringArray = Resource.getResourceMnemonic(Resource.getString("PROMPT_CREDENTIAL_TEXT", "Do not prompt for credentials when connecting to LDAP"));
        this.ldapPromptChk = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.ldapPromptChk.setMnemonic(stringArray[1].charAt(0));
        }
        this.ldapPromptChk.setSelected(false);
        this.ldapPromptChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VivaldiStartupSettings.this.ldapPromptChk.isSelected()) {
                    JOptionPane jOptionPane = new JOptionPane(Resource.getString("PROMPT_CREDENTIAL_CONFIRMATION_MSG", "<html>You have chosen not to prompt for login credentials when connecting <br>to LDAP server. You must enter IP Address, Port, Distinguished Name, <br> User Name and Password. </html>"), 2);
                    JDialog jDialog = jOptionPane.createDialog(Resource.getString("LDAP_MANDATORY_FIELDS_TITLE", " Mandatory Fields"));
                    Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                    jDialog.setIconImage(image);
                    jDialog.setVisible(true);
                    if (VivaldiStartupSettings.this.ldapServerIP.getText().trim().equals("") || VivaldiStartupSettings.this.port.getText().trim().equals("") || VivaldiStartupSettings.this.domainName.getText().trim().equals("") || VivaldiStartupSettings.this.userName.getText().trim().equals("") || new String(VivaldiStartupSettings.this.password.getPassword()).trim().equals("")) {
                        VivaldiStartupSettings.this.goButton.setEnabled(false);
                    }
                } else {
                    VivaldiStartupSettings.this.goButton.setEnabled(true);
                }
            }
        });
        container.add((Component)this.ldapPromptChk, "South");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("LDAP_SERVER_TEXT", "LDAP Server")));
        stringArray = Resource.getResourceMnemonic(Resource.getString("IP_ADDRESS_TEXT", "IP Address:"));
        JLabel jLabel5 = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            jLabel5.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel5.setLabelFor(this.ldapServerIP);
        jPanel3.add((Component)jLabel5, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.ldapServerIP.addKeyListener(this);
        jPanel3.add((Component)this.ldapServerIP, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        stringArray = Resource.getResourceMnemonic(Resource.getString("DEFAULT_PORT_TEXT", "Port:"));
        JLabel jLabel6 = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            jLabel6.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel6.setLabelFor(this.port);
        jPanel3.add((Component)jLabel6, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.port.addKeyListener(this);
        this.port.setText(DEFAULT_PORT);
        jPanel3.add((Component)this.port, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DISTINGUISHED_NAME_TEXT", "Distinguished Name:"));
        JLabel jLabel7 = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            jLabel7.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jLabel7.setLabelFor(this.domainName);
        jPanel3.add((Component)jLabel7, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.domainName.addKeyListener(this);
        jPanel3.add((Component)this.domainName, gridBagConstraints2);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("CONNECTION_DISPLAY_TEXT", "Connection")));
        stringArray = Resource.getResourceMnemonic(Resource.getString("USERNAME_TEXT", "User Name:"));
        JLabel jLabel8 = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            jLabel8.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jLabel8.setLabelFor(this.userName);
        jPanel4.add((Component)jLabel8, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.userName.addKeyListener(this);
        jPanel4.add((Component)this.userName, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        jPanel4.add((Component)jLabel9, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel4.add((Component)jLabel10, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PASSWORD_TEXT", "Password:"));
        JLabel jLabel11 = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            jLabel11.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jLabel11.setLabelFor(this.password);
        jPanel4.add((Component)jLabel11, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.password.addKeyListener(this);
        jPanel4.add((Component)this.password, gridBagConstraints2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)new JPanel(new BorderLayout()), "South");
        jPanel2.add((Component)jPanel5, "Center");
        this.settingsLDAPPanel.add((Component)container, "North");
        this.settingsLDAPPanel.add((Component)jPanel2, "Center");
        this.tabbedPane.add("LDAP Settings", this.settingsLDAPPanel);
        super.add((Component)this.tabbedPane, "Center");
        JPanel jPanel6 = new JPanel();
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("BUTTON_SAVE_SETTINGS", "Save Settings"));
        this.goButton = new JButton(stringArray2[0]);
        this.goButton.setToolTipText(stringArray2[0]);
        if (stringArray2.length == 2) {
            this.goButton.setMnemonic(stringArray2[1].charAt(0));
        }
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = VivaldiStartupSettings.this.doGoAction();
                if (bl) {
                    VivaldiStartupSettings.this.classObj.dispose();
                    RemoteServerPanel.applyDiscoverySettings();
                }
            }
        });
        jPanel6.add(this.goButton);
        String[] stringArray3 = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        JButton jButton = new JButton(stringArray3[0]);
        jButton.setToolTipText(Resource.getString("BUTTON_CANCEL_TEXT", "Go"));
        if (stringArray3.length == 2) {
            jButton.setMnemonic(stringArray2[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0);
                JDialog jDialog = jOptionPane.createDialog(VivaldiStartupSettings.this.classObj, VivaldiStartupSettings.this.classObj.getTitle());
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object instanceof Integer) {
                    if ((Integer)object == 0) {
                        jDialog.dispose();
                        VivaldiStartupSettings.this.classObj.dispose();
                    } else {
                        jDialog.dispose();
                    }
                }
            }
        });
        jPanel6.add(jButton);
        super.add((Component)jPanel6, "South");
        this.setResizable(false);
        this.pack();
    }

    private static String getFileStr() {
        String string = "msm.properties";
        return string;
    }

    private void getProperties() {
        String string;
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        if ((string = pfh.getProperty("DISCOVERYOPTION")) != null) {
            this.discoveryOption = Integer.parseInt(string);
        }
        String string2 = pfh.getProperty("IPADDRESS");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.listModel.addElement(stringTokenizer.nextElement());
        }
    }

    private void setProperties() {
        switch (this.discoveryOption) {
            case 1: {
                this.localRadio.setSelected(true);
                break;
            }
            case 2: {
                this.IPRadio.setSelected(true);
                break;
            }
            case 3: {
                this.nwRadio.setSelected(true);
                break;
            }
            case 4: {
                this.CIMOMIPRadio.setSelected(true);
                break;
            }
            default: {
                this.localRadio.setSelected(true);
            }
        }
    }

    private void setLDAPProperties() {
        this.defaultLDAPLogin.setSelected(VivaldiStartupSettings.isLDAPAuthenticate());
        this.ldapPromptChk.setSelected(!VivaldiStartupSettings.promptForCredentials());
        this.ldapServerIP.setText(VivaldiStartupSettings.getLDAPServerIP());
        this.port.setText(VivaldiStartupSettings.getLDAPServerPort());
        this.domainName.setText(VivaldiStartupSettings.getLDAPServerDomainName());
        this.userName.setText(VivaldiStartupSettings.getLDAPServerUserName());
        this.password.setText(VivaldiStartupSettings.getLDAPServerPassword());
    }

    private boolean doGoAction() {
        if (this.defaultLDAPLogin.isSelected()) {
            VivaldiStartupSettings.setDefaultAuthenticationMode("LDAP");
        } else {
            VivaldiStartupSettings.setDefaultAuthenticationMode("MULTICAST");
        }
        if (this.ldapPromptChk.isSelected()) {
            VivaldiStartupSettings.setPromptForCredentials("no");
        } else {
            VivaldiStartupSettings.setPromptForCredentials("yes");
        }
        VivaldiStartupSettings.setLDAPServerIP(this.ldapServerIP.getText());
        VivaldiStartupSettings.setLDAPServerUserName(this.userName.getText());
        VivaldiStartupSettings.setLDAPServerPassword(new String(this.password.getPassword()));
        VivaldiStartupSettings.setLDAPServerDomainName(this.domainName.getText());
        VivaldiStartupSettings.setLDAPServerPort(this.port.getText());
        String string = this.settingsGrp.getSelection().getActionCommand();
        if (string.equals(LOCALTEXT)) {
            this.discoveryOption = 1;
            pfh.setProperty("DISCOVERYOPTION", "" + this.discoveryOption);
            RemoteServerPanel.setDiscoverySettings(this.discoveryOption, this.discovery);
            return true;
        }
        if (string.equals(IPTEXT)) {
            this.discoveryOption = 2;
            String string2 = null;
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.listModel.size(); ++i) {
                string2 = string2 == null ? this.listModel.get(i) + ";" : string2 + this.listModel.get(i) + ";";
                arrayList.add(this.listModel.get(i));
            }
            if (arrayList.size() > 0) {
                pfh.setProperty("DISCOVERYOPTION", "" + this.discoveryOption);
                if (string2 != null) {
                    pfh.setProperty("IPADDRESS", "" + string2);
                } else {
                    pfh.setProperty("IPADDRESS", "");
                }
                RemoteServerPanel.setDiscoverySettings(this.discoveryOption, arrayList, this.discovery);
                return true;
            }
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("FAV_LIST_EMPTY_MSG", "Favorite list is empty."), 2);
            JDialog jDialog = jOptionPane.createDialog(Resource.getString("IP_ADDRESS_TITLE", "Enter IP Address"));
            Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
            jDialog.setIconImage(image);
            jDialog.setVisible(true);
            this.ipAddrText.requestFocus();
            return false;
        }
        if (string.equals(NWTEXT)) {
            this.discoveryOption = 3;
            pfh.setProperty("DISCOVERYOPTION", "" + this.discoveryOption);
            RemoteServerPanel.setDiscoverySettings(this.discoveryOption, this.discovery);
            return true;
        }
        if (string.equals(CIMOM_NWTEXT)) {
            this.discoveryOption = 4;
            pfh.setProperty("DISCOVERYOPTION", "" + this.discoveryOption);
            RemoteServerPanel.setDiscoverySettings(this.discoveryOption, this.discovery);
            return true;
        }
        return true;
    }

    public static int getDiscoveryOption() {
        String string;
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        if ((string = pfh.getProperty("DISCOVERYOPTION")) != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public static boolean isLDAPAuthenticate() {
        String string;
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        return (string = pfh.getProperty(DEFAULT_AUTH_MODE)) != null && string.equals("LDAP");
    }

    public static boolean promptForCredentials() {
        String string;
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        return (string = pfh.getProperty(PROMPT_LDAP_LOGIN_DIALOG)) == null || !string.equals("no");
    }

    public static String getLDAPServerIP() {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty(LDAP_SERVER_IP_ADDRESS);
        return string;
    }

    public static String getLDAPServerUserName() {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty(LDAP_SERVER_USER_NAME);
        return string;
    }

    public static String getLDAPServerPassword() {
        String string;
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        if ((string = pfh.getProperty(LDAP_SERVER_PASSWORD)) != null) {
            BlowFishEncoder blowFishEncoder = new BlowFishEncoder(PASSWORD_ENCRYPTION_KEY);
            return blowFishEncoder.decrypt(string);
        }
        return null;
    }

    public static String getLDAPServerDomainName() {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty(LDAP_SERVER_DOMAIN_NAME);
        return string;
    }

    public static String getLDAPServerPort() {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty(LDAP_SERVER_PORT_NUMBER);
        return string;
    }

    public static String getLDAPLoginCount() {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty(LDAP_SERVER_LOGIN_COUNT);
        return string;
    }

    public static void setLDAPServerIP(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(LDAP_SERVER_IP_ADDRESS, "" + string);
    }

    public static void setLDAPServerUserName(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(LDAP_SERVER_USER_NAME, "" + string);
    }

    public static void setLDAPServerPassword(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        BlowFishEncoder blowFishEncoder = new BlowFishEncoder(PASSWORD_ENCRYPTION_KEY);
        pfh.setProperty(LDAP_SERVER_PASSWORD, "" + blowFishEncoder.encrypt(string));
    }

    public static void setLDAPServerDomainName(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(LDAP_SERVER_DOMAIN_NAME, "" + string);
    }

    public static void setLDAPServerPort(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(LDAP_SERVER_PORT_NUMBER, "" + string);
    }

    public static void setLDAPLoginCount(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(LDAP_SERVER_LOGIN_COUNT, "" + string);
    }

    public static void setDefaultAuthenticationMode(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(DEFAULT_AUTH_MODE, "" + string);
    }

    public static void setPromptForCredentials(String string) {
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        pfh.setProperty(PROMPT_LDAP_LOGIN_DIALOG, "" + string);
    }

    public static ArrayList<String> getIPAddresses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (pfh == null) {
            pfh = new PropertiesFileHandler(VivaldiStartupSettings.getFileStr());
        }
        String string = pfh.getProperty("IPADDRESS");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.equals("null")) continue;
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    protected static boolean isValidIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getHelpPage() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            return HelpContextResourse.getHelpPageName("MR_CONFIGURING_LDAP_SUPPORT_SETTINGS");
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.ldapPromptChk.isSelected() && (this.ldapServerIP.getText().trim().equals("") || this.port.getText().trim().equals("") || this.domainName.getText().trim().equals("") || this.userName.getText().trim().equals("") || new String(this.password.getPassword()).trim().equals(""))) {
            this.goButton.setEnabled(false);
        } else {
            this.goButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.discovery = 0;
        if (itemEvent.getStateChange() == 1) {
            if (this.currentNCPStatus) {
                this.discovery = 1;
            }
        } else if (!this.currentNCPStatus) {
            this.discovery = 2;
        }
    }
}

