/*
 * Decompiled with CFR 0.152.
 */
package GUI.security;

import GUI.VivaldiStartupDialog;
import GUI.security.DisableEncryptionErrorDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import Utils.Resource;
import Wizard.controllerSecurityWizard.SecurityBasedOperations;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class ChangeEncyptionSettingsPanel
extends JPanel {
    private AdapterHelper m_adapterHelper = null;
    private boolean m_isEncryptionEnabled = false;
    private String m_strControllerName = null;
    private ButtonGroup m_btnGrp = null;

    public ChangeEncyptionSettingsPanel(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
        this.m_isEncryptionEnabled = adapterHelper.isLockKeyAssigned();
        this.m_strControllerName = adapterHelper.getText();
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = null;
        String string = this.m_isEncryptionEnabled ? Resource.getString("LABEL_ENCRYPTION_STATUS_ENABLED", "Drive security is currently enabled.") : Resource.getString("LABEL_ENCRYPTION_STATUS_DISABLED", "Drive security is currently disabled.");
        JLabel jLabel = new JLabel(string);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ENABLE_ENCRYPTION", "Ena(b)le..."));
        JRadioButton jRadioButton = new JRadioButton(stringArray[0]);
        jRadioButton.setActionCommand(stringArray[0]);
        if (stringArray.length == 2) {
            jRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        jRadioButton.setEnabled(!this.m_isEncryptionEnabled);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CHANGE_PASSPHRASE", "Chan(g)e Security Settings..."));
        JRadioButton jRadioButton2 = new JRadioButton(stringArray[0]);
        jRadioButton2.setActionCommand(stringArray[0]);
        if (stringArray.length == 2) {
            jRadioButton2.setMnemonic(stringArray[1].charAt(0));
        }
        jRadioButton2.setEnabled(this.m_isEncryptionEnabled);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_DISABLE_ENCRYPTION", "(D)isable..."));
        JRadioButton jRadioButton3 = new JRadioButton(stringArray[0]);
        jRadioButton3.setActionCommand(stringArray[0]);
        if (stringArray.length == 2) {
            jRadioButton3.setMnemonic(stringArray[1].charAt(0));
        }
        jRadioButton3.setEnabled(this.m_isEncryptionEnabled);
        this.m_btnGrp = new ButtonGroup();
        this.m_btnGrp.add(jRadioButton);
        this.m_btnGrp.add(jRadioButton2);
        this.m_btnGrp.add(jRadioButton3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.gridy = 1;
        this.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)jRadioButton3, gridBagConstraints);
    }

    public void launchSelectedOpDialog() {
        ButtonModel buttonModel = this.m_btnGrp.getSelection();
        System.out.println(buttonModel.getActionCommand());
        if (buttonModel.getActionCommand().equals(Resource.getResourceMnemonic(Resource.getString("BUTTON_ENABLE_ENCRYPTION", "Ena(b)le..."))[0])) {
            new SecurityBasedOperations(this.m_adapterHelper, false);
        } else if (buttonModel.getActionCommand().equals(Resource.getResourceMnemonic(Resource.getString("BUTTON_CHANGE_PASSPHRASE", "Chan(g)e Security Settings..."))[0])) {
            new SecurityBasedOperations(this.m_adapterHelper, false);
        } else if (buttonModel.getActionCommand().equals(Resource.getResourceMnemonic(Resource.getString("BUTTON_DISABLE_ENCRYPTION", "(D)isable..."))[0])) {
            Vector vector = this.m_adapterHelper.getSecuredArrays();
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("LABEL_CONTROLLER", "Controller:"));
            stringBuffer.append(" ");
            stringBuffer.append(this.m_strControllerName);
            stringBuffer.append("\n\n");
            if (vector != null && vector.size() > 0) {
                DisableEncryptionErrorDialog disableEncryptionErrorDialog = new DisableEncryptionErrorDialog(this.m_adapterHelper, vector);
            } else {
                Object[] objectArray = new Object[1];
                boolean bl = false;
                PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    if (!physicalDriveHelperArray[i].isFDECapable()) continue;
                    bl = true;
                    break;
                }
                objectArray[0] = bl ? " " + Resource.getString("MESSAGE_ALL_FDE_DRIVES_ERASED", "and all secure unconfigured FDE\ndrives will be securely erased") : "";
                stringBuffer.append(MessageFormat.format(Resource.getString("MESSAGE_CONFIRM_DISABLE_ENCRYPTION"), objectArray));
                if (JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, stringBuffer.toString(), Resource.getString("TITLE_CONFIRM_DISABLE_DRIVE_SECURITY", "Confirm Disable Drive Security"), 0, 2) == 0) {
                    this.m_adapterHelper.fireDestroyKeyOperation();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

