/*
 * Decompiled with CFR 0.152.
 */
package GUI.security;

import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfirmCtrlEncryptionDialog
extends VivaldiBaseOptionDialog {
    private int m_driveGroupNumber = -1;

    public ConfirmCtrlEncryptionDialog(Window window, int n) {
        super(window);
        this.m_driveGroupNumber = n;
        this.buildUI();
    }

    @Override
    public void buildUI() {
        Object[] objectArray;
        String[] stringArray = null;
        this.initUI(Resource.getString("CONFIRM_CTRL_ENCRYPTION_DIALOG_TITLE", "Confirm Controller Encryption"), 0, 2);
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 1;
        String string = null;
        if (this.m_driveGroupNumber == -1) {
            string = Resource.getString("CTRL_ENCRYPTION_WARN_DESC", "<html>One or more drive groups that are capable of Full Disk Encryption<br>(FDE) will not be used to their full security capability.<br><br>Once a drive group is secured, you will not be able to remove<br>the security without deleting the virtual drives.<br><br>Are you sure you want to use controller encryption only?<br><br></html>");
        } else {
            objectArray = new Object[]{new Integer(this.m_driveGroupNumber)};
            string = MessageFormat.format(Resource.getString("CTRL_ENCRYPTION_WARN_DESC1", "<html>Drive group {0} is capable of Full Disk Encryption (FDE) and will<br>not be used to their full security capability.<br><br>Once a drive group is secured, you will not be able to remove<br>the security without deleting the virtual drives.<br><br>Are you sure you want to use controller encryption only?<br><br></html>"), objectArray);
        }
        objectArray = new JLabel(string);
        this.m_panel.add((Component)objectArray, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CONFIRM_TEXT", "(C)onfirm"));
        final JCheckBox jCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            jCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        jCheckBox.setSelected(false);
        gridBagConstraints.gridy = 1;
        this.m_panel.add((Component)jCheckBox, gridBagConstraints);
        this.setYesEnabled(false);
        this.setModalProperty(true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmCtrlEncryptionDialog.this.setYesEnabled(jCheckBox.isSelected());
            }
        });
        super.buildUI();
    }
}

