/*
 * Decompiled with CFR 0.152.
 */
package GUI.security;

import GUI.VivaldiStartupDialog;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfirmSecureEraseDialog
extends VivaldiBaseOptionDialog {
    private PhysicalDriveHelper m_pdHelper = null;

    public ConfirmSecureEraseDialog(PhysicalDriveHelper physicalDriveHelper) {
        super((Window)VivaldiStartupDialog.mainScreen);
        this.m_pdHelper = physicalDriveHelper;
    }

    @Override
    public void buildUI() {
        this.initUI(Resource.getString("CONFIRM_SECURE_ERASE_TITLE", "Confirm Secure Erase"), 0, 2);
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 1;
        int n = this.m_pdHelper.getEnclosureID();
        char c = ((SASPhysicalDrive)this.m_pdHelper.getDeviceObject()).getInformation().getslotNumber();
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_SECURE_ERASE_WARN", "<html>When you securely erase a drive, any data on the drive will<br>be permanently lost.<br><br>Are you sure you want to securely erase the drive in"));
        stringBuffer.append(" " + Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
        stringBuffer.append(" " + n + ", ");
        stringBuffer.append(Resource.getString("SLOT_TEXT", "Slot") + " " + c + "?");
        stringBuffer.append("<br><br></html>");
        JLabel jLabel = new JLabel(stringBuffer.toString());
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("CONFIRM_TEXT", "(C)onfirm"));
        final JCheckBox jCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            jCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        jCheckBox.setSelected(false);
        gridBagConstraints.gridy = 2;
        this.m_panel.add((Component)jCheckBox, gridBagConstraints);
        this.setYesEnabled(false);
        this.setModalProperty(true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmSecureEraseDialog.this.setYesEnabled(jCheckBox.isSelected());
            }
        });
        super.buildUI();
    }
}

