/*
 * Decompiled with CFR 0.152.
 */
package GUI.security;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.security.SuggestedPassPhraseDialog;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_LOCK_KEY_PARAMS;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.PassPhraseVerifier;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnableAndChangeEncryptionSettingsDialog
extends VivaldiBaseDialog
implements DocumentListener,
ActionListener {
    private AdapterHelper m_adapterHelper = null;
    private JPasswordField m_tfOldPassPhrase = null;
    private JPasswordField m_tfPassPhrase = null;
    private JPasswordField m_tfConfirmPassPhrase = null;
    private JButton m_btnOk = null;
    private SuggestedPassPhraseDialog m_suggestPassPhraseDlg = null;

    public EnableAndChangeEncryptionSettingsDialog(AdapterHelper adapterHelper) {
        super(VivaldiStartupDialog.mainScreen);
        this.m_adapterHelper = adapterHelper;
        this.buildUI();
    }

    private void buildUI() {
        String[] stringArray = null;
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            this.setTitle(Resource.getString("CHANGE_PASSPHRASE_DIALOG_TITLE", "Change Pass Phrase"));
        } else {
            this.setTitle(Resource.getString("ENABLE_ENCRYPTION_DIALOG_TITLE", "Enable Encryption"));
        }
        this.setResizable(false);
        String string = Resource.getString("LABEL_CONTROLLER", "Controller:");
        JLabel jLabel = new JLabel(string + " " + this.m_adapterHelper.getText());
        JLabel jLabel2 = new JLabel(Resource.getString("ENABLE_ENCRYPTION_DESC", "<html>When encryption is enabled, data will be secured using a Password.<br>Encryption must be enabled to create encrypted virtual drives.<br><br>The Password is case-sensitive.It must be between eight and<br>thirty-two characters and contain at least one number, one lowercase letter,<br>one uppercase letter, and one non-alphanumeric character e.g. ! * @ + #).<br><br>Note: For maximum security, use thirty-two varied characters.</html>"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SUGGEST_PASS_PHRASE", "Suggest Pass Phrase"));
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = EnableAndChangeEncryptionSettingsDialog.this.m_adapterHelper.getControllerGeneratedPassPhrase();
                if (string != null) {
                    if (EnableAndChangeEncryptionSettingsDialog.this.m_suggestPassPhraseDlg == null) {
                        EnableAndChangeEncryptionSettingsDialog.this.m_suggestPassPhraseDlg = new SuggestedPassPhraseDialog(string);
                    } else {
                        EnableAndChangeEncryptionSettingsDialog.this.m_suggestPassPhraseDlg.setSuggestedPassPhrase(string);
                    }
                }
            }
        });
        JLabel jLabel3 = null;
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_OLD_PASS_PHRASE", "Old pass phrase:"));
            jLabel3 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            this.m_tfOldPassPhrase = new JPasswordField(32){

                @Override
                public void paste() {
                }
            };
            this.m_tfOldPassPhrase.getDocument().addDocumentListener(this);
            this.m_tfOldPassPhrase.addActionListener(new EnterKeyOnTextFieldListener());
            jLabel3.setLabelFor(this.m_tfOldPassPhrase);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PASS_PHRASE", "Pass phrase:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfPassPhrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfPassPhrase.getDocument().addDocumentListener(this);
        this.m_tfPassPhrase.addActionListener(new EnterKeyOnTextFieldListener());
        jLabel4.setLabelFor(this.m_tfPassPhrase);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CONFIRM", "Confirm:"));
        JLabel jLabel5 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel5.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfConfirmPassPhrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfConfirmPassPhrase.getDocument().addDocumentListener(this);
        this.m_tfConfirmPassPhrase.addActionListener(new EnterKeyOnTextFieldListener());
        jLabel5.setLabelFor(this.m_tfConfirmPassPhrase);
        this.m_btnOk = new JButton(Resource.getString("BUTTON_LABEL_OK", "Ok"));
        this.m_btnOk.setEnabled(false);
        this.m_btnOk.addActionListener(this);
        JButton jButton2 = new JButton(Resource.getString("BUTTON_LABEL_CANCEL", "Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnableAndChangeEncryptionSettingsDialog.this.setVisible(false);
                EnableAndChangeEncryptionSettingsDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_btnOk);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)jButton, gridBagConstraints);
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            gridBagConstraints.gridy = n++;
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridy = n;
            jPanel2.add((Component)this.m_tfOldPassPhrase, gridBagConstraints);
        }
        ++n;
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)this.m_tfPassPhrase, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = n;
        jPanel2.add((Component)this.m_tfConfirmPassPhrase, gridBagConstraints);
        this.contentPane.add((Component)jPanel2, "Center");
        this.contentPane.add((Component)jPanel, "South");
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.pack();
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            this.m_tfOldPassPhrase.requestFocusInWindow();
        } else {
            this.m_tfPassPhrase.requestFocusInWindow();
        }
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isReady()) {
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("LABEL_CONTROLLER", "Controller:"));
            stringBuffer.append(" ");
            stringBuffer.append(this.m_adapterHelper.getText());
            stringBuffer.append("\n\n");
            if (this.m_adapterHelper.isLockKeyAssigned()) {
                stringBuffer.append(Resource.getString("MESSAGE_CONFIRM_CHANGE_PASSPHRASE", "If you change the Password, the existing configuration on\nthis controller will be updated to use the new Password. If\nyou have removed any encrypted drives, they will continue to\nuse the old Password.\n\nAre you sure you want to change the Password?\n\n"));
                if (JOptionPane.showConfirmDialog(this, stringBuffer.toString(), Resource.getString("TITLE_CONFIRM_PASSPHRASE_CHANGE", "Confirm Change Pass Phrase"), 0, 2) == 0) {
                    try {
                        this.m_adapterHelper.fireRekeyOperation(new String(this.m_tfOldPassPhrase.getPassword()), new String(this.m_tfPassPhrase.getPassword()), null, null, false);
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        if (vKOperationFailedException.GetErrorCode() == 72) {
                            String string = Resource.getMfiStatString("MFI_STAT_LOCK_KEY_INVALID");
                            new CustomMsgBox(this, string, Resource.getString("TITLE_INCORRECT_PASSPHRASE", "Invalid Pass Phrase"), 0);
                            return;
                        }
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                    }
                }
            } else {
                MR_CTRL_LOCK_KEY_PARAMS mR_CTRL_LOCK_KEY_PARAMS = this.m_adapterHelper.fireCreateKeyOperation(new String(this.m_tfPassPhrase.getPassword()), null, null, false);
                if (mR_CTRL_LOCK_KEY_PARAMS != null) {
                    stringBuffer.append(Resource.getString("MESSAGE_CONFIRM_ENABLE_ENCRYPTION", " <html>Drive security will be enabled on this controller using the<br>specified security key identifier,"));
                    new CustomMsgBox(this, stringBuffer.toString(), Resource.getString("TITLE_ENCRYPTION_ENABLED", "Encryption Enabled"), 1);
                } else {
                    JOptionPane.showMessageDialog(this, Resource.getString("UNABLE_CREATE_KEY", "Unable to create key"));
                }
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.m_suggestPassPhraseDlg != null) {
            this.m_suggestPassPhraseDlg.setVisible(false);
            this.m_suggestPassPhraseDlg.dispose();
            this.m_suggestPassPhraseDlg = null;
        }
        super.dispose();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableDisableOkButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableDisableOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableDisableOkButton();
    }

    private boolean isReady() {
        String string;
        String string2 = null;
        String string3 = new String(this.m_tfPassPhrase.getPassword());
        if (!string3.equals(string = new String(this.m_tfConfirmPassPhrase.getPassword()))) {
            string2 = Resource.getString("ERROR_PASSWORD_MISMATCH", "The characters entered in the Password field and the confirm\nfield do not match.\n\nPlease re-enter and confirm your Password.");
            new CustomMsgBox(this, string2, Resource.getString("TITLE_PASSPHRASE_MISMATCH", "Pass Phrase Mismatch"), 0);
            return false;
        }
        if (!PassPhraseVerifier.isValidPassPhrase(string3)) {
            string2 = Resource.getString("ERROR_INVALID_PASSPHRASE", " The Password entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe Password is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a Password that meets the above requirements.\n\n");
            new CustomMsgBox(this, string2, Resource.getString("TITLE_INVALID_PASSPHRASE", "Invalid Pass Phrase"), 0);
            return false;
        }
        return true;
    }

    private void enableDisableOkButton() {
        boolean bl = false;
        String string = new String(this.m_tfPassPhrase.getPassword());
        String string2 = new String(this.m_tfConfirmPassPhrase.getPassword());
        if (string.length() >= 8 && string2.length() >= 8) {
            bl = true;
        }
        if (this.m_adapterHelper.isLockKeyAssigned() && bl) {
            String string3 = new String(this.m_tfOldPassPhrase.getPassword());
            bl = string3.length() >= 8;
        }
        this.m_btnOk.setEnabled(bl);
    }

    class EnterKeyOnTextFieldListener
    implements ActionListener {
        EnterKeyOnTextFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EnableAndChangeEncryptionSettingsDialog.this.m_btnOk.isEnabled()) {
                EnableAndChangeEncryptionSettingsDialog.this.m_btnOk.doClick();
            }
        }
    }
}

