/*
 * Decompiled with CFR 0.152.
 */
package GUI.security;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmCtrlEncryptionDialog;
import GUI.security.ConfirmFDEDialog;
import GUI.security.DrivesUsingFDEDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.GUIUtils;
import Utils.Resource;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectEncryptionMethodDialog
extends VivaldiBaseDialog
implements ActionListener {
    private List m_pdsInDG = null;
    private int m_iDGNumber = 0;
    private JRadioButton m_rdBtnUseFDE = new JRadioButton();
    private JRadioButton m_rdBtnUseCtrlEncryption = new JRadioButton();
    private JRadioButton m_rdBtnNoEncryption = new JRadioButton();
    private JButton m_buttonOK = new JButton();
    private JButton m_buttonCancel = new JButton();
    private byte m_selectedDriveSecurity = (byte)-1;
    private ArrayList m_securedFDEDrives = null;
    private int m_selOptFrmCannotUseFDEDrivesDlg = -1;

    public SelectEncryptionMethodDialog(List list, int n) {
        this.m_pdsInDG = list;
        this.m_iDGNumber = n;
        this.buildUI();
    }

    private void buildUI() {
        String[] stringArray = null;
        boolean bl = false;
        AdapterHelper adapterHelper = BaseConfigWizardDialog.getAdapterHelper();
        if (VivaldiStartupDialog.OEM_TYPE == 2561 && adapterHelper.isOnlyFDESupported()) {
            bl = true;
            this.setTitle(Resource.getString("SECURE_USING_FDE_ONLY"));
        } else {
            this.setTitle(Resource.getString("SELECT_ENCRYPTION_METHOD_DIALOG_TITLE", "Select Drive Security Method"));
        }
        this.setResizable(false);
        this.setModal(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 1;
        Object[] objectArray = new Object[]{new Integer(this.m_iDGNumber), new Integer(this.m_iDGNumber)};
        JLabel jLabel = null;
        jLabel = bl ? new JLabel(MessageFormat.format(Resource.getString("SELECT_SECURE_DISK_GROUP_DESC"), objectArray)) : new JLabel(MessageFormat.format(Resource.getString("SELECT_DRIVE_SECURITY_METHOD_DESC"), objectArray));
        jPanel.add((Component)jLabel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        stringArray = bl ? Resource.getResourceMnemonic(Resource.getString("BUTTON_YES_TEXT", "(Y)es")) : Resource.getResourceMnemonic(Resource.getString("LABEL_USE_FDE", "Use full disk encryption(FDE)"));
        this.m_rdBtnUseFDE.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnUseFDE.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_rdBtnUseFDE, gridBagConstraints);
        buttonGroup.add(this.m_rdBtnUseFDE);
        if (!bl) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_CTRL_BASED_ENCRYPTION", "Use controller-based encryption only"));
            this.m_rdBtnUseCtrlEncryption.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_rdBtnUseCtrlEncryption.setMnemonic(stringArray[1].charAt(0));
                if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                    this.m_rdBtnUseCtrlEncryption.setEnabled(false);
                }
            }
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)this.m_rdBtnUseCtrlEncryption, gridBagConstraints);
            buttonGroup.add(this.m_rdBtnUseCtrlEncryption);
        }
        if (bl) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_NO_TEXT", "(N)o"));
            gridBagConstraints.gridy = 2;
        } else {
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_NO_ENCRYPTION", "No Encryption"));
            gridBagConstraints.gridy = 3;
        }
        this.m_rdBtnNoEncryption.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnNoEncryption.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add((Component)this.m_rdBtnNoEncryption, gridBagConstraints);
        buttonGroup.add(this.m_rdBtnNoEncryption);
        boolean bl2 = this.isFDEOnlyDriveGroup();
        boolean bl3 = adapterHelper.isOnlyFDESupported();
        this.m_rdBtnUseFDE.setSelected(bl2);
        this.m_rdBtnUseCtrlEncryption.setVisible(!bl3);
        if (!bl2) {
            this.m_rdBtnUseFDE.setEnabled(false);
            if (bl3) {
                this.m_rdBtnNoEncryption.setSelected(true);
            } else {
                this.m_rdBtnUseFDE.setSelected(false);
            }
        }
        JPanel jPanel2 = new JPanel();
        this.m_buttonOK.setText(Resource.getString("BUTTON_OK_TEXT", "OK"));
        this.m_buttonCancel.setText(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        jPanel2.add(this.m_buttonOK);
        jPanel2.add(this.m_buttonCancel);
        this.m_buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectEncryptionMethodDialog.this.m_selectedDriveSecurity = (byte)-1;
                SelectEncryptionMethodDialog.this.setVisible(false);
                SelectEncryptionMethodDialog.this.dispose();
            }
        });
        this.m_buttonOK.addActionListener(this);
        this.contentPane.add((Component)jPanel, "Center");
        this.contentPane.add((Component)jPanel2, "South");
        this.pack();
        GUIUtils.centerDialogOnScreen(this, null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_rdBtnUseFDE.isSelected()) {
            ConfirmFDEDialog confirmFDEDialog;
            PhysicalDriveHelper[] physicalDriveHelperArray = BaseConfigWizardDialog.getAdapterHelper().getPhysicalDrives();
            Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
            if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    SASPhysicalDrive sASPhysicalDrive;
                    if (physicalDriveHelperArray[i].isFDECapable() || (sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisGlobalSpare() != 1) continue;
                    vector.add(physicalDriveHelperArray[i]);
                }
            }
            if (vector.size() > 0 && (confirmFDEDialog = new ConfirmFDEDialog((Window)this, vector)).getSelectedOption() != 0) {
                return;
            }
            this.m_selectedDriveSecurity = 1;
        } else if (this.m_rdBtnUseCtrlEncryption.isSelected()) {
            ConfirmCtrlEncryptionDialog confirmCtrlEncryptionDialog;
            this.showSecuredFDEDriveDialog();
            if (this.m_securedFDEDrives.size() > 0) {
                if (this.m_securedFDEDrives.size() == this.m_pdsInDG.size()) {
                    return;
                }
                if (this.m_selOptFrmCannotUseFDEDrivesDlg != 0) {
                    return;
                }
            }
            if (this.isFDEOnlyDriveGroup() && (confirmCtrlEncryptionDialog = new ConfirmCtrlEncryptionDialog((Window)this, this.m_iDGNumber)).getSelectedOption() != 0) {
                return;
            }
            this.m_selectedDriveSecurity = (byte)2;
        } else {
            this.showSecuredFDEDriveDialog();
            if (this.m_securedFDEDrives.size() > 0) {
                if (this.m_securedFDEDrives.size() == this.m_pdsInDG.size()) {
                    return;
                }
                if (this.m_selOptFrmCannotUseFDEDrivesDlg != 0) {
                    return;
                }
            }
            this.m_selectedDriveSecurity = 0;
        }
        this.setVisible(false);
        this.dispose();
    }

    public byte getSelectedDriveSecurity() {
        return this.m_selectedDriveSecurity;
    }

    private boolean isFDEOnlyDriveGroup() {
        boolean bl = true;
        for (SASPhysicalDrive sASPhysicalDrive : this.m_pdsInDG) {
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void showSecuredFDEDriveDialog() {
        PhysicalDriveHelper[] physicalDriveHelperArray;
        this.m_securedFDEDrives = new ArrayList();
        for (int i = 0; i < this.m_pdsInDG.size(); ++i) {
            physicalDriveHelperArray = (PhysicalDriveHelper[])this.m_pdsInDG.get(i);
            if (!physicalDriveHelperArray.getInformation().getSecurity_MR_PD_INFO().getSecured()) continue;
            this.m_securedFDEDrives.add(physicalDriveHelperArray.getDeviceId());
        }
        if (this.m_securedFDEDrives.size() > 0) {
            Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
            physicalDriveHelperArray = BaseConfigWizardDialog.getAdapterHelper().getPhysicalDrives();
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (!this.m_securedFDEDrives.contains(physicalDriveHelperArray[i].getDeviceID())) continue;
                vector.add(physicalDriveHelperArray[i]);
            }
            DrivesUsingFDEDialog drivesUsingFDEDialog = new DrivesUsingFDEDialog((Window)this, vector, this.m_securedFDEDrives.size() != this.m_pdsInDG.size());
            this.m_selOptFrmCannotUseFDEDrivesDlg = drivesUsingFDEDialog.getSelectedOption();
        }
    }

    public List getSecuredFDEList() {
        return this.m_securedFDEDrives;
    }
}

