/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration;

import GUIHelper.CapacityHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ArrayTableModel
extends AbstractTableModel {
    public ArrayList m_cmbItems = new ArrayList();

    public ArrayTableModel(ArrayList<CapacityHelper> arrayList) {
        this.m_cmbItems = arrayList;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.m_cmbItems.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return Resource.getString("COL_NAME_DG", "Drive group name");
            }
            case 1: {
                return Resource.getString("COL_NAME_RL", "RAID Level");
            }
            case 2: {
                return Resource.getString("COL_NAME_FC", "Capacity");
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return "DG-" + ((CapacityHelper)this.m_cmbItems.get(n)).getArrayRef() + " : " + Resource.getString("FREE_CAP_NODE", "Free capacity node") + " " + ((CapacityHelper)this.m_cmbItems.get(n)).getFreeIndex();
            }
            case 1: {
                int n3 = ((CapacityHelper)this.m_cmbItems.get(n)).getRAIDLevelInfo();
                if (n3 == 17) {
                    n3 = 1;
                }
                return "RAID " + n3;
            }
            case 2: {
                return KernelConstants.getConvertedSize(((CapacityHelper)this.m_cmbItems.get(n)).getFreeSpaceInBlocks(1), ((CapacityHelper)this.m_cmbItems.get(n)).getUserDataBlockSize());
            }
        }
        return "";
    }

    public CapacityHelper getCapacityHelperForRow(int n) {
        return (CapacityHelper)this.m_cmbItems.get(n);
    }
}

