/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration;

import GUI.CSA.ManageCSACachingDialog;
import GUI.DrivesSpinUpProgressDialog;
import GUI.ManageSSDCachingDialog;
import GUI.venus.configuration.ConfigurationSummaryPanel;
import GUI.venus.configuration.DriveGroupSelectionPage;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.AdvanceConfigSummaryGenerator;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.DriveGroupCreationPage;
import GUI.venus.configuration.advanced.VirtualDiskCreationPage;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUI.venus.configuration.simple.SimpleConfigSummaryGenerator;
import GUI.venus.configuration.simple.VirtualDriveSettingsPage;
import GUI.venus.wizard.DefaultWizardPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.SASAdapter.SASAdapter;
import Utils.CustomMsgBox;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ConfigurationSummaryPage
extends DefaultWizardPage
implements HelpInterface {
    private AdapterHelper m_adapterHelper = null;
    private SimpleConfigParams m_simpleParams = null;
    private ConfigurationSummaryPanel m_summaryPanel = null;
    private AdvanceConfigEngine m_engine = null;
    private SimpleConfigEngine m_objSimpleConfigEngine = null;
    private CapacityHelper m_CapacityHelper = null;
    private boolean m_isSimple = false;

    public ConfigurationSummaryPage() {
        this.m_isFinishWizardPage = true;
    }

    @Override
    protected void reinitialise() {
        Object object;
        String string = null;
        this.m_isSimple = this.m_hmWizardData.get("SelectedMode").equals("Simple");
        this.m_adapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        if (this.m_isSimple) {
            object = null;
            this.m_simpleParams = (SimpleConfigParams)this.m_hmWizardData.get("DriveGroupData");
            if (this.m_simpleParams != null) {
                this.m_objSimpleConfigEngine = new SimpleConfigEngine(this.m_adapterHelper);
                this.m_objSimpleConfigEngine.setSimpleConfigParams(this.m_simpleParams);
                object = new SimpleConfigSummaryGenerator(this.m_simpleParams, this.m_adapterHelper);
                string = ((SimpleConfigSummaryGenerator)object).getSummaryForNewDriveGroup();
            } else {
                this.m_CapacityHelper = (CapacityHelper)this.m_hmWizardData.get("ArrayData");
                this.m_objSimpleConfigEngine = new SimpleConfigEngine(this.m_adapterHelper, this.m_CapacityHelper);
                object = new SimpleConfigSummaryGenerator(this.m_objSimpleConfigEngine, this.m_adapterHelper);
                string = ((SimpleConfigSummaryGenerator)object).getSummaryForExistingDriveGroup();
            }
            this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_A_SIMPLE_CONFIGURATION");
        } else {
            this.m_engine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
            object = new AdvanceConfigSummaryGenerator(this.m_engine);
            string = ((AdvanceConfigSummaryGenerator)object).getConfigSummaryText();
            this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION");
        }
        if (this.m_summaryPanel == null) {
            this.m_summaryPanel = new ConfigurationSummaryPanel(string);
        } else {
            this.m_summaryPanel.setSummaryText(string);
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        return this.m_summaryPanel;
    }

    @Override
    public String getPageID() {
        return "ConfigurationSummaryPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CREATE_VD_CONFIG_SUMMARY_TITLE", "Create Virtual Drive - Summary");
    }

    @Override
    public void onNext() {
        Serializable serializable;
        Object object;
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        JOptionPane jOptionPane = null;
        String string = null;
        boolean bl = false;
        if (this.m_isSimple) {
            object = null;
            try {
                object = this.m_objSimpleConfigEngine.fireConfigCommand();
                jOptionPane = new JOptionPane(object, 1);
                string = Resource.getString("CONFIG_SUCCESS_TITLE", "Create Virtual Drive - complete");
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                CustomMsgBox.errorMsg(vKOperationFailedException);
                vKOperationFailedException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                jOptionPane = new JOptionPane("Cannot create configuration: " + exception.getMessage(), 0);
                string = Resource.getString("CONFIG_FAILED_TITLE", "Create Configuration Failed.");
                exception.printStackTrace();
                bl = true;
            }
        } else {
            try {
                if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig() && (object = this.m_engine.getPhysicalDrivesInPowerSaveMode()).size() > 0) {
                    serializable = new DrivesSpinUpProgressDialog((SASAdapter)this.m_adapterHelper.getDeviceObject(), (List)object);
                }
                this.m_engine.writeConfiguration();
                jOptionPane = new JOptionPane(Resource.getString("CONFIG_SUCCESS_MSG"), 1);
                string = Resource.getString("CONFIG_SUCCESS_TITLE", "Create Virtual Drive - complete");
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                CustomMsgBox.errorMsg(vKOperationFailedException);
                vKOperationFailedException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                jOptionPane = new JOptionPane("Cannot create configuration: " + exception.getMessage(), 0);
                string = Resource.getString("CONFIG_FAILED_TITLE", "Create Configuration Failed.");
                exception.printStackTrace();
                bl = true;
            }
        }
        if (bl) {
            object = jOptionPane.createDialog(string);
            ((Window)object).setIconImage(image);
            ((Dialog)object).setVisible(true);
            this.dispose();
            super.onNext();
            return;
        }
        object = jOptionPane.createDialog(string);
        ((Window)object).setIconImage(image);
        ((Dialog)object).setVisible(true);
        this.dispose();
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 && this.m_adapterHelper.isSSCEnabled() && this.m_adapterHelper.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation()) {
            if (this.m_isSimple) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_objSimpleConfigEngine.enableSSDCaching();
            } else if (this.m_adapterHelper.isCSA()) {
                serializable = this.m_adapterHelper.getCSACacheableLDList(this.m_engine.getVirtualDriveList(), 1);
                if (((ArrayList)serializable).size() > 0) {
                    new ManageCSACachingDialog(this.m_adapterHelper, (ArrayList)serializable, 1);
                }
            } else {
                serializable = this.m_adapterHelper.getSSCCacheableLDList(this.m_engine.getVirtualDriveList(), 1);
                if (((ArrayList)serializable).size() > 0) {
                    new ManageSSDCachingDialog(this.m_adapterHelper, (ArrayList)serializable, 1);
                }
            }
        }
        super.onNext();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    class CreateVDAgainAction
    implements Runnable {
        private AdapterHelper m_adapterHelp = null;
        private String m_strSelectedMode = null;

        public CreateVDAgainAction(AdapterHelper adapterHelper, String string) {
            this.m_adapterHelp = adapterHelper;
            this.m_strSelectedMode = string;
        }

        @Override
        public void run() {
            try {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("AdapterHelper", this.m_adapterHelp);
                hashMap.put("WarningDialogTitle", Resource.getString("CONFIG_CONFIRMATION_TITLE", "Create virtual Drive - Confirmation"));
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(this.m_adapterHelp);
                PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelp.getUnconfiguredPhysicalDrives();
                bl = physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0;
                ArrayList<CapacityHelper> arrayList = this.m_adapterHelp.getCapacityHelpers();
                if (!arrayList.isEmpty() && (object = advanceConfigEngine.getExistingDriveGroups()) != null && !object.isEmpty()) {
                    bl3 = true;
                    Iterator<DriveGroup> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        DriveGroup driveGroup = iterator.next();
                        if (driveGroup.getSpanDepth() != 1) continue;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                }
                if (this.m_strSelectedMode.equals("Simple") && bl) {
                    object = new SimpleConfigEngine(this.m_adapterHelp);
                    hashMap.put("SimpleConfigEngine", object);
                    hashMap.put("SelectedMode", "Simple");
                    wizardController.addPage(DriveGroupSelectionPage.class.getName(), "DriveGroupSelectionPage");
                    wizardController.addPage(VirtualDriveSettingsPage.class.getName(), "VirtualDriveSettingsPage");
                    wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
                    if (bl2) {
                        wizardController.setFirstPage("DriveGroupSelectionPage");
                    } else {
                        wizardController.setFirstPage("VirtualDriveSettingsPage");
                    }
                    wizardController.addPageTransition("DriveGroupSelectionPage", 1, "VirtualDriveSettingsPage");
                    wizardController.addPageTransition("VirtualDriveSettingsPage", 0, "ConfigurationSummaryPage");
                    wizardController.launchWizard();
                    return;
                }
                hashMap.put("SelectedMode", "Advanced");
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(DriveGroupSelectionPage.class.getName(), "DriveGroupSelectionPage");
                wizardController.addPage(DriveGroupCreationPage.class.getName(), "AdvanceDGCreationPage");
                wizardController.addPage(VirtualDiskCreationPage.class.getName(), "AdvanceVDCreationPage");
                wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
                wizardController.setFirstPage(bl3 ? "DriveGroupSelectionPage" : "AdvanceDGCreationPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 2, "AdvanceVDCreationPage");
                wizardController.addPageTransition("DriveGroupSelectionPage", 3, "AdvanceDGCreationPage");
                wizardController.addPageTransition("AdvanceDGCreationPage", 0, "AdvanceVDCreationPage");
                wizardController.addPageTransition("AdvanceVDCreationPage", 0, "ConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

