/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration;

import GUI.venus.configuration.ArrayTableModel;
import GUI.venus.configuration.DriveGroupSelectionPanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DGHoleTableModel;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.SpanHole;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.CapacityHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DriveGroupSelectionPage
extends DefaultWizardPage
implements HelpInterface {
    private SimpleConfigEngine m_simpleConfigEngine = null;
    private AdapterHelper m_adapterHelper = null;
    private DriveGroupSelectionPanel m_driveGroupSelectionPanel = null;
    private int holeCount;
    private int rowCount;
    private boolean m_isSimpleMode = false;
    private AdvanceConfigEngine m_engine = null;
    private SpanHole m_currentlySelectedSpanHole = null;
    private DriveGroup m_currentlySelectedDG = null;
    private ArrayTableModel arrayTableModel = null;
    private DGHoleTableModel m_dgHoleTableModel = null;

    @Override
    protected void reinitialise() {
        this.m_isSimpleMode = this.m_hmWizardData.get("SelectedMode").equals("Simple");
        this.m_adapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        if (!this.m_isSimpleMode) {
            if (this.m_driveGroupSelectionPanel != null) {
                if (this.m_dgHoleTableModel == null) {
                    this.constructSpanHoleTableModel();
                }
                this.m_driveGroupSelectionPanel.initData(this.m_dgHoleTableModel);
            }
            this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION");
        } else {
            if (this.m_driveGroupSelectionPanel != null) {
                if (this.arrayTableModel == null) {
                    this.constructArrayHoleTableModelForSimple();
                }
                this.m_driveGroupSelectionPanel.initData(this.arrayTableModel);
            }
            this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_A_SIMPLE_CONFIGURATION");
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_isSimpleMode) {
            this.m_simpleConfigEngine = (SimpleConfigEngine)this.m_hmWizardData.get("SimpleConfigEngine");
            if (this.m_driveGroupSelectionPanel == null) {
                this.constructArrayHoleTableModelForSimple();
                this.m_driveGroupSelectionPanel = new DriveGroupSelectionPanel(this.arrayTableModel);
            }
        } else if (this.m_driveGroupSelectionPanel == null) {
            this.constructSpanHoleTableModel();
            this.m_driveGroupSelectionPanel = new DriveGroupSelectionPanel(this.m_dgHoleTableModel);
        }
        this.m_hmWizardData.put("HoleAndGDVisited", false);
        this.setUnconfiguredButton();
        this.m_driveGroupSelectionPanel.buildPanel();
        this.m_driveGroupSelectionPanel.addItemListener(new RadioButtonItemListener());
        this.m_driveGroupSelectionPanel.addListSelectionListener(new ArrayTableListListener());
        return this.m_driveGroupSelectionPanel;
    }

    @Override
    public String getPageID() {
        return "DriveGroupSelectionPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("DRIVE_GROUP_SELECTION_PAGE_TITLE", "Create CacheCade\u2122 - SSD Caching Drive group");
    }

    public void setUnconfiguredButton() {
        if (this.m_adapterHelper.getUnconfiguredPhysicalDrives() != null) {
            this.m_driveGroupSelectionPanel.m_unconfigPds = true;
        }
    }

    @Override
    public void onNext() {
        this.m_iTrigger = this.m_driveGroupSelectionPanel.getSelectionOption();
        if (this.m_iTrigger == 0) {
            if (this.m_isSimpleMode) {
                this.m_hmWizardData.put("ArrayData", this.m_driveGroupSelectionPanel.getSelectedDriveGroup());
            } else {
                SpanHole spanHole = this.m_driveGroupSelectionPanel.getSelectedSpanHole();
                List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
                if (list != null && ((Boolean)this.m_hmWizardData.get("HoleAndGDVisited")).booleanValue()) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        this.m_engine.removeDriveGroup(list.get(0));
                    }
                    this.m_hmWizardData.put("HoleAndGDVisited", false);
                    this.m_hmWizardData.put("HoleSelectionChanged", true);
                }
                if (this.m_currentlySelectedSpanHole == null) {
                    this.m_currentlySelectedSpanHole = spanHole;
                    this.m_currentlySelectedDG = spanHole.getSpan().getDriveGroup();
                    this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                    List<DriveGroup> list2 = this.m_engine.getNewlyCreatedDriveGroups();
                    if (list2 == null || list2.isEmpty()) {
                        this.m_engine.addNewDriveGroup(this.m_currentlySelectedDG);
                    }
                    this.m_hmWizardData.put("SelectedSpanHole", this.m_currentlySelectedSpanHole);
                } else if (spanHole != null) {
                    DriveGroup driveGroup = spanHole.getSpan().getDriveGroup();
                    if (this.m_currentlySelectedDG.equals(driveGroup)) {
                        if (this.m_currentlySelectedSpanHole.equals(spanHole)) {
                            this.m_hmWizardData.put("HoleSelectionChanged", false);
                        } else {
                            this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                            this.m_currentlySelectedSpanHole = spanHole;
                            this.m_hmWizardData.put("HoleSelectionChanged", true);
                            this.m_hmWizardData.put("SelectedSpanHole", spanHole);
                            List<VirtualDrive> list3 = driveGroup.getVirtualDrives();
                            if (list3 != null && !list3.isEmpty()) {
                                for (int i = 0; i < list3.size(); ++i) {
                                    this.m_engine.returnLDTargetId(list3.get(i).getTargetId());
                                }
                                list3.clear();
                            }
                        }
                    } else {
                        this.m_engine.removeDriveGroup(this.m_currentlySelectedDG);
                        this.m_currentlySelectedDG = driveGroup;
                        this.m_currentlySelectedSpanHole = spanHole;
                        this.m_hmWizardData.put("HoleSelectionChanged", true);
                        this.m_hmWizardData.put("SelectedSpanHole", spanHole);
                        this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                        this.m_engine.addNewDriveGroup(driveGroup);
                    }
                }
                this.m_iTrigger = 2;
            }
        } else if (this.m_iTrigger == 1 && !this.m_isSimpleMode) {
            this.m_hmWizardData.remove("SelectedSpanHole");
            this.m_currentlySelectedSpanHole = null;
            this.m_hmWizardData.put("HoleAndGDVisited", true);
            if (this.m_currentlySelectedDG != null) {
                this.m_engine.removeDriveGroup(this.m_currentlySelectedDG);
            }
            this.m_hmWizardData.put("DGsModified", true);
            this.m_iTrigger = 3;
        }
        super.onNext();
    }

    public void constructArrayHoleTableModelForSimple() {
        ArrayList<CapacityHelper> arrayList = new ArrayList<CapacityHelper>();
        AdapterHelper adapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        HashMap<Short, Boolean> hashMap = new HashMap<Short, Boolean>();
        try {
            int n;
            ArrayHelper[] arrayHelperArray = adapterHelper.getArrays();
            ArrayList<CapacityHelper> arrayList2 = adapterHelper.getCapacityHelpers();
            for (n = 0; n < arrayHelperArray.length; ++n) {
                short s;
                if (arrayHelperArray[n].isRebuildInProgress() || !arrayHelperArray[n].isAtleastMinimumBlockSizeRemaining()) continue;
                if (arrayHelperArray[n].getSpanDepth() > 1) {
                    s = arrayHelperArray[n].getDeviceObject().getID();
                    hashMap.put(s, true);
                    continue;
                }
                s = arrayHelperArray[n].getDeviceObject().getID();
                hashMap.put(s, false);
            }
            for (n = 0; n < arrayList2.size(); n = (int)((short)(n + 1))) {
                CapacityHelper capacityHelper = arrayList2.get(n);
                short s = capacityHelper.getArrayRef();
                if (!hashMap.containsKey(s) || ((Boolean)hashMap.get(s)).booleanValue()) continue;
                arrayList.add(capacityHelper);
            }
            this.arrayTableModel = new ArrayTableModel(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void constructSpanHoleTableModel() {
        ArrayList<SpanHole> arrayList = new ArrayList<SpanHole>();
        this.m_engine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
        List<DriveGroup> list = this.m_engine.getExistingDriveGroups();
        if (list != null && !list.isEmpty()) {
            for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
                List<SpanHole> list2 = list.get(n).getSpanHoles();
                if (list2 == null || list2.isEmpty()) continue;
                arrayList.addAll(list2);
            }
        }
        this.m_dgHoleTableModel = new DGHoleTableModel(arrayList);
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    class ArrayTableListListener
    implements ListSelectionListener {
        ArrayTableListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JTable jTable = DriveGroupSelectionPage.this.m_driveGroupSelectionPanel.getDriveGroupTable();
            DriveGroupSelectionPage.this.setNextButtonStatus(jTable.getSelectedRow() != -1);
        }
    }

    class RadioButtonItemListener
    implements ItemListener {
        RadioButtonItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            JTable jTable = DriveGroupSelectionPage.this.m_driveGroupSelectionPanel.getDriveGroupTable();
            if (jRadioButton.isSelected()) {
                jTable.setEnabled(true);
                DriveGroupSelectionPage.this.setNextButtonStatus(false);
            } else {
                jTable.clearSelection();
                jTable.setEnabled(false);
                DriveGroupSelectionPage.this.setNextButtonStatus(true);
            }
        }
    }
}

