/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JBODToUnconfiguredGoodConversion
extends DefaultWizardPage
implements HelpInterface {
    private AdapterHelper m_adapterHelper = null;
    private JPanel m_contentPanel = null;
    private JCheckBox doNotConvertJBODsCheckBox = new JCheckBox();
    PhysicalDriveHelper[] pdHelpers = null;
    private JList jbodList = null;
    boolean nextButtonStatus = false;
    AdvanceConfigEngine advEngine = null;
    private JButton convertButton = new JButton();
    boolean convertButtonStatus = false;
    private DefaultListModel modelList = new DefaultListModel();
    int unconfiguredPDCount;
    int maxPDs;
    int JBODCount;
    JLabel eligibleJBODSDesc = new JLabel();
    int timeout = 5;
    int systemPDCount;

    @Override
    protected void reinitialise() {
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_contentPanel == null) {
            this.buildPanel();
        }
        return this.m_contentPanel;
    }

    @Override
    public String getPageID() {
        return "JBODToUnconfiguredGoodConversion";
    }

    @Override
    public String getTitle() {
        return Resource.getString("JBOD_CONVERT_UNCONF_GOOD_PAGE_TITLE", "Create Virtual Drive - JBOD to Unconfigured Good Conversion");
    }

    public void onConvert() {
        if (!this.doNotConvertJBODsCheckBox.isSelected()) {
            int n;
            int[] nArray = this.jbodList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                this.changeJBODtoUCG(this.pdHelpers[nArray[n]]);
            }
            for (n = 0; n < nArray.length; ++n) {
                for (int i = 0; i < this.timeout && (byte)this.pdHelpers[nArray[n]].getDeviceObject().getState() != 0; ++i) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!this.jbodList.getSelectionModel().isSelectionEmpty()) {
                this.modelList.removeRange(this.jbodList.getMinSelectionIndex(), this.jbodList.getMaxSelectionIndex());
            }
        }
    }

    @Override
    public void onNext() {
        super.onNext();
    }

    private void buildPanel() {
        String[] stringArray = null;
        this.m_adapterHelper = (AdapterHelper)this.m_hmWizardData.get("JBODToUnconfiguredGoodConversion");
        try {
            this.advEngine = new AdvanceConfigEngine(this.m_adapterHelper);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.maxPDs = this.m_adapterHelper.getAdapterInfo().getmaxConfigurablePds() < this.m_adapterHelper.getAdapterInfo().getpdDiskPresentCount() ? this.m_adapterHelper.getAdapterInfo().getmaxConfigurablePds() : (int)this.m_adapterHelper.getAdapterInfo().getpdDiskPresentCount();
        this.unconfiguredPDCount = 0;
        if (this.m_adapterHelper.getUnconfiguredPhysicalDrives() != null) {
            this.unconfiguredPDCount = this.m_adapterHelper.getUnconfiguredPhysicalDrives().length;
        }
        if (this.unconfiguredPDCount <= 0 && !this.advEngine.canCreateConfig()) {
            this.convertButtonStatus = false;
            this.nextButtonStatus = false;
            this.doNotConvertJBODsCheckBox.setEnabled(false);
        } else {
            this.convertButtonStatus = true;
            this.nextButtonStatus = true;
            this.doNotConvertJBODsCheckBox.setEnabled(true);
        }
        if (this.m_adapterHelper.getUnconfiguredPhysicalDrives() != null && this.m_adapterHelper.getUnconfiguredPhysicalDrives().length < 1) {
            this.nextButtonStatus = false;
        }
        this.setNextButtonStatus(this.nextButtonStatus);
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(Resource.getString("JBOD_CONVERT_UNCONF_GOOD_DESC", "One or more JBODs were detected in the system. In order to convert JBOD(s) to Unconfigured Good drive(s), choose\nthe drive(s) from the table below."));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.m_contentPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Resource.getString("MAX_ALLOWED_UCG", "Maximum number of Unconfigured Good drives allowed on this controller: ") + this.m_adapterHelper.getAdapterInfo().getmaxConfigurablePds());
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.m_contentPanel.add((Component)jLabel2, gridBagConstraints);
        this.JBODCount = this.maxPDs - this.getunconfiguredandOnlinePDCnt();
        String string = Resource.getString("ELIGIBLE_JBOD_DESC", "Eligible number of JBOD(s) for conversion: ") + this.JBODCount;
        this.eligibleJBODSDesc = new JLabel(string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.m_contentPanel.add((Component)this.eligibleJBODSDesc, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("JBOD_DRIVES", "(J)BOD Drives:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.m_contentPanel.add((Component)jLabel3, gridBagConstraints);
        this.pdHelpers = this.m_adapterHelper.getSystemDrivesList();
        if (this.pdHelpers != null) {
            int n = this.pdHelpers.length;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = "";
                stringArray2[i] = this.pdHelpers[i].getText(true);
                this.modelList.addElement(stringArray2[i]);
            }
        }
        this.jbodList = new JList(this.modelList);
        this.jbodList.setVisibleRowCount(5);
        this.jbodList.setSelectionMode(2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        JScrollPane jScrollPane = new JScrollPane(this.jbodList);
        this.m_contentPanel.add((Component)jScrollPane, gridBagConstraints);
        this.jbodList.addListSelectionListener(new ListSelectionHandler());
        stringArray = Resource.getResourceMnemonic(Resource.getString("DO_NOT_CONVERT_JBOD_DESC", "(D)o not convert JBOD drives to unconfigured good drives."));
        this.doNotConvertJBODsCheckBox.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.doNotConvertJBODsCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.m_contentPanel.add((Component)this.doNotConvertJBODsCheckBox, gridBagConstraints);
        this.doNotConvertJBODsCheckBox.addActionListener(new checkBoxListener());
        stringArray = Resource.getResourceMnemonic(Resource.getString("JBOD_CONVERT_BUTTON_TEXT", "(C)onvert"));
        this.convertButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.convertButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        this.m_contentPanel.add((Component)this.convertButton, gridBagConstraints);
        this.convertButton.setEnabled(false);
        this.convertButton.addActionListener(new convertButtonListener());
        this.convertButton.setToolTipText(Resource.getString("JBOD_TO_UNCONFIG_GOOD", "Convert selected JBOD drive(s) to Unconfigured Good drive(s)"));
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    public int getunconfiguredandOnlinePDCnt() {
        int n = 0;
        n = this.m_adapterHelper.findunconfiguredAndOnlinePdCnt();
        return n;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    public void changeJBODtoUCG(PhysicalDriveHelper physicalDriveHelper) {
        OperationDetails operationDetails = new OperationDetails(19, "", "", null);
        operationDetails.setParameter((byte)2);
        try {
            ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).fireOperation(operationDetails);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkPDState(PhysicalDriveHelper physicalDriveHelper) {
        short s = ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getState();
        if (s != 0) {
            System.out.println("PD " + physicalDriveHelper.getDeviceID() + " state still didn't changed from JBOD to UCG");
        }
    }

    class checkBoxListener
    implements ActionListener {
        checkBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = abstractButton.getModel().isSelected();
            if (bl) {
                JBODToUnconfiguredGoodConversion.this.jbodList.setEnabled(false);
                JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(false);
            } else {
                JBODToUnconfiguredGoodConversion.this.jbodList.setEnabled(true);
                if (JBODToUnconfiguredGoodConversion.this.jbodList.getSelectedIndices().length > 0 && JBODToUnconfiguredGoodConversion.this.JBODCount > 0 && JBODToUnconfiguredGoodConversion.this.convertButtonStatus) {
                    JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(true);
                } else {
                    JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(false);
                }
            }
        }
    }

    class convertButtonListener
    implements ActionListener {
        convertButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(false);
            JBODToUnconfiguredGoodConversion.this.setNextButtonStatus(false);
            JBODToUnconfiguredGoodConversion.this.m_contentPanel.setCursor(Cursor.getPredefinedCursor(3));
            JBODToUnconfiguredGoodConversion.this.onConvert();
            JBODToUnconfiguredGoodConversion.this.modelList.removeAllElements();
            JBODToUnconfiguredGoodConversion.this.pdHelpers = JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getSystemDrivesList();
            if (JBODToUnconfiguredGoodConversion.this.pdHelpers != null) {
                try {
                    JBODToUnconfiguredGoodConversion.this.systemPDCount = JBODToUnconfiguredGoodConversion.this.pdHelpers.length;
                }
                catch (NullPointerException nullPointerException) {
                    JBODToUnconfiguredGoodConversion.this.systemPDCount = 0;
                }
                if (JBODToUnconfiguredGoodConversion.this.systemPDCount != 0) {
                    String[] stringArray = new String[JBODToUnconfiguredGoodConversion.this.systemPDCount];
                    for (int i = 0; i < JBODToUnconfiguredGoodConversion.this.systemPDCount; ++i) {
                        stringArray[i] = "";
                        stringArray[i] = JBODToUnconfiguredGoodConversion.this.pdHelpers[i].getText(true);
                        JBODToUnconfiguredGoodConversion.this.modelList.addElement(stringArray[i]);
                    }
                }
            }
            JBODToUnconfiguredGoodConversion.this.m_contentPanel.setCursor(Cursor.getDefaultCursor());
            JBODToUnconfiguredGoodConversion.this.jbodList.setSelectedIndex(-1);
            JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
            JBODToUnconfiguredGoodConversion.this.setNextButtonStatus(true);
            JBODToUnconfiguredGoodConversion.this.doNotConvertJBODsCheckBox.setEnabled(true);
            if (JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getUnconfiguredPhysicalDrives() != null) {
                JBODToUnconfiguredGoodConversion.this.unconfiguredPDCount = JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getUnconfiguredPhysicalDrives().length;
            }
            JBODToUnconfiguredGoodConversion.this.maxPDs = JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getAdapterInfo().getmaxConfigurablePds() < JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getAdapterInfo().getpdDiskPresentCount() ? JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getAdapterInfo().getmaxConfigurablePds() : (int)JBODToUnconfiguredGoodConversion.this.m_adapterHelper.getAdapterInfo().getpdDiskPresentCount();
            JBODToUnconfiguredGoodConversion.this.JBODCount = JBODToUnconfiguredGoodConversion.this.maxPDs - JBODToUnconfiguredGoodConversion.this.getunconfiguredandOnlinePDCnt();
            JBODToUnconfiguredGoodConversion.this.eligibleJBODSDesc.setText(Resource.getString("ELIGIBLE_JBOD_DESC", "Eligible number of JBOD(s) for conversion: ") + JBODToUnconfiguredGoodConversion.this.JBODCount);
            if (JBODToUnconfiguredGoodConversion.this.JBODCount == 0) {
                JBODToUnconfiguredGoodConversion.this.jbodList.setEnabled(false);
                JBODToUnconfiguredGoodConversion.this.doNotConvertJBODsCheckBox.setEnabled(false);
            }
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (JBODToUnconfiguredGoodConversion.this.jbodList.getSelectedIndices().length > 0) {
                    JBODToUnconfiguredGoodConversion.this.convertButtonStatus = true;
                    if (JBODToUnconfiguredGoodConversion.this.jbodList.getSelectedIndices().length > JBODToUnconfiguredGoodConversion.this.maxPDs) {
                        JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
                    }
                    if (JBODToUnconfiguredGoodConversion.this.unconfiguredPDCount >= JBODToUnconfiguredGoodConversion.this.maxPDs) {
                        JBODToUnconfiguredGoodConversion.this.doNotConvertJBODsCheckBox.setEnabled(true);
                        JBODToUnconfiguredGoodConversion.this.jbodList.setEnabled(false);
                        JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
                    }
                    if (JBODToUnconfiguredGoodConversion.this.unconfiguredPDCount >= 0 && JBODToUnconfiguredGoodConversion.this.jbodList.getSelectedIndices().length + JBODToUnconfiguredGoodConversion.this.unconfiguredPDCount > JBODToUnconfiguredGoodConversion.this.maxPDs) {
                        JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
                    }
                    if (JBODToUnconfiguredGoodConversion.this.jbodList.getSelectedIndex() == -1) {
                        JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
                    }
                    JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(JBODToUnconfiguredGoodConversion.this.convertButtonStatus);
                } else {
                    JBODToUnconfiguredGoodConversion.this.convertButtonStatus = false;
                    JBODToUnconfiguredGoodConversion.this.convertButton.setEnabled(JBODToUnconfiguredGoodConversion.this.convertButtonStatus);
                    if (JBODToUnconfiguredGoodConversion.this.unconfiguredPDCount > 0) {
                        JBODToUnconfiguredGoodConversion.this.setNextButtonStatus(true);
                    } else {
                        JBODToUnconfiguredGoodConversion.this.setNextButtonStatus(false);
                    }
                }
            }
        }
    }
}

