/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ModeSelectionPage
extends DefaultWizardPage
implements HelpInterface {
    private JPanel m_contentPanel = null;
    private AdapterHelper m_adapterHelper = null;
    private SimpleConfigEngine m_simpleConfigEngine = null;
    private JRadioButton m_rdBtnsimpleRadioButton = null;
    private JRadioButton m_rdBtnadvancedRadioButton = null;

    @Override
    public JPanel getContentPanel() {
        if (this.m_contentPanel == null) {
            this.buildPanel();
        }
        return this.m_contentPanel;
    }

    @Override
    public String getPageID() {
        return "ModeSelectionPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CREATE_VD_CHOOSE_MODE_PAGE_TITLE", "Create Virtual Drive - Choose mode");
    }

    @Override
    public void onNext() {
        block11: {
            if (this.m_rdBtnsimpleRadioButton.isSelected()) {
                this.m_hmWizardData.put("SelectedMode", "Simple");
                try {
                    this.m_simpleConfigEngine = (SimpleConfigEngine)this.m_hmWizardData.get("SimpleConfigEngine");
                    this.m_adapterHelper = this.m_simpleConfigEngine.getAdapterHelper();
                    if (this.m_adapterHelper.getAdapterProperties().getOnOffProperties_MR_CTRL_PROP().getEnableJBOD() == 1) {
                        this.m_iMRpresent = true;
                    }
                    if (this.isFreeHolePresentForSimple()) {
                        this.m_iTrigger = 0;
                        break block11;
                    }
                    this.m_iTrigger = 1;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.m_hmWizardData.put("SelectedMode", "Advanced");
                if (this.m_hmWizardData.containsKey("CapacityNodeLaunch")) {
                    this.m_iTrigger = 1;
                } else {
                    AdvanceConfigEngine advanceConfigEngine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
                    this.m_adapterHelper = advanceConfigEngine.getAdapterHelper();
                    if (this.m_adapterHelper.getAdapterProperties().getOnOffProperties_MR_CTRL_PROP().getEnableJBOD() == 1) {
                        this.m_iMRpresent = true;
                    }
                    try {
                        List<DriveGroup> list = advanceConfigEngine.getExistingDriveGroups();
                        this.m_iTrigger = list != null && !list.isEmpty() ? 0 : 2;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.m_iTrigger = 2;
                    }
                }
            }
        }
        super.onNext();
    }

    private void buildPanel() {
        int n;
        boolean bl = false;
        this.m_simpleConfigEngine = (SimpleConfigEngine)this.m_hmWizardData.get("SimpleConfigEngine");
        this.m_adapterHelper = this.m_simpleConfigEngine.getAdapterHelper();
        this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_STORAGE_CONFIGURATION_USING_MSM" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_NEW_CONFIGURATION" : "IR_CREATING_A_NEW_CONFIGURATION");
        String[] stringArray = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_CHOOSE_MODE_1", "<html>This wizard will help you quickly create virtual drives.<br><br></html>")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_CHOOSE_MODE_2", "<html>Choose how to create the virtual drive:<br><br></html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_SIMPLE", "(S)imple"));
        this.m_rdBtnsimpleRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnsimpleRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_rdBtnsimpleRadioButton.setToolTipText(Resource.getString("TOOLTIP_SIMPLE_BUTTON", "Simple"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.m_contentPanel.add((Component)this.m_rdBtnsimpleRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_rdBtnsimpleRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 20, 70);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_SIMPLE_MODE", " <html>Specify a limited number of settings and have the system pick drives for you. This is the easiest way to create a<br>virtual drive.<br><br></html>")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADVANCED", "(A)dvanced"));
        this.m_rdBtnadvancedRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnadvancedRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_rdBtnadvancedRadioButton.setToolTipText(Resource.getString("TOOLTIP_ADVANCED_BUTTON", "Advanced"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.m_contentPanel.add((Component)this.m_rdBtnadvancedRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_rdBtnadvancedRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 120, 70);
        gridBagConstraints.gridwidth = 5;
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESCRIPTION_ADVANCED_MODE", "<html>Choose additional settings and customize virtual drive creation. This option provides greater flexibility when creating<br>virtual drives for your specific requirements.<br><br></html>")), gridBagConstraints);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getUnconfiguredPhysicalDrives();
        if (physicalDriveHelperArray != null) {
            for (n = 0; n < physicalDriveHelperArray.length; ++n) {
                if (physicalDriveHelperArray[n].isForeign()) continue;
                bl = true;
            }
        }
        n = ((Boolean)this.m_hmWizardData.get("isSimpleAllowed")).booleanValue() ? 1 : 0;
        if ((bl || this.isFreeHolePresentForSimple()) && n != 0) {
            this.m_rdBtnsimpleRadioButton.setEnabled(true);
            this.m_rdBtnsimpleRadioButton.setSelected(true);
        } else {
            this.m_rdBtnsimpleRadioButton.setEnabled(false);
            this.m_rdBtnadvancedRadioButton.setSelected(true);
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    public boolean isFreeHolePresentForSimple() {
        HashMap<Short, Boolean> hashMap = new HashMap<Short, Boolean>();
        try {
            ArrayList<CapacityHelper> arrayList = this.m_adapterHelper.getCapacityHelpers();
            if (arrayList.size() > 0) {
                int n;
                ArrayHelper[] arrayHelperArray = this.m_adapterHelper.getArrays();
                for (n = 0; n < arrayHelperArray.length; ++n) {
                    short s;
                    if (arrayHelperArray[n].isRebuildInProgress()) continue;
                    if (arrayHelperArray[n].getSpanDepth() > 1) {
                        s = arrayHelperArray[n].getDeviceObject().getID();
                        hashMap.put(s, true);
                        continue;
                    }
                    s = arrayHelperArray[n].getDeviceObject().getID();
                    hashMap.put(s, false);
                }
                for (n = 0; n < arrayList.size(); n = (int)((short)(n + 1))) {
                    int n2;
                    CapacityHelper capacityHelper = arrayList.get(n);
                    short s = capacityHelper.getSLArrayInfo().getarray().getarrayRef();
                    if (!hashMap.containsKey(s) || ((Boolean)hashMap.get(s)).booleanValue() || (n2 = capacityHelper.getSLArrayInfo().getfreeCount()) == 0) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }
}

