/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.ModifySSC;

import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;

public class ModifySSCSummaryGenerator {
    private static final String NEW_LINE = "\n";
    private static final String TABS_2 = "\t";
    private static final String TABS_3 = "\t\t";
    private LogicalDriveHelper m_ldHelper = null;
    private int m_iSelectedMode = -1;
    private PhysicalDriveHelper[] m_pdHelpers = null;

    public ModifySSCSummaryGenerator(LogicalDriveHelper logicalDriveHelper, int n, PhysicalDriveHelper[] physicalDriveHelperArray) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_iSelectedMode = n;
        this.m_pdHelpers = physicalDriveHelperArray;
    }

    public String getModifySSCSummary() {
        PhysicalDriveHelper[] physicalDriveHelperArray = null;
        PhysicalDriveHelper[] physicalDriveHelperArray2 = this.m_ldHelper.getPDListInLd();
        if (this.m_iSelectedMode == 1) {
            physicalDriveHelperArray = new PhysicalDriveHelper[physicalDriveHelperArray2.length + this.m_pdHelpers.length];
            System.arraycopy(physicalDriveHelperArray2, 0, physicalDriveHelperArray, 0, physicalDriveHelperArray2.length);
            System.arraycopy(this.m_pdHelpers, 0, physicalDriveHelperArray, physicalDriveHelperArray2.length, this.m_pdHelpers.length);
        } else if (this.m_iSelectedMode == 2) {
            physicalDriveHelperArray = new PhysicalDriveHelper[physicalDriveHelperArray2.length - this.m_pdHelpers.length];
            int n = 0;
            for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
                PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray2[i];
                boolean bl = false;
                for (int j = 0; j < this.m_pdHelpers.length; ++j) {
                    if (!this.m_pdHelpers[j].equals(physicalDriveHelper)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                int n2 = n;
                n = (byte)(n + 1);
                physicalDriveHelperArray[n2] = physicalDriveHelper;
            }
        }
        ArrayHelper arrayHelper = this.m_ldHelper.getArrays()[0];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_SSC_NAME", "CacheCade\u2122 Drive Group name"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(Resource.getString("LABEL_SSC", "CacheCade\u2122 Drive Group"));
        stringBuffer.append(": ");
        stringBuffer.append(arrayHelper.getDeviceObject().getID());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_SSCD_NAME", "CacheCade\u2122 VD name:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getName());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY", "Total capacity:"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.getDriveGroupCapacity(physicalDriveHelperArray));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("LABEL_RECONFIG_SUMMARY_NO_DRIVES", "Number of drives:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(physicalDriveHelperArray.length);
        return stringBuffer.toString();
    }

    private String getDriveGroupCapacity(PhysicalDriveHelper[] physicalDriveHelperArray) {
        ArrayHelper[] arrayHelperArray = this.m_ldHelper.getArrays();
        if (arrayHelperArray != null && physicalDriveHelperArray != null && arrayHelperArray.length > 0) {
            return KernelConstants.getConvertedSize(arrayHelperArray[0].getMinSizeForModifySSC() * (long)physicalDriveHelperArray.length, arrayHelperArray[0].getBlockSize());
        }
        return "";
    }

    private long getMinCapacity(PhysicalDriveHelper[] physicalDriveHelperArray) {
        long l = ((SASPhysicalDrive)physicalDriveHelperArray[0].getDeviceObject()).getInformation().getcoercedSize();
        for (int i = 1; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            long l2 = sASPhysicalDrive.getInformation().getcoercedSize();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }
}

