/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.ModifySSC;

import GUI.VivaldiStartupDialog;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ModifySSCSummaryPanel
extends JPanel {
    private LogicalDriveHelper m_ldHelper = null;
    private ArrayHelper m_arrayHelper = null;
    private JTextArea m_taReconSummary = null;
    private String m_strReconSummary = null;

    public ModifySSCSummaryPanel(LogicalDriveHelper logicalDriveHelper, String string) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_arrayHelper = this.m_ldHelper.getArrays()[0];
        this.m_strReconSummary = string;
        this.buildPanel();
    }

    public void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 20, 10, 10);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_PAGE_HEADING")), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 10);
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_SUMMARY")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel(Resource.getString("LABEL_CURRENT_SETTINGS")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)new JLabel(Resource.getString("LABEL_POST_MODI_SETTINGS")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 20, 100, 10);
        this.add((Component)this.getCurrentSummaryPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.m_taReconSummary = new JTextArea(this.m_strReconSummary, 6, 50);
        this.m_taReconSummary.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_taReconSummary, 20, 30);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private JPanel getCurrentSummaryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_SSC_NAME", "CacheCade\u2122 Drive Group name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_SSCD_DGPNAME", "CacheCade\u2122 - SSD Caching Drive Group") + ((SASArray)this.m_arrayHelper.getDeviceObject()).getID()), gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel("CacheCade\u2122 Drive Group " + ((SASArray)this.m_arrayHelper.getDeviceObject()).getID()), gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_SSCD_NAME", "CacheCade\u2122 VD name:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel(((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getName()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel(this.getDriveGroupCapacity()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_SUMMARY_NO_DRIVES")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("" + this.m_arrayHelper.getPhysicalDrives().length), gridBagConstraints);
        return jPanel;
    }

    public void setSummary(String string) {
        if (this.m_taReconSummary != null) {
            this.m_taReconSummary.setText(string);
        }
    }

    public String getSummary() {
        return this.m_strReconSummary;
    }

    private String getDriveGroupCapacity() {
        SASArray sASArray = (SASArray)this.m_arrayHelper.getDeviceObject();
        MR_ARRAY mR_ARRAY = sASArray.getInformation();
        return KernelConstants.getConvertedSize(mR_ARRAY.getsize() * (long)mR_ARRAY.getnumDrives(), this.m_arrayHelper.getBlockSize());
    }
}

