/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.ModifySSC;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_RECON;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SSCDExpansion
extends VivaldiBaseDialog
implements ActionListener,
ChangeListener {
    private ArrayHelper m_arrayHelper = null;
    private LogicalDriveHelper m_ldHelper = null;
    private SASArray m_sasArray = null;
    private SASLogicalDrive m_sasLogicalDrive = null;
    private long m_lNewMinSizeOfArray = 0L;
    private JSpinner m_spinPercent = null;
    private SpinnerNumberModel m_spinnerNumberModel = null;
    private JLabel m_lblNewVDSize = null;
    private JButton m_btnOK = null;
    private JButton m_btnCancel = null;
    private long m_lAvailableCapacityToExpand = 0L;

    public SSCDExpansion(LogicalDriveHelper logicalDriveHelper, ArrayHelper arrayHelper) {
        super(VivaldiStartupDialog.mainScreen);
        this.m_ldHelper = logicalDriveHelper;
        this.m_arrayHelper = arrayHelper;
        this.m_sasLogicalDrive = (SASLogicalDrive)this.m_ldHelper.getDeviceObject();
        this.m_sasArray = (SASArray)this.m_arrayHelper.getDeviceObject();
        this.m_lNewMinSizeOfArray = this.m_arrayHelper.getNewMinSizeOfArray();
        this.computeAvailableCapacity();
    }

    public void buildUI() {
        String[] stringArray = null;
        this.setTitle(Resource.getString("TITLE_EXPAND_SSCD", "Expand CacheCade\u2122 Virtual Drive"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(this.m_ldHelper.getText());
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Resource.getString("EXPAND_SSCD_DESC", "<html>Use the default percentage value to occupy the remaining capacity in the CacheCade\u2122 Drive Group or<br>change the percentage if needed. The CacheCade\u2122 Virtual Drive expansion may also expand the<br>CacheCade\u2122 Drive Group if necessary.<br><br>The expansion will occurwhen you click OK. On click of cancel will terminate this<br>operation.<br><br></html>")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        Object[] objectArray = new Object[]{KernelConstants.getConvertedSize(this.m_sasLogicalDrive.getInformation().getsize(), this.m_arrayHelper.getBlockSize())};
        JLabel jLabel2 = new JLabel(MessageFormat.format(Resource.getString("LABEL_CURRENT_VD_CAPACITY", "<html><b>Current Capacity: {0}</b></html>"), objectArray));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        objectArray = new Object[]{KernelConstants.getConvertedSize(this.m_lAvailableCapacityToExpand, this.m_arrayHelper.getBlockSize())};
        JLabel jLabel3 = new JLabel(MessageFormat.format(Resource.getString("AVAILABLE_CAPACITY_TO_GROW", "<html><b>Available capacity: {0}</b></html>"), objectArray));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.m_spinnerNumberModel = new SpinnerNumberModel(100, 1, 100, 1);
        this.m_spinnerNumberModel.addChangeListener(this);
        this.m_spinPercent = new JSpinner(this.m_spinnerNumberModel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_PERCENT", "(E)nter a percentage of available capacity:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel4.setLabelFor(this.m_spinPercent);
        }
        jPanel2.add(this.m_spinPercent);
        jPanel2.add(new JLabel("%"));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        long l = this.m_lAvailableCapacityToExpand + this.m_sasLogicalDrive.getInformation().getsize();
        objectArray = new Object[]{KernelConstants.getConvertedSize(l, this.m_arrayHelper.getBlockSize())};
        this.m_lblNewVDSize = new JLabel(MessageFormat.format(Resource.getString("LABEL_NEW_SSCD_SIZE", "<html><b>Capacity of the CacheCade\u2122 Virtual Drive after expansion: {0}</b></html>"), objectArray));
        jPanel.add((Component)this.m_lblNewVDSize, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(this.getSize().width, 50));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.m_btnOK = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_btnCancel = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.m_btnOK);
        jPanel4.add(this.m_btnCancel);
        this.contentPane.add((Component)jPanel, "Center");
        this.contentPane.add((Component)jPanel4, "South");
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        byte by = Byte.parseByte("" + this.m_spinnerNumberModel.getValue());
        double d = 0.0;
        if (by != 100) {
            double d2 = this.m_lAvailableCapacityToExpand * (long)by / 100L;
            d = (double)this.m_sasLogicalDrive.getInformation().getsize() + d2;
        } else {
            d = this.m_lAvailableCapacityToExpand + this.m_sasLogicalDrive.getInformation().getsize();
        }
        Object[] objectArray = new Object[]{KernelConstants.getConvertedSize(d, this.m_arrayHelper.getBlockSize())};
        System.out.println("newVDSize: " + KernelConstants.getConvertedSize(d, this.m_arrayHelper.getBlockSize()));
        this.m_lblNewVDSize.setText(MessageFormat.format(Resource.getString("LABEL_NEW_SSCD_SIZE"), objectArray));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_btnCancel)) {
            this.dispose();
        } else if (actionEvent.getSource().equals(this.m_btnOK)) {
            try {
                Object object;
                ArrayList arrayList;
                OperationDetails operationDetails = null;
                if (this.m_lNewMinSizeOfArray > this.m_sasArray.getInformation().getsize() && (arrayList = this.m_sasArray.getPhysicalDriveArrayList()) != null && !arrayList.isEmpty()) {
                    object = this.m_sasArray.getInformation();
                    pd_MR_ARRAY[] pd_MR_ARRAYArray = new pd_MR_ARRAY[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        pd_MR_ARRAYArray[i] = new pd_MR_ARRAY((SASPhysicalDrive)arrayList.get(i));
                    }
                    MR_ARRAY mR_ARRAY = new MR_ARRAY(((MR_ARRAY)object).getarrayRef(), ((MR_ARRAY)object).getnumDrives(), pd_MR_ARRAYArray, this.m_lNewMinSizeOfArray);
                    operationDetails = new OperationDetails(0x4060000, mR_ARRAY);
                    this.m_sasArray.fireOperation(operationDetails);
                }
                byte by = Byte.parseByte("" + this.m_spinnerNumberModel.getValue());
                object = new MR_RECON();
                ((MR_RECON)object).setnewRaidLevel(this.m_sasLogicalDrive.getInformation().getldConfig().getparams().getPRL());
                ((MR_RECON)object).setldRef(this.m_sasLogicalDrive.getInformation().getldConfig().getproperties().getldRef());
                ((MR_RECON)object).setoperation((byte)0);
                ((MR_RECON)object).setPercentExpansion(by);
                operationDetails = new OperationDetails(12, object);
                this.m_sasLogicalDrive.fireOperation(operationDetails);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dispose();
        }
    }

    public long computeAvailableCapacity() {
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.m_sasArray.getSLArrayInformation();
            MR_SPAN mR_SPAN = this.m_sasLogicalDrive.getInformation().getldConfig().getspan()[0];
            byte by = (byte)this.m_sasArray.getInformation().getnumDrives();
            if (mR_SPAN.getstartBlock() == 0L) {
                long l;
                long l2 = this.m_lNewMinSizeOfArray * (long)by;
                long l3 = sL_ARRAY_INFO_T.getusedBlocks();
                this.m_lAvailableCapacityToExpand = l = l2 - l3;
            } else {
                long l = mR_SPAN.getstartBlock() + mR_SPAN.getnumBlocks();
                freeInfo_SL_ARRAY_INFO_T[] freeInfo_SL_ARRAY_INFO_TArray = sL_ARRAY_INFO_T.getfreeInfo_SL_ARRAY_INFO_T();
                long l4 = this.m_lNewMinSizeOfArray - l;
                this.m_lAvailableCapacityToExpand = l4 * (long)by;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_lAvailableCapacityToExpand;
    }

    private long getDriveGroupRAIDCapacity() {
        byte by = (byte)this.m_sasArray.getInformation().getnumDrives();
        long l = this.m_lNewMinSizeOfArray * (long)by;
        return l;
    }
}

