/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.DedicatedHotSpare;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

public class AdvanceConfigEngine {
    private static AdapterHelper m_adapterHelper = null;
    private Stack<Byte> m_stLDTargetID = null;
    private Stack<Byte> m_stArrayReference = null;
    private List<DriveGroup> m_newDGList = null;
    private List<DriveGroup> m_oldDGList = null;
    private List<Span> m_newSpanList = null;
    private List<DedicatedHotSpare> m_dedHSPList = null;
    private SASAdapter adapter = null;

    public AdvanceConfigEngine(AdapterHelper adapterHelper) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        m_adapterHelper = adapterHelper;
        this.adapter = (SASAdapter)m_adapterHelper.getDeviceObject();
        this.fillLDTargetID();
        this.fillArrayReferences();
        this.fillExistingDriveGroups();
    }

    public SASAdapter getCurrentAdapter() {
        return this.adapter;
    }

    public MR_MFC_DEFAULTS getmfcDefaults() {
        try {
            return this.adapter.getMFCDefaults();
        }
        catch (Exception exception) {
            return new MR_MFC_DEFAULTS();
        }
    }

    protected void init() throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        if (this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() != 4) {
            // empty if block
        }
    }

    public byte getLDTargetId() {
        return this.m_stLDTargetID.pop();
    }

    public void returnLDTargetId(byte by) {
        this.m_stLDTargetID.push(new Byte(by));
    }

    public byte getArrayReference() {
        return this.m_stArrayReference.pop();
    }

    public void returnArrayReference(byte by) {
        this.m_stArrayReference.push(new Byte(by));
    }

    public boolean canCreateConfig() {
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2;
        if (m_adapterHelper.getLogicalDrives().length == this.adapter.getInformation().getmaxLDs()) {
            return false;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = m_adapterHelper.getUnconfiguredPhysicalDrives();
        if (physicalDriveHelperArray == null) {
            physicalDriveHelperArray = new PhysicalDriveHelper[]{};
        }
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (!physicalDriveHelperArray[i].isEligibleForLd()) continue;
            return true;
        }
        if ((this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) && physicalDriveHelperArray.length >= (pdsForRaidLevels_MR_CTRL_INFO2 = m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO()).getMinPdRAIDLevel_0()) {
            return true;
        }
        return this.m_oldDGList != null && !this.m_oldDGList.isEmpty();
    }

    public boolean canAddNewSpan() {
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)16384);
            if (this.m_newSpanList == null || this.m_newSpanList.isEmpty()) {
                return arrayList.size() <= AdvanceConfigEngine.m_adapterHelper.MAX_ARRAYS;
            }
            return arrayList.size() + this.m_newSpanList.size() <= AdvanceConfigEngine.m_adapterHelper.MAX_ARRAYS;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
            return false;
        }
    }

    public boolean canAddNewVirtualDrive() {
        return !this.m_stLDTargetID.isEmpty();
    }

    public void addNewDriveGroup(DriveGroup driveGroup) {
        if (this.m_newDGList == null) {
            this.m_newDGList = new ArrayList<DriveGroup>();
        }
        if (this.m_newDGList.contains(driveGroup)) {
            return;
        }
        this.m_newDGList.add(driveGroup);
    }

    public void addNewSpan(Span span) {
        if (this.m_newSpanList == null) {
            this.m_newSpanList = new ArrayList<Span>();
        }
        this.m_newSpanList.add(span);
    }

    public void removeDriveGroup(DriveGroup driveGroup) {
        List<Span> list;
        if (this.m_newDGList == null || !this.m_newDGList.contains(driveGroup)) {
            return;
        }
        List<VirtualDrive> list2 = driveGroup.getVirtualDrives();
        if (list2 != null && !list2.isEmpty()) {
            for (int n = 0; n < list2.size(); n = (int)((byte)(n + 1))) {
                this.returnLDTargetId(list2.get(n).getTargetId());
            }
            list2.clear();
        }
        if (!(this.m_oldDGList != null && this.m_oldDGList.contains(driveGroup) || (list = driveGroup.getSpans()) == null || list.isEmpty())) {
            for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
                this.returnArrayReference(list.get(n).getSpanId());
            }
            list.clear();
        }
        this.m_newDGList.remove(driveGroup);
    }

    public void removeSpan(Span span) {
        if (this.m_newSpanList == null || !this.m_newSpanList.contains(span)) {
            return;
        }
        this.m_newSpanList.remove(span);
    }

    public void addDedicatedHotSpare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHSPList == null) {
            this.m_dedHSPList = new ArrayList<DedicatedHotSpare>();
        }
        this.m_dedHSPList.add(dedicatedHotSpare);
    }

    public void removedDedicatedHotSpare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHSPList == null || !this.m_dedHSPList.contains(dedicatedHotSpare)) {
            return;
        }
        this.m_dedHSPList.remove(dedicatedHotSpare);
    }

    public static AdapterHelper getAdapterHelper() {
        return m_adapterHelper;
    }

    public List<DriveGroup> getNewlyCreatedDriveGroups() {
        return this.m_newDGList;
    }

    public List<Span> getNewlyCreatedSpans() {
        return this.m_newSpanList;
    }

    public List<DriveGroup> getExistingDriveGroups() {
        return this.m_oldDGList;
    }

    public List<DedicatedHotSpare> getDedicatedHotSpares() {
        return this.m_dedHSPList;
    }

    public List<SASPhysicalDrive> getPhysicalDrivesInPowerSaveMode() {
        Object object;
        Object object2;
        int n;
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
        for (n = 0; n < this.m_newDGList.size(); n = (int)((byte)(n + 1))) {
            object2 = this.m_newDGList.get(n);
            object = ((DriveGroup)object2).getVirtualDrives();
            if (object == null || object.isEmpty()) continue;
            List<Span> list = ((DriveGroup)object2).getSpans();
            for (int n2 = 0; n2 < list.size(); n2 = (int)((byte)(n2 + 1))) {
                List<PhysicalDriveHelper> list2 = list.get(n2).getPhysicalDrivesList();
                for (int n3 = 0; n3 < list2.size(); n3 = (int)((byte)(n3 + 1))) {
                    PhysicalDriveHelper physicalDriveHelper = list2.get(n3);
                    if (physicalDriveHelper.getInformation().getdisabledForRemoval() != '\u0001' && physicalDriveHelper.getInformation().getPowerState() != 1) continue;
                    arrayList.add((SASPhysicalDrive)physicalDriveHelper.getDeviceObject());
                }
            }
        }
        if (this.m_dedHSPList != null && !this.m_dedHSPList.isEmpty()) {
            for (n = 0; n < this.m_dedHSPList.size(); n = (int)((byte)(n + 1))) {
                object2 = this.m_dedHSPList.get(n);
                object = ((DedicatedHotSpare)object2).getPhysicalDriveHelper();
                if (((PhysicalDriveHelper)object).getInformation().getdisabledForRemoval() != '\u0001' && ((PhysicalDriveHelper)object).getInformation().getPowerState() != 1) continue;
                arrayList.add((SASPhysicalDrive)((PhysicalDriveHelper)object).getDeviceObject());
            }
        }
        return arrayList;
    }

    public ArrayList getPossibleRAIDLevelAndSize(ArrayList arrayList) throws IlligalConfigOperationException {
        return null;
    }

    public void writeConfiguration() throws IlligalConfigOperationException, InternalDataStructureCorruptionException, VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException {
        MR_SPARE[] mR_SPAREArray;
        Object object;
        List<VirtualDrive> list;
        MR_CONFIG_DATA mR_CONFIG_DATA = new MR_CONFIG_DATA();
        ArrayList<MR_ARRAY> arrayList = new ArrayList<MR_ARRAY>();
        ArrayList<MR_LD_CONFIG> arrayList2 = new ArrayList<MR_LD_CONFIG>();
        boolean bl = false;
        for (int n = 0; n < this.m_newDGList.size(); n = (int)((byte)(n + 1))) {
            DriveGroup driveGroup = this.m_newDGList.get(n);
            list = driveGroup.getVirtualDrives();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(driveGroup.getMRArray());
            arrayList2.addAll(driveGroup.getLDConfig());
        }
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            treeMap.put(((MR_ARRAY)arrayList.get(i)).getarrayRef(), arrayList.get(i));
        }
        arrayList.clear();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((MR_ARRAY)treeMap.get(iterator.next()));
        }
        list = new ArrayList<VirtualDrive>();
        if (this.m_dedHSPList != null && !this.m_dedHSPList.isEmpty()) {
            for (int n = 0; n < this.m_dedHSPList.size(); n = (int)((byte)(n + 1))) {
                object = this.m_dedHSPList.get(n);
                mR_SPAREArray = ((DedicatedHotSpare)object).getMRSpare();
                if (mR_SPAREArray == null) continue;
                list.add((VirtualDrive)mR_SPAREArray);
            }
        }
        MR_ARRAY[] mR_ARRAYArray = new MR_ARRAY[arrayList.size()];
        object = new MR_LD_CONFIG[arrayList2.size()];
        arrayList.toArray(mR_ARRAYArray);
        arrayList2.toArray((T[])object);
        mR_CONFIG_DATA.setarray(mR_ARRAYArray);
        mR_CONFIG_DATA.setld((MR_LD_CONFIG[])object);
        if (!list.isEmpty()) {
            mR_SPAREArray = new MR_SPARE[list.size()];
            list.toArray(mR_SPAREArray);
            mR_CONFIG_DATA.setspare(mR_SPAREArray);
        }
        ((SASAdapter)m_adapterHelper.getDeviceObject()).fireConfigOperation(new OperationDetails(1, mR_CONFIG_DATA));
    }

    private void fillLDTargetID() {
        this.m_stLDTargetID = new Stack();
        LogicalDriveHelper[] logicalDriveHelperArray = m_adapterHelper.getLogicalDrives();
        byte[] byArray = null;
        boolean bl = false;
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = null;
        try {
            mR_LD_TARGETID_LIST = ((SASAdapter)m_adapterHelper.getDeviceObject()).getUsedLds();
            byArray = mR_LD_TARGETID_LIST.getTargetId();
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            for (byte by = (byte)(AdvanceConfigEngine.m_adapterHelper.MAX_LOGICAL_DRIVES - 1); by >= 0; by = (byte)(by - 1)) {
                int n;
                if (byArray == null) {
                    for (n = 0; n < logicalDriveHelperArray.length; n = (int)((short)(n + 1))) {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject();
                        if (sASLogicalDrive.getID() != by) continue;
                        bl = true;
                        break;
                    }
                } else {
                    for (n = 0; n < byArray.length; ++n) {
                        if (byArray[n] != by) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.m_stLDTargetID.push(new Byte(by));
                }
                bl = false;
            }
        } else {
            for (byte by = (byte)(AdvanceConfigEngine.m_adapterHelper.MAX_LOGICAL_DRIVES - 1); by >= 0; by = (byte)(by - 1)) {
                if (byArray != null) {
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] != by) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.m_stLDTargetID.push(new Byte(by));
                }
                bl = false;
            }
        }
    }

    private void fillArrayReferences() {
        System.out.println("AdvanceConfigEngine.fillArrayReferences() MAX_ARRAYS: " + AdvanceConfigEngine.m_adapterHelper.MAX_ARRAYS);
        this.m_stArrayReference = new Stack();
        ArrayHelper[] arrayHelperArray = m_adapterHelper.getArrays();
        if (arrayHelperArray != null && arrayHelperArray.length > 0) {
            for (byte by = (byte)(AdvanceConfigEngine.m_adapterHelper.MAX_ARRAYS - 1); by >= 0; by = (byte)(by - 1)) {
                boolean bl = false;
                for (int n = 0; n < arrayHelperArray.length; n = (int)((short)(n + 1))) {
                    SASArray sASArray = (SASArray)arrayHelperArray[n].getDeviceObject();
                    if (sASArray.getInformation().getarrayRef() != by) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.m_stArrayReference.push(new Byte(by));
            }
        } else {
            for (byte by = (byte)(AdvanceConfigEngine.m_adapterHelper.MAX_ARRAYS - 1); by >= 0; by = (byte)(by - 1)) {
                this.m_stArrayReference.push(new Byte(by));
            }
        }
    }

    private void fillExistingDriveGroups() {
        this.m_oldDGList = new ArrayList<DriveGroup>();
        ArrayHelper[] arrayHelperArray = m_adapterHelper.getArrays();
        HashMap<Short, ArrayHelper> hashMap = new HashMap<Short, ArrayHelper>();
        int n = 0;
        if (arrayHelperArray != null && arrayHelperArray.length > 0) {
            for (int n2 = 0; n2 < arrayHelperArray.length; n2 = (int)((byte)(n2 + 1))) {
                if (arrayHelperArray[n2].isRebuildInProgress() || !arrayHelperArray[n2].isAtleastMinimumBlockSizeRemaining()) continue;
                SL_ARRAY_INFO_T sL_ARRAY_INFO_T = null;
                SASArray sASArray = (SASArray)arrayHelperArray[n2].getDeviceObject();
                try {
                    sL_ARRAY_INFO_T = sASArray.getSLArrayInformation();
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                }
                if (sL_ARRAY_INFO_T.getfreeCount() <= 0 || sL_ARRAY_INFO_T.getldCount() >= AdvanceConfigEngine.m_adapterHelper.MAX_LDS_PER_ARRAY || hashMap.containsKey(arrayHelperArray[n2].getDeviceObject().getID())) continue;
                if (arrayHelperArray[n2].getSpanDepth() == 1) {
                    ArrayList<ArrayHelper> arrayList = new ArrayList<ArrayHelper>();
                    arrayList.add(arrayHelperArray[n2]);
                    this.m_oldDGList.add(new DriveGroup(arrayList));
                    continue;
                }
                boolean bl = false;
                LogicalDriveHelper logicalDriveHelper = arrayHelperArray[n2].getLogicalDriveHelpers()[0];
                ArrayHelper[] arrayHelperArray2 = logicalDriveHelper.getArrays();
                ArrayList<ArrayHelper> arrayList = new ArrayList<ArrayHelper>();
                for (int n3 = 0; n3 < arrayHelperArray2.length; n3 = (int)((byte)(n3 + 1))) {
                    if (arrayHelperArray2[n3].isRebuildInProgress()) {
                        bl = true;
                        break;
                    }
                    arrayList.add(arrayHelperArray2[n3]);
                    hashMap.put(new Short(arrayHelperArray2[n3].getDeviceObject().getID()), arrayHelperArray2[n3]);
                }
                if (bl) continue;
                DriveGroup driveGroup = new DriveGroup(arrayList);
                int n4 = n;
                n = (byte)(n + 1);
                driveGroup.setDriveGroupId(n4);
                this.m_oldDGList.add(driveGroup);
            }
        }
    }

    public ArrayList<VirtualDrive> getVirtualDriveList() {
        ArrayList<VirtualDrive> arrayList = new ArrayList<VirtualDrive>();
        for (int n = 0; n < this.m_newDGList.size(); n = (int)((byte)(n + 1))) {
            DriveGroup driveGroup = this.m_newDGList.get(n);
            List<VirtualDrive> list = driveGroup.getVirtualDrives();
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

