/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.text.MessageFormat;
import java.util.List;

public class AdvanceConfigSummaryGenerator {
    private static final String TABS_4 = "\t\t\t\t";
    private static final String TABS_3 = "\t\t\t";
    private static final String TABS_2 = "\t\t";
    private static final String NEW_LINE = "\n";
    private AdvanceConfigEngine m_engine = null;
    private AdapterHelper m_adapterHelper = null;

    public AdvanceConfigSummaryGenerator(AdvanceConfigEngine advanceConfigEngine) {
        this.m_engine = advanceConfigEngine;
        AdvanceConfigSummaryGenerator advanceConfigSummaryGenerator = this;
        this.m_adapterHelper = advanceConfigSummaryGenerator.m_engine.getAdapterHelper();
    }

    public String getConfigSummaryText() {
        Object[] objectArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        AdvanceConfigSummaryGenerator advanceConfigSummaryGenerator = this;
        this.m_adapterHelper = advanceConfigSummaryGenerator.m_engine.getAdapterHelper();
        for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
            DriveGroup driveGroup = list.get(n);
            List<VirtualDrive> list2 = driveGroup.getVirtualDrives();
            short s = driveGroup.getBlockSize();
            if (list2 != null && !list2.isEmpty()) {
                int n2;
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_DG_NAME", "Drive group name:"));
                stringBuffer.append(TABS_3);
                stringBuffer.append(driveGroup.getDriveGroupName());
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID level:"));
                stringBuffer.append(TABS_4);
                stringBuffer.append(driveGroup.getRaidLevelString());
                stringBuffer.append(NEW_LINE);
                if (driveGroup.getSpanDepth() == 1) {
                    stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_USED", "Number of drives used:"));
                    stringBuffer.append(TABS_3);
                    stringBuffer.append(driveGroup.getSpans().get(0).getNumberOfDrives());
                } else {
                    String string = System.getProperty("os.name");
                    stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_PER_SPAN", " Number of drives per span:"));
                    if (string.contains("Windows")) {
                        stringBuffer.append(TABS_2);
                    } else {
                        stringBuffer.append(TABS_3);
                    }
                    stringBuffer.append(driveGroup.getSpans().get(0).getNumberOfDrives());
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_NO_OF_SPANS", "Number of spans:"));
                    stringBuffer.append(TABS_3);
                    stringBuffer.append(driveGroup.getSpans().size());
                }
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_DRIVE_SECURITY_METHOD", "Drive security method:"));
                stringBuffer.append(TABS_3);
                byte by = driveGroup.getEncrptionMethod();
                if (by == 0) {
                    stringBuffer.append(Resource.getString("TEXT_NO_ENCRYPTION", "No Encryption"));
                } else if (by == 2) {
                    stringBuffer.append(Resource.getString("DESC_ENCRYPTION_METHOD_CTRL", "Controller-based encryption"));
                } else if (by == 1) {
                    stringBuffer.append(Resource.getString("DESC_ENCRYPTION_METHOD_FDE", "Full disk encryption"));
                }
                stringBuffer.append(NEW_LINE);
                if (this.m_adapterHelper.isPowerSaveSupportedOnConfiguredDrives() && (this.m_adapterHelper.getMFCDefaults().getdisablePowerSavings() & 8) != 8) {
                    stringBuffer.append(Resource.getString("DS_PS_POLICY_TEXT", "Power Save Policy:"));
                    stringBuffer.append(TABS_3);
                    stringBuffer.append(this.getPowerState(driveGroup.getPowerSavePolicy()));
                    stringBuffer.append(NEW_LINE);
                }
                if (this.m_adapterHelper.isPIEnabledOnController() && this.m_adapterHelper.isPISupported()) {
                    stringBuffer.append(Resource.getString("DATA_PROTECTION_TEXT", "Data Protection:"));
                    if (!VivaldiStartupDialog.isSolaris) {
                        stringBuffer.append(TABS_3);
                    } else if (this.m_adapterHelper.isSolaris11()) {
                        stringBuffer.append(TABS_3);
                    } else {
                        stringBuffer.append(TABS_4);
                    }
                    stringBuffer.append(driveGroup.isPIEnabled() ? Resource.getString("ENABLED", "Enabled") : Resource.getString("DISABLED", "Disabled"));
                    stringBuffer.append(NEW_LINE);
                }
                if (!this.m_adapterHelper.isSWRController() && driveGroup.getRaidLevel() != 0 && driveGroup.getRaidLevel() != 64) {
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_HOT_SPARE", "Hot spare"));
                    stringBuffer.append(TABS_4);
                    List<Span> list3 = driveGroup.getSpans();
                    boolean bl = false;
                    for (n2 = 0; n2 < list3.size(); ++n2) {
                        if (!list3.get(n2).isHotSpareAssigned()) continue;
                        bl = true;
                        break;
                    }
                    stringBuffer.append(bl ? Resource.getString("SUMMARY_TEXT_HSP_YES", "Yes") : Resource.getString("SUMMARY_TEXT_HSP_NO", "No"));
                    stringBuffer.append(NEW_LINE);
                }
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY", "Total capacity:"));
                if (!VivaldiStartupDialog.isSolaris) {
                    stringBuffer.append(TABS_4);
                } else if (this.m_adapterHelper.isSolaris11()) {
                    stringBuffer.append(TABS_3);
                } else {
                    stringBuffer.append(TABS_4);
                }
                long l = driveGroup.getTotalCapacityInBlocks();
                stringBuffer.append(KernelConstants.getConvertedSize(l, s));
                stringBuffer.append(NEW_LINE);
                if (!driveGroup.isNotExceedingMinimumBlockSize(driveGroup.getFreeSizeInBlocks())) {
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_FREE_CAPACITY", "Free capacity:"));
                    if (!VivaldiStartupDialog.isSolaris) {
                        stringBuffer.append(TABS_4);
                    } else if (this.m_adapterHelper.isSolaris11()) {
                        stringBuffer.append(TABS_3);
                    } else {
                        stringBuffer.append(TABS_4);
                    }
                    long l2 = driveGroup.getFreeSizeInBlocks();
                    stringBuffer.append(KernelConstants.getConvertedSize(l2, s));
                    stringBuffer.append(NEW_LINE);
                }
                for (n2 = 0; n2 < list2.size(); n2 = (int)((byte)(n2 + 1))) {
                    stringBuffer.append(NEW_LINE);
                    VirtualDrive virtualDrive = list2.get(n2);
                    objectArray = new Object[]{n2 + 1};
                    stringBuffer.append(MessageFormat.format(Resource.getString("SUMMARY_TEXT_VD_NAME", "Virtual drive {0} name:"), objectArray));
                    stringBuffer.append(TABS_3);
                    stringBuffer.append(virtualDrive.getName());
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_CAPACITY", "Capacity:"));
                    stringBuffer.append(TABS_4);
                    long l3 = virtualDrive.getSize();
                    stringBuffer.append(KernelConstants.getConvertedSize(l3, s));
                }
            }
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    public String getPowerState(byte by) {
        if (this.m_adapterHelper.isSupportPSMaxWithCache()) {
            switch (by) {
                case 0: {
                    return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
                }
                case -2: {
                    return Resource.getString("DS_NONE", "None");
                }
                case 1: {
                    return Resource.getString("DS_AUTO", "Auto");
                }
                case 2: {
                    return Resource.getString("DS_MAX", "Max");
                }
                case 6: {
                    return Resource.getString("DS_MAX_NO_CACHE", "Max without Cache");
                }
            }
            return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
        }
        switch (by) {
            case 0: {
                return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
            }
            case -2: {
                return Resource.getString("DS_NONE", "None");
            }
            case 1: 
            case 5: {
                return Resource.getString("DS_AUTO", "Auto");
            }
            case 2: 
            case 6: {
                return Resource.getString("DS_MAX", "Max");
            }
        }
        return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
    }
}

