/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.DriveGroupsTreePanel;
import GUI.venus.configuration.advanced.DriveSecurityComboBoxModel;
import GUI.venus.configuration.advanced.DriveSecurityRenderer;
import GUI.venus.configuration.advanced.PDTableToTreePanel;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.RaidLevelRenderer;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class AdvancedDriveGroupSettings {
    public static final byte RAID_LEVEL_SELECT = -1;
    public static final byte DRIVE_SECURITY_SELECT = -1;
    public static final byte PROTECTION_DISABLE = 0;
    public static final byte PROTECTION_ENABLE = 1;
    private AdapterHelper m_AdapterHelper = null;
    private DefaultWizardPage m_defWizardPage = null;
    private PDTableToTreePanel m_pdTableToTreePanel = null;
    private DriveGroupsTreePanel m_dgTreePanel = null;
    private JComboBox m_raidLevelCombobox = new JComboBox();
    private JComboBox m_driveSecurityCombobox = new JComboBox();
    private JComboBox m_powerSettingsCombobox = new JComboBox();
    private JComboBox m_protectionCombobox = new JComboBox();
    private JLabel m_powerSaveModeDesc = null;
    private JLabel m_protectionDesc = null;
    private JPanel m_contentPanel = null;
    private AdvanceConfigEngine m_engine = null;
    private short mfcDisablePowerSavings = 0;
    private byte mfctreatR1EAsR10 = 0;

    public AdvancedDriveGroupSettings(AdvanceConfigEngine advanceConfigEngine, DefaultWizardPage defaultWizardPage) {
        this.m_engine = advanceConfigEngine;
        this.m_AdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_defWizardPage = defaultWizardPage;
        this.initialise();
    }

    public void initialise() {
        this.m_dgTreePanel = new DriveGroupsTreePanel(this.m_AdapterHelper, this.m_raidLevelCombobox, this.m_driveSecurityCombobox, this.m_defWizardPage, this.m_powerSettingsCombobox, this.m_protectionCombobox);
        this.m_pdTableToTreePanel = new PDTableToTreePanel(this.m_engine, this.m_raidLevelCombobox, this.m_driveSecurityCombobox, this.m_dgTreePanel, this.m_defWizardPage, this.m_powerSettingsCombobox, this.m_protectionCombobox);
        this.m_dgTreePanel.addDriveGroupNodeToTree();
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension dimension = new Dimension(230, 25);
        Dimension dimension2 = new Dimension(32, 32);
        final JLabel jLabel = new JLabel();
        RaidLevelComboBoxModel raidLevelComboBoxModel = new RaidLevelComboBoxModel(this.m_AdapterHelper, this.m_pdTableToTreePanel.getUnconfiguredDrivesGrouping().getMaxGroupPdCount(), false);
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("PICK_RAID_DESC")), gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        final JLabel jLabel3 = new JLabel();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_RAID_LEVEL_ADG", "(R)AID level:"));
        jLabel2.setText(stringArray[0]);
        jLabel2.setLabelFor(this.m_raidLevelCombobox);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.m_raidLevelCombobox.setPreferredSize(dimension);
        this.m_raidLevelCombobox.setModel(raidLevelComboBoxModel);
        this.m_raidLevelCombobox.setRenderer(new RaidLevelRenderer(this.m_AdapterHelper));
        this.m_contentPanel.add((Component)this.m_raidLevelCombobox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel3.setPreferredSize(dimension2);
        jLabel3.setIcon(Resource.getImage(""));
        this.m_contentPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 18;
        jLabel.setText(this.getRaidLevelDescription((byte)-1));
        this.m_contentPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        final JLabel jLabel5 = new JLabel();
        final JLabel jLabel6 = new JLabel();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_AdapterHelper.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_SECURE_DISK_GROUP", "(S)ecure Disk Group:")) : Resource.getResourceMnemonic(Resource.getString("LABEL_DRIVE_SECURITY", " (D)rive security method:"));
        jLabel4.setText(stringArray[0]);
        jLabel4.setLabelFor(this.m_driveSecurityCombobox);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.m_driveSecurityCombobox.setPreferredSize(dimension);
        Object object = new DriveSecurityComboBoxModel(this.m_AdapterHelper, this.m_dgTreePanel.isFDEPossible());
        this.m_driveSecurityCombobox.setModel(object);
        if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_AdapterHelper.isOnlyFDESupported()) {
            this.m_driveSecurityCombobox.setRenderer(new DriveSecurityRenderer(true));
        } else {
            this.m_driveSecurityCombobox.setRenderer(new DriveSecurityRenderer(false));
        }
        this.m_driveSecurityCombobox.setEnabled(this.m_AdapterHelper.isSecuritySupported() && this.m_AdapterHelper.isLockKeyAssigned());
        this.m_contentPanel.add((Component)this.m_driveSecurityCombobox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel5.setPreferredSize(dimension2);
        jLabel5.setIcon(Resource.getImage(""));
        this.m_contentPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 18;
        jLabel6.setText(this.getDriveSecurityDescription((byte)-1));
        this.m_contentPanel.add((Component)jLabel6, gridBagConstraints);
        object = this.m_AdapterHelper.getMFCDefaults();
        if (object != null) {
            this.mfcDisablePowerSavings = ((MR_MFC_DEFAULTS)object).getdisablePowerSavings();
            this.mfctreatR1EAsR10 = ((MR_MFC_DEFAULTS)object).gettreatR1EAsR10();
            System.out.println("mfcdefaults.getdisablePowerSavings()" + ((MR_MFC_DEFAULTS)object).getdisablePowerSavings());
        }
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("LABEL_DATA_PROTECTION", "Da(t)a protection:"));
        JLabel jLabel7 = new JLabel(stringArray2[0]);
        if (stringArray2.length == 2) {
            jLabel7.setDisplayedMnemonic(stringArray2[1].charAt(0));
        }
        ProtectionComboBoxModel protectionComboBoxModel = new ProtectionComboBoxModel(this.m_dgTreePanel.isPICapablePossible());
        this.m_protectionCombobox.setPreferredSize(dimension);
        this.m_protectionCombobox.setModel(protectionComboBoxModel);
        this.m_protectionCombobox.setRenderer(new ProtectionComboBoxRenderer());
        jLabel7.setLabelFor(this.m_protectionCombobox);
        this.m_protectionDesc = new JLabel(Resource.getString("DATA_PROTECTION_DESC", "<html> Data Protection is a guard that detects corruption of data on media; thereby preventing <br>system errors caused by silent data corruption (SDC). </html>"));
        if (this.m_AdapterHelper.isPIEnabledOnController() && this.m_AdapterHelper.isPISupported()) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.m_contentPanel.add((Component)jLabel7, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.m_contentPanel.add((Component)this.m_protectionCombobox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 18;
            this.m_contentPanel.add((Component)this.m_protectionDesc, gridBagConstraints);
        }
        stringArray2 = Resource.getResourceMnemonic(Resource.getString("SELECT_POWER_SAVE_MODE", "(S)elect power save mode:"));
        JLabel jLabel8 = new JLabel(stringArray2[0]);
        if (stringArray2.length == 2) {
            jLabel8.setDisplayedMnemonic(stringArray2[1].charAt(0));
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add((byte)-2);
        arrayList.add((byte)1);
        if ((this.mfcDisablePowerSavings & 0x10) != 16) {
            arrayList.add((byte)2);
            if (this.m_AdapterHelper.isSupportPSMaxWithCache() && VivaldiStartupDialog.OEM_TYPE != 2561) {
                arrayList.add((byte)6);
            }
        }
        arrayList.add((byte)0);
        PowerSaveComboBoxModel powerSaveComboBoxModel = new PowerSaveComboBoxModel(arrayList);
        this.m_powerSettingsCombobox.setPreferredSize(dimension);
        this.m_powerSettingsCombobox.setModel(powerSaveComboBoxModel);
        this.m_powerSettingsCombobox.setRenderer(new PowerSaveComboBoxRenderer());
        this.m_powerSettingsCombobox.setEnabled((this.mfcDisablePowerSavings & 8) != 8);
        jLabel8.setLabelFor(this.m_powerSettingsCombobox);
        this.m_powerSaveModeDesc = new JLabel(this.getPowerSaveModeDescription(((Byte)this.m_powerSettingsCombobox.getSelectedItem()).byteValue()));
        if (this.m_AdapterHelper.isPowerSaveSupportedOnConfiguredDrives() && (this.mfcDisablePowerSavings & 8) != 8) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.m_contentPanel.add((Component)jLabel8, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.m_contentPanel.add((Component)this.m_powerSettingsCombobox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 18;
            this.m_contentPanel.add((Component)this.m_powerSaveModeDesc, gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 8;
        this.m_contentPanel.add((Component)this.m_pdTableToTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridwidth = 8;
        this.m_contentPanel.add((Component)this.m_dgTreePanel, gridBagConstraints);
        this.m_protectionCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriveGroup driveGroup = AdvancedDriveGroupSettings.this.m_dgTreePanel.getLastDgObject();
                AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                boolean bl = false;
                int n = AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getSelectedIndex();
                if (AdvancedDriveGroupSettings.this.m_protectionCombobox.getSelectedIndex() == 1) {
                    bl = true;
                    boolean bl2 = false;
                    if ((Byte)AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getSelectedItem() == 1) {
                        bl2 = true;
                    }
                    AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().protectedTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredGoodPdList(), bl2, bl);
                    ((DriveSecurityComboBoxModel)AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getModel()).updateDriveSecurityModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isFDEPICapablePossible());
                    AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.setSelectedIndex(n);
                } else if ((Byte)AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getSelectedItem() == 1) {
                    AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().driveSecurityTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredGoodPdList(), false);
                } else {
                    AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().raidLevelTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesGrouping(), (Byte)AdvancedDriveGroupSettings.this.m_raidLevelCombobox.getSelectedItem());
                    ((DriveSecurityComboBoxModel)AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getModel()).updateDriveSecurityModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isFDEPossible());
                    AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.setSelectedIndex(n);
                }
            }
        });
        this.m_powerSettingsCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedDriveGroupSettings.this.m_powerSaveModeDesc.setText(AdvancedDriveGroupSettings.this.getPowerSaveModeDescription(((Byte)AdvancedDriveGroupSettings.this.m_powerSettingsCombobox.getSelectedItem()).byteValue()));
            }
        });
        this.m_raidLevelCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (AdvancedDriveGroupSettings.this.m_raidLevelCombobox.getSelectedIndex() != -1) {
                    Object object;
                    Object object2;
                    AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.reset();
                    byte by = (Byte)itemEvent.getItem();
                    jLabel.setText(AdvancedDriveGroupSettings.this.getRaidLevelDescription(by));
                    jLabel3.setIcon(AdvancedDriveGroupSettings.this.getRaidLevelIcon(by));
                    DefaultMutableTreeNode defaultMutableTreeNode = AdvancedDriveGroupSettings.this.m_dgTreePanel.getLastDgNode();
                    DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
                    if (!driveGroup.isCompleted() && by <= 17 && defaultMutableTreeNode.getChildCount() == 1 && (object2 = ((DefaultMutableTreeNode)(object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0))).getUserObject()) instanceof Span && ((DefaultMutableTreeNode)object).getChildCount() == 0) {
                        ((DefaultTreeModel)AdvancedDriveGroupSettings.this.m_dgTreePanel.getDriveGroupsTree().getModel()).removeNodeFromParent((MutableTreeNode)object);
                    }
                    if (by == -1) {
                        AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(false);
                        if (((SASAdapter)AdvancedDriveGroupSettings.this.m_AdapterHelper.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)AdvancedDriveGroupSettings.this.m_AdapterHelper.getDeviceObject()).getAdapterType() != 2 && ((SASAdapter)AdvancedDriveGroupSettings.this.m_AdapterHelper.getDeviceObject()).getAdapterType() != 4) {
                            if (AdvancedDriveGroupSettings.this.m_dgTreePanel.getDgCount() > 0 && AdvancedDriveGroupSettings.this.m_dgTreePanel.isPreviousDgNodeCompleted()) {
                                AdvancedDriveGroupSettings.this.m_dgTreePanel.addDriveGroupNodeToTree();
                            }
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                        } else {
                            if (AdvancedDriveGroupSettings.this.m_dgTreePanel.getDgCount() < AdvancedDriveGroupSettings.this.m_AdapterHelper.getAdapterInfo().getmaxArrays() && AdvancedDriveGroupSettings.this.m_dgTreePanel.isPreviousDgNodeCompleted() && AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesGrouping().getMaxGroupPdCount() > 1) {
                                AdvancedDriveGroupSettings.this.m_dgTreePanel.addDriveGroupNodeToTree();
                            }
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                        }
                    } else if (by >= 0) {
                        Object object3;
                        ((DriveSecurityComboBoxModel)AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getModel()).updateDriveSecurityModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isFDEPossible());
                        AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.setSelectedIndex(0);
                        ((ProtectionComboBoxModel)AdvancedDriveGroupSettings.this.m_protectionCombobox.getModel()).updateModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isPICapablePossible());
                        AdvancedDriveGroupSettings.this.m_protectionCombobox.setSelectedIndex(0);
                        AdvancedDriveGroupSettings.this.m_powerSettingsCombobox.setSelectedIndex(0);
                        AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                        AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().raidLevelTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesGrouping(), by);
                        if (!driveGroup.isCompleted()) {
                            if (driveGroup.getisSpan()) {
                                driveGroup.setDriveGroupId(AdvancedDriveGroupSettings.this.m_dgTreePanel.getFWDGCount() + AdvancedDriveGroupSettings.this.m_dgTreePanel.getExistingDgCount());
                                driveGroup.setisSpan(false);
                            }
                            driveGroup.setRaidLevel(by);
                        }
                        if (by > 17) {
                            if (defaultMutableTreeNode.getChildCount() > 0) {
                                object = (Span)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1)).getUserObject();
                                if (((Span)object).isCompleted() && !driveGroup.isCompleted()) {
                                    driveGroup.setDriveGroupId(AdvancedDriveGroupSettings.this.m_dgTreePanel.getFWSpanCount() + AdvancedDriveGroupSettings.this.m_dgTreePanel.getExistingSpanCount());
                                    driveGroup.setisSpan(true);
                                    AdvancedDriveGroupSettings.this.m_dgTreePanel.addSpanNodeToTree();
                                }
                            } else if (!driveGroup.isCompleted()) {
                                driveGroup.setDriveGroupId(AdvancedDriveGroupSettings.this.m_dgTreePanel.getFWSpanCount() + AdvancedDriveGroupSettings.this.m_dgTreePanel.getExistingSpanCount());
                                driveGroup.setisSpan(true);
                                AdvancedDriveGroupSettings.this.m_dgTreePanel.addSpanNodeToTree();
                            }
                        }
                        boolean bl = true;
                        object2 = AdvancedDriveGroupSettings.this.m_dgTreePanel.getSelectedNodeFromTree();
                        if (object2 != null && (object3 = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof DriveGroup && ((DriveGroup)object3).isCompleted()) {
                            bl = false;
                        }
                        if (AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.isPdSelectedFromTable() && bl) {
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(true);
                        } else {
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(false);
                        }
                    }
                }
            }
        });
        this.m_driveSecurityCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.getSelectedIndex() > 0) {
                    byte by = (Byte)itemEvent.getItem();
                    jLabel6.setText(AdvancedDriveGroupSettings.this.getDriveSecurityDescription(by));
                    jLabel5.setIcon(AdvancedDriveGroupSettings.this.getDriveSecurityIcon(by));
                    DriveGroup driveGroup = AdvancedDriveGroupSettings.this.m_dgTreePanel.getLastDgObject();
                    AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                    if (by == -1) {
                        driveGroup.setEncrptionMethod((byte)0);
                    } else {
                        driveGroup.setEncrptionMethod(by);
                        if (by == 1) {
                            boolean bl = false;
                            if (AdvancedDriveGroupSettings.this.m_protectionCombobox.getSelectedIndex() == 1) {
                                bl = true;
                            }
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().driveSecurityTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredGoodPdList(), bl);
                            int n = AdvancedDriveGroupSettings.this.m_protectionCombobox.getSelectedIndex();
                            ((ProtectionComboBoxModel)AdvancedDriveGroupSettings.this.m_protectionCombobox.getModel()).updateModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isFDEPICapablePossible());
                            AdvancedDriveGroupSettings.this.m_protectionCombobox.setSelectedIndex(n);
                        }
                    }
                    if (by != 1 && AdvancedDriveGroupSettings.this.m_driveSecurityCombobox.isEnabled()) {
                        if (AdvancedDriveGroupSettings.this.m_protectionCombobox.getSelectedIndex() == 1) {
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().protectedTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredGoodPdList(), false, true);
                        } else {
                            AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().raidLevelTrigger(AdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesGrouping(), (Byte)AdvancedDriveGroupSettings.this.m_raidLevelCombobox.getSelectedItem());
                            ((ProtectionComboBoxModel)AdvancedDriveGroupSettings.this.m_protectionCombobox.getModel()).updateModel(AdvancedDriveGroupSettings.this.m_dgTreePanel.isPICapablePossible());
                            AdvancedDriveGroupSettings.this.m_protectionCombobox.setSelectedIndex(0);
                        }
                    }
                }
            }
        });
    }

    private String getRaidLevelDescription(byte by) {
        switch (by) {
            case -1: {
                return Resource.getString("RAID_DESC", " <html>Pick a RAID level to specify the amount of fault tolerance and performance for<br>the virtual drives.</html>");
            }
            case 0: {
                return Resource.getString("RAID0_DESC", "<html>This RAID level is suitable for high performance with zero<br> data redundancy.Choose this option only for non-critical data.</html>");
            }
            case 1: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high<br> redundancy and performance.</html>");
            }
            case 17: {
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getString("RAID1E_DESC", "<html>RAID level that combines RAID 0's striping capabilities with<br>RAID 1's mirroring protection.</html>");
                }
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 4) {
                    if (this.m_AdapterHelper.treatRAID1EasRAID10() && !this.m_AdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                        return Resource.getString("RAID10_DESC");
                    }
                    return Resource.getString("RAID1E_DESC");
                }
                return Resource.getString("RAID10_DESC");
            }
            case 16: {
                return Resource.getString("RAID10_DESC");
            }
            case 5: {
                return Resource.getString("RAID5_DESC", "<html>This RAID level is suitable for multi-user environments(database <br>or file system) with large IO size and high proportion of read activity.</html>");
            }
            case 6: {
                return Resource.getString("RAID6_DESC", "<html>This RAID level is suitable for environments requiring redundancy<br> protection beyond RAID 5,but not requiring high write performance.</html>");
            }
            case 64: {
                return Resource.getString("RAID00_DESC", "<html>RAID level 00 is a stripe of stripes.</html>");
            }
            case 65: {
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 69: {
                return Resource.getString("RAID50_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed parity of RAID 5.</html>");
            }
            case 70: {
                return Resource.getString("RAID60_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed double parity of RAID 6.</html>");
            }
        }
        return "";
    }

    private ImageIcon getRaidLevelIcon(byte by) {
        switch (by) {
            case -1: {
                return Resource.getImage("");
            }
            case 0: {
                return Resource.getImage("RAID0_ICON");
            }
            case 1: {
                return Resource.getImage("RAID1_ICON");
            }
            case 17: {
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getImage("RAID1E_ICON");
                }
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 4) {
                    if (this.m_AdapterHelper.treatRAID1EasRAID10() && !this.m_AdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                        return Resource.getImage("RAID10_ICON");
                    }
                    return Resource.getImage("RAID1E_ICON");
                }
                return Resource.getImage("RAID10_ICON");
            }
            case 16: {
                return Resource.getImage("RAID10_ICON");
            }
            case 5: {
                return Resource.getImage("RAID5_ICON");
            }
            case 6: {
                return Resource.getImage("RAID6_ICON");
            }
            case 64: {
                return Resource.getImage("RAID00_ICON");
            }
            case 65: {
                return Resource.getImage("RAID10_ICON");
            }
            case 69: {
                return Resource.getImage("RAID50_ICON");
            }
            case 70: {
                return Resource.getImage("RAID60_ICON");
            }
        }
        return Resource.getImage("");
    }

    private String getDriveSecurityDescription(byte by) {
        switch (by) {
            case -1: {
                return Resource.getString("DRIVE_SECURITY_DESC", "<html>Drive security will make the virtual drive secure by applying encryption logic to<br>underlying data in the drive.</html>");
            }
            case 0: {
                return Resource.getString("NO_ENCRYPTION_DESC", "<html>Data in the virtual drives will not have encryption.</html>");
            }
            case 1: {
                return Resource.getString("FDE_ENCRYPTION_DESC", "<html>Data in the virtual dirves will be encrypted by the drive itself.</html>");
            }
            case 2: {
                return Resource.getString("CTRL_ENCRYPTION_DESC", "<html>Data in the virtual drives will be encrypted using controller generated<br>encryption keys.</html>");
            }
        }
        return "";
    }

    private ImageIcon getDriveSecurityIcon(byte by) {
        switch (by) {
            case -1: {
                return Resource.getImage("");
            }
            case 0: {
                return Resource.getImage("NO_ENCRYPTION_ICON");
            }
            case 1: {
                return Resource.getImage("FDE_ENCRYPTION_ICON");
            }
            case 2: {
                return Resource.getImage("CTRL_ENCRYPTION_ICON");
            }
        }
        return Resource.getImage("");
    }

    public JPanel getContentPanel() {
        return this.m_contentPanel;
    }

    public DriveGroupsTreePanel getDgTreePanel() {
        return this.m_dgTreePanel;
    }

    public String getPowerSaveModeDescription(int n) {
        switch (n) {
            case 0: {
                return Resource.getString("DS_CTRL_DEF_DESC", "<html>This option ensures that the system will inherit the controller power save <br>mode.</html>");
            }
            case -2: {
                return Resource.getString("DS_NONE_DESC", "<html>This option ensures that the system will not spin down configured <br>drives.</html>");
            }
            case 1: {
                return Resource.getString("DS_AUTO_DESC", "<html>This option ensures that the system will decide the best power saving<br>settings for the online drives.</html>");
            }
            case 2: {
                if (this.m_AdapterHelper.isSupportPSMaxWithCache()) {
                    return Resource.getString("DS_MAX_DESC", "<html>This option ensures that the system will save maximum power by caching<br>data and avoid spinning up online drives when possible.</html>");
                }
                return Resource.getString("DS_SSM_MAX_DESC", "<html>This option ensures that the system will save maximum power by <br>spinning down online drives when possible.</html>");
            }
            case 6: {
                return Resource.getString("DS_MAX_NO_CACHE_DESC", "<html>This option ensures that the system will save maximum power without<br>caching data for online drives.</html>");
            }
        }
        return "";
    }

    public class ProtectionComboBoxModel
    extends DefaultComboBoxModel {
        public ProtectionComboBoxModel(boolean bl) {
            this.updateModel(bl);
        }

        public void updateModel(boolean bl) {
            if (this.getSize() > 0) {
                this.removeAllElements();
            }
            this.addElement(new Byte(0));
            if (bl) {
                this.addElement(new Byte(1));
            }
        }
    }

    public class ProtectionComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    jLabel.setText(Resource.getString("TEXT_PROTECTION_DISABLE", "Disable"));
                } else if (by == 1) {
                    jLabel.setText(Resource.getString("TEXT_PROTECTION_ENABLE", "Enable"));
                }
            }
            return jLabel;
        }
    }

    public class PowerSaveComboBoxModel
    extends DefaultComboBoxModel {
        public PowerSaveComboBoxModel(ArrayList<Byte> arrayList) {
            this.updateModel(arrayList);
        }

        private void updateModel(ArrayList<Byte> arrayList) {
            if (this.getSize() > 0) {
                this.removeAllElements();
            }
            for (int n = 0; n < arrayList.size(); n = (int)((short)(n + 1))) {
                this.addElement(arrayList.get(n));
            }
        }
    }

    public class PowerSaveComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    jLabel.setText(Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined"));
                } else if (by == -2) {
                    jLabel.setText(Resource.getString("DS_NONE", "None"));
                } else if (by == 1) {
                    jLabel.setText(Resource.getString("DS_AUTO", "Auto"));
                } else if (by == 2) {
                    jLabel.setText(Resource.getString("DS_MAX", "Max"));
                } else if (by == 6) {
                    jLabel.setText(Resource.getString("DS_MAX_NO_CACHE", "Max without Cache"));
                }
            }
            return jLabel;
        }
    }
}

