/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.SpanHole;
import Services.KernelConstants;
import Utils.Resource;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DGHoleTableModel
extends AbstractTableModel {
    public List<SpanHole> m_spanHoles = null;

    public DGHoleTableModel(List<SpanHole> list) {
        this.m_spanHoles = list;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.m_spanHoles.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SpanHole spanHole = this.m_spanHoles.get(n);
        DriveGroup driveGroup = spanHole.getSpan().getDriveGroup();
        if (n2 == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = null;
            if (driveGroup.getSpanDepth() > 1) {
                driveGroup.setisSpan(true);
                objectArray = new Object[]{driveGroup.getDriveGroupId()};
                stringBuffer.append(MessageFormat.format(Resource.getString("LABEL_SPANNED_DG"), objectArray));
            } else {
                objectArray = new Object[]{driveGroup.getDriveGroupId()};
                stringBuffer.append(MessageFormat.format(Resource.getString("LABEL_DG"), objectArray));
            }
            stringBuffer.append(" ");
            objectArray = new Object[]{spanHole.getFreeCapacityIndex()};
            stringBuffer.append(MessageFormat.format(Resource.getString("LABEL_FREE_CAPACITY"), objectArray));
            return stringBuffer.toString();
        }
        if (n2 == 1) {
            return driveGroup.getRaidLevelString();
        }
        return KernelConstants.getConvertedSize(spanHole.getSizePerRaidLevel(), driveGroup.getBlockSize());
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return Resource.getString("COL_NAME_DG", "Drive group name");
        }
        if (n == 1) {
            return Resource.getString("COL_NAME_RL", "RAID level");
        }
        return Resource.getString("COL_NAME_FC", "Free capacity");
    }

    public SpanHole getSelectedHole(int n) {
        return this.m_spanHoles.get(n);
    }
}

