/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class DGVDTreePanel
extends JPanel {
    private JTree m_driveGroupTree = null;
    private DefaultTreeModel m_dgTreeModel = null;
    private boolean m_isSSC = false;
    private DefaultMutableTreeNode m_dgRootNode = null;
    private Object m_rootNodeUserObj = null;
    private List<DriveGroup> m_driveGroups = null;
    public JScrollPane scrollPane;

    public DGVDTreePanel(Object object, List<DriveGroup> list, boolean bl) {
        this.m_rootNodeUserObj = object;
        this.m_driveGroups = list;
        this.m_isSSC = bl;
        this.m_dgRootNode = new DefaultMutableTreeNode(this.m_rootNodeUserObj);
        for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
            this.m_dgRootNode.add(new DefaultMutableTreeNode(this.m_driveGroups.get(n)));
        }
        this.m_dgTreeModel = new DefaultTreeModel(this.m_dgRootNode);
        this.m_driveGroupTree = new JTree(this.m_dgTreeModel);
        this.m_driveGroupTree.setEditable(false);
        this.m_driveGroupTree.getSelectionModel().setSelectionMode(1);
        this.m_driveGroupTree.setShowsRootHandles(true);
        this.m_driveGroupTree.setRootVisible(true);
        this.m_driveGroupTree.setCellRenderer(new DriveGroupTreeCellRenderer());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_dgRootNode.getChildAt(0);
        this.m_driveGroupTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        this.scrollPane = new JScrollPane(this.m_driveGroupTree, 20, 30);
        this.scrollPane.setPreferredSize(new Dimension(350, 250));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    public void initData(List<DriveGroup> list) {
        int n;
        this.m_driveGroups = list;
        this.clearChildNodes(this.m_dgRootNode);
        for (n = 0; n < this.m_driveGroups.size(); n = (int)((byte)(n + 1))) {
            this.m_dgTreeModel.insertNodeInto(new DefaultMutableTreeNode(this.m_driveGroups.get(n)), this.m_dgRootNode, this.m_dgRootNode.getChildCount());
        }
        for (n = 0; n < this.m_dgRootNode.getChildCount(); ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_dgRootNode.getChildAt(n);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            List<VirtualDrive> list2 = driveGroup.getVirtualDrives();
            if (list2 == null || list2.isEmpty()) continue;
            for (int i = 0; i < list2.size(); ++i) {
                this.addVirtualDrive(defaultMutableTreeNode, list2.get(i));
            }
        }
    }

    public void selectRootNode() {
        this.m_driveGroupTree.setSelectionPath(new TreePath(this.m_dgRootNode.getPath()));
    }

    public void selectFirstFreeDGNode() {
        int n = this.m_dgRootNode.getChildCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_dgRootNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            if (!driveGroup.canAddVD()) continue;
            n2 = i;
            break;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_dgRootNode.getChildAt(n2);
        this.m_driveGroupTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void selectFirstDGNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_dgRootNode.getChildAt(0);
        this.m_driveGroupTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void removeCurrentlySelectedVirtualDrive() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.m_driveGroupTree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.m_dgTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.m_driveGroupTree.setSelectionPath(treePath.getParentPath());
            this.m_dgTreeModel.nodeChanged(mutableTreeNode);
            return;
        }
    }

    public void updateCurrentlySelectedVirtualDrive() {
        TreePath treePath = this.m_driveGroupTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.m_dgTreeModel.nodeChanged(defaultMutableTreeNode);
            this.m_dgTreeModel.nodeChanged(defaultMutableTreeNode.getParent());
            int n = this.m_dgRootNode.getChildCount();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof DriveGroup) {
                DriveGroup driveGroup = (DriveGroup)object;
            } else {
                DriveGroup driveGroup = (DriveGroup)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            }
            this.selectFirstFreeDGNode();
        }
    }

    public void addVirtualDrive(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        this.m_dgTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.m_driveGroupTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.m_driveGroupTree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.m_driveGroupTree.removeTreeSelectionListener(treeSelectionListener);
    }

    public JTree getDriveGroupTree() {
        return this.m_driveGroupTree;
    }

    public void clearChildNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        while (n > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            this.clearChildNodes(defaultMutableTreeNode2);
            this.m_dgTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
            n = defaultMutableTreeNode.getChildCount();
        }
    }

    public boolean canCreateSSCD() {
        for (int i = 0; i < this.m_dgRootNode.getChildCount(); ++i) {
            if (!this.m_dgRootNode.getChildAt(i).isLeaf()) continue;
            return true;
        }
        return false;
    }

    class DriveGroupTreeCellRenderer
    extends DefaultTreeCellRenderer {
        DriveGroupTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof AdapterHelper) {
                AdapterHelper adapterHelper = (AdapterHelper)object2;
                jLabel.setIcon(adapterHelper.getIcon());
            } else if (object2 instanceof DriveGroup) {
                String string = "";
                string = DGVDTreePanel.this.m_isSSC ? Resource.getString("SSC_GROUP_IMAGE", "sscds_group.png") : Resource.getString("ARRAY_IMAGE", "array.png");
                ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
                jLabel.setIcon(imageIcon);
            } else if (object2 instanceof VirtualDrive) {
                VirtualDrive virtualDrive = (VirtualDrive)object2;
                if (virtualDrive.isSSCD()) {
                    String string = Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png");
                    ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
                    jLabel.setIcon(imageIcon);
                } else {
                    String string = Resource.getString("VOLUME_IMAGE", "volume.png");
                    ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
                    jLabel.setIcon(imageIcon);
                }
            }
            return jLabel;
        }
    }
}

