/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.Capacity;
import GUI.venus.configuration.advanced.DedicatedHotSpare;
import GUI.venus.configuration.advanced.MR_ARRAY_Creator;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.SpanHole;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.util.ArrayList;
import java.util.List;

public class DriveGroup {
    private static final short MIN_CONFIGURABLE_ARRAY_SIZE = 2048;
    private static final byte MAX_SPAN_DEPTH = 8;
    private AdapterHelper m_adapterHelper = null;
    private byte m_bRaidLevel = (byte)-1;
    private List<VirtualDrive> m_virtualDrives = null;
    private List<Span> m_spans = null;
    private long m_lTotalAvailableCapacity = 0L;
    private long m_lUsedCapacity = 0L;
    private long m_lDupCapacity = 0L;
    private long m_totalCapacityInBlocks = 0L;
    private short blockSize = (short)512;
    private byte m_bTempDGId = 0;
    private byte m_bEncrptionType = 0;
    private ArrayHelper m_arrayHelper = null;
    private List<ArrayHelper> m_listOfArrayHelpers = null;
    private boolean m_isOld = false;
    private byte m_bCurrentlySelectedHole = 0;
    private SpanHole m_selSpanHole = null;
    private boolean m_isCompleted = false;
    private List<DedicatedHotSpare> m_dedHotSpares = null;
    private boolean m_isSSC = false;
    private boolean m_isCSACacheCade = false;
    private byte m_powerSavePolicy;
    private boolean m_dataProtection = false;
    private boolean m_isSpan = false;

    public DriveGroup(byte by) {
        this.m_bRaidLevel = by;
        this.calculateCapacity();
    }

    public DriveGroup(byte by, boolean bl) {
        this.m_bTempDGId = by;
        this.m_isCompleted = bl;
    }

    public DriveGroup(List<ArrayHelper> list) {
        this.m_listOfArrayHelpers = list;
        this.m_isOld = true;
        this.m_spans = new ArrayList<Span>();
        this.m_arrayHelper = this.m_listOfArrayHelpers.get(0);
        this.m_adapterHelper = (AdapterHelper)this.m_arrayHelper.getParent();
        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.m_arrayHelper.getLogicalDriveHelpers()[0].getDeviceObject();
        this.m_bRaidLevel = sASLogicalDrive.getInformation().getldConfig().getparams().getPRL();
        this.m_bEncrptionType = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
        boolean bl = this.m_dataProtection = sASLogicalDrive.getInformation().getldConfig().getparams().getPIEnabled() != 0;
        if (this.m_listOfArrayHelpers.size() == 1) {
            Span span = new Span(this, this.m_arrayHelper, this.m_bCurrentlySelectedHole);
            this.m_spans.add(span);
            this.m_bRaidLevel = ((SASLogicalDrive)this.m_arrayHelper.getLogicalDriveHelpers()[0].getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
            this.m_selSpanHole = span.getCurrentlySelectedSpanHole();
            this.m_bTempDGId = (byte)this.m_arrayHelper.getDeviceObject().getID();
        } else {
            this.m_spans = new ArrayList<Span>();
            for (int n = 0; n < this.m_listOfArrayHelpers.size(); n = (int)((byte)(n + 1))) {
                Span span = new Span(this, this.m_listOfArrayHelpers.get(n), this.m_bCurrentlySelectedHole);
                this.m_spans.add(span);
            }
            this.m_selSpanHole = this.m_spans.get(0).getCurrentlySelectedSpanHole();
        }
        this.calculateCapacity();
    }

    public List<ArrayHelper> getArrayHelpers() {
        return this.m_listOfArrayHelpers;
    }

    public byte getRaidLevel() {
        return this.m_bRaidLevel;
    }

    public List<SpanHole> getSpanHoles() {
        return this.m_spans.get(0).getSpanHoles();
    }

    public void setSelectedSpanHoleIndex(byte by) {
        this.m_bCurrentlySelectedHole = by;
        Span span = this.m_spans.get(0);
        span.setCurrentlySelectedSpanHole(this.m_bCurrentlySelectedHole);
        this.m_selSpanHole = span.getCurrentlySelectedSpanHole();
        this.calculateCapacity();
    }

    public SpanHole getCurrentlySelectedSpanHole() {
        return this.m_selSpanHole;
    }

    public String toString() {
        if (!this.m_isOld) {
            if (this.m_lTotalAvailableCapacity < this.getMinSizeInBlocks()) {
                this.m_lTotalAvailableCapacity = 0L;
            }
            if (this.m_isCSACacheCade) {
                return Resource.getString("CSA_DRIVE_GROUP_LABEL", "Nytro Drive Group") + this.m_bTempDGId + ": " + this.getRaidLevelString() + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available Capacity ") + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity);
            }
            if (this.m_isSSC) {
                return Resource.getString("SSC_DRIVEGROUP", "CacheCade\u2122 Drive Group ") + this.m_bTempDGId + ": " + this.getRaidLevelString() + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available Capacity ") + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
            }
            if (this.m_isSpan) {
                return "Spanned Drive Group " + this.m_bTempDGId + ": " + this.getRaidLevelString() + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", Resource.getString("LEGEND_UNUSED_TEXT", "Available") + " " + Resource.getString("CAPACITY_TEXT", "Capacity ")) + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
            }
            return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + this.m_bTempDGId + ": " + this.getRaidLevelString() + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", Resource.getString("LEGEND_UNUSED_TEXT", "Available") + " " + Resource.getString("CAPACITY_TEXT", "Capacity ")) + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
        }
        this.m_bTempDGId = (byte)((SASArray)this.m_arrayHelper.getDeviceObject()).getID();
        if (this.m_isSSC) {
            return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group ") + this.getDriveGroupId() + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available Capacity ") + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
        }
        if (this.m_isSpan) {
            return "Spanned Drive Group " + this.getDriveGroupId() + ": " + this.getRaidLevelString() + ": " + Resource.getString("LEGEND_UNUSED_TEXT", Resource.getString("LEGEND_UNUSED_TEXT", "Available") + " " + Resource.getString("CAPACITY_TEXT", "Capacity ")) + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
        }
        return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group ") + this.getDriveGroupId() + ": " + this.getRaidLevelString() + ": " + Resource.getString("LEGEND_UNUSED_TEXT", Resource.getString("LEGEND_UNUSED_TEXT", "Available") + " " + Resource.getString("CAPACITY_TEXT", "Capacity ")) + ": " + KernelConstants.getConvertedSize(this.m_lTotalAvailableCapacity, this.getBlockSize());
    }

    public String getDriveGroupName() {
        return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group ") + this.m_bTempDGId;
    }

    public int getSpanDepth() {
        if (this.m_spans == null || this.m_spans.isEmpty()) {
            return 0;
        }
        return this.m_spans.size();
    }

    public byte getEncrptionMethod() {
        return this.m_bEncrptionType;
    }

    public void setEncrptionMethod(byte by) {
        this.m_bEncrptionType = by;
    }

    public boolean isPIEnabled() {
        return this.m_dataProtection;
    }

    public void setPIEnable(boolean bl) {
        this.m_dataProtection = bl;
    }

    public List<Span> getSpans() {
        return this.m_spans;
    }

    public byte getPowerSavePolicy() {
        if (this.m_isOld && this.m_arrayHelper != null) {
            return this.m_arrayHelper.getDefaultPowerSavePolicy();
        }
        return this.m_powerSavePolicy;
    }

    public byte setPowerSavePolicy(byte by) {
        this.m_powerSavePolicy = by;
        return this.m_powerSavePolicy;
    }

    public void addVirtualDrive(VirtualDrive virtualDrive) {
        if (this.m_virtualDrives == null) {
            this.m_virtualDrives = new ArrayList<VirtualDrive>();
        }
        this.m_virtualDrives.add(virtualDrive);
        this.m_lUsedCapacity += virtualDrive.getSize();
        this.m_lTotalAvailableCapacity -= virtualDrive.getSize();
        if (this.isNotExceedingMinimumBlockSize(this.m_lTotalAvailableCapacity)) {
            this.m_lDupCapacity = this.m_lTotalAvailableCapacity;
            this.m_lTotalAvailableCapacity = 0L;
        }
    }

    public void removeVirtualDrive(VirtualDrive virtualDrive) {
        if (this.m_virtualDrives != null && !this.m_virtualDrives.isEmpty() && this.m_virtualDrives.contains(virtualDrive)) {
            this.m_lUsedCapacity -= virtualDrive.getSize();
            this.m_lTotalAvailableCapacity += virtualDrive.getSize();
            if (this.m_lDupCapacity != 0L) {
                this.m_lTotalAvailableCapacity += this.m_lDupCapacity;
                this.m_lDupCapacity = 0L;
            }
            this.m_virtualDrives.remove(virtualDrive);
        }
    }

    public void updateVirtualDrive(VirtualDrive virtualDrive, long l) {
        if (this.m_virtualDrives != null && !this.m_virtualDrives.isEmpty() && this.m_virtualDrives.contains(virtualDrive)) {
            this.m_lUsedCapacity -= l;
            this.m_lTotalAvailableCapacity += l;
            this.m_lUsedCapacity += virtualDrive.getSize();
            this.m_lTotalAvailableCapacity -= virtualDrive.getSize();
            System.out.println("VD is contained in the DG.");
        }
    }

    public List<VirtualDrive> getVirtualDrives() {
        return this.m_virtualDrives;
    }

    public boolean canAddVD() {
        if (this.m_isOld) {
            LogicalDriveHelper[] logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers();
            if (this.m_adapterHelper.MAX_LDS_PER_ARRAY - logicalDriveHelperArray.length > 0) {
                if (this.m_virtualDrives == null || this.m_virtualDrives.isEmpty()) {
                    return true;
                }
                return this.m_adapterHelper.MAX_LDS_PER_ARRAY - logicalDriveHelperArray.length - this.m_virtualDrives.size() > 0 && this.getFreeSizeInBlocks() > this.getMinSizeInBlocks();
            }
            return false;
        }
        if (this.m_virtualDrives == null || this.m_virtualDrives.isEmpty()) {
            return true;
        }
        if (this.m_adapterHelper.MAX_LDS_PER_ARRAY - this.m_virtualDrives.size() > 0) {
            return this.getFreeSizeInBlocks() > this.getMinSizeInBlocks();
        }
        return false;
    }

    private boolean canAddSpan() {
        if (this.m_spans == null || this.m_spans.isEmpty()) {
            return true;
        }
        return 8 - this.m_spans.size() > 0;
    }

    public void addSpan(Span span) {
        if (this.m_spans == null) {
            this.m_spans = new ArrayList<Span>();
        }
        this.m_spans.add(span);
        this.calculateCapacity();
    }

    public void removeSpan(Span span) {
        if (this.m_spans == null || !this.m_spans.contains(span)) {
            return;
        }
        this.m_spans.remove(span);
        this.calculateCapacity();
    }

    public void addDedicatedHotspare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHotSpares == null) {
            this.m_dedHotSpares = new ArrayList<DedicatedHotSpare>();
        }
        this.m_dedHotSpares.add(dedicatedHotSpare);
    }

    public void removeDedicatedHotspare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHotSpares == null || !this.m_dedHotSpares.contains(dedicatedHotSpare)) {
            return;
        }
        this.m_dedHotSpares.remove(dedicatedHotSpare);
    }

    public long getFreeSizeInBlocks() {
        return this.m_lTotalAvailableCapacity;
    }

    public Capacity getCapacity() {
        Capacity capacity = new Capacity();
        capacity.setMinSizeInBlocks(this.getMinSizeInBlocks());
        capacity.setMaxSizeInBlocks(this.m_lTotalAvailableCapacity);
        return capacity;
    }

    public List<DedicatedHotSpare> getDHSPList() {
        return this.m_dedHotSpares;
    }

    public short getBlockSize() {
        if (this.m_arrayHelper != null) {
            this.blockSize = this.m_arrayHelper.getBlockSize();
        }
        return this.blockSize;
    }

    public void setBlockSize(short s) {
        this.blockSize = s;
    }

    private long getMinSizeInBlocks() {
        long l;
        int n = 0;
        if (this.m_spans != null && !this.m_spans.isEmpty()) {
            byte by = this.m_spans.get(0).getDgPrl();
            switch (by) {
                case 0: {
                    n = this.m_spans.get(0).getNumberOfDrives();
                    break;
                }
                case 1: 
                case 17: {
                    n = this.m_spans.get(0).getNumberOfDrives() / 2;
                    break;
                }
                case 5: {
                    n = this.m_spans.get(0).getNumberOfDrives() - 1;
                    break;
                }
                case 6: {
                    n = this.m_spans.get(0).getNumberOfDrives() - 2;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return (l = (long)(n * 8192)) > 2048L ? l : 2048L;
    }

    private long getMinCapacityFromSpans() {
        long l = this.m_spans.get(0).getMinPDSizeInSpan();
        for (int n = 1; n < this.m_spans.size(); n = (int)((byte)(n + 1))) {
            long l2 = this.m_spans.get(n).getMinPDSizeInSpan();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    private void calculateCapacity() {
        if (this.m_spans == null || this.m_spans.isEmpty()) {
            return;
        }
        float f = 0.0f;
        int n = this.m_spans.get(0).getNumberOfDrives();
        byte by = (byte)(this.m_bRaidLevel & 0xFFFFFFBF);
        if (by == 0 || by == 7) {
            f = n;
        } else if (by == 1) {
            f = 1.0f;
        } else if (by == 17) {
            f = (float)n / 2.0f;
        } else if (by == 16) {
            f = (float)n / 2.0f;
        } else if (by == 5) {
            f = n - 1;
        } else if (by == 6) {
            f = n - 2;
        }
        if (this.m_isOld) {
            SpanHole spanHole = this.m_spans.get(0).getCurrentlySelectedSpanHole();
            this.m_lTotalAvailableCapacity = (long)((float)spanHole.getNumBlocks() * f * (float)this.m_spans.size());
        } else {
            long l;
            long l2 = this.getMinCapacityFromSpans();
            long l3 = 0L;
            l3 = by == 17 || by == 16 ? (long)((float)l2 * f) : l2 * (long)((int)f);
            this.m_lTotalAvailableCapacity = l = l3 * (long)this.m_spans.size();
        }
        this.m_totalCapacityInBlocks = this.m_lTotalAvailableCapacity;
    }

    public List<MR_ARRAY> getMRArray() {
        ArrayList<MR_ARRAY> arrayList = new ArrayList<MR_ARRAY>();
        if (this.m_isOld) {
            for (int n = 0; n < this.m_spans.size(); n = (int)((byte)(n + 1))) {
                Span span = this.m_spans.get(n);
                arrayList.add(span.getArrayInfo().getarray());
            }
        } else {
            for (int n = 0; n < this.m_spans.size(); n = (int)((byte)(n + 1))) {
                Span span = this.m_spans.get(n);
                MR_ARRAY_Creator mR_ARRAY_Creator = new MR_ARRAY_Creator(AdvanceConfigEngine.getAdapterHelper(), span.getPhysicalDrivesList(), span.getSpanId(), this.getMinCapacityFromSpans());
                arrayList.add(mR_ARRAY_Creator.getMRArray());
            }
        }
        return arrayList;
    }

    public List<MR_LD_CONFIG> getLDConfig() {
        float f = 0.0f;
        int n = this.m_spans.get(0).getNumberOfDrives();
        byte by = (byte)(this.m_bRaidLevel & 0xFFFFFFBF);
        System.out.println("DriveGroup.getLDConfig()  RAID LEVEL = " + by);
        if (by == 0 || by == 7) {
            f = n;
        } else if (by == 1) {
            f = 1.0f;
        } else if (by == 17) {
            f = (float)n / 2.0f;
        } else if (by == 16) {
            f = (float)n / 2.0f;
        } else if (by == 5) {
            f = n - 1;
        } else if (by == 6) {
            f = n - 2;
        }
        List<MR_ARRAY> list = this.getMRArray();
        ArrayList<MR_LD_CONFIG> arrayList = new ArrayList<MR_LD_CONFIG>();
        long l = 0L;
        if (this.m_isOld) {
            l = this.m_selSpanHole.getStartBlock();
        }
        for (int n2 = 0; n2 < this.m_virtualDrives.size(); n2 = (int)((byte)(n2 + 1))) {
            VirtualDrive virtualDrive = this.m_virtualDrives.get(n2);
            long l2 = virtualDrive.getSize();
            long l3 = l2 / (long)this.m_spans.size();
            long l4 = 0L;
            l4 = by == 17 || by == 16 ? (long)((float)l3 / f) : l3 / (long)((int)f);
            arrayList.add(virtualDrive.getMRLDConfig(l, l4, list));
            l += l4;
        }
        return arrayList;
    }

    public void setRaidLevel(byte by) {
        this.m_bRaidLevel = by;
    }

    public int getDriveGroupId() {
        if (this.m_isOld) {
            if (this.m_isSpan) {
                return this.getDriveGroupIDforOldSpan();
            }
            return this.m_arrayHelper.getID(3);
        }
        return this.m_bTempDGId;
    }

    public int getDriveGroupIDforOldSpan() {
        ArrayHelper[] arrayHelperArray;
        int n;
        ArrayList arrayList = new ArrayList();
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_adapterHelper.getLogicalDrives();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth() <= '\u0001') continue;
            arrayHelperArray = logicalDriveHelperArray[n].getArrays();
            ArrayList<Short> arrayList2 = new ArrayList<Short>();
            for (int n4 = 0; n4 < arrayHelperArray.length; n4 = (int)((byte)(n4 + 1))) {
                arrayList2.add(n2, ((SASArray)arrayHelperArray[n4].getDeviceObject()).getID());
                n2 = (byte)(n2 + 1);
            }
            n2 = 0;
            if (this.Contains(arrayList, arrayList2)) continue;
            arrayList.add(n3, arrayList2);
            n3 = (byte)(n3 + 1);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            arrayHelperArray = (ArrayHelper[])arrayList.get(n);
            if (!arrayHelperArray.contains(((SASArray)this.m_listOfArrayHelpers.get(0).getDeviceObject()).getID())) continue;
            return n;
        }
        return 0;
    }

    public boolean Contains(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList3 = (ArrayList)arrayList.get(i);
            if (!arrayList3.contains(arrayList2.get(0))) continue;
            return true;
        }
        return false;
    }

    public void setDriveGroupId(int n) {
        this.m_bTempDGId = (byte)n;
    }

    public boolean isCompleted() {
        return this.m_isCompleted;
    }

    public void setAsCompleted(boolean bl) {
        this.m_isCompleted = bl;
    }

    public String getIcon() {
        return Resource.getString("ARRAY_IMAGE", "array.png");
    }

    public String getSSCDIcon() {
        return Resource.getString("SSC_GROUP_IMAGE", "sscds_group.png");
    }

    public void setTotalCapacityInBlocks(long l) {
        this.m_totalCapacityInBlocks = l;
    }

    public long getTotalCapacityInBlocks() {
        return this.m_totalCapacityInBlocks;
    }

    public String getRaidLevelString() {
        boolean bl;
        byte by = (byte)(this.m_bRaidLevel & 0xFFFFFFBF);
        boolean bl2 = bl = this.getSpanDepth() > 1;
        if (by == 7) {
            return Resource.getString("RAID_LEVEL_EC", "R1-EC");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("RAID", "RAID"));
        stringBuffer.append(" ");
        if (by == 17) {
            by = 1;
            stringBuffer.append(by);
            SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
            if (sASAdapter.getAdapterType() == 2) {
                stringBuffer.append("E");
            } else if (sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
                if (this.m_adapterHelper.treatRAID1EasRAID10() && !this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                    stringBuffer.append("0");
                } else {
                    stringBuffer.append("E");
                }
            } else if (this.m_spans != null && !this.m_spans.isEmpty()) {
                try {
                    MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                    if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                        stringBuffer.append("0");
                    } else {
                        stringBuffer.append("");
                        if (bl) {
                            stringBuffer.append("0");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (by == 16) {
            by = 1;
            stringBuffer.append(by);
            stringBuffer.append("0");
        } else {
            stringBuffer.append(by);
            if (bl) {
                stringBuffer.append("0");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isHotSpareAssigned() {
        return this.m_dedHotSpares != null && !this.m_dedHotSpares.isEmpty();
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isSpan) {
            stringBuffer.append("Spanned Drive Group");
        } else {
            stringBuffer.append(Resource.getString("DRIVE_GROUP_TEXT", "Drive Group "));
        }
        stringBuffer.append(this.m_bTempDGId);
        if (this.m_totalCapacityInBlocks > 0L) {
            stringBuffer.append(": ");
            stringBuffer.append(this.getTextForRaidLevel(this.m_bRaidLevel));
            stringBuffer.append(": ");
            stringBuffer.append(KernelConstants.getConvertedSize(this.m_totalCapacityInBlocks, this.getBlockSize()));
        }
        return stringBuffer.toString();
    }

    public String getSSCText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SSC_DRIVEGROUP", "CacheCade\u2122 Drive Group "));
        stringBuffer.append(this.m_bTempDGId);
        if (this.m_totalCapacityInBlocks > 0L) {
            stringBuffer.append(": ");
            stringBuffer.append(this.getTextForRaidLevel(this.m_bRaidLevel));
            stringBuffer.append(": ");
            stringBuffer.append(KernelConstants.getConvertedSize(this.m_totalCapacityInBlocks, this.getBlockSize()));
        }
        return stringBuffer.toString();
    }

    public String getCSACacheCadeText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("CSA_CACHECADE_DRIVEGROUP", "Nytro\u2122 Drive Group "));
        stringBuffer.append(this.m_bTempDGId);
        if (this.m_totalCapacityInBlocks > 0L) {
            stringBuffer.append(" : ");
            stringBuffer.append(this.getTextForRaidLevel(this.m_bRaidLevel));
            stringBuffer.append(" : ");
            stringBuffer.append(KernelConstants.getConvertedSize(this.m_totalCapacityInBlocks, this.getBlockSize()));
        }
        return stringBuffer.toString();
    }

    public String getTextForRaidLevel(byte by) {
        switch (by) {
            case 0: {
                return Resource.getString("RAID_0", "RAID 0");
            }
            case 1: {
                return Resource.getString("RAID_1", "RAID 1");
            }
            case 17: {
                if (this.m_adapterHelper != null) {
                    if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2) {
                        return Resource.getString("RAID_1E", "RAID 1E");
                    }
                    if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                        if (this.m_adapterHelper.treatRAID1EasRAID10() && !this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                            return Resource.getString("RAID_10", "RAID 10");
                        }
                        return Resource.getString("RAID_1E", "RAID 1E");
                    }
                    try {
                        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                        if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                            return Resource.getString("RAID_10", "RAID 10");
                        }
                        return Resource.getString("RAID_1", "RAID 1");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return Resource.getString("RAID_1", "RAID 1");
            }
            case 16: {
                return Resource.getString("RAID_10", "RAID 10");
            }
            case 5: {
                return Resource.getString("RAID_5", "RAID 5");
            }
            case 6: {
                return Resource.getString("RAID_6", "RAID 6");
            }
            case 64: {
                return Resource.getString("RAID_00", "RAID 00");
            }
            case 65: 
            case 81: {
                return Resource.getString("RAID_10", "RAID 10");
            }
            case 69: {
                return Resource.getString("RAID_50", "RAID 50");
            }
            case 70: {
                return Resource.getString("RAID_60", "RAID 60");
            }
        }
        return "";
    }

    public void setAdapterHelper(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
    }

    public AdapterHelper getAdapterHelper() {
        return this.m_adapterHelper;
    }

    public void setisSSC(boolean bl) {
        this.m_isSSC = bl;
    }

    public boolean isSSC() {
        return this.m_isSSC;
    }

    public void setisSpan(boolean bl) {
        this.m_isSpan = bl;
    }

    public boolean getisSpan() {
        return this.m_isSpan;
    }

    public void setMRArray(int n) {
        if (this.m_isOld) {
            for (int n2 = 0; n2 < this.m_spans.size(); n2 = (int)((byte)(n2 + 1))) {
                Span span = this.m_spans.get(n2);
                span.setSpanId((byte)(n + n2));
            }
        } else {
            for (int n3 = 0; n3 < this.m_spans.size(); n3 = (int)((byte)(n3 + 1))) {
                Span span = this.m_spans.get(n3);
                span.setSpanId((byte)(n + n3));
            }
        }
    }

    public ArrayHelper getM_arrayHelper() {
        return this.m_arrayHelper;
    }

    public void setIsCSACacheCade(boolean bl) {
        this.m_isCSACacheCade = bl;
    }

    public boolean isCSACacheCade() {
        return this.m_isCSACacheCade;
    }

    public boolean isNotExceedingMinimumBlockSize(double d) {
        return this.getMinSizeInBlocks() > (long)d;
    }
}

