/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.AdvancedDriveGroupSettings;
import GUI.venus.configuration.advanced.DedicatedHotSpare;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class DriveGroupCreationPage
extends DefaultWizardPage
implements TreeModelListener,
HelpInterface {
    private AdapterHelper m_adapterHelper = null;
    private AdvanceConfigEngine m_engine = null;
    private AdvancedDriveGroupSettings m_advancedDGSettings = null;

    @Override
    protected void reinitialise() {
        this.m_engine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
        DriveGroupCreationPage driveGroupCreationPage = this;
        this.m_adapterHelper = driveGroupCreationPage.m_engine.getAdapterHelper();
        this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_ADVANCED_CONFIGURATION");
        if (this.m_advancedDGSettings == null) {
            this.m_advancedDGSettings = new AdvancedDriveGroupSettings(this.m_engine, this);
            this.setNextButtonStatus(false);
        } else {
            JTree jTree = this.m_advancedDGSettings.getDgTreePanel().getDriveGroupsTree();
            jTree.getModel().addTreeModelListener(this);
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        return this.m_advancedDGSettings.getContentPanel();
    }

    @Override
    public String getPageID() {
        return "AdvanceDGCreationPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("ADVANCED_DG_CREATION_PAGE_TITLE", "Create Drive Group - Drive Group Settings");
    }

    @Override
    public void onNext() {
        int n;
        ArrayList<PhysicalDriveHelper> arrayList = null;
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_advancedDGSettings.getDgTreePanel().getRootNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt((n = defaultMutableTreeNode.getChildCount()) - 1);
        if (!((DriveGroup)defaultMutableTreeNode2.getUserObject()).isCompleted()) {
            --n;
        }
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            int n3;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode3.getUserObject();
            if (list == null || list.isEmpty() || !list.contains(driveGroup)) {
                PhysicalDriveHelper physicalDriveHelper;
                if (driveGroup.getRaidLevel() <= 17) {
                    Object object2;
                    arrayList = new ArrayList<PhysicalDriveHelper>();
                    n3 = defaultMutableTreeNode3.getChildCount();
                    for (int j = 0; j < n3; ++j) {
                        object2 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(j);
                        PhysicalDriveHelper physicalDriveHelper2 = (PhysicalDriveHelper)((DefaultMutableTreeNode)object2).getUserObject();
                        if (physicalDriveHelper2.isDedicatedHotSpare()) continue;
                        arrayList.add(physicalDriveHelper2);
                    }
                    pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().getpdsForRaidLevels_MR_CTRL_INFO();
                    if (driveGroup.getRaidLevel() == 1 && arrayList.size() > pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1() && arrayList.size() >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_1E_RLQ0()) {
                        driveGroup.setRaidLevel((byte)17);
                    }
                    object2 = new Span(driveGroup, arrayList);
                    ((Span)object2).setSpanId(this.m_engine.getArrayReference());
                    driveGroup.addSpan((Span)object2);
                    block2: for (int j = 0; j < n3; ++j) {
                        object = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(j);
                        PhysicalDriveHelper physicalDriveHelper3 = (PhysicalDriveHelper)((DefaultMutableTreeNode)object).getUserObject();
                        if (!physicalDriveHelper3.isDedicatedHotSpare()) continue;
                        List<DedicatedHotSpare> list2 = driveGroup.getDHSPList();
                        for (n2 = 0; n2 < list2.size(); ++n2) {
                            if (!physicalDriveHelper3.equals(list2.get(n2).getPhysicalDriveHelper())) continue;
                            list2.get(n2).addSpan((Span)object2);
                            ((Span)object2).addDedicatedHotspare(list2.get(n2));
                            continue block2;
                        }
                    }
                    this.m_engine.addNewDriveGroup(driveGroup);
                    continue;
                }
                n3 = defaultMutableTreeNode3.getChildCount();
                int n4 = 0;
                if (driveGroup.getRaidLevel() == 65) {
                    int n5 = 0;
                    if (n5 < n3) {
                        DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(n5);
                        object = (Span)defaultMutableTreeNode4.getUserObject();
                        int n6 = defaultMutableTreeNode4.getChildCount();
                        arrayList = new ArrayList();
                        for (int j = 0; j < n6; ++j) {
                            DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(j);
                            physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNode5.getUserObject();
                            if (physicalDriveHelper.isDedicatedHotSpare()) continue;
                            arrayList.add(physicalDriveHelper);
                        }
                        n4 = arrayList.size();
                    }
                    if (n4 >= 4 && n4 % 2 == 0) {
                        driveGroup.setRaidLevel((byte)81);
                    }
                    if (driveGroup.getRaidLevel() == 65 && driveGroup.getSpanDepth() == 1) {
                        driveGroup.setRaidLevel((byte)17);
                    }
                }
                for (int j = 0; j < n3; ++j) {
                    DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(j);
                    object = (Span)defaultMutableTreeNode6.getUserObject();
                    int n7 = defaultMutableTreeNode6.getChildCount();
                    arrayList = new ArrayList();
                    for (int k = 0; k < n7; ++k) {
                        DefaultMutableTreeNode defaultMutableTreeNode7 = (DefaultMutableTreeNode)defaultMutableTreeNode6.getChildAt(k);
                        physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNode7.getUserObject();
                        if (physicalDriveHelper.isDedicatedHotSpare()) continue;
                        arrayList.add(physicalDriveHelper);
                    }
                    ((Span)object).setDriveGroup(driveGroup);
                    ((Span)object).setPhysicalDrivesList(arrayList);
                    ((Span)object).setSpanId(this.m_engine.getArrayReference());
                    driveGroup.addSpan((Span)object);
                }
                this.m_engine.addNewDriveGroup(driveGroup);
                continue;
            }
            if (!this.m_hmWizardData.containsKey("DGsModified") || driveGroup.getRaidLevel() > 17) continue;
            n3 = defaultMutableTreeNode3.getChildCount();
            block7: for (int j = 0; j < n3; ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode8 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(j);
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNode8.getUserObject();
                if (!physicalDriveHelper.isDedicatedHotSpare()) continue;
                object = driveGroup.getDHSPList();
                for (int k = 0; k < object.size(); ++k) {
                    if (!physicalDriveHelper.equals(((DedicatedHotSpare)object.get(k)).getPhysicalDriveHelper())) continue;
                    List<Span> list3 = driveGroup.getSpans();
                    for (n2 = 0; n2 < list3.size(); ++n2) {
                        ((DedicatedHotSpare)object.get(k)).addSpan(list3.get(n2));
                        list3.get(n2).addDedicatedHotspare((DedicatedHotSpare)object.get(k));
                    }
                    continue block7;
                }
            }
        }
        super.onNext();
    }

    private boolean isDuplicateDHSPForEngine(DedicatedHotSpare dedicatedHotSpare) {
        List<DedicatedHotSpare> list = this.m_engine.getDedicatedHotSpares();
        for (int i = 0; i < list.size(); ++i) {
            DedicatedHotSpare dedicatedHotSpare2 = list.get(i);
            if (!dedicatedHotSpare2.getPhysicalDriveHelper().equals(dedicatedHotSpare.getPhysicalDriveHelper())) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateDHSPForDG(DedicatedHotSpare dedicatedHotSpare, DriveGroup driveGroup) {
        List<DedicatedHotSpare> list = driveGroup.getDHSPList();
        for (int i = 0; i < list.size(); ++i) {
            DedicatedHotSpare dedicatedHotSpare2 = list.get(i);
            if (!dedicatedHotSpare2.getPhysicalDriveHelper().equals(dedicatedHotSpare.getPhysicalDriveHelper())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cleanUp() {
        List<DedicatedHotSpare> list = this.m_engine.getDedicatedHotSpares();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).getPhysicalDriveHelper().setAsDedicatedHotSpare(false);
            }
        }
        super.cleanUp();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.m_hmWizardData.put("DGsModified", true);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.m_hmWizardData.put("DGsModified", true);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.m_hmWizardData.put("DGsModified", true);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.m_hmWizardData.put("DGsModified", true);
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }
}

