/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvancedDriveGroupSettings;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.DriveSecurityComboBoxModel;
import GUI.venus.configuration.advanced.PDTableToTreePanel;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.UnconfiguredDrivesDisabler;
import GUI.venus.configuration.advanced.UnconfiguredDrivesTableModel;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DriveGroupsTreePanel
extends JPanel {
    private AdapterHelper m_adapterHelper = null;
    private JComboBox m_raidLevelComboBox = null;
    private JComboBox m_driveSecurityComboBox = null;
    private JComboBox m_powerSettingsCombobox = null;
    private JComboBox m_protectionCombobox = null;
    private pdsForRaidLevels_MR_CTRL_INFO m_pdsForRaidLevel = null;
    private DefaultWizardPage m_DefWizardPage = null;
    private String[] mnemonics;
    private int m_UnconfGoodPdListSize = 0;
    private ArrayList<PhysicalDriveHelper> m_UnconfGoodPdList = null;
    private UnconfiguredDrivesDisabler m_unconfDrivesDisabler = null;
    private UnconfiguredDrivesTableModel m_unconfGoodPdTableModel = null;
    private PDTableToTreePanel m_PdTableToTreePanel = null;
    private JTree m_driveGroupsTree = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private DefaultTreeModel m_driveGroupsTreeModel = null;
    private boolean showWarning = false;
    private short mfcDisablePowerSavings = 0;
    JButton m_createDriveGroupButton = null;
    JButton m_createSpanButton = null;
    protected DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 == null) {
                return this;
            }
            if (!VivaldiStartupDialog.isWindows) {
                this.setForeground(Color.black);
            }
            if (object2 instanceof GUIHelperInterface) {
                GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)object2;
                if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                    PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)gUIHelperInterface;
                    this.setText(physicalDriveHelper.getTextForTable()[0] + ": " + physicalDriveHelper.getTextForTable()[1] + ": " + physicalDriveHelper.getTextForTable()[2]);
                    if (physicalDriveHelper.isDedicatedHotSpare()) {
                        try {
                            this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("HOTSPARE_IMAGE", "hotspare.png")))));
                        }
                        catch (Exception exception) {
                            System.out.println(".getTreeCellRendererComponent()");
                            return null;
                        }
                    } else {
                        try {
                            this.setIcon(gUIHelperInterface.getIcon());
                        }
                        catch (Exception exception) {
                            System.out.println(".getTreeCellRendererComponent()");
                            return null;
                        }
                    }
                } else if (gUIHelperInterface instanceof AdapterHelper) {
                    try {
                        this.setIcon(gUIHelperInterface.getIcon());
                    }
                    catch (Exception exception) {
                        System.out.println(".getTreeCellRendererComponent()");
                        return null;
                    }
                }
            } else {
                if (object2 instanceof DriveGroup) {
                    this.setText(((DriveGroup)object2).getText());
                    try {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(((DriveGroup)object2).getIcon()))));
                    }
                    catch (Exception exception) {
                        System.out.println(".getTreeCellRendererComponent()");
                        return null;
                    }
                }
                if (object2 instanceof Span) {
                    this.setText(((Span)object2).getText());
                    try {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(((Span)object2).getIcon()))));
                    }
                    catch (Exception exception) {
                        System.out.println(".getTreeCellRendererComponent()");
                        return null;
                    }
                }
            }
            return this;
        }
    };

    public DriveGroupsTreePanel(AdapterHelper adapterHelper, JComboBox jComboBox, JComboBox jComboBox2, DefaultWizardPage defaultWizardPage, JComboBox jComboBox3, JComboBox jComboBox4) {
        this.m_adapterHelper = adapterHelper;
        this.m_raidLevelComboBox = jComboBox;
        this.m_driveSecurityComboBox = jComboBox2;
        this.m_powerSettingsCombobox = jComboBox3;
        this.m_protectionCombobox = jComboBox4;
        this.m_pdsForRaidLevel = this.m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        this.m_DefWizardPage = defaultWizardPage;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_rootNode = new DefaultMutableTreeNode(this.m_adapterHelper);
        this.m_driveGroupsTreeModel = new DefaultTreeModel(this.m_rootNode);
        this.m_driveGroupsTree = new JTree(this.m_driveGroupsTreeModel);
        this.m_driveGroupsTree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.m_driveGroupsTree, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.gridwidth = 3;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_DRIVE_GROUPS", "Drive (g)roups:"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(jScrollPane);
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.m_driveGroupsTree.setCellRenderer(this.renderer);
        DriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
        this.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_DG", "(C)reate Drive Group"));
        this.m_createDriveGroupButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_createDriveGroupButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_createDriveGroupButton.setEnabled(false);
        jPanel.add(this.m_createDriveGroupButton);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_SPAN", "Create (S)pan"));
        this.m_createSpanButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_createSpanButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_createSpanButton.setEnabled(false);
        jPanel.add(this.m_createSpanButton);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
            this.m_createSpanButton.setVisible(false);
        }
        this.add((Component)jPanel, gridBagConstraints);
        System.out.println("m_adapterHelper :" + this.m_adapterHelper);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() != 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() != 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() != 4) {
            MR_MFC_DEFAULTS mR_MFC_DEFAULTS = null;
            try {
                mR_MFC_DEFAULTS = this.m_adapterHelper.getMFCDefaults();
            }
            catch (Exception exception) {
                mR_MFC_DEFAULTS = null;
            }
            if (mR_MFC_DEFAULTS != null) {
                this.mfcDisablePowerSavings = mR_MFC_DEFAULTS.getdisablePowerSavings();
            }
        }
        this.m_createDriveGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DriveGroupsTreePanel.this.m_rootNode.getChildCount();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DriveGroupsTreePanel.this.m_rootNode.getChildAt(n - 1);
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DriveGroup) {
                    DriveGroup driveGroup = (DriveGroup)object;
                    if (((SASAdapter)DriveGroupsTreePanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)DriveGroupsTreePanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                        try {
                            MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)DriveGroupsTreePanel.this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                            if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                                if (driveGroup.getRaidLevel() == 17 && defaultMutableTreeNode.getChildCount() % 2 == 1 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_RAID1E_WARNING", "The virtual dirve cannot be migrated to MegaRAID controller. Do you want to continue?"))) {
                                    int n2;
                                    int n3 = defaultMutableTreeNode.getChildCount();
                                    ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
                                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DriveGroupsTreePanel.this.m_driveGroupsTree.getModel();
                                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n3];
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        defaultMutableTreeNodeArray[n2] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                                        PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n2].getUserObject();
                                        physicalDriveHelper.setAsDedicatedHotSpare(false);
                                        if (arrayList.contains(physicalDriveHelper)) continue;
                                        arrayList.add(physicalDriveHelper);
                                    }
                                    DriveGroupsTreePanel.this.m_UnconfGoodPdList.addAll(arrayList);
                                    DriveGroupsTreePanel.this.m_unconfGoodPdTableModel.updateModel(DriveGroupsTreePanel.this.m_UnconfGoodPdList);
                                    if (!driveGroup.isCompleted()) {
                                        for (n2 = 0; n2 < n3; ++n2) {
                                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n2]);
                                        }
                                        DriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                                        DriveGroupsTreePanel.this.m_powerSettingsCombobox.setEnabled((DriveGroupsTreePanel.this.mfcDisablePowerSavings & 8) != 8);
                                        DriveGroupsTreePanel.this.m_protectionCombobox.setEnabled(true);
                                        if (DriveGroupsTreePanel.this.m_PdTableToTreePanel != null) {
                                            ((RaidLevelComboBoxModel)DriveGroupsTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(DriveGroupsTreePanel.this.m_PdTableToTreePanel.getUnconfiguredDrivesGrouping().getMaxGroupPdCount());
                                        }
                                        DriveGroupsTreePanel.this.m_driveSecurityComboBox.setEnabled(DriveGroupsTreePanel.this.m_adapterHelper.isSecuritySupported() && DriveGroupsTreePanel.this.m_adapterHelper.isLockKeyAssigned());
                                        DriveGroupsTreePanel.this.m_raidLevelComboBox.setSelectedIndex(0);
                                        if (DriveGroupsTreePanel.this.m_rootNode.getChildCount() > 1) {
                                            DriveGroupsTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                        }
                                        DriveGroupsTreePanel.this.m_unconfDrivesDisabler.reset();
                                    }
                                    return;
                                }
                            } else if (driveGroup.getRaidLevel() == 1 && defaultMutableTreeNode.getChildCount() > 2 && defaultMutableTreeNode.getChildCount() % 2 == 1 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_RAID1E_WARNING", "The virtual dirve cannot be migrated to MegaRAID controller. Do you want to continue?"))) {
                                int n4;
                                int n5 = defaultMutableTreeNode.getChildCount();
                                ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
                                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DriveGroupsTreePanel.this.m_driveGroupsTree.getModel();
                                DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n5];
                                for (n4 = 0; n4 < n5; ++n4) {
                                    defaultMutableTreeNodeArray[n4] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n4);
                                    PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n4].getUserObject();
                                    physicalDriveHelper.setAsDedicatedHotSpare(false);
                                    if (arrayList.contains(physicalDriveHelper)) continue;
                                    arrayList.add(physicalDriveHelper);
                                }
                                DriveGroupsTreePanel.this.m_UnconfGoodPdList.addAll(arrayList);
                                DriveGroupsTreePanel.this.m_unconfGoodPdTableModel.updateModel(DriveGroupsTreePanel.this.m_UnconfGoodPdList);
                                if (!driveGroup.isCompleted()) {
                                    for (n4 = 0; n4 < n5; ++n4) {
                                        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n4]);
                                    }
                                    DriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                                    DriveGroupsTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                    DriveGroupsTreePanel.this.m_protectionCombobox.setEnabled(true);
                                    if (DriveGroupsTreePanel.this.m_PdTableToTreePanel != null) {
                                        ((RaidLevelComboBoxModel)DriveGroupsTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(DriveGroupsTreePanel.this.m_PdTableToTreePanel.getUnconfiguredDrivesGrouping().getMaxGroupPdCount());
                                    }
                                    DriveGroupsTreePanel.this.m_driveSecurityComboBox.setEnabled(DriveGroupsTreePanel.this.m_adapterHelper.isSecuritySupported() && DriveGroupsTreePanel.this.m_adapterHelper.isLockKeyAssigned());
                                    DriveGroupsTreePanel.this.m_raidLevelComboBox.setSelectedIndex(0);
                                    if (DriveGroupsTreePanel.this.m_rootNode.getChildCount() > 1) {
                                        DriveGroupsTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                    }
                                    DriveGroupsTreePanel.this.m_unconfDrivesDisabler.reset();
                                }
                                return;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (((SASAdapter)DriveGroupsTreePanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                        Object object2;
                        int n6;
                        if ((Byte)DriveGroupsTreePanel.this.m_driveSecurityComboBox.getSelectedItem() != 1) {
                            n6 = defaultMutableTreeNode.getChildCount();
                            if (!DriveGroupsTreePanel.this.showWarning) {
                                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DriveGroupsTreePanel.this.m_driveGroupsTree.getModel();
                                object2 = new DefaultMutableTreeNode[n6];
                                block6: for (int i = 0; i < n6; ++i) {
                                    object2[i] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                                    if (object2[i].getUserObject() instanceof Span) {
                                        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[object2[i].getChildCount()];
                                        for (int j = 0; j < object2[i].getChildCount(); ++j) {
                                            defaultMutableTreeNodeArray[j] = (DefaultMutableTreeNode)object2[i].getChildAt(j);
                                            if (!((PhysicalDriveHelper)defaultMutableTreeNodeArray[j].getUserObject()).isEncrypted()) continue;
                                            DriveGroupsTreePanel.this.showWarning = true;
                                            continue block6;
                                        }
                                        continue;
                                    }
                                    if (!(object2[i].getUserObject() instanceof PhysicalDriveHelper) || !((PhysicalDriveHelper)object2[i].getUserObject()).isEncrypted()) continue;
                                    DriveGroupsTreePanel.this.showWarning = true;
                                    break;
                                }
                            }
                            if (DriveGroupsTreePanel.this.showWarning) {
                                DriveGroupsTreePanel.this.showWarning = false;
                                if (JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), 0, 2) == 1) {
                                    return;
                                }
                            }
                        }
                        if (DriveGroupsTreePanel.this.m_adapterHelper.isPowerSaveSupportedOnConfiguredDrives()) {
                            if ((DriveGroupsTreePanel.this.mfcDisablePowerSavings & 8) != 8) {
                                if ((Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem() != -2 && (Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem() != 0 && (Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem() != 1) {
                                    n6 = 1;
                                    int n7 = defaultMutableTreeNode.getChildCount();
                                    object2 = (DefaultTreeModel)DriveGroupsTreePanel.this.m_driveGroupsTree.getModel();
                                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n7];
                                    block8: for (int i = 0; i < n7; ++i) {
                                        defaultMutableTreeNodeArray[i] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                                        if (defaultMutableTreeNodeArray[i].getUserObject() instanceof Span) {
                                            DefaultMutableTreeNode[] defaultMutableTreeNodeArray2 = new DefaultMutableTreeNode[defaultMutableTreeNodeArray[i].getChildCount()];
                                            for (int j = 0; j < defaultMutableTreeNodeArray[i].getChildCount(); ++j) {
                                                defaultMutableTreeNodeArray2[j] = (DefaultMutableTreeNode)defaultMutableTreeNodeArray[i].getChildAt(j);
                                                if (((PhysicalDriveHelper)defaultMutableTreeNodeArray2[j].getUserObject()).isSSDDrive()) continue;
                                                n6 = 0;
                                                continue block8;
                                            }
                                            continue;
                                        }
                                        if (!(defaultMutableTreeNodeArray[i].getUserObject() instanceof PhysicalDriveHelper) || ((PhysicalDriveHelper)defaultMutableTreeNodeArray[i].getUserObject()).isSSDDrive()) continue;
                                        n6 = 0;
                                        break;
                                    }
                                    if (n6 == 1) {
                                        String string = null;
                                        string = (Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem() == 2 ? "Max" : "Max without Cache";
                                        Object[] objectArray = new Object[]{string};
                                        String string2 = MessageFormat.format(Resource.getString("DS_SSD_PS_WARNING"), objectArray);
                                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, string2, Resource.getString("DS_SSD_PS_WARNING_TITLE", "Power Save Mode - Confirmation"), 1);
                                        driveGroup.setPowerSavePolicy((byte)0);
                                    } else {
                                        driveGroup.setPowerSavePolicy((Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem());
                                    }
                                } else {
                                    driveGroup.setPowerSavePolicy((Byte)DriveGroupsTreePanel.this.m_powerSettingsCombobox.getSelectedItem());
                                }
                            } else {
                                driveGroup.setPowerSavePolicy((byte)0);
                            }
                        }
                    }
                    driveGroup.setPIEnable((Byte)DriveGroupsTreePanel.this.m_protectionCombobox.getSelectedItem() == 1);
                    if ((DriveGroupsTreePanel.this.mfcDisablePowerSavings & 8) != 8) {
                        DriveGroupsTreePanel.this.m_powerSettingsCombobox.setSelectedIndex(0);
                    }
                    DriveGroupsTreePanel.this.m_protectionCombobox.setSelectedIndex(0);
                    driveGroup.setTotalCapacityInBlocks(DriveGroupsTreePanel.this.getTotalCapacityInBlocks(defaultMutableTreeNode));
                    driveGroup.setAsCompleted(true);
                    defaultMutableTreeNode.setUserObject(driveGroup);
                    DriveGroupsTreePanel.this.m_driveGroupsTreeModel.nodeChanged(defaultMutableTreeNode);
                    if (driveGroup.getRaidLevel() > 17) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
                        Span span = (Span)defaultMutableTreeNode2.getUserObject();
                        span.setAsCompleted(true);
                    }
                    if (DriveGroupsTreePanel.this.m_PdTableToTreePanel != null) {
                        ((RaidLevelComboBoxModel)DriveGroupsTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(DriveGroupsTreePanel.this.m_PdTableToTreePanel.getUnconfiguredDrivesGrouping().getMaxGroupPdCount());
                    }
                    if (DriveGroupsTreePanel.this.m_UnconfGoodPdListSize == 0 || !DriveGroupsTreePanel.this.canMoreDgsBeCreated()) {
                        DriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                        DriveGroupsTreePanel.this.m_driveSecurityComboBox.setEnabled(false);
                        DriveGroupsTreePanel.this.m_powerSettingsCombobox.setEnabled((DriveGroupsTreePanel.this.mfcDisablePowerSavings & 8) != 8);
                        DriveGroupsTreePanel.this.m_protectionCombobox.setEnabled(false);
                    } else {
                        DriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                        DriveGroupsTreePanel.this.m_driveSecurityComboBox.setEnabled(DriveGroupsTreePanel.this.m_adapterHelper.isSecuritySupported() && DriveGroupsTreePanel.this.m_adapterHelper.isLockKeyAssigned());
                        DriveGroupsTreePanel.this.m_powerSettingsCombobox.setEnabled((DriveGroupsTreePanel.this.mfcDisablePowerSavings & 8) != 8);
                        DriveGroupsTreePanel.this.m_protectionCombobox.setEnabled(true);
                    }
                    pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = ((SASAdapter)DriveGroupsTreePanel.this.m_adapterHelper.getDeviceObject()).getInformation().getpdsForRaidLevels_MR_CTRL_INFO();
                    int n8 = defaultMutableTreeNode.getChildCount();
                    if (driveGroup.getRaidLevel() == 1 && n8 > pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1() && n8 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_1E_RLQ0()) {
                        driveGroup.setRaidLevel((byte)17);
                    }
                } else {
                    System.out.println("m_createDriveGroupButton.actionPerformed()");
                }
                DriveGroupsTreePanel.this.m_createDriveGroupButton.setEnabled(false);
                DriveGroupsTreePanel.this.m_createSpanButton.setEnabled(false);
                DriveGroupsTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                ((DriveSecurityComboBoxModel)DriveGroupsTreePanel.this.m_driveSecurityComboBox.getModel()).updateDriveSecurityModel(DriveGroupsTreePanel.this.isFDEPossible());
                ((AdvancedDriveGroupSettings.ProtectionComboBoxModel)DriveGroupsTreePanel.this.m_protectionCombobox.getModel()).updateModel(DriveGroupsTreePanel.this.isPICapablePossible());
                DriveGroupsTreePanel.this.m_protectionCombobox.setEnabled(DriveGroupsTreePanel.this.getPICapablePdCount() > 0);
                DriveGroupsTreePanel.this.m_unconfDrivesDisabler.reset();
            }
        });
        this.m_createSpanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = DriveGroupsTreePanel.this.getLastDgNode();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
                Span span = (Span)defaultMutableTreeNode2.getUserObject();
                span.setAsCompleted(true);
                DriveGroupsTreePanel.this.addSpanNodeToTree();
                if ((Byte)DriveGroupsTreePanel.this.m_driveSecurityComboBox.getSelectedItem() != 1) {
                    int n = defaultMutableTreeNode2.getChildCount();
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DriveGroupsTreePanel.this.m_driveGroupsTree.getModel();
                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n];
                    for (int i = 0; i < n; ++i) {
                        defaultMutableTreeNodeArray[i] = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                        PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[i].getUserObject();
                        if (!physicalDriveHelper.isEncrypted()) continue;
                        DriveGroupsTreePanel.this.showWarning = true;
                    }
                }
                DriveGroupsTreePanel.this.m_createSpanButton.setEnabled(false);
                DriveGroupsTreePanel.this.m_createDriveGroupButton.setEnabled(false);
                DriveGroupsTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
            }
        });
    }

    public void addPdNodeToTree(PhysicalDriveHelper physicalDriveHelper) {
        this.m_DefWizardPage.setNextButtonStatus(false);
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        byte by = driveGroup.getRaidLevel();
        if (by <= 17) {
            this.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode);
            this.m_createDriveGroupButton.setEnabled(this.isCreateDgButtonEnabled(defaultMutableTreeNode));
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
            this.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode2);
            this.m_createSpanButton.setEnabled(this.isCreateSpanButtonEnabled(defaultMutableTreeNode2));
            this.m_createDriveGroupButton.setEnabled(this.isCreateDgButtonEnabled(defaultMutableTreeNode));
        }
    }

    public int getFWDGCount() {
        ArrayHelper[] arrayHelperArray = this.m_adapterHelper.getArrays();
        int n = 0;
        for (int n2 = 0; n2 < arrayHelperArray.length; n2 = (int)((byte)(n2 + 1))) {
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelperArray[n2].getLogicalDriveHelpers();
            if (((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth() != '\u0001' || logicalDriveHelperArray[0].isSSCD()) continue;
            n = (byte)(n + 1);
        }
        return n;
    }

    public int getFWSpanCount() {
        ArrayHelper[] arrayHelperArray = this.m_adapterHelper.getArrays();
        ArrayList<Short> arrayList = new ArrayList<Short>();
        int n = 0;
        for (int n2 = 0; n2 < arrayHelperArray.length; n2 = (int)((byte)(n2 + 1))) {
            LogicalDriveHelper[] logicalDriveHelperArray = arrayHelperArray[n2].getLogicalDriveHelpers();
            if (((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth() <= '\u0001' || arrayList.contains(((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getID())) continue;
            arrayList.add(((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getID());
            n = (byte)(n + 1);
        }
        return n;
    }

    public int getExistingSpanCount() {
        int n = 0;
        int n2 = this.m_rootNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            if (!((DriveGroup)((DefaultMutableTreeNode)this.m_rootNode.getChildAt(i)).getUserObject()).getisSpan()) continue;
            n = (byte)(n + 1);
        }
        return n;
    }

    public int getExistingDgCount() {
        int n = 0;
        int n2 = this.m_rootNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            if (((DriveGroup)((DefaultMutableTreeNode)this.m_rootNode.getChildAt(i)).getUserObject()).getisSpan()) continue;
            n = (byte)(n + 1);
        }
        return n;
    }

    public void addDriveGroupNodeToTree() {
        DriveGroup driveGroup = new DriveGroup((byte)this.m_rootNode.getChildCount(), false);
        if (driveGroup.getisSpan()) {
            driveGroup.setDriveGroupId(this.getFWSpanCount() + this.getExistingSpanCount());
        } else {
            driveGroup.setDriveGroupId(this.getFWDGCount() + this.getExistingDgCount());
        }
        this.addDriveGroupNodeToTree(driveGroup);
    }

    public void addDriveGroupNodeToTree(DriveGroup driveGroup) {
        driveGroup.setAdapterHelper(this.m_adapterHelper);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(driveGroup);
        this.m_driveGroupsTreeModel.insertNodeInto(defaultMutableTreeNode, this.m_rootNode, this.m_rootNode.getChildCount());
        this.m_driveGroupsTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        DriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void addSpanNodeToTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        Span span = new Span(driveGroup, (byte)defaultMutableTreeNode.getChildCount());
        this.addSpanNodeToTree(span, defaultMutableTreeNode);
    }

    public void addSpanNodeToTree(Span span, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(span);
        this.m_driveGroupsTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.m_driveGroupsTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        DriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void addPdNodeToTree(PhysicalDriveHelper physicalDriveHelper, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_driveGroupsTreeModel.insertNodeInto(new DefaultMutableTreeNode(physicalDriveHelper), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        DriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void setEnabledCreateSpanButton(boolean bl) {
        this.m_createSpanButton.setEnabled(bl);
    }

    public void setEnabledCreateDriveGroupButton(boolean bl) {
        this.m_createDriveGroupButton.setEnabled(bl);
    }

    public int getDgCount() {
        return this.m_rootNode.getChildCount();
    }

    public JTree getDriveGroupsTree() {
        return this.m_driveGroupsTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.m_rootNode;
    }

    public DefaultMutableTreeNode getSelectedNodeFromTree() {
        TreePath treePath = this.m_driveGroupsTree.getLeadSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public DefaultMutableTreeNode getLastDgNode() {
        return (DefaultMutableTreeNode)this.m_rootNode.getChildAt(this.m_rootNode.getChildCount() - 1);
    }

    public DriveGroup getLastDgObject() {
        return (DriveGroup)this.getLastDgNode().getUserObject();
    }

    public DefaultMutableTreeNode getLastSpanNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        return (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
    }

    public Span getLastSpanObject() {
        return (Span)this.getLastSpanNode().getUserObject();
    }

    public DefaultMutableTreeNode getLastPdNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        if (this.getLastDgObject().getRaidLevel() <= 17) {
            return (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getLastSpanNode();
        return (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1);
    }

    public PhysicalDriveHelper getLastPdObject() {
        return (PhysicalDriveHelper)this.getLastPdNode().getUserObject();
    }

    public boolean isPreviousDgNodeCompleted() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(this.m_rootNode.getChildCount() - 1);
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        return driveGroup.isCompleted();
    }

    public boolean isCreateDgButtonEnabled(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        Object object;
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        if (driveGroup.getRaidLevel() <= 17) {
            return this.isCreateDgForPrlEnabled(defaultMutableTreeNode);
        }
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 == 1) {
            try {
                object = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                if (((MR_MFC_DEFAULTS)object).gettreatR1EAsR10() == 1 && VivaldiStartupDialog.OEM_TYPE == 2561 && driveGroup.getRaidLevel() == 65) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    n = defaultMutableTreeNode2.getChildCount();
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    if (defaultMutableTreeNode2.getChildCount() == 22 || defaultMutableTreeNode2.getChildCount() == 26) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (n2 < 2) {
            return false;
        }
        object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        int n3 = ((DefaultMutableTreeNode)object).getChildCount();
        for (n = 1; n < n2; ++n) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            if (((DefaultMutableTreeNode)object).getChildCount() == n3) continue;
            return false;
        }
        return true;
    }

    public boolean isCreateDgForPrlEnabled(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        switch (driveGroup.getRaidLevel()) {
            case 0: {
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_0() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_0()) break;
                return true;
            }
            case 1: {
                if ((((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) && n >= this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() && n <= this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) {
                    return true;
                }
                if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                    try {
                        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                        if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1 && (n == 22 || n == 26)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) break;
                    return true;
                }
                if ((n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) && (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() || n > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0()) || n % 2 != 0) break;
                return true;
            }
            case 17: {
                if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                    if (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() || n > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0()) break;
                    if (!this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                        return n % 2 != 1;
                    }
                    return !this.m_adapterHelper.treatRAID1EasRAID10() || n % 2 != 0;
                }
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1E() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1E()) break;
                return true;
            }
            case 16: {
                if (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() || n > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0() || n % 2 != 0) break;
                return true;
            }
            case 5: {
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_5()) break;
                return true;
            }
            case 6: {
                if (!(VivaldiStartupDialog.OEM_TYPE == 2561 ? n >= 4 : n >= this.m_pdsForRaidLevel.getMinPdRaidLevel_6())) break;
                return true;
            }
        }
        return false;
    }

    public boolean isCreateSpanButtonEnabled(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n2 = defaultMutableTreeNode2.getChildCount();
        if (n2 >= this.m_adapterHelper.getAdapterInfo().getmaxSpans()) {
            return false;
        }
        if (n2 == 1) {
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
            switch (driveGroup.getRaidLevel()) {
                case 64: {
                    if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_0()) break;
                    return true;
                }
                case 65: {
                    if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() || n % 2 != 0) break;
                    return true;
                }
                case 69: {
                    if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_5()) break;
                    return true;
                }
                case 70: {
                    if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                        return n >= 4;
                    }
                    if (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_6()) break;
                    return true;
                }
            }
        } else if (n2 > 1) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
            return defaultMutableTreeNode3.getChildCount() == n;
        }
        return false;
    }

    public boolean canPdsBeAdded(int n) {
        Object object;
        int n2 = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        int n3 = defaultMutableTreeNode.getChildCount();
        byte by = driveGroup.getRaidLevel();
        if (by <= 17) {
            n2 = n + n3;
        } else {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            int n4 = ((DefaultMutableTreeNode)object).getChildCount();
            if (n3 == 1) {
                n2 = n4 + n;
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3 - 1);
                n2 = defaultMutableTreeNode2.getChildCount() + n;
                return n2 <= n4;
            }
        }
        switch (by) {
            case 0: 
            case 64: {
                if (n2 > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_0()) break;
                return true;
            }
            case 1: 
            case 65: {
                if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                    if (n2 > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1() && n2 > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1E()) break;
                    return true;
                }
                if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                    try {
                        object = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                        if (((MR_MFC_DEFAULTS)object).gettreatR1EAsR10() == 0 ? n2 <= this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1() || n2 <= this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0() : n2 <= this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                if (n2 > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) break;
                return true;
            }
            case 17: {
                if (!(((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4 ? n2 <= this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0() : n2 <= this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1E())) break;
                return true;
            }
            case 16: {
                if (n2 <= this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0()) {
                    // empty if block
                }
                return true;
            }
            case 81: {
                if (n2 > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E0_RLQ0()) break;
                return true;
            }
            case 5: 
            case 69: {
                if (n2 > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_5()) break;
                return true;
            }
            case 6: 
            case 70: {
                if (n2 > this.m_pdsForRaidLevel.getMaxPdRaidLevel_6()) break;
                return true;
            }
        }
        return false;
    }

    public long getTotalCapacityInBlocks(DefaultMutableTreeNode defaultMutableTreeNode) {
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        byte by = driveGroup.getRaidLevel();
        long l = -1L;
        short s = 512;
        if (by <= 17) {
            int n = defaultMutableTreeNode.getChildCount();
            s = ((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getUserObject()).getUserDataBlockSize();
            driveGroup.setBlockSize(s);
            for (int i = 0; i < n; ++i) {
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                long l2 = ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getInformation().getcoercedSize();
                if (l >= 0L && l2 >= l) continue;
                l = l2;
            }
            switch (by) {
                case 0: {
                    return l * (long)n;
                }
                case 1: 
                case 17: {
                    return l * (long)n / 2L;
                }
                case 16: {
                    return l * (long)n / 2L;
                }
                case 5: {
                    return l * (long)(n - 1);
                }
                case 6: {
                    return l * (long)(n - 2);
                }
            }
        } else {
            int n = defaultMutableTreeNode.getChildCount();
            int n2 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getChildCount();
            s = ((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0).getChildAt(0)).getUserObject()).getUserDataBlockSize();
            driveGroup.setBlockSize(s);
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                for (int j = 0; j < n2; ++j) {
                    PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(j)).getUserObject();
                    long l3 = ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getInformation().getcoercedSize();
                    if (l >= 0L && l3 >= l) continue;
                    l = l3;
                }
            }
            switch (by) {
                case 64: {
                    return l * (long)n2 * (long)n;
                }
                case 65: {
                    return l * (long)n2 * (long)n / 2L;
                }
                case 69: {
                    return l * (long)(n2 - 1) * (long)n;
                }
                case 70: {
                    return l * (long)(n2 - 2) * (long)n;
                }
            }
        }
        return 0L;
    }

    public static void expandTree(JTree jTree) {
        int n = 0;
        do {
            jTree.expandRow(n);
        } while (++n < jTree.getRowCount());
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.m_driveGroupsTree.addTreeSelectionListener(treeSelectionListener);
    }

    public void setUnconfGoodPdListSize(int n) {
        this.m_UnconfGoodPdListSize = n;
    }

    public void setUnconfGoodPdList(ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_UnconfGoodPdList = arrayList;
        this.setUnconfGoodPdListSize(this.m_UnconfGoodPdList.size());
    }

    public void setUnconfiguredDrivesDisabler(UnconfiguredDrivesDisabler unconfiguredDrivesDisabler) {
        this.m_unconfDrivesDisabler = unconfiguredDrivesDisabler;
    }

    public void setUnconfGoodPdTableModel(UnconfiguredDrivesTableModel unconfiguredDrivesTableModel) {
        this.m_unconfGoodPdTableModel = unconfiguredDrivesTableModel;
    }

    public int getFDEPdCount() {
        int n = this.m_UnconfGoodPdListSize;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.m_UnconfGoodPdList.get(i).isFDECapable()) continue;
            ++n2;
        }
        return n2;
    }

    public int getPICapablePdCount() {
        int n = this.m_UnconfGoodPdListSize;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.m_UnconfGoodPdList.get(i).isPDPICapable()) continue;
            ++n2;
        }
        return n2;
    }

    public int getFDEandPIPdCount() {
        int n = this.m_UnconfGoodPdListSize;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.m_UnconfGoodPdList.get(i).isFDECapable() || !this.m_UnconfGoodPdList.get(i).isPDPICapable()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isFDEPICapablePossible() {
        int n = this.getFDEandPIPdCount();
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        switch ((Byte)this.m_raidLevelComboBox.getSelectedItem()) {
            case -1: {
                if (n <= 0) break;
                return true;
            }
            case 0: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0()) break;
                return true;
            }
            case 1: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) break;
                return true;
            }
            case 17: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) break;
                return true;
            }
            case 5: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) break;
                return true;
            }
            case 6: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6()) break;
                return true;
            }
            case 64: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0() * 2) break;
                return true;
            }
            case 65: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() * 2) break;
                return true;
            }
            case 69: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() * 2) break;
                return true;
            }
            case 70: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() * 2) break;
                return true;
            }
        }
        return false;
    }

    public boolean isPICapablePossible() {
        int n = this.getPICapablePdCount();
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        switch ((Byte)this.m_raidLevelComboBox.getSelectedItem()) {
            case -1: {
                if (n <= 0) break;
                return true;
            }
            case 0: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0()) break;
                return true;
            }
            case 1: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) break;
                return true;
            }
            case 17: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) break;
                return true;
            }
            case 16: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_10()) break;
                return true;
            }
            case 5: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) break;
                return true;
            }
            case 6: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6()) break;
                return true;
            }
            case 64: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0() * 2) break;
                return true;
            }
            case 65: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() * 2) break;
                return true;
            }
            case 69: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() * 2) break;
                return true;
            }
            case 70: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() * 2) break;
                return true;
            }
        }
        return false;
    }

    public boolean isFDEPossible() {
        int n = this.getFDEPdCount();
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        if (this.m_raidLevelComboBox.isEnabled()) {
            switch ((Byte)this.m_raidLevelComboBox.getSelectedItem()) {
                case -1: {
                    if (n <= 0) break;
                    return true;
                }
                case 0: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0()) break;
                    return true;
                }
                case 1: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) break;
                    return true;
                }
                case 17: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) break;
                    return true;
                }
                case 5: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) break;
                    return true;
                }
                case 6: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6()) break;
                    return true;
                }
                case 64: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0() * 2) break;
                    return true;
                }
                case 65: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() * 2) break;
                    return true;
                }
                case 69: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() * 2) break;
                    return true;
                }
                case 70: {
                    if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() * 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canMoreDgsBeCreated() {
        char c = this.m_adapterHelper.getAdapterInfo().getmaxArrays();
        int n = this.m_adapterHelper.getArrays().length;
        int n2 = 0;
        int n3 = this.m_rootNode.getChildCount();
        if (!this.getLastDgObject().isCompleted()) {
            --n3;
        }
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            if (driveGroup.getRaidLevel() <= 17) {
                ++n2;
                continue;
            }
            n2 += defaultMutableTreeNode.getChildCount();
        }
        return n2 + n < c;
    }

    public ArrayList<PhysicalDriveHelper> getPdListForSpanNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        for (int i = 0; i < n; ++i) {
            arrayList.add((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject());
        }
        return arrayList;
    }

    public void setPdTableToTreePanel(PDTableToTreePanel pDTableToTreePanel) {
        this.m_PdTableToTreePanel = pDTableToTreePanel;
    }
}

