/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.AdvancedDriveGroupSettings;
import GUI.venus.configuration.advanced.DedicatedHotSpare;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.DriveGroupsTreePanel;
import GUI.venus.configuration.advanced.DriveSecurityComboBoxModel;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.UnconfiguredDrivesDisabler;
import GUI.venus.configuration.advanced.UnconfiguredDrivesGrouping;
import GUI.venus.configuration.advanced.UnconfiguredDrivesTableModel;
import GUI.venus.configuration.advanced.UnconfiguredPdTableCellRender;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PDTableToTreePanel
extends JPanel {
    private AdapterHelper m_AdapterHelper = null;
    private JComboBox m_RaidLevelComboBox = null;
    private JComboBox m_DriveSecurityCombobox = null;
    private JComboBox m_powerSettingsCombobox = null;
    private JComboBox m_protectionCombobox = null;
    private DriveGroupsTreePanel m_DgTreePanel = null;
    private DefaultWizardPage m_DefWizardPage = null;
    private boolean m_isPdSelected = false;
    private ArrayList<PhysicalDriveHelper> m_unconfiguredGoodPdList = new ArrayList();
    private String[] mnemonics;
    private JTable m_unconfiguredDrivesTable = null;
    private UnconfiguredDrivesTableModel m_unconfGoodPdTableModel = null;
    private UnconfiguredDrivesDisabler m_unconfDriveDisabler = null;
    private UnconfiguredDrivesGrouping m_unconfDrivesGrouping = null;
    private JButton m_addButton = new JButton();
    private JButton m_addHotSpareButton = new JButton();
    private JButton m_removeButton = new JButton();
    private ArrayList<PhysicalDriveHelper> m_pdListForThisDriveGroup = new ArrayList();
    private AdvanceConfigEngine m_engine = null;

    public PDTableToTreePanel(AdvanceConfigEngine advanceConfigEngine, JComboBox jComboBox, JComboBox jComboBox2, DriveGroupsTreePanel driveGroupsTreePanel, DefaultWizardPage defaultWizardPage, JComboBox jComboBox3, JComboBox jComboBox4) {
        this.m_engine = advanceConfigEngine;
        this.m_AdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_RaidLevelComboBox = jComboBox;
        this.m_DriveSecurityCombobox = jComboBox2;
        this.m_powerSettingsCombobox = jComboBox3;
        this.m_protectionCombobox = jComboBox4;
        this.m_DgTreePanel = driveGroupsTreePanel;
        this.m_DefWizardPage = defaultWizardPage;
        this.m_DgTreePanel.addTreeSelectionListener(new DriveGroupTreeSelectionListener());
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_AdapterHelper.getUnconfiguredPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getInformation().getproperties_MR_PD_INFO().getIneligibleForLd() != 0) continue;
            this.m_unconfiguredGoodPdList.add(physicalDriveHelperArray[i]);
        }
        this.m_DgTreePanel.setUnconfGoodPdList(this.m_unconfiguredGoodPdList);
        this.m_unconfGoodPdTableModel = new UnconfiguredDrivesTableModel(this.m_unconfiguredGoodPdList);
        driveGroupsTreePanel.setUnconfGoodPdTableModel(this.m_unconfGoodPdTableModel);
        this.m_unconfDrivesGrouping = new UnconfiguredDrivesGrouping(this.m_AdapterHelper, this.m_unconfiguredGoodPdList);
        this.buildPanel();
        this.m_DgTreePanel.setPdTableToTreePanel(this);
    }

    public void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.m_unconfiguredDrivesTable = new JTable(this.m_unconfGoodPdTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                short s = ((PhysicalDriveHelper)this.getValueAt(n, n2)).getUserDataBlockSize();
                if (n2 == 0) {
                    return ((PhysicalDriveHelper)this.getValueAt(n, n2)).getTextForTable()[0];
                }
                if (n2 == 1) {
                    return this.getValueAt(n, n2).toString();
                }
                if (n2 == 2) {
                    return KernelConstants.getConvertedSize(((Long)this.getValueAt(n, n2)).longValue(), s);
                }
                return "";
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.m_unconfiguredDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.gridwidth = 3;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_UG_DRIVES", "Select (u)nconfigured drives:"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(jScrollPane);
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridwidth = 3;
        this.m_unconfDriveDisabler = new UnconfiguredDrivesDisabler(this.m_unconfiguredDrivesTable, this.m_AdapterHelper);
        this.m_DgTreePanel.setUnconfiguredDrivesDisabler(this.m_unconfDriveDisabler);
        this.m_unconfiguredDrivesTable.setShowGrid(false);
        this.m_unconfiguredDrivesTable.setCellSelectionEnabled(false);
        this.m_unconfiguredDrivesTable.setSelectionMode(2);
        this.m_unconfiguredDrivesTable.setRowSelectionAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoResizeMode(0);
        this.m_unconfiguredDrivesTable.setAutoscrolls(true);
        this.m_unconfiguredDrivesTable.setColumnSelectionAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoCreateRowSorter(true);
        ((TableRowSorter)this.m_unconfiguredDrivesTable.getRowSorter()).setSortable(0, false);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        UnconfiguredPdTableCellRender unconfiguredPdTableCellRender = new UnconfiguredPdTableCellRender();
        this.m_unconfiguredDrivesTable.setDefaultRenderer(PhysicalDriveHelper.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(String.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(Long.class, unconfiguredPdTableCellRender);
        class UnconfDrivesTableListSelectionListener
        implements ListSelectionListener {
            UnconfDrivesTableListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                PDTableToTreePanel.this.m_isPdSelected = true;
                int[] nArray = PDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                int n3 = 0;
                ArrayList<Integer> arrayList = PDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                for (n = 0; n < n2; ++n) {
                    if (arrayList != null && arrayList.contains(nArray[n])) {
                        ++n3;
                    }
                    nArray[n] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[n]);
                }
                if (n2 > 0 && (Byte)PDTableToTreePanel.this.m_DriveSecurityCombobox.getSelectedItem() != 1 && (arrayList == null || arrayList != null && !arrayList.contains(nArray[0]))) {
                    PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0]));
                    n = (Byte)PDTableToTreePanel.this.m_DriveSecurityCombobox.getSelectedItem() == 1 ? 1 : 0;
                    boolean bl = PDTableToTreePanel.this.m_protectionCombobox.getSelectedIndex() == 1;
                    PDTableToTreePanel.this.m_unconfDriveDisabler.protectedTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, n != 0, bl);
                }
                if ((Byte)PDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedItem() >= 0 && n3 != n2 && PDTableToTreePanel.this.m_DgTreePanel.canPdsBeAdded(n2 - n3)) {
                    PDTableToTreePanel.this.m_addButton.setEnabled(true);
                } else {
                    PDTableToTreePanel.this.m_addButton.setEnabled(false);
                }
                JTree jTree = PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree();
                TreePath treePath = jTree.getLeadSelectionPath();
                boolean bl = false;
                if (treePath != null && n2 == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof DriveGroup) {
                        if (((DriveGroup)object).isCompleted()) {
                            PhysicalDriveHelper physicalDriveHelper;
                            PDTableToTreePanel.this.m_addButton.setEnabled(false);
                            if (((DriveGroup)object).getRaidLevel() > 0 && ((DriveGroup)object).getRaidLevel() != 64 && PDTableToTreePanel.this.isPdEligibleForDHSP((SASPhysicalDrive)(physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0])).getDeviceObject(), defaultMutableTreeNode) && PDTableToTreePanel.this.canDhspButtonBeEnabled(1)) {
                                bl = true;
                            }
                        }
                    } else if (object instanceof Span) {
                        DefaultMutableTreeNode defaultMutableTreeNode2;
                        DriveGroup driveGroup;
                        if (((Span)object).isCompleted()) {
                            PDTableToTreePanel.this.m_addButton.setEnabled(false);
                        }
                        if ((driveGroup = (DriveGroup)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject()).isCompleted()) {
                            PhysicalDriveHelper physicalDriveHelper;
                            PDTableToTreePanel.this.m_addButton.setEnabled(false);
                            if (driveGroup.getRaidLevel() > 0 && driveGroup.getRaidLevel() != 64 && PDTableToTreePanel.this.isPdEligibleForDHSP((SASPhysicalDrive)(physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0])).getDeviceObject(), defaultMutableTreeNode) && PDTableToTreePanel.this.canDhspButtonBeEnabled(1)) {
                                bl = true;
                            }
                        }
                    }
                }
                PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(bl);
            }
        }
        this.m_unconfiguredDrivesTable.getSelectionModel().addListSelectionListener(new UnconfDrivesTableListSelectionListener());
        this.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_DRIVE", "(A)dd >"));
        this.m_addButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_addButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_addButton.setEnabled(false);
        jPanel.add(this.m_addButton);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_HSP", "Add H(o)t Spare >"));
        this.m_addHotSpareButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_addHotSpareButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_addHotSpareButton.setEnabled(false);
        jPanel.add(this.m_addHotSpareButton);
        if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 4 || this.m_AdapterHelper.isSWRController()) {
            this.m_addHotSpareButton.setVisible(false);
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_DRIVE", "< Remo(v)e"));
        this.m_removeButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_removeButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        jPanel.add(this.m_removeButton);
        this.add((Component)jPanel, gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                int[] nArray = PDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                ArrayList<Integer> arrayList = PDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                boolean bl = false;
                for (n = 0; n < n2; n += 1) {
                    bl = arrayList != null && arrayList.contains(nArray[n]);
                    nArray[n] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[n]);
                    if (bl) continue;
                    PDTableToTreePanel.this.m_pdListForThisDriveGroup.add(PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                }
                if (PDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0) {
                    for (n = 0; n < n2; n += 1) {
                        PDTableToTreePanel.this.m_pdListForThisDriveGroup.add(PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                    }
                }
                for (n = 0; n < PDTableToTreePanel.this.m_pdListForThisDriveGroup.size(); n += 1) {
                    PDTableToTreePanel.this.m_DgTreePanel.addPdNodeToTree((PhysicalDriveHelper)PDTableToTreePanel.this.m_pdListForThisDriveGroup.get(n));
                }
                PDTableToTreePanel.this.m_unconfiguredGoodPdList.removeAll(PDTableToTreePanel.this.m_pdListForThisDriveGroup);
                n = PDTableToTreePanel.this.m_protectionCombobox.getSelectedIndex() == 1 ? 1 : 0;
                boolean bl2 = false;
                if ((Byte)PDTableToTreePanel.this.m_DriveSecurityCombobox.getSelectedItem() == 1) {
                    bl2 = true;
                    PDTableToTreePanel.this.m_unconfDriveDisabler.driveSecurityTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, n != 0);
                }
                PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)PDTableToTreePanel.this.m_pdListForThisDriveGroup.get(0));
                PDTableToTreePanel.this.m_unconfDriveDisabler.protectedTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, bl2, n != 0);
                PDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
                PDTableToTreePanel.this.m_addButton.setEnabled(false);
                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                PDTableToTreePanel.this.m_isPdSelected = false;
            }
        });
        this.m_addHotSpareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = PDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n = nArray.length;
                if (n == 1) {
                    nArray[0] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[0]);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().getLeadSelectionPath().getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof DriveGroup) {
                        int n2;
                        int n3;
                        DriveGroup driveGroup = (DriveGroup)object;
                        PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0]);
                        if (physicalDriveHelper.isEncrypted() && JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), 0, 2) == 1) {
                            return;
                        }
                        if (((DriveGroup)object).getRaidLevel() <= 17) {
                            PDTableToTreePanel.this.m_DgTreePanel.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode);
                        } else {
                            n3 = defaultMutableTreeNode.getChildCount();
                            for (int i = 0; i < n3; ++i) {
                                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                                PDTableToTreePanel.this.m_DgTreePanel.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode2);
                            }
                        }
                        physicalDriveHelper.setAsDedicatedHotSpare(true);
                        n3 = defaultMutableTreeNode.getChildCount();
                        DedicatedHotSpare dedicatedHotSpare = new DedicatedHotSpare(physicalDriveHelper, driveGroup);
                        for (n2 = 0; n2 < n3; ++n2) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                            Object object2 = defaultMutableTreeNode3.getUserObject();
                            if (!(object2 instanceof Span)) {
                                driveGroup.addDedicatedHotspare(dedicatedHotSpare);
                                break;
                            }
                            Span span = (Span)object2;
                            dedicatedHotSpare.addSpan(span);
                            span.addDedicatedHotspare(dedicatedHotSpare);
                        }
                        PDTableToTreePanel.this.m_engine.addDedicatedHotSpare(dedicatedHotSpare);
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.remove(physicalDriveHelper);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        n2 = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem((byte)n2);
                    } else if (object instanceof Span) {
                        PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0]);
                        if (physicalDriveHelper.isEncrypted() && JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), 0, 2) == 1) {
                            return;
                        }
                        PDTableToTreePanel.this.m_DgTreePanel.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode);
                        physicalDriveHelper.setAsDedicatedHotSpare(true);
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.remove(physicalDriveHelper);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        Span span = (Span)object;
                        DedicatedHotSpare dedicatedHotSpare = new DedicatedHotSpare(physicalDriveHelper, span);
                        span.addDedicatedHotspare(dedicatedHotSpare);
                        PDTableToTreePanel.this.m_engine.addDedicatedHotSpare(dedicatedHotSpare);
                        byte by = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                    }
                    if (PDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0) {
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                        PDTableToTreePanel.this.m_addButton.setEnabled(false);
                    }
                    PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                    PDTableToTreePanel.this.m_addButton.setEnabled(false);
                    PDTableToTreePanel.this.m_isPdSelected = false;
                } else {
                    System.out.println("PDTableToTreePanel.buildPanel()");
                    System.out.println("no of pds selected for hotspare should be only one");
                }
                PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(false);
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                JTree jTree = PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DriveGroup) {
                    int n;
                    Object object2;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    Object object3 = defaultMutableTreeNode2.getUserObject();
                    DriveGroup driveGroup = (DriveGroup)object;
                    if (driveGroup.isHotSpareAssigned()) {
                        List<DedicatedHotSpare> list = driveGroup.getDHSPList();
                        for (int i = 0; i < list.size(); ++i) {
                            PDTableToTreePanel.this.m_engine.removedDedicatedHotSpare(list.get(i));
                        }
                    }
                    if (defaultMutableTreeNode.getChildCount() != 0 && driveGroup.getRaidLevel() > 17) {
                        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                            Object object4 = defaultMutableTreeNode3.getUserObject();
                            object2 = (Span)object4;
                            if (!((Span)object2).isHotSpareAssigned()) continue;
                            List<DedicatedHotSpare> list = ((Span)object2).getDedicatedHotSpares();
                            for (int j = 0; j < list.size(); ++j) {
                                PDTableToTreePanel.this.m_engine.removedDedicatedHotSpare(list.get(j));
                            }
                        }
                    }
                    if (object3 instanceof PhysicalDriveHelper) {
                        int n2;
                        int n3 = defaultMutableTreeNode.getChildCount();
                        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            defaultMutableTreeNodeArray[n2] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                            object2 = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n2].getUserObject();
                            ((PhysicalDriveHelper)object2).setAsDedicatedHotSpare(false);
                            if (PDTableToTreePanel.this.m_pdListForThisDriveGroup.contains(object2)) continue;
                            PDTableToTreePanel.this.m_pdListForThisDriveGroup.add(object2);
                        }
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.addAll(PDTableToTreePanel.this.m_pdListForThisDriveGroup);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        if (!((DriveGroup)object).isCompleted()) {
                            for (n2 = 0; n2 < n3; ++n2) {
                                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n2]);
                            }
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                            PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                            PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                            PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedIndex(0);
                            PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                            PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                        } else if (((DriveGroup)object).isCompleted()) {
                            DefaultMutableTreeNode defaultMutableTreeNode4 = PDTableToTreePanel.this.m_DgTreePanel.getLastDgNode();
                            byte by = -1;
                            if (((DriveGroup)defaultMutableTreeNode4.getUserObject()).isCompleted()) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                by = -1;
                                PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                            } else {
                                by = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                                if (defaultMutableTreeNode4.getChildCount() == 0) {
                                    PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                    PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                    PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                    ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                    PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                    PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                    PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                                } else {
                                    PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                    PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                                    PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                                    PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                                    PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                                    PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)PDTableToTreePanel.this.m_pdListForThisDriveGroup.get(0));
                                }
                            }
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                    } else if (object3 instanceof Span) {
                        int n4;
                        int n5 = defaultMutableTreeNode.getChildCount();
                        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            defaultMutableTreeNodeArray[n4] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n4);
                            int n6 = defaultMutableTreeNodeArray[n4].getChildCount();
                            for (int i = 0; i < n6; ++i) {
                                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNodeArray[n4].getChildAt(i)).getUserObject();
                                physicalDriveHelper.setAsDedicatedHotSpare(false);
                                if (PDTableToTreePanel.this.m_pdListForThisDriveGroup.contains(physicalDriveHelper)) continue;
                                PDTableToTreePanel.this.m_pdListForThisDriveGroup.add(physicalDriveHelper);
                            }
                        }
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.addAll(PDTableToTreePanel.this.m_pdListForThisDriveGroup);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        if (!((DriveGroup)object).isCompleted()) {
                            for (n4 = 0; n4 < n5; ++n4) {
                                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n4]);
                            }
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedIndex(0);
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                            PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                            ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                            PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                            PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                            PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                        } else if (((DriveGroup)object).isCompleted()) {
                            DefaultMutableTreeNode defaultMutableTreeNode5 = PDTableToTreePanel.this.m_DgTreePanel.getLastDgNode();
                            byte by = -1;
                            if (((DriveGroup)defaultMutableTreeNode5.getUserObject()).isCompleted()) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                by = -1;
                                PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                            } else {
                                by = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                                if (by <= 17) {
                                    if (defaultMutableTreeNode5.getChildCount() == 0) {
                                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                        PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                                    } else {
                                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.raidLevelTrigger(PDTableToTreePanel.this.m_unconfDrivesGrouping, by);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)PDTableToTreePanel.this.m_pdListForThisDriveGroup.get(0));
                                    }
                                } else {
                                    DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode5.getChildAt(0);
                                    if (defaultMutableTreeNode6.getChildCount() == 0) {
                                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                        PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                                    } else {
                                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                                        PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.raidLevelTrigger(PDTableToTreePanel.this.m_unconfDrivesGrouping, by);
                                        PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)PDTableToTreePanel.this.m_pdListForThisDriveGroup.get(0));
                                    }
                                }
                            }
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode7 = PDTableToTreePanel.this.m_DgTreePanel.getRootNode();
                    int n7 = defaultMutableTreeNode7.getChildCount();
                    int n8 = 0;
                    int n9 = 0;
                    for (n = 0; n < n7; ++n) {
                        DefaultMutableTreeNode defaultMutableTreeNode8 = (DefaultMutableTreeNode)defaultMutableTreeNode7.getChildAt(n);
                        DriveGroup driveGroup2 = (DriveGroup)defaultMutableTreeNode8.getUserObject();
                        if (driveGroup2.getisSpan()) {
                            driveGroup2.setDriveGroupId(PDTableToTreePanel.this.m_DgTreePanel.getFWSpanCount() + n9);
                            ++n9;
                        } else {
                            driveGroup2.setDriveGroupId(PDTableToTreePanel.this.m_DgTreePanel.getFWDGCount() + n8);
                            ++n8;
                        }
                        if (n != n7 - 1) continue;
                        if (defaultMutableTreeNode8.getChildCount() == 0) {
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                            PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                            ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                            PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                            continue;
                        }
                        DefaultMutableTreeNode defaultMutableTreeNode9 = (DefaultMutableTreeNode)defaultMutableTreeNode8.getChildAt(0);
                        Object object5 = defaultMutableTreeNode9.getUserObject();
                        if (!(object5 instanceof Span) || defaultMutableTreeNode9.getChildCount() != 0) continue;
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                    }
                    PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(PDTableToTreePanel.this.m_DgTreePanel.getLastDgNode().getPath()));
                    n = ((Byte)PDTableToTreePanel.this.m_DriveSecurityCombobox.getSelectedItem()).byteValue();
                    ((DriveSecurityComboBoxModel)PDTableToTreePanel.this.m_DriveSecurityCombobox.getModel()).updateDriveSecurityModel(PDTableToTreePanel.this.m_DgTreePanel.isFDEPossible());
                    PDTableToTreePanel.this.m_DriveSecurityCombobox.setSelectedItem((byte)n);
                    ((AdvancedDriveGroupSettings.ProtectionComboBoxModel)PDTableToTreePanel.this.m_protectionCombobox.getModel()).updateModel(PDTableToTreePanel.this.m_DgTreePanel.isPICapablePossible());
                    PDTableToTreePanel.this.m_protectionCombobox.setSelectedItem((byte)((Byte)PDTableToTreePanel.this.m_protectionCombobox.getSelectedItem()));
                    PDTableToTreePanel.this.m_engine.removeDriveGroup((DriveGroup)object);
                    if (PDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 1 && PDTableToTreePanel.this.m_DgTreePanel.isPreviousDgNodeCompleted()) {
                        PDTableToTreePanel.this.m_DgTreePanel.addDriveGroupNodeToTree();
                        if (PDTableToTreePanel.this.m_DgTreePanel.getLastDgNode().getChildCount() == 0) {
                            PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                        }
                    }
                } else if (object instanceof Span) {
                    Span span;
                    DefaultMutableTreeNode defaultMutableTreeNode10;
                    DefaultMutableTreeNode defaultMutableTreeNode11;
                    int n;
                    DefaultMutableTreeNode defaultMutableTreeNode12 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    int n10 = defaultMutableTreeNode.getChildCount();
                    PhysicalDriveHelper physicalDriveHelper = null;
                    for (n = 0; n < n10; ++n) {
                        physicalDriveHelper = (PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n)).getUserObject();
                        physicalDriveHelper.setAsDedicatedHotSpare(false);
                        if (PDTableToTreePanel.this.m_pdListForThisDriveGroup.contains(physicalDriveHelper)) continue;
                        PDTableToTreePanel.this.m_pdListForThisDriveGroup.add(physicalDriveHelper);
                    }
                    PDTableToTreePanel.this.m_unconfiguredGoodPdList.addAll(PDTableToTreePanel.this.m_pdListForThisDriveGroup);
                    PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                    n = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                    int n11 = defaultMutableTreeNode12.getChildCount();
                    boolean bl = false;
                    if (defaultMutableTreeNode12.getChildCount() > 0 && (defaultMutableTreeNode11 = PDTableToTreePanel.this.m_DgTreePanel.getLastSpanNode()).getChildCount() == 0) {
                        for (int i = 0; i < n11; ++i) {
                            defaultMutableTreeNode10 = (DefaultMutableTreeNode)defaultMutableTreeNode12.getChildAt(i);
                            span = (Span)defaultMutableTreeNode10.getUserObject();
                            span.setSpanId((byte)i);
                        }
                        DefaultMutableTreeNode defaultMutableTreeNode13 = (DefaultMutableTreeNode)defaultMutableTreeNode12.getChildAt(n11 - 1);
                        PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode13.getPath()));
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem((byte)n);
                        PDTableToTreePanel.this.m_unconfDriveDisabler.raidLevelTrigger(PDTableToTreePanel.this.m_unconfDrivesGrouping, (byte)n);
                        bl = true;
                    }
                    if (n11 == 0) {
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedIndex(0);
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                        PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                        PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode12.getPath()));
                        PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateSpanButton(false);
                    } else if (!bl) {
                        PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateDriveGroupButton(PDTableToTreePanel.this.m_DgTreePanel.isCreateDgButtonEnabled(defaultMutableTreeNode12));
                        defaultMutableTreeNode11 = (DefaultMutableTreeNode)defaultMutableTreeNode12.getChildAt(n11 - 1);
                        PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateSpanButton(PDTableToTreePanel.this.m_DgTreePanel.isCreateSpanButtonEnabled(defaultMutableTreeNode11));
                        for (int i = 0; i < n11; ++i) {
                            defaultMutableTreeNode10 = (DefaultMutableTreeNode)defaultMutableTreeNode12.getChildAt(i);
                            span = (Span)defaultMutableTreeNode10.getUserObject();
                            span.setSpanId((byte)i);
                        }
                        PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode11.getPath()));
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem((byte)n);
                        if (n10 > 0 && physicalDriveHelper != null) {
                            PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, physicalDriveHelper);
                        } else if (PDTableToTreePanel.this.m_DgTreePanel.getLastPdObject() != null) {
                            PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, PDTableToTreePanel.this.m_DgTreePanel.getLastPdObject());
                        }
                    }
                } else if (object instanceof PhysicalDriveHelper) {
                    if (((PhysicalDriveHelper)object).isDedicatedHotSpare()) {
                        int n;
                        Object object6;
                        PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)object;
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.add(physicalDriveHelper);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        physicalDriveHelper.setAsDedicatedHotSpare(false);
                        byte by = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                        DefaultMutableTreeNode defaultMutableTreeNode14 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        Object object7 = defaultMutableTreeNode14.getUserObject();
                        if (object7 instanceof DriveGroup) {
                            DriveGroup driveGroup = (DriveGroup)object7;
                            if (driveGroup.isHotSpareAssigned()) {
                                object6 = driveGroup.getDHSPList();
                                for (int i = 0; i < object6.size(); ++i) {
                                    if (!physicalDriveHelper.equals(((DedicatedHotSpare)object6.get(i)).getPhysicalDriveHelper())) continue;
                                    PDTableToTreePanel.this.m_engine.removedDedicatedHotSpare((DedicatedHotSpare)object6.get(i));
                                    if (driveGroup.getSpanDepth() == 1) {
                                        List<Span> list = driveGroup.getSpans();
                                        list.get(0).removeDedicatedHotspare((DedicatedHotSpare)object6.get(i));
                                    }
                                    driveGroup.removeDedicatedHotspare((DedicatedHotSpare)object6.get(i));
                                    break;
                                }
                            }
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        } else if (object7 instanceof Span) {
                            int n12;
                            List<Object> list;
                            Object object8;
                            int n13;
                            boolean bl = true;
                            object6 = (DefaultMutableTreeNode)defaultMutableTreeNode14.getParent();
                            Object object9 = ((DefaultMutableTreeNode)object6).getUserObject();
                            if (((DefaultMutableTreeNode)object6).getChildCount() != 0) {
                                block13: for (n13 = 0; n13 < ((DefaultMutableTreeNode)object6).getChildCount(); ++n13) {
                                    DefaultMutableTreeNode defaultMutableTreeNode15 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object6).getChildAt(n13);
                                    object8 = defaultMutableTreeNode15.getUserObject();
                                    Span span = (Span)object8;
                                    if (!span.isHotSpareAssigned()) continue;
                                    list = span.getDedicatedHotSpares();
                                    for (n12 = 0; n12 < list.size(); ++n12) {
                                        if (!physicalDriveHelper.equals(((DedicatedHotSpare)list.get(n12)).getPhysicalDriveHelper())) continue;
                                        if (bl) {
                                            PDTableToTreePanel.this.m_engine.removedDedicatedHotSpare((DedicatedHotSpare)list.get(n12));
                                            bl = false;
                                        }
                                        span.removeDedicatedHotspare((DedicatedHotSpare)list.get(n12));
                                        continue block13;
                                    }
                                }
                            }
                            n13 = ((DefaultMutableTreeNode)object6).getChildCount();
                            block15: for (n = 0; n < n13; ++n) {
                                object8 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object6).getChildAt(n);
                                int n14 = ((DefaultMutableTreeNode)object8).getChildCount();
                                list = PDTableToTreePanel.this.m_DgTreePanel.getPdListForSpanNode((DefaultMutableTreeNode)object8);
                                if (!((ArrayList)list).contains(physicalDriveHelper)) continue;
                                for (n12 = 0; n12 < n14; ++n12) {
                                    DefaultMutableTreeNode defaultMutableTreeNode16 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object8).getChildAt(n12);
                                    PhysicalDriveHelper physicalDriveHelper2 = (PhysicalDriveHelper)defaultMutableTreeNode16.getUserObject();
                                    if (!physicalDriveHelper2.equals(physicalDriveHelper)) continue;
                                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode16);
                                    continue block15;
                                }
                            }
                        }
                        ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                        PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode14.getPath()));
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                        List<DedicatedHotSpare> list = PDTableToTreePanel.this.m_engine.getDedicatedHotSpares();
                        boolean bl = false;
                        DedicatedHotSpare dedicatedHotSpare = null;
                        if (list != null && !list.isEmpty()) {
                            for (int n15 = 0; n15 < list.size(); n15 = (int)((byte)(n15 + 1))) {
                                dedicatedHotSpare = list.get(n15);
                                if (!dedicatedHotSpare.getPhysicalDriveHelper().equals((PhysicalDriveHelper)object)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                List<Span> list2 = dedicatedHotSpare.getSpans();
                                if (list2 != null && list2.size() > 0) {
                                    for (n = 0; n < list2.size(); n = (int)((byte)(n + 1))) {
                                        list2.get(n).removeDedicatedHotspare(dedicatedHotSpare);
                                        dedicatedHotSpare.removeSpan(list2.get(n));
                                    }
                                }
                                PDTableToTreePanel.this.m_engine.removedDedicatedHotSpare(dedicatedHotSpare);
                            }
                        }
                    } else {
                        PDTableToTreePanel.this.m_unconfiguredGoodPdList.add((PhysicalDriveHelper)object);
                        PDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfDrivesGrouping.updateUnconfDriveGroups(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        PDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(PDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        ((PhysicalDriveHelper)object).setAsDedicatedHotSpare(false);
                        byte by = PDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                        DefaultMutableTreeNode defaultMutableTreeNode17 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        Object object10 = defaultMutableTreeNode17.getUserObject();
                        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        if (object10 instanceof DriveGroup) {
                            PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateDriveGroupButton(PDTableToTreePanel.this.m_DgTreePanel.isCreateDgButtonEnabled(defaultMutableTreeNode17));
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(((DriveGroup)object10).getRaidLevel());
                            if (defaultMutableTreeNode17.getChildCount() == 0) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                                if (PDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 0) {
                                    PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                                } else {
                                    PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                }
                            }
                        } else if (object10 instanceof Span) {
                            DefaultMutableTreeNode defaultMutableTreeNode18 = (DefaultMutableTreeNode)defaultMutableTreeNode17.getParent();
                            PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateDriveGroupButton(PDTableToTreePanel.this.m_DgTreePanel.isCreateDgButtonEnabled(defaultMutableTreeNode18));
                            PDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateSpanButton(PDTableToTreePanel.this.m_DgTreePanel.isCreateSpanButtonEnabled(defaultMutableTreeNode17));
                            PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(((DriveGroup)defaultMutableTreeNode18.getUserObject()).getRaidLevel());
                            if (defaultMutableTreeNode17.getChildCount() == 0 && defaultMutableTreeNode18.getChildCount() == 1) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                ((RaidLevelComboBoxModel)PDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(PDTableToTreePanel.this.m_unconfDrivesGrouping.getMaxGroupPdCount());
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                                PDTableToTreePanel.this.m_unconfDriveDisabler.reset();
                            }
                        }
                        PDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode17.getPath()));
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                        if (defaultMutableTreeNode17.getChildCount() != 0) {
                            PDTableToTreePanel.this.m_unconfDriveDisabler.driveMixingTrigger(PDTableToTreePanel.this.m_unconfiguredGoodPdList, (PhysicalDriveHelper)object);
                        }
                    }
                }
                PDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
            }
        });
    }

    public UnconfiguredDrivesDisabler getUnconfiguredDrivesDisabler() {
        return this.m_unconfDriveDisabler;
    }

    public UnconfiguredDrivesGrouping getUnconfiguredDrivesGrouping() {
        return this.m_unconfDrivesGrouping;
    }

    public int getUnconfiguredGoodPdListSize() {
        return this.m_unconfiguredGoodPdList.size();
    }

    public ArrayList<PhysicalDriveHelper> getUnconfiguredGoodPdList() {
        return this.m_unconfiguredGoodPdList;
    }

    private ArrayList<PhysicalDriveHelper> getUnconfiguredGoodPdHelpersList(PhysicalDriveHelper[] physicalDriveHelperArray) {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            char c = sASPhysicalDrive.getInformation().getnotSupported();
            if (sASPhysicalDrive.getState() != 0 || pdType_MR_PD_INFO2.getisForeign() == 1 || c != '\u0000') continue;
            arrayList.add(physicalDriveHelperArray[i]);
        }
        return arrayList;
    }

    public void setEnabledAddButton(boolean bl) {
        this.m_addButton.setEnabled(bl);
    }

    public void setEnabledAddHotSpareButton(boolean bl) {
        this.m_addHotSpareButton.setEnabled(bl);
    }

    public void setEnabledRemoveButton(boolean bl) {
        this.m_removeButton.setEnabled(bl);
    }

    public boolean isPdSelectedFromTable() {
        return this.m_isPdSelected;
    }

    public boolean isPdEligibleForDHSP(SASPhysicalDrive sASPhysicalDrive, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        int n2;
        DriveGroup driveGroup;
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        Object object = defaultMutableTreeNode.getUserObject();
        int n3 = defaultMutableTreeNode.getChildCount();
        boolean bl = false;
        int n4 = -1;
        if (object instanceof DriveGroup) {
            driveGroup = (DriveGroup)object;
            n4 = driveGroup.getEncrptionMethod();
            if (driveGroup.getRaidLevel() > 17) {
                bl = true;
            }
        } else if (object instanceof Span) {
            bl = false;
            driveGroup = (DriveGroup)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            n4 = driveGroup.getEncrptionMethod();
        }
        if (bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                int n5 = defaultMutableTreeNode2.getChildCount();
                for (n = 0; n < n5; ++n) {
                    arrayList.add((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n)).getUserObject());
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2)).getUserObject());
            }
        }
        n2 = sASPhysicalDrive.getMediatype();
        short s = sASPhysicalDrive.getInformation().getUserDataBlockSize();
        MR_CTRL_INFO mR_CTRL_INFO = this.m_AdapterHelper.getAdapterInfo();
        n = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
        int n6 = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
        int n7 = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
        boolean bl2 = this.isFDEOnlyDriveGroup(arrayList);
        long l = -1L;
        int n8 = arrayList.size();
        for (int i = 0; i < n8; ++i) {
            PhysicalDriveHelper physicalDriveHelper = arrayList.get(i);
            SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
            byte by = sASPhysicalDrive2.getMediatype();
            long l2 = sASPhysicalDrive2.getInformation().getcoercedSize();
            if (l < 0L || l2 < l) {
                l = l2;
            }
            if (sASPhysicalDrive2.getInformation().getUserDataBlockSize() != s) {
                return false;
            }
            if (!(by == 0 && n2 == 0 ? n6 == 0 && sASPhysicalDrive2.getDriveType() != sASPhysicalDrive.getDriveType() : (by == 0 && n2 == 1 ? n == 0 : (by == 1 && n2 == 0 ? n == 0 : by == 1 && n2 == 1 && n7 == 0 && sASPhysicalDrive2.getDriveType() != sASPhysicalDrive.getDriveType())))) continue;
            return false;
        }
        if (mR_CTRL_INFO.getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned() && (n4 == 0 ? bl2 && sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured() : bl2 && !sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable())) {
            return false;
        }
        return sASPhysicalDrive.getInformation().getcoercedSize() >= l;
    }

    public boolean isFDEOnlyDriveGroup(ArrayList<PhysicalDriveHelper> arrayList) {
        int n = arrayList.size();
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(n2).getDeviceObject();
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            return false;
        }
        return true;
    }

    public boolean canDhspButtonBeEnabled(int n) {
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_AdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        int n2 = this.m_unconfiguredGoodPdList.size() - n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_DgTreePanel.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        if (driveGroup.isCompleted()) {
            return true;
        }
        int n3 = 0;
        if (driveGroup.getRaidLevel() <= 17) {
            n3 = defaultMutableTreeNode.getChildCount() + n2;
            switch (driveGroup.getRaidLevel()) {
                case 0: {
                    return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0();
                }
                case 1: {
                    return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1();
                }
                case 17: {
                    return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E();
                }
                case 5: {
                    return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5();
                }
                case 6: {
                    return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6();
                }
            }
        } else {
            int n4 = defaultMutableTreeNode.getChildCount();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            if (n4 == 1) {
                n3 = defaultMutableTreeNode2.getChildCount() + n2;
                switch (driveGroup.getRaidLevel()) {
                    case 64: {
                        return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0() * 2;
                    }
                    case 65: {
                        return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() * 2;
                    }
                    case 69: {
                        return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() * 2;
                    }
                    case 70: {
                        return n3 >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() * 2;
                    }
                }
            } else if (n4 > 1) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n4 - 1);
                return n2 + defaultMutableTreeNode3.getChildCount() >= defaultMutableTreeNode2.getChildCount();
            }
        }
        return true;
    }

    public void reset() {
        this.m_unconfiguredDrivesTable.clearSelection();
        this.m_isPdSelected = false;
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            Serializable serializable;
            Object object2;
            if (PDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 1 && !((DriveGroup)(object2 = (DriveGroup)((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)PDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildAt(0))).getUserObject())).isCompleted()) {
                PDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
            }
            if ((object = ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)((TreePath)(serializable = treeSelectionEvent.getPath())).getLastPathComponent())).getUserObject()) instanceof AdapterHelper) {
                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(false);
                PDTableToTreePanel.this.m_removeButton.setEnabled(false);
            } else if (object instanceof DriveGroup) {
                int n;
                DriveGroup driveGroup = (DriveGroup)object;
                if (driveGroup.isCompleted()) {
                    PDTableToTreePanel.this.m_powerSettingsCombobox.setSelectedItem(driveGroup.getPowerSavePolicy());
                    PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                } else if (PDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() != 1) {
                    PDTableToTreePanel.this.m_powerSettingsCombobox.setSelectedIndex(0);
                }
                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                int n2 = ((DefaultMutableTreeNode)object2).getChildCount();
                if (!((DriveGroup)object).isCompleted()) {
                    PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                } else {
                    PDTableToTreePanel.this.m_removeButton.setEnabled(true);
                }
                int[] nArray = PDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n3 = nArray.length;
                int n4 = 0;
                ArrayList<Integer> arrayList = PDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                for (n = 0; n < n3; ++n) {
                    if (arrayList != null && arrayList.contains(nArray[n])) {
                        ++n4;
                    }
                    nArray[n] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[n]);
                }
                if (PDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedIndex() != -1) {
                    n = 0;
                    if (((DriveGroup)object).isCompleted()) {
                        PDTableToTreePanel.this.m_addButton.setEnabled(false);
                        PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                        PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                        PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                        PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                        if (((DriveGroup)object).getRaidLevel() > 0 && ((DriveGroup)object).getRaidLevel() != 64 && n3 == 1) {
                            nArray[0] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[0]);
                            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0]);
                            if (PDTableToTreePanel.this.isPdEligibleForDHSP((SASPhysicalDrive)physicalDriveHelper.getDeviceObject(), (DefaultMutableTreeNode)object2) && PDTableToTreePanel.this.canDhspButtonBeEnabled(1)) {
                                n = 1;
                            }
                        }
                        PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(n != 0);
                    } else if (!((DriveGroup)object).isCompleted()) {
                        PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(false);
                        if (((DriveGroup)object).getRaidLevel() <= 17) {
                            if (n2 == 0) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                            } else {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                            }
                        } else if (((DefaultMutableTreeNode)object2).getChildCount() > 0) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getChildAt(0);
                            if (defaultMutableTreeNode.getChildCount() == 0) {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(true);
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(PDTableToTreePanel.this.m_AdapterHelper.isSecuritySupported() && PDTableToTreePanel.this.m_AdapterHelper.isLockKeyAssigned());
                            } else {
                                PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                                PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                            }
                        }
                        if ((Byte)PDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedItem() >= 0 && n4 != n3 && PDTableToTreePanel.this.m_DgTreePanel.canPdsBeAdded(n3 - n4)) {
                            PDTableToTreePanel.this.m_addButton.setEnabled(true);
                        } else {
                            PDTableToTreePanel.this.m_addButton.setEnabled(false);
                        }
                    }
                }
                if (PDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0 || !PDTableToTreePanel.this.m_DgTreePanel.canMoreDgsBeCreated()) {
                    PDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                    PDTableToTreePanel.this.m_DriveSecurityCombobox.setEnabled(false);
                    PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                    PDTableToTreePanel.this.m_protectionCombobox.setEnabled(false);
                }
            } else if (object instanceof Span) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(true);
                if (((Span)object).isCompleted()) {
                    PDTableToTreePanel.this.m_addButton.setEnabled(false);
                    PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                }
                if ((defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent()) != null) {
                    if (!((DriveGroup)defaultMutableTreeNode.getUserObject()).isCompleted()) {
                        if (defaultMutableTreeNode.getChildCount() > 1 || ((DefaultMutableTreeNode)object2).getChildCount() != 0) {
                            PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                        }
                        if (defaultMutableTreeNode.getChildCount() == 1 && ((DefaultMutableTreeNode)object2).getChildCount() == 0) {
                            PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                        } else {
                            PDTableToTreePanel.this.m_removeButton.setEnabled(true);
                        }
                    } else {
                        int[] nArray;
                        int n;
                        boolean bl = false;
                        if (((DriveGroup)defaultMutableTreeNode.getUserObject()).getRaidLevel() > 0 && ((DriveGroup)defaultMutableTreeNode.getUserObject()).getRaidLevel() != 64 && (n = (nArray = PDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows()).length) == 1) {
                            nArray[0] = PDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[0]);
                            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)PDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[0]);
                            if (PDTableToTreePanel.this.isPdEligibleForDHSP((SASPhysicalDrive)physicalDriveHelper.getDeviceObject(), (DefaultMutableTreeNode)object2) && PDTableToTreePanel.this.canDhspButtonBeEnabled(1)) {
                                bl = true;
                            }
                        }
                        PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(bl);
                        PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                    }
                }
            } else if (object instanceof PhysicalDriveHelper) {
                PDTableToTreePanel.this.m_powerSettingsCombobox.setEnabled(false);
                if (((PhysicalDriveHelper)object).isDedicatedHotSpare()) {
                    PDTableToTreePanel.this.m_removeButton.setEnabled(true);
                } else {
                    PDTableToTreePanel.this.m_addHotSpareButton.setEnabled(false);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
                    if (defaultMutableTreeNode != null) {
                        Object object3 = defaultMutableTreeNode.getUserObject();
                        if (object3 instanceof DriveGroup) {
                            if (!((DriveGroup)object3).isCompleted()) {
                                PDTableToTreePanel.this.m_removeButton.setEnabled(true);
                            } else {
                                PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                            }
                        } else if (object3 instanceof Span) {
                            if (!((Span)object3).isCompleted()) {
                                PDTableToTreePanel.this.m_removeButton.setEnabled(true);
                            } else {
                                PDTableToTreePanel.this.m_removeButton.setEnabled(false);
                            }
                        }
                    }
                }
            }
        }
    }
}

