/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class RaidLevelComboBoxModel
extends DefaultComboBoxModel {
    private int m_numberOfPds = 0;
    private boolean m_isCacheCade = false;
    private AdapterHelper m_adapterHelper = null;
    private raidLevels_MR_CTRL_INFO m_raidLevelCtrlInfo = null;
    private byte m_controllerType = 0;
    private pdsForRaidLevels_MR_CTRL_INFO m_pdsForRaidLevel = null;
    private List<Byte> m_supportedRaidLevels = null;

    public RaidLevelComboBoxModel(AdapterHelper adapterHelper, int n, boolean bl) {
        this.m_numberOfPds = n;
        this.m_isCacheCade = bl;
        this.m_adapterHelper = adapterHelper;
        this.m_controllerType = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType();
        this.m_raidLevelCtrlInfo = this.m_adapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO();
        this.m_pdsForRaidLevel = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().getpdsForRaidLevels_MR_CTRL_INFO();
        this.fillSupportedRaidLevels();
        this.updateModel();
    }

    public void updateRaidLevelModel(int n) {
        this.m_numberOfPds = n;
        this.updateModel();
    }

    private void updateModel() {
        if (this.getSize() > 0) {
            this.removeAllElements();
        }
        if (this.m_numberOfPds >= 0) {
            this.addElement(new Byte(-1));
            if (this.m_controllerType == 2) {
                if (this.m_supportedRaidLevels.contains((byte)0) && this.m_numberOfPds >= this.m_pdsForRaidLevel.getMinPdRAIDLevel_0()) {
                    this.addElement(new Byte(0));
                }
                if (this.m_supportedRaidLevels.contains((byte)1) && this.m_numberOfPds >= this.m_pdsForRaidLevel.getMinPdRAIDLevel_1()) {
                    this.addElement(new Byte(1));
                }
                if (this.m_supportedRaidLevels.contains((byte)17) && this.m_numberOfPds >= this.m_pdsForRaidLevel.getMinPdRAIDLevel_1E()) {
                    this.addElement(new Byte(17));
                }
            } else if (this.m_controllerType == 3 || this.m_controllerType == 4) {
                this.addRaidLevelForIR((byte)0);
                this.addRaidLevelForIR((byte)1);
                this.addRaidLevelForIR((byte)17);
            } else if (this.m_controllerType == 1) {
                this.addRaidLevel((byte)0);
                this.addRaidLevel((byte)1);
                this.addRaidLevel((byte)17);
                this.addRaidLevel((byte)5);
                this.addRaidLevel((byte)6);
                this.addRaidLevel((byte)64);
                this.addRaidLevel((byte)65);
                this.addRaidLevel((byte)81);
                this.addRaidLevel((byte)69);
                this.addRaidLevel((byte)70);
                this.addRaidLevel((byte)7);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addRaidLevelForIR(byte var1_1) {
        block9: {
            if (!this.m_supportedRaidLevels.contains(var1_1)) break block9;
            switch (var1_1) {
                case 0: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_0()) break;
                    this.addElement(new Byte(var1_1));
                    break;
                }
                case 1: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1()) break;
                    this.addElement(new Byte(var1_1));
                    break;
                }
                case 17: {
                    if (this.m_numberOfPds >= this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) ** GOTO lbl16
                    if (!this.m_supportedRaidLevels.contains((byte)1) && this.m_numberOfPds >= this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) {
                        this.addElement(new Byte(1));
                    }
                    ** GOTO lbl22
lbl16:
                    // 1 sources

                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) ** GOTO lbl22
                    if (!this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) ** GOTO lbl20
                    this.addElement(new Byte(var1_1));
                    ** GOTO lbl22
lbl20:
                    // 1 sources

                    if (this.m_numberOfPds > this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) {
                        this.addElement(new Byte(var1_1));
                    }
                }
lbl22:
                // 7 sources

                case 16: {
                    if (!this.m_adapterHelper.treatRAID1EasRAID10() || !this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) break;
                    if (this.m_numberOfPds > this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) {
                        this.addElement(new Byte(16));
                        break;
                    }
                    if (this.m_supportedRaidLevels.contains((byte)1) || this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) break;
                    this.addElement(new Byte(1));
                }
            }
        }
    }

    private void fillSupportedRaidLevels() {
        this.m_supportedRaidLevels = new ArrayList<Byte>();
        if (this.m_isCacheCade) {
            if (this.m_raidLevelCtrlInfo.getSSCraidLevel_0_unsupported() == 0) {
                this.m_supportedRaidLevels.add((byte)0);
            }
            if (this.m_raidLevelCtrlInfo.getSSCraidLevel_1() != 0) {
                this.m_supportedRaidLevels.add((byte)1);
            }
            if (this.m_raidLevelCtrlInfo.getSSCraidLevel_1E() != 0) {
                this.m_supportedRaidLevels.add((byte)17);
            }
            if (this.m_raidLevelCtrlInfo.getSSCraidLevel_5() != 0) {
                this.m_supportedRaidLevels.add((byte)5);
            }
            if (this.m_raidLevelCtrlInfo.getSSCraidLevel_EC() != 0) {
                this.m_supportedRaidLevels.add((byte)7);
            }
        } else {
            if (this.m_raidLevelCtrlInfo.getraidLevel_0() != 0) {
                this.m_supportedRaidLevels.add((byte)0);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_1() != 0) {
                this.m_supportedRaidLevels.add((byte)1);
            }
            if (this.m_controllerType == 2) {
                if (this.m_raidLevelCtrlInfo.getraidLevel_1E() != 0) {
                    this.m_supportedRaidLevels.add((byte)17);
                }
            } else if (this.m_raidLevelCtrlInfo.getRaidLevel_1E_RLQ0() != 0) {
                this.m_supportedRaidLevels.add((byte)17);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_5() != 0) {
                this.m_supportedRaidLevels.add((byte)5);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_6() != 0) {
                this.m_supportedRaidLevels.add((byte)6);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_00_unsupported() == 0 && this.m_controllerType == 1) {
                this.m_supportedRaidLevels.add((byte)64);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_10() != 0 || this.m_raidLevelCtrlInfo.getRaidLevel_1E0_RLQ0() != 0) {
                this.m_supportedRaidLevels.add((byte)65);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_50() != 0) {
                this.m_supportedRaidLevels.add((byte)69);
            }
            if (this.m_raidLevelCtrlInfo.getraidLevel_60() != 0) {
                this.m_supportedRaidLevels.add((byte)70);
            }
            if (this.m_raidLevelCtrlInfo.getRaidLevel_1E0_RLQ0() != 0) {
                this.m_supportedRaidLevels.add((byte)81);
            }
        }
    }

    private void addRaidLevel(byte by) {
        if (this.m_supportedRaidLevels.contains(by)) {
            switch (by) {
                case 0: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_0()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 1: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 17: {
                    if (VivaldiStartupDialog.OEM_TYPE != 2561) {
                        if (this.m_supportedRaidLevels.contains((byte)1) || this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0()) break;
                        this.addElement(new Byte(1));
                        break;
                    }
                    try {
                        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getMFCDefaults();
                        if (mR_MFC_DEFAULTS.gettreatR1EAsR10() != 1 || this.m_supportedRaidLevels.contains((byte)65) || this.m_numberOfPds < 22) break;
                        this.addElement(new Byte(65));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_5()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 6: {
                    if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                        if (this.m_numberOfPds < 4) break;
                        this.addElement(new Byte(by));
                        break;
                    }
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_6()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 64: {
                    if (VivaldiStartupDialog.OEM_TYPE == 2561 || this.m_numberOfPds < 2 * this.m_pdsForRaidLevel.getMinPdRAIDLevel_0()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 65: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_10()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 81: {
                    if (this.m_supportedRaidLevels.contains((byte)65) || this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E0_RLQ0()) break;
                    this.addElement(new Byte(65));
                    break;
                }
                case 69: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_50()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 70: {
                    if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                        if (this.m_numberOfPds < 8) break;
                        this.addElement(new Byte(by));
                        break;
                    }
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRaidLevel_60()) break;
                    this.addElement(new Byte(by));
                    break;
                }
                case 7: {
                    if (this.m_numberOfPds < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1E()) break;
                    this.addElement(new Byte(by));
                }
            }
        }
    }
}

