/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.DedicatedHotSpare;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.SpanHole;
import GUIHelper.ArrayHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.Resource;
import java.util.ArrayList;
import java.util.List;

public class Span {
    private DriveGroup m_driveGrp = null;
    private List<PhysicalDriveHelper> m_pdList = null;
    private byte m_bSpanId = 0;
    private boolean m_isOld = false;
    private ArrayHelper m_arrayHelper = null;
    private SL_ARRAY_INFO_T m_slArrayInfo = null;
    private List<SpanHole> m_spanHoles = null;
    private SpanHole m_selectedSpanHole = null;
    private freeInfo_SL_ARRAY_INFO_T m_selFreeInfo = null;
    private byte m_bSelSpanHoleIndex = 0;
    private boolean m_isCompleted = false;
    private List<DedicatedHotSpare> m_dedHotSpares = null;
    private short blockSize = (short)512;

    public Span(DriveGroup driveGroup, List<PhysicalDriveHelper> list) {
        this.m_pdList = list;
        this.m_driveGrp = driveGroup;
    }

    public Span(DriveGroup driveGroup, byte by) {
        this.m_driveGrp = driveGroup;
        this.m_bSpanId = by;
    }

    public Span(DriveGroup driveGroup, ArrayHelper arrayHelper, byte by) {
        this.m_driveGrp = driveGroup;
        this.m_arrayHelper = arrayHelper;
        this.m_isOld = true;
        SASArray sASArray = (SASArray)arrayHelper.getDeviceObject();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_arrayHelper.getPhysicalDrives();
        this.m_pdList = new ArrayList<PhysicalDriveHelper>();
        for (int n = 0; n < physicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            this.m_pdList.add(physicalDriveHelperArray[n]);
        }
        this.m_bSpanId = (byte)sASArray.getArrayRef();
        try {
            this.m_slArrayInfo = sASArray.getSLArrayInformation();
            freeInfo_SL_ARRAY_INFO_T[] freeInfo_SL_ARRAY_INFO_TArray = this.m_slArrayInfo.getfreeInfo_SL_ARRAY_INFO_T();
            this.m_spanHoles = new ArrayList<SpanHole>();
            for (int i = 0; i < freeInfo_SL_ARRAY_INFO_TArray.length; ++i) {
                if (freeInfo_SL_ARRAY_INFO_TArray[i].getnumBlocks() == 0L) continue;
                this.m_spanHoles.add(new SpanHole(this, freeInfo_SL_ARRAY_INFO_TArray[i], (byte)i));
            }
            if (!this.m_spanHoles.isEmpty()) {
                this.m_selectedSpanHole = this.m_spanHoles.get(by);
                this.m_selFreeInfo = this.m_selectedSpanHole.getFreeInfo();
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
    }

    public void setDriveGroup(DriveGroup driveGroup) {
        this.m_driveGrp = driveGroup;
    }

    public int getNumberOfDrives() {
        if (this.m_slArrayInfo != null) {
            return this.m_slArrayInfo.getarray().getnumDrives();
        }
        return this.m_pdList.size();
    }

    public void setSpanId(byte by) {
        this.m_bSpanId = by;
    }

    public byte getSpanId() {
        return this.m_bSpanId;
    }

    public DriveGroup getDriveGroup() {
        return this.m_driveGrp;
    }

    public List<PhysicalDriveHelper> getPhysicalDrivesList() {
        if (this.m_arrayHelper != null) {
            return this.m_arrayHelper.getPhysicalDrivesArrayList();
        }
        return this.m_pdList;
    }

    public void setPhysicalDrivesList(List<PhysicalDriveHelper> list) {
        this.m_pdList = list;
    }

    public void setCurrentlySelectedSpanHole(byte by) {
        this.m_bSelSpanHoleIndex = by;
        if (!this.m_spanHoles.isEmpty()) {
            this.m_selectedSpanHole = this.m_spanHoles.get(this.m_bSelSpanHoleIndex);
            this.m_selFreeInfo = this.m_selectedSpanHole.getFreeInfo();
        }
    }

    public SpanHole getCurrentlySelectedSpanHole() {
        return this.m_selectedSpanHole;
    }

    public SL_ARRAY_INFO_T getArrayInfo() {
        return this.m_slArrayInfo;
    }

    public long getMinPDSizeInSpan() {
        long l = ((SASPhysicalDrive)this.m_pdList.get(0).getDeviceObject()).getInformation().getcoercedSize();
        for (int n = 1; n < this.m_pdList.size(); n = (int)((byte)(n + 1))) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.m_pdList.get(n).getDeviceObject();
            long l2 = sASPhysicalDrive.getInformation().getcoercedSize();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public freeInfo_SL_ARRAY_INFO_T getFreeHoleInfo() {
        return this.m_selFreeInfo;
    }

    public List<SpanHole> getSpanHoles() {
        return this.m_spanHoles;
    }

    public String getText() {
        return Resource.getString("SPAN_TEXT", "Span") + " " + this.m_bSpanId;
    }

    public String getIcon() {
        return Resource.getString("SPAN_IMAGE", "span.png");
    }

    public boolean isCompleted() {
        return this.m_isCompleted;
    }

    public void setAsCompleted(boolean bl) {
        this.m_isCompleted = bl;
    }

    public void addDedicatedHotspare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHotSpares == null) {
            this.m_dedHotSpares = new ArrayList<DedicatedHotSpare>();
        }
        this.m_dedHotSpares.add(dedicatedHotSpare);
    }

    public void removeDedicatedHotspare(DedicatedHotSpare dedicatedHotSpare) {
        if (this.m_dedHotSpares == null || !this.m_dedHotSpares.contains(dedicatedHotSpare)) {
            return;
        }
        this.m_dedHotSpares.remove(dedicatedHotSpare);
    }

    public boolean isHotSpareAssigned() {
        return this.m_dedHotSpares != null && !this.m_dedHotSpares.isEmpty();
    }

    public List<DedicatedHotSpare> getDedicatedHotSpares() {
        return this.m_dedHotSpares;
    }

    public short getBlockSize() {
        if (this.m_arrayHelper != null) {
            this.blockSize = this.m_arrayHelper.getBlockSize();
        }
        return this.blockSize;
    }

    public byte getDgPrl() {
        return (byte)(this.m_driveGrp.getRaidLevel() & 0xFFFFFFBF);
    }
}

