/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.Span;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import Services.KernelConstants;
import Utils.Resource;
import java.util.List;

public class SpanHole {
    private Span m_span = null;
    private freeInfo_SL_ARRAY_INFO_T m_freeInfo = null;
    private byte m_bFreeHoleIndex = 0;

    public SpanHole(Span span, freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2, byte by) {
        this.m_span = span;
        this.m_freeInfo = freeInfo_SL_ARRAY_INFO_T2;
        this.m_bFreeHoleIndex = by;
    }

    public long getStartBlock() {
        return this.m_freeInfo.getstartBlock();
    }

    public long getNumBlocks() {
        return this.m_freeInfo.getnumBlocks();
    }

    public long getActualNumBlocks() {
        return this.m_freeInfo.getactualNumBlocks();
    }

    public freeInfo_SL_ARRAY_INFO_T getFreeInfo() {
        return this.m_freeInfo;
    }

    public String toString() {
        return Resource.getString("FREE_CAP_NODE", "Free Capacity Node") + " " + this.m_bFreeHoleIndex + ": " + Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available Capacity : ") + KernelConstants.getConvertedSize(this.m_freeInfo.getnumBlocks(), this.m_span.getBlockSize());
    }

    public Span getSpan() {
        return this.m_span;
    }

    public byte getFreeCapacityIndex() {
        return this.m_bFreeHoleIndex;
    }

    public long getSizePerRaidLevel() {
        int n = 0;
        int n2 = this.m_span.getNumberOfDrives();
        List<Span> list = this.m_span.getDriveGroup().getSpans();
        byte by = this.m_span.getDriveGroup().getRaidLevel();
        byte by2 = (byte)(by & 0xFFFFFFBF);
        if (by2 == 0) {
            n = n2;
        } else if (by2 == 1) {
            n = 1;
        } else if (by2 == 17) {
            n = n2 / 2;
        } else if (by2 == 5) {
            n = n2 - 1;
        } else if (by2 == 6) {
            n = n2 - 2;
        }
        return this.getNumBlocks() * (long)n * (long)list.size();
    }
}

