/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;

public class UnconfiguredDrivesGrouping {
    public static final byte PD_TYPE_SSD_SAS = 0;
    public static final byte PD_TYPE_SSD_SATA = 1;
    public static final byte PD_TYPE_HDD_SAS = 2;
    public static final byte PD_TYPE_HDD_SATA = 3;
    private AdapterHelper m_adapterHelper = null;
    private ArrayList<ArrayList<PhysicalDriveHelper>> m_unconfiguredPdGroup = null;
    private ArrayList<PhysicalDriveHelper> m_unconfiguredPdList = null;

    UnconfiguredDrivesGrouping(AdapterHelper adapterHelper, ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_adapterHelper = adapterHelper;
        this.updateUnconfDriveGroups(arrayList);
    }

    public void updateUnconfDriveGroups(ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_unconfiguredPdList = arrayList;
        this.m_unconfiguredPdGroup = this.getUnconfPdGroups();
    }

    public ArrayList<ArrayList<PhysicalDriveHelper>> getUnconfPdGroups() {
        ArrayList<ArrayList<PhysicalDriveHelper>> arrayList = new ArrayList<ArrayList<PhysicalDriveHelper>>();
        ArrayList<PhysicalDriveHelper> arrayList2 = new ArrayList<PhysicalDriveHelper>();
        ArrayList<PhysicalDriveHelper> arrayList3 = new ArrayList<PhysicalDriveHelper>();
        ArrayList<PhysicalDriveHelper> arrayList4 = new ArrayList<PhysicalDriveHelper>();
        ArrayList<PhysicalDriveHelper> arrayList5 = new ArrayList<PhysicalDriveHelper>();
        MR_CTRL_INFO mR_CTRL_INFO = this.m_adapterHelper.getAdapterInfo();
        boolean bl = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD() == 1;
        boolean bl2 = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowMixInLD() == 1;
        boolean bl3 = mR_CTRL_INFO.getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD() == 1;
        int n = this.m_unconfiguredPdList.size();
        block5: for (int i = 0; i < n; ++i) {
            PhysicalDriveHelper physicalDriveHelper = this.m_unconfiguredPdList.get(i);
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
            byte by = sASPhysicalDrive.getMediatype();
            switch (sASPhysicalDrive.getDriveType()) {
                case 1: {
                    continue block5;
                }
                case 2: {
                    if (by == 1) {
                        arrayList2.add(physicalDriveHelper);
                        continue block5;
                    }
                    arrayList4.add(physicalDriveHelper);
                    continue block5;
                }
                case 3: {
                    if (by == 1) {
                        arrayList3.add(physicalDriveHelper);
                        continue block5;
                    }
                    arrayList5.add(physicalDriveHelper);
                }
            }
        }
        if (bl || bl2 || bl3) {
            if (!bl && !bl2 && bl3) {
                arrayList2.addAll(arrayList3);
                arrayList3.clear();
            } else if (!bl && bl2 && !bl3) {
                arrayList4.addAll(arrayList5);
                arrayList5.clear();
            } else if (!bl && bl2 && bl3) {
                arrayList2.addAll(arrayList3);
                arrayList3.clear();
                arrayList4.addAll(arrayList5);
                arrayList5.clear();
            } else if (bl && !bl2 && !bl3) {
                arrayList2.addAll(arrayList4);
                arrayList4.clear();
                arrayList3.addAll(arrayList5);
                arrayList5.clear();
            } else if (bl && (bl2 || bl3)) {
                arrayList2.addAll(arrayList3);
                arrayList3.clear();
                arrayList2.addAll(arrayList4);
                arrayList4.clear();
                arrayList2.addAll(arrayList5);
                arrayList5.clear();
            }
        }
        if (arrayList2.size() > 0) {
            arrayList.add(arrayList2);
        }
        if (arrayList3.size() > 0) {
            arrayList.add(arrayList3);
        }
        if (arrayList4.size() > 0) {
            arrayList.add(arrayList4);
        }
        if (arrayList5.size() > 0) {
            arrayList.add(arrayList5);
        }
        return arrayList;
    }

    public int getMaxGroupPdCount() {
        int n = this.m_unconfiguredPdGroup.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3;
            ArrayList<PhysicalDriveHelper> arrayList = this.m_unconfiguredPdGroup.get(i);
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                if (arrayList.get(n3).getUserDataBlockSize() == 512) {
                    ++n5;
                    continue;
                }
                ++n4;
            }
            n3 = Math.max(n4, n5);
            if (n2 != -1 && n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public ArrayList<Integer> getDisableRows(byte by) {
        int n = this.m_unconfiguredPdList.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.m_unconfiguredPdGroup.size();
        for (int i = 0; i < n2; ++i) {
            ArrayList<PhysicalDriveHelper> arrayList2 = this.m_unconfiguredPdGroup.get(i);
            int n3 = arrayList2.size();
            if (this.isSelectedRaidLevelPossible(n3, by)) continue;
            for (int j = 0; j < n && !arrayList.contains(j); ++j) {
                if (!arrayList2.contains(this.m_unconfiguredPdList.get(j))) continue;
                arrayList.add(j);
            }
        }
        return arrayList;
    }

    public boolean isSelectedRaidLevelPossible(int n, byte by) {
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_adapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        switch (by) {
            case -1: {
                if (n <= 0) break;
                return true;
            }
            case 0: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0()) break;
                return true;
            }
            case 1: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) break;
                return true;
            }
            case 17: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) break;
                return true;
            }
            case 16: {
                if (n <= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) break;
                return true;
            }
            case 5: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) break;
                return true;
            }
            case 6: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6()) break;
                return true;
            }
            case 64: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0() * 2) break;
                return true;
            }
            case 65: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() * 2) break;
                return true;
            }
            case 69: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() * 2) break;
                return true;
            }
            case 70: {
                if (n < pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() * 2) break;
                return true;
            }
        }
        return false;
    }
}

