/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.Capacity;
import GUI.venus.configuration.advanced.DGVDTreePanel;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.VDSettingsPanelRenderers;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.stripeSizeOptions_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.Resource;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class VDCreationPanel
extends JPanel
implements AncestorListener {
    private AdapterHelper m_adapterHelper = null;
    private AdvanceConfigEngine m_engine = null;
    private DGVDTreePanel m_dgTreePanel = null;
    private JTextField m_tfVDName = null;
    private String m_strSuggestedVDName = null;
    private SpinnerNumberModel m_capacitySpinnerModel = null;
    private JSpinner m_capacitySpinner = null;
    private UnitsComboBoxModel m_unitsComboModel = null;
    private JComboBox m_cmbBxUnits = null;
    private int m_iCurrentUnit = 3;
    private double[] m_dMaxSizeAndUnit = null;
    private double[] m_dMinSizeAndUnit = null;
    private JComboBox m_cmbBxInitState = null;
    private JComboBox m_cmbBxStripeSize = null;
    private DefaultComboBoxModel m_stripeSizeModel = null;
    private byte m_bMinStripeSize = 0;
    private byte m_bMaxStripeSize = 0;
    private byte m_bDefStripeSize = 0;
    private JComboBox m_cmbBxReadPolicy = null;
    private JComboBox m_cmbBxWritePolicy = null;
    private JComboBox m_cmbBxIOPolicy = null;
    private JComboBox m_cmbBxAccessPolicy = null;
    private JComboBox m_cmbBxDiskCachePolicy = null;
    private JCheckBox m_chkBxExposeVd = new JCheckBox();
    private JButton m_btnCreateVirtualDrive = null;
    private JButton m_btnUpdateVirtualDrive = null;
    private JButton m_btnRemoveVirtualDrive = null;
    private DriveGroup m_selDriveGroup = null;
    private DriveGroup m_selDriveGroupall = null;
    private List<ChangeListener> m_changeListeners = null;
    private DriveGroupTreeSelectionListener m_dgTreeSelectionListener = null;
    private boolean m_memoryAbsent = false;
    private boolean m_controllerisSWR = false;
    private boolean isPIEnabled = false;
    private static final int DISK_CACHE_POLICY_UNCHANGED = 0;
    private static final int DISK_CACHE_POLICY_DISABLE = 2;

    public VDCreationPanel(AdvanceConfigEngine advanceConfigEngine, AdapterHelper adapterHelper) {
        this.m_engine = advanceConfigEngine;
        this.m_adapterHelper = adapterHelper;
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0) {
            this.m_memoryAbsent = true;
        }
        if (this.m_adapterHelper.isSWRController()) {
            this.m_controllerisSWR = true;
        }
        byte by = this.m_engine.getLDTargetId();
        this.m_strSuggestedVDName = "VD_" + by;
        this.m_engine.returnLDTargetId(by);
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_selDriveGroup = list.get(0);
        this.isPIEnabled = list.get(0).isPIEnabled();
        this.m_dgTreePanel = new DGVDTreePanel(this.m_adapterHelper, list, false);
        this.m_dgTreePanel.getDriveGroupTree().getModel().addTreeModelListener(new DriveGroupTreeModelListener());
        this.m_dgTreeSelectionListener = new DriveGroupTreeSelectionListener();
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        this.buildPanel();
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
            this.m_capacitySpinner.setEnabled(false);
            this.m_cmbBxUnits.setEnabled(false);
            this.m_cmbBxInitState.setEnabled(false);
            this.m_cmbBxStripeSize.setEnabled(false);
            this.m_cmbBxReadPolicy.setEnabled(false);
            this.m_cmbBxWritePolicy.setEnabled(false);
            this.m_cmbBxIOPolicy.setEnabled(false);
            this.m_cmbBxAccessPolicy.setEnabled(false);
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
            this.m_btnUpdateVirtualDrive.setVisible(false);
        }
    }

    public void initDriveGroups() {
        this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_dgTreePanel.initData(list);
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        this.m_selDriveGroup = list.get(0);
        this.m_dgTreePanel.selectFirstFreeDGNode();
    }

    private void buildPanel() {
        String[] stringArray = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)new JLabel(Resource.getString("LABEL_SPECIFY_PARAMS")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DRIVE_GROUPS", "Drive (g)roups:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_dgTreePanel.getDriveGroupTree());
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.getVDParamPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.m_dgTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        JPanel jPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_VD", " (C)reate Virtual Drive"));
        this.m_btnCreateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnCreateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_UPDATE_VD", "U)pdate Virtual Drive"));
        this.m_btnUpdateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnUpdateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add(this.m_btnUpdateVirtualDrive);
        jPanel.add(this.m_btnCreateVirtualDrive);
        this.m_btnCreateVirtualDrive.addActionListener(new CreateVDAction());
        this.m_btnUpdateVirtualDrive.addActionListener(new UpdateVDAction());
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_VD", "(R)emove Virtual Drive"));
        this.m_btnRemoveVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnRemoveVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnRemoveVirtualDrive.addActionListener(new DeleteVDAction());
        this.add((Component)this.m_btnRemoveVirtualDrive, gridBagConstraints);
        JTree jTree = this.m_dgTreePanel.getDriveGroupTree();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DriveGroup && ((DriveGroup)object).canAddVD()) {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(true);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        } else {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(false);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        }
        this.m_btnCreateVirtualDrive.addAncestorListener(this);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (this.m_btnCreateVirtualDrive.isEnabled()) {
            this.m_btnCreateVirtualDrive.requestFocusInWindow();
        } else {
            this.m_tfVDName.requestFocusInWindow();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    private JPanel getVDParamPanel() {
        int n;
        int n2;
        String[] stringArray = null;
        VDSettingsPanelRenderers vDSettingsPanelRenderers = new VDSettingsPanelRenderers();
        SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        byte by = this.m_selDriveGroup.getRaidLevel();
        System.out.println("m_selDriveGroup.getDriveGroupName() in getVDParamPanel()" + this.m_selDriveGroup.getDriveGroupName());
        this.m_tfVDName = new JTextField(15);
        this.m_tfVDName.setText(this.m_strSuggestedVDName);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_VD_NAME", "(V)irtual drive name:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_tfVDName);
        }
        this.m_tfVDName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (VDCreationPanel.this.m_tfVDName.getText().length() > 15) {
                    new CustomMsgBox("Virtual Drive Name cannot exceed more than 15 characters");
                    VDCreationPanel.this.m_tfVDName.setText(VDCreationPanel.this.m_tfVDName.getText().substring(0, 15));
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(3));
        Capacity capacity = this.m_selDriveGroup.getCapacity();
        this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
            this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
            this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
        }
        this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
        this.m_unitsComboModel = new UnitsComboBoxModel((int)this.m_dMaxSizeAndUnit[1]);
        this.m_capacitySpinnerModel = new SpinnerNumberModel(this.m_dMaxSizeAndUnit[0], this.m_dMinSizeAndUnit[0], this.m_dMaxSizeAndUnit[0], 1.0);
        this.m_capacitySpinner = new JSpinner(this.m_capacitySpinnerModel);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CAPACITY", "Capacit(y):"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel2.setLabelFor(this.m_capacitySpinner);
        }
        this.m_cmbBxUnits = new JComboBox(this.m_unitsComboModel);
        this.m_cmbBxUnits.setRenderer(new UnitsRenderer());
        this.m_cmbBxUnits.addItemListener(new UnitsChangeItemListener());
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_UNITS", " Uni(t)s:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel3.setLabelFor(this.m_cmbBxUnits);
        }
        jPanel.add(this.m_capacitySpinner);
        jPanel.add(jLabel3);
        jPanel.add(this.m_cmbBxUnits);
        Object[] objectArray = this.isPIEnabled && (by == 6 || by == 70) ? new Object[]{new Byte(0), new Byte(1)} : new Object[]{new Byte(0), new Byte(1), new Byte(2)};
        this.m_cmbBxInitState = new JComboBox<Object>(objectArray);
        this.m_cmbBxInitState.setRenderer(new VDSettingsPanelRenderers.InitStateRenderer(vDSettingsPanelRenderers));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_INIT_STATE", "(I)nitialization state:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel4.setLabelFor(this.m_cmbBxInitState);
        }
        stripeSizeOptions_MR_CTRL_INFO stripeSizeOptions_MR_CTRL_INFO2 = sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO();
        this.m_bMinStripeSize = (byte)stripeSizeOptions_MR_CTRL_INFO2.getmin();
        this.m_bMaxStripeSize = (byte)stripeSizeOptions_MR_CTRL_INFO2.getmax();
        objectArray = new Object[this.m_bMaxStripeSize - this.m_bMinStripeSize + 1];
        int n3 = 0;
        for (byte by2 = this.m_bMinStripeSize; by2 <= this.m_bMaxStripeSize; by2 = (byte)(by2 + 1)) {
            int n4 = n3;
            n3 = (byte)(n3 + 1);
            objectArray[n4] = by2;
        }
        this.m_stripeSizeModel = new DefaultComboBoxModel<Object>(objectArray);
        this.m_cmbBxStripeSize = new JComboBox(this.m_stripeSizeModel);
        this.m_cmbBxStripeSize.setRenderer(new VDSettingsPanelRenderers.StripeSizeRenderer(vDSettingsPanelRenderers));
        this.m_bDefStripeSize = this.m_engine.getmfcDefaults().getstripeSize();
        if (this.m_bMinStripeSize <= this.m_bDefStripeSize && this.m_bMaxStripeSize >= this.m_bDefStripeSize) {
            this.m_cmbBxStripeSize.setSelectedItem(new Byte(this.m_bDefStripeSize));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_STRIPE_SIZE", "Strip si(z)e:"));
        JLabel jLabel5 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel5.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel5.setLabelFor(this.m_cmbBxStripeSize);
        }
        if ((n2 = this.m_selDriveGroup.getSpans().get(0).getNumberOfDrives()) == 3 && (by == 6 || by == 70) && (n = this.m_stripeSizeModel.getIndexOf(new Byte(4))) != -1) {
            this.m_stripeSizeModel.removeElementAt(n);
        }
        if (this.m_memoryAbsent && !this.m_controllerisSWR) {
            objectArray = new Object[]{new Byte(0)};
            this.m_cmbBxReadPolicy = new JComboBox<Object>(objectArray);
            this.m_cmbBxReadPolicy.setSelectedIndex(0);
        } else {
            objectArray = new Object[]{new Byte(0), new Byte(4)};
            this.m_cmbBxReadPolicy = new JComboBox<Object>(objectArray);
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                this.m_cmbBxReadPolicy.setSelectedIndex(1);
            }
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_READ_POLICY", "R(e)ad policy:"));
        JLabel jLabel6 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel6.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel6.setLabelFor(this.m_cmbBxReadPolicy);
        }
        this.m_cmbBxReadPolicy.setRenderer(new VDSettingsPanelRenderers.LDReadPolicyRenderer(vDSettingsPanelRenderers));
        if (this.m_controllerisSWR) {
            objectArray = new Object[]{new Byte(0), new Byte(17)};
            this.m_cmbBxWritePolicy = new JComboBox<Object>(objectArray);
            if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                this.m_cmbBxWritePolicy.setSelectedIndex(0);
            } else {
                this.m_cmbBxWritePolicy.setSelectedIndex(1);
            }
        } else if (this.m_memoryAbsent) {
            objectArray = new Object[]{new Byte(0)};
            this.m_cmbBxWritePolicy = new JComboBox<Object>(objectArray);
            this.m_cmbBxWritePolicy.setSelectedIndex(0);
        } else {
            objectArray = new Object[]{new Byte(0), new Byte(17), new Byte(1)};
            this.m_cmbBxWritePolicy = new JComboBox<Object>(objectArray);
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                if (SASKernel.getOemType() == 2561) {
                    if (by == 0) {
                        this.m_cmbBxWritePolicy.setSelectedIndex(2);
                    } else if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                        this.m_cmbBxWritePolicy.setSelectedIndex(0);
                    } else if (this.m_engine.getmfcDefaults().getcacheWhenBBUBad() == 1) {
                        this.m_cmbBxWritePolicy.setSelectedIndex(1);
                    } else {
                        this.m_cmbBxWritePolicy.setSelectedIndex(2);
                    }
                } else if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                    this.m_cmbBxWritePolicy.setSelectedIndex(0);
                } else if (this.m_engine.getmfcDefaults().getcacheWhenBBUBad() == 1) {
                    this.m_cmbBxWritePolicy.setSelectedIndex(1);
                } else {
                    this.m_cmbBxWritePolicy.setSelectedIndex(2);
                }
            }
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_WRITE_POLICY", "(W)rite policy:"));
        JLabel jLabel7 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel7.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel7.setLabelFor(this.m_cmbBxWritePolicy);
        }
        this.m_cmbBxWritePolicy.setRenderer(new VDSettingsPanelRenderers.LDWritePolicyRenderer(vDSettingsPanelRenderers));
        if (this.m_memoryAbsent) {
            objectArray = new Object[]{new Byte(0)};
            this.m_cmbBxIOPolicy = new JComboBox<Object>(objectArray);
            this.m_cmbBxIOPolicy.setSelectedIndex(0);
        } else {
            objectArray = new Object[]{new Byte(0), new Byte(96)};
            this.m_cmbBxIOPolicy = new JComboBox<Object>(objectArray);
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                this.m_cmbBxIOPolicy.setSelectedIndex(this.m_engine.getmfcDefaults().getcachedIo());
            }
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_IO_POLICY", "I/O (p)olicy:"));
        JLabel jLabel8 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel8.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel8.setLabelFor(this.m_cmbBxIOPolicy);
        }
        this.m_cmbBxIOPolicy.setRenderer(new VDSettingsPanelRenderers.LDIOPolicyRenderer(vDSettingsPanelRenderers));
        objectArray = new Object[]{new Byte(0), new Byte(2), new Byte(3)};
        this.m_cmbBxAccessPolicy = new JComboBox<Object>(objectArray);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ACCESS_POLICY", "(A)ccess policy:"));
        JLabel jLabel9 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel9.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel9.setLabelFor(this.m_cmbBxAccessPolicy);
        }
        this.m_cmbBxAccessPolicy.setRenderer(new VDSettingsPanelRenderers.LDAccessPolicyRenderer(vDSettingsPanelRenderers));
        objectArray = new Object[]{new Byte(0), new Byte(1), new Byte(2)};
        this.m_cmbBxDiskCachePolicy = new JComboBox<Object>(objectArray);
        this.m_cmbBxDiskCachePolicy.setSelectedIndex(2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DISK_CACHE_POLICY", "(D)isk cache policy:"));
        JLabel jLabel10 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel10.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel10.setLabelFor(this.m_cmbBxDiskCachePolicy);
        }
        this.m_cmbBxDiskCachePolicy.setRenderer(new VDSettingsPanelRenderers.PDCachePolicyRenderer(vDSettingsPanelRenderers));
        JTree jTree = this.m_dgTreePanel.getDriveGroupTree();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (this.isVDCompriseOfSSDDrives(this.m_selDriveGroup) && this.m_adapterHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 1) {
            this.m_cmbBxDiskCachePolicy.setSelectedIndex(0);
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
        } else if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
        } else {
            this.m_cmbBxDiskCachePolicy.setEnabled(true);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_EXPOSE_VD_TO_OS", "(G)rant access to remote OS"));
        this.m_chkBxExposeVd = new JCheckBox(stringArray[0]);
        this.m_chkBxExposeVd.setSelected(true);
        this.m_chkBxExposeVd.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_chkBxExposeVd.setMnemonic(stringArray[1].charAt(0));
        }
        int n5 = 0;
        gridBagConstraints.gridx = 0;
        int n6 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_tfVDName, gridBagConstraints);
        int n7 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n7;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        int n8 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n8;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_cmbBxInitState, gridBagConstraints);
        int n9 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n9;
        jPanel2.add((Component)this.m_cmbBxStripeSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        int n10 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n10;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_cmbBxReadPolicy, gridBagConstraints);
        int n11 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n11;
        jPanel2.add((Component)this.m_cmbBxWritePolicy, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        int n12 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n12;
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_cmbBxIOPolicy, gridBagConstraints);
        int n13 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n13;
        jPanel2.add((Component)this.m_cmbBxAccessPolicy, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel9, gridBagConstraints);
        int n14 = n5;
        n5 = (byte)(n5 + 1);
        gridBagConstraints.gridy = n14;
        jPanel2.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_cmbBxDiskCachePolicy, gridBagConstraints);
        if (this.m_adapterHelper.getAdapterInfo().getmaxHANodes() > 1) {
            gridBagConstraints.gridx = 0;
            int n15 = n5;
            n5 = (byte)(n5 + 1);
            gridBagConstraints.gridy = n15;
            jPanel2.add((Component)this.m_chkBxExposeVd, gridBagConstraints);
        }
        return jPanel2;
    }

    private void resetVDPanelToSelectedDriveGroup() {
        byte by;
        System.out.println("VDCreationPanel.resetVDPanelToDGDefault()");
        if (this.m_engine.canAddNewVirtualDrive()) {
            by = this.m_engine.getLDTargetId();
            this.m_strSuggestedVDName = "VD_" + by;
            this.m_engine.returnLDTargetId(by);
        }
        this.m_tfVDName.setText(this.m_strSuggestedVDName);
        System.out.println("m_selDriveGroup in resetVDPanelToSelectedDriveGroup:" + this.m_selDriveGroup.getDriveGroupName());
        by = this.m_selDriveGroup.getRaidLevel();
        if (this.m_selDriveGroup.isPIEnabled() && (by == 6 || by == 70)) {
            this.m_cmbBxInitState.removeAllItems();
            this.m_cmbBxInitState.addItem(new Byte(0));
            this.m_cmbBxInitState.addItem(new Byte(1));
        } else {
            this.m_cmbBxInitState.removeAllItems();
            this.m_cmbBxInitState.addItem(new Byte(0));
            this.m_cmbBxInitState.addItem(new Byte(1));
            this.m_cmbBxInitState.addItem(new Byte(2));
        }
        this.m_cmbBxStripeSize.setSelectedItem(new Byte(this.m_bDefStripeSize));
        this.m_cmbBxInitState.setSelectedIndex(0);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_memoryAbsent) {
                if (this.m_adapterHelper.isSWRController()) {
                    this.m_cmbBxReadPolicy.setSelectedIndex(1);
                } else {
                    this.m_cmbBxReadPolicy.setSelectedIndex(0);
                }
            } else {
                this.m_cmbBxReadPolicy.setSelectedIndex(1);
            }
        }
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_adapterHelper.isSWRController()) {
                if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                    this.m_cmbBxWritePolicy.setSelectedIndex(0);
                } else {
                    this.m_cmbBxWritePolicy.setSelectedIndex(1);
                }
            }
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0 && !this.m_adapterHelper.isSWRController()) {
                this.m_cmbBxWritePolicy.setSelectedIndex(0);
            } else if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                this.m_cmbBxWritePolicy.setSelectedIndex(0);
            } else if (this.m_engine.getmfcDefaults().getcacheWhenBBUBad() == 1) {
                this.m_cmbBxWritePolicy.setSelectedIndex(1);
            } else if (!this.m_adapterHelper.isSWRController()) {
                this.m_cmbBxWritePolicy.setSelectedIndex(2);
            }
        }
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_memoryAbsent) {
                this.m_cmbBxIOPolicy.setSelectedIndex(0);
            } else {
                this.m_cmbBxIOPolicy.setSelectedIndex(this.m_engine.getmfcDefaults().getcachedIo());
            }
        }
        this.m_cmbBxAccessPolicy.setSelectedIndex(0);
        this.m_cmbBxDiskCachePolicy.setSelectedIndex(2);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
        } else {
            this.m_cmbBxDiskCachePolicy.setEnabled(true);
        }
        if (this.isVDCompriseOfSSDDrives(this.m_selDriveGroup) && this.m_adapterHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 1) {
            this.m_cmbBxDiskCachePolicy.setSelectedIndex(0);
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
        } else if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
            this.m_cmbBxDiskCachePolicy.setEnabled(false);
        } else {
            this.m_cmbBxDiskCachePolicy.setEnabled(true);
        }
        if (this.m_engine.canAddNewVirtualDrive() && this.m_selDriveGroup.canAddVD()) {
            Capacity capacity = this.m_selDriveGroup.getCapacity();
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
            this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_unitsComboModel.setUnit((int)this.m_dMaxSizeAndUnit[1]);
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setValue(this.m_dMaxSizeAndUnit[0]);
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_btnCreateVirtualDrive.setEnabled(false);
        }
    }

    private void resetVDPanelToVirtualDrive(VirtualDrive virtualDrive) {
        this.m_tfVDName.setText(virtualDrive.getName());
        byte by = virtualDrive.getDriveGroup().getRaidLevel();
        if (virtualDrive.getDriveGroup().isPIEnabled() && (by == 6 || by == 70)) {
            this.m_cmbBxInitState.removeAllItems();
            this.m_cmbBxInitState.addItem(new Byte(0));
            this.m_cmbBxInitState.addItem(new Byte(1));
        } else {
            this.m_cmbBxInitState.removeAllItems();
            this.m_cmbBxInitState.addItem(new Byte(0));
            this.m_cmbBxInitState.addItem(new Byte(1));
            this.m_cmbBxInitState.addItem(new Byte(2));
        }
        this.m_cmbBxInitState.setSelectedItem(virtualDrive.getInitState());
        this.m_cmbBxStripeSize.setSelectedItem(virtualDrive.getStripeSize());
        this.m_cmbBxReadPolicy.setSelectedItem(virtualDrive.getReadPolicy());
        this.m_cmbBxWritePolicy.setSelectedItem(virtualDrive.getWritePolicy());
        this.m_cmbBxIOPolicy.setSelectedItem(virtualDrive.getIOPolicy());
        this.m_cmbBxAccessPolicy.setSelectedItem(virtualDrive.getAccessPolicy());
        this.m_cmbBxDiskCachePolicy.setSelectedItem(virtualDrive.getDiskCachePolicy());
        long l = virtualDrive.getSize();
        double[] dArray = KernelConstants.getSizeAndUnit(l, this.m_selDriveGroup.getBlockSize());
        Capacity capacity = virtualDrive.getDriveGroup().getCapacity();
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        if (capacity.getMaxSizeInBlocks() != 0L) {
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks() + virtualDrive.getSize(), this.m_selDriveGroup.getBlockSize());
            int n = (int)this.m_dMaxSizeAndUnit[1];
            if (dArray[1] == this.m_dMinSizeAndUnit[1]) {
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)this.m_dMinSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMaxSizeAndUnit[1] = this.m_dMinSizeAndUnit[1];
            } else if (dArray[1] == this.m_dMaxSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            } else {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)dArray[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)dArray[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = dArray[1];
                this.m_dMaxSizeAndUnit[1] = dArray[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            double d = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], n, this.m_selDriveGroup.getBlockSize());
            if (d == 0.0) {
                --n;
            }
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_dMaxSizeAndUnit[0] = dArray[0];
            this.m_dMaxSizeAndUnit[1] = dArray[1];
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            int n = (int)this.m_dMaxSizeAndUnit[1];
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        }
        this.m_chkBxExposeVd.setSelected(virtualDrive.isM_accessToRemoteOs());
    }

    private void resetPanel() {
        this.m_tfVDName.setText("");
        this.m_cmbBxInitState.setSelectedIndex(0);
        this.m_cmbBxStripeSize.setSelectedItem(this.m_bDefStripeSize);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_memoryAbsent) {
                this.m_cmbBxReadPolicy.setSelectedIndex(0);
            } else {
                this.m_cmbBxReadPolicy.setSelectedIndex(1);
            }
        }
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_memoryAbsent) {
                this.m_cmbBxWritePolicy.setSelectedIndex(0);
            } else if (this.m_engine.getmfcDefaults().getwriteBack() == 0) {
                this.m_cmbBxWritePolicy.setSelectedIndex(0);
            } else if (this.m_engine.getmfcDefaults().getcacheWhenBBUBad() == 1) {
                this.m_cmbBxWritePolicy.setSelectedIndex(1);
            } else {
                this.m_cmbBxWritePolicy.setSelectedIndex(2);
            }
        }
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            if (this.m_memoryAbsent) {
                this.m_cmbBxIOPolicy.setSelectedIndex(0);
            } else {
                this.m_cmbBxIOPolicy.setSelectedIndex(this.m_engine.getmfcDefaults().getcachedIo());
            }
        }
        this.m_cmbBxAccessPolicy.setSelectedIndex(0);
        if (this.isVDCompriseOfSSDDrives(this.m_selDriveGroup) && this.m_adapterHelper.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 1) {
            this.m_cmbBxDiskCachePolicy.setSelectedIndex(0);
        } else {
            this.m_cmbBxDiskCachePolicy.setSelectedIndex(2);
        }
        this.m_capacitySpinnerModel.setValue(0);
    }

    private void generateChangeEvent() {
        if (this.m_changeListeners != null) {
            for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                this.m_changeListeners.get(i).stateChanged(new ChangeEvent(new Boolean(this.isVDsAvailable())));
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new ArrayList<ChangeListener>();
        }
        this.m_changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null || !this.m_changeListeners.contains(changeListener)) {
            return;
        }
        this.m_changeListeners.remove(changeListener);
    }

    public void cleanUp() {
        if (this.m_dgTreePanel != null) {
            this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        }
    }

    public boolean isVDsAvailable() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_dgTreePanel.getDriveGroupTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
            List<VirtualDrive> list = driveGroup.getVirtualDrives();
            if (list == null || list.isEmpty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public JButton getDefaultButton() {
        return this.m_btnCreateVirtualDrive;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("VD and DG Panel.");
        jFrame.setDefaultCloseOperation(3);
        VDCreationPanel vDCreationPanel = new VDCreationPanel(null, null);
        jFrame.getContentPane().add(vDCreationPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void testPRL056() {
        this.m_engine.addNewDriveGroup(new DriveGroup(0));
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        arrayList.add(physicalDriveHelperArray[0]);
        arrayList.add(physicalDriveHelperArray[1]);
        this.m_selDriveGroup = list.get(0);
        Span span = new Span(this.m_selDriveGroup, arrayList);
        span.setSpanId((byte)0);
        this.m_selDriveGroup.addSpan(span);
        this.m_engine.addNewSpan(span);
    }

    private void testR50() {
        this.m_engine.addNewDriveGroup(new DriveGroup(70));
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_selDriveGroup = list.get(0);
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        arrayList.add(physicalDriveHelperArray[3]);
        arrayList.add(physicalDriveHelperArray[4]);
        arrayList.add(physicalDriveHelperArray[5]);
        Span span = new Span(this.m_selDriveGroup, arrayList);
        span.setSpanId((byte)0);
        this.m_selDriveGroup.addSpan(span);
        this.m_engine.addNewSpan(span);
        arrayList = new ArrayList();
        arrayList.add(physicalDriveHelperArray[6]);
        arrayList.add(physicalDriveHelperArray[7]);
        arrayList.add(physicalDriveHelperArray[8]);
        Span span2 = new Span(this.m_selDriveGroup, arrayList);
        span2.setSpanId((byte)1);
        this.m_selDriveGroup.addSpan(span2);
        this.m_engine.addNewSpan(span2);
    }

    private void testR10() {
        this.m_engine.addNewDriveGroup(new DriveGroup(65));
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_selDriveGroup = list.get(0);
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        arrayList.add(physicalDriveHelperArray[3]);
        arrayList.add(physicalDriveHelperArray[4]);
        Span span = new Span(this.m_selDriveGroup, arrayList);
        span.setSpanId((byte)0);
        this.m_selDriveGroup.addSpan(span);
        this.m_engine.addNewSpan(span);
        arrayList = new ArrayList();
        arrayList.add(physicalDriveHelperArray[6]);
        arrayList.add(physicalDriveHelperArray[7]);
        Span span2 = new Span(this.m_selDriveGroup, arrayList);
        span2.setSpanId((byte)1);
        this.m_selDriveGroup.addSpan(span2);
        this.m_engine.addNewSpan(span2);
    }

    private void testR00() {
        this.m_engine.addNewDriveGroup(new DriveGroup(64));
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_selDriveGroup = list.get(0);
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        arrayList.add(physicalDriveHelperArray[3]);
        arrayList.add(physicalDriveHelperArray[4]);
        arrayList.add(physicalDriveHelperArray[5]);
        Span span = new Span(this.m_selDriveGroup, arrayList);
        span.setSpanId((byte)0);
        this.m_selDriveGroup.addSpan(span);
        this.m_engine.addNewSpan(span);
        arrayList = new ArrayList();
        arrayList.add(physicalDriveHelperArray[6]);
        arrayList.add(physicalDriveHelperArray[7]);
        arrayList.add(physicalDriveHelperArray[8]);
        Span span2 = new Span(this.m_selDriveGroup, arrayList);
        span2.setSpanId((byte)1);
        this.m_selDriveGroup.addSpan(span2);
        this.m_engine.addNewSpan(span2);
    }

    public boolean isVDCompriseOfSASDrives() {
        List<Span> list = this.m_selDriveGroup.getSpans();
        for (int i = 0; i < list.size(); ++i) {
            List<PhysicalDriveHelper> list2 = list.get(i).getPhysicalDrivesList();
            for (int j = 0; j < list2.size(); ++j) {
                if (((SASPhysicalDrive)list2.get(j).getDeviceObject()).getDriveType() == 2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isVDCompriseOfSATADrives() {
        List<Span> list = this.m_selDriveGroup.getSpans();
        for (int i = 0; i < list.size(); ++i) {
            List<PhysicalDriveHelper> list2 = list.get(i).getPhysicalDrivesList();
            for (int j = 0; j < list2.size(); ++j) {
                if (((SASPhysicalDrive)list2.get(j).getDeviceObject()).getDriveType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isVDCompriseOfSSDDrives(DriveGroup driveGroup) {
        List<Span> list = driveGroup.getSpans();
        System.out.println("m_selDriveGroup.getDriveGroupName() :" + driveGroup.getDriveGroupName());
        for (int i = 0; i < list.size(); ++i) {
            List<PhysicalDriveHelper> list2 = list.get(i).getPhysicalDrivesList();
            for (int j = 0; j < list2.size(); ++j) {
                if (((SASPhysicalDrive)list2.get(j).getDeviceObject()).getMediatype() != 1) continue;
                return true;
            }
        }
        return false;
    }

    class UnitsChangeItemListener
    implements ItemListener {
        UnitsChangeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            double d;
            int n;
            if (VDCreationPanel.this.m_cmbBxUnits.getSelectedIndex() != -1 && (n = ((Integer)itemEvent.getItem()).intValue()) != VDCreationPanel.this.m_iCurrentUnit && (d = Double.parseDouble(VDCreationPanel.this.m_capacitySpinner.getValue() + "")) > 0.0) {
                double d2 = KernelConstants.getSizeInSpecifiedUnit(d, VDCreationPanel.this.m_iCurrentUnit, n, VDCreationPanel.this.m_selDriveGroup.getBlockSize());
                double d3 = KernelConstants.getSizeInSpecifiedUnit(VDCreationPanel.this.m_dMinSizeAndUnit[0], (int)VDCreationPanel.this.m_dMinSizeAndUnit[1], n, VDCreationPanel.this.m_selDriveGroup.getBlockSize());
                double d4 = KernelConstants.getSizeInSpecifiedUnit(VDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)VDCreationPanel.this.m_dMaxSizeAndUnit[1], n, VDCreationPanel.this.m_selDriveGroup.getBlockSize());
                ((VDCreationPanel)VDCreationPanel.this).m_dMinSizeAndUnit[0] = d3;
                ((VDCreationPanel)VDCreationPanel.this).m_dMaxSizeAndUnit[0] = d4;
                ((VDCreationPanel)VDCreationPanel.this).m_dMaxSizeAndUnit[1] = n;
                ((VDCreationPanel)VDCreationPanel.this).m_dMinSizeAndUnit[1] = n;
                VDCreationPanel.this.m_capacitySpinnerModel.setValue(d2);
                VDCreationPanel.this.m_capacitySpinnerModel.setMaximum(Double.valueOf(VDCreationPanel.this.m_dMaxSizeAndUnit[0]));
                VDCreationPanel.this.m_capacitySpinnerModel.setMinimum(Double.valueOf(VDCreationPanel.this.m_dMinSizeAndUnit[0]));
                VDCreationPanel.this.m_iCurrentUnit = n;
            }
        }
    }

    class DeleteVDAction
    implements ActionListener {
        DeleteVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = VDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            VirtualDrive virtualDrive = (VirtualDrive)defaultMutableTreeNode.getUserObject();
            VDCreationPanel.this.m_engine.returnLDTargetId(virtualDrive.getTargetId());
            DriveGroup driveGroup = (DriveGroup)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            driveGroup.removeVirtualDrive(virtualDrive);
            VDCreationPanel.this.m_dgTreePanel.removeCurrentlySelectedVirtualDrive();
        }
    }

    class UpdateVDAction
    implements ActionListener {
        UpdateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            JTree jTree = VDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            VirtualDrive virtualDrive = (VirtualDrive)defaultMutableTreeNode.getUserObject();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
            long l2 = virtualDrive.getSize();
            byte by = virtualDrive.getStripeSize();
            String string = VDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                string = "Virtual Drive_" + virtualDrive.getTargetId();
            }
            virtualDrive.setName(string);
            if (VDCreationPanel.this.m_engine.getCurrentAdapter().getAdapterType() == 1) {
                byte by2 = (Byte)VDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                String string2 = null;
                String string3 = null;
                if (virtualDrive.getWritePolicy() != by2) {
                    if (by2 == 0) {
                        string2 = Resource.getString("TITLE_WRITE_THROUGH_SELECTED", "Write Through Selected");
                        string3 = Resource.getString("WRITE_THROUGH_SELECTED_DESC", "<html>Write Through mode eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Are you sure you want to select Write Through mode? <br><br></html>");
                    } else if (by2 == 17) {
                        string2 = Resource.getString("TITLE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                        string3 = Resource.getString("ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back mode provides optimal performance, but data loss will <br>occur if there is a power failure and no cache battery installed or the battery <br>is failed or discharged.<br><br>Are you sure you want to select Always Write Back mode? <br><br></html> ");
                    } else if (by2 == 1) {
                        string2 = Resource.getString("TITLE_WRITE_BACK_WITH_BBU_SELECTED", "Write Back with BBU Selected");
                        string3 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_DESC", "<html>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance. <br><br>However, slower performance should be expected when BBU is not <br>installed,not fully charged, or running through re-learn cycle.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                        if (VDCreationPanel.this.m_adapterHelper.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getbbu() == 0) {
                            string3 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                        } else {
                            MR_BBU_FW_STATUS mR_BBU_FW_STATUS = null;
                            int n = 5;
                            try {
                                n = ((SASAdapter)VDCreationPanel.this.m_adapterHelper.getDeviceObject()).getBBUObject().getInformation().getStatus().getbatteryType();
                                mR_BBU_FW_STATUS = ((SASAdapter)VDCreationPanel.this.m_adapterHelper.getDeviceObject()).getBBUObject().getStatus().getMrbbufwStatus();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (mR_BBU_FW_STATUS.getreplacePack() || mR_BBU_FW_STATUS.getremainingCapacityLow()) {
                                string3 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            } else if (n == 1 && (mR_BBU_FW_STATUS.getlearnCycleRequested() || mR_BBU_FW_STATUS.getlearnCycleActive() || mR_BBU_FW_STATUS.getdischargeActive())) {
                                string3 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            }
                        }
                    }
                    if (JOptionPane.showConfirmDialog(null, string3, string2, 0, 2) != 0) {
                        return;
                    }
                }
            }
            double[] dArray = KernelConstants.getSizeAndUnit(l2, VDCreationPanel.this.m_selDriveGroup.getBlockSize());
            double d = Double.parseDouble(VDCreationPanel.this.m_capacitySpinner.getValue() + "");
            double d2 = ((Integer)VDCreationPanel.this.m_cmbBxUnits.getSelectedItem()).intValue();
            long l3 = KernelConstants.getSizeInBlocks(d, (int)d2, driveGroup.getBlockSize());
            if (dArray[1] != d2) {
                dArray[0] = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], (int)d2, VDCreationPanel.this.m_selDriveGroup.getBlockSize());
                dArray[1] = d2;
                if (driveGroup.getFreeSizeInBlocks() != 0L) {
                    l = KernelConstants.getSizeInBlocks(VDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)VDCreationPanel.this.m_dMaxSizeAndUnit[1], driveGroup.getBlockSize());
                    if (l3 == l) {
                        l3 = driveGroup.getFreeSizeInBlocks() + l2;
                    }
                } else if (d == dArray[0]) {
                    l3 = l2;
                }
            } else if (d == dArray[0]) {
                l3 = l2;
            } else if (driveGroup.getFreeSizeInBlocks() != 0L && l3 == (l = KernelConstants.getSizeInBlocks(VDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)VDCreationPanel.this.m_dMaxSizeAndUnit[1], driveGroup.getBlockSize()))) {
                l3 = driveGroup.getFreeSizeInBlocks() + l2;
            }
            if (l3 != l2) {
                virtualDrive.setSize(l3);
            }
            virtualDrive.setInitState((byte)VDCreationPanel.this.m_cmbBxInitState.getSelectedIndex());
            byte by3 = (Byte)VDCreationPanel.this.m_cmbBxStripeSize.getSelectedItem();
            if (by3 != by) {
                virtualDrive.setStripeSize(by3);
            }
            virtualDrive.setReadPolicy((Byte)VDCreationPanel.this.m_cmbBxReadPolicy.getSelectedItem());
            virtualDrive.setWritePolicy((Byte)VDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            virtualDrive.setIOPolicy((Byte)VDCreationPanel.this.m_cmbBxIOPolicy.getSelectedItem());
            virtualDrive.setAccessPolicy((Byte)VDCreationPanel.this.m_cmbBxAccessPolicy.getSelectedItem());
            virtualDrive.setDiskCachePolicy((Byte)VDCreationPanel.this.m_cmbBxDiskCachePolicy.getSelectedItem());
            boolean bl = VDCreationPanel.this.m_chkBxExposeVd.isSelected();
            virtualDrive.setM_accessToRemoteOs(bl);
            if (l2 != l3 || by != by3) {
                driveGroup.updateVirtualDrive(virtualDrive, l2);
            }
            VDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
        }
    }

    class CreateVDAction
    implements ActionListener {
        CreateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            if (((SASAdapter)VDCreationPanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                byte by = (Byte)VDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                object2 = null;
                object = null;
                if (by == 0) {
                    object2 = Resource.getString("TITLE_WRITE_THROUGH_SELECTED", "Write Through Selected");
                    object = Resource.getString("WRITE_THROUGH_SELECTED_DESC", "<html>Write Through means that the cache can only be<br>used for reads. It will not support any writes.</html>");
                } else if (by == 17) {
                    object2 = Resource.getString("TITLE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                    object = Resource.getString("ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back mode provides optimal performance, but data loss will <br>occur if there is a power failure and no cache battery installed or the battery <br>is failed or discharged.<br><br>Are you sure you want to select Always Write Back mode? <br><br></html> ");
                } else if (by == 1) {
                    object2 = Resource.getString("TITLE_WRITE_BACK_WITH_BBU_SELECTED", "Write Back with BBU Selected");
                    object = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_DESC", "<html>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance. <br><br>However, slower performance should be expected when BBU is not <br>installed,not fully charged, or running through re-learn cycle.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    if (VDCreationPanel.this.m_adapterHelper.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getbbu() == 0) {
                        object = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    } else {
                        MR_BBU_FW_STATUS mR_BBU_FW_STATUS = null;
                        int n = 5;
                        try {
                            n = ((SASAdapter)VDCreationPanel.this.m_adapterHelper.getDeviceObject()).getBBUObject().getInformation().getStatus().getbatteryType();
                            mR_BBU_FW_STATUS = ((SASAdapter)VDCreationPanel.this.m_adapterHelper.getDeviceObject()).getBBUObject().getStatus().getMrbbufwStatus();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (mR_BBU_FW_STATUS != null) {
                            if (mR_BBU_FW_STATUS.getreplacePack() || mR_BBU_FW_STATUS.getremainingCapacityLow()) {
                                object = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            } else if (n == 1 && (mR_BBU_FW_STATUS.getlearnCycleRequested() || mR_BBU_FW_STATUS.getlearnCycleActive() || mR_BBU_FW_STATUS.getdischargeActive())) {
                                object = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                            }
                        }
                    }
                }
                if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                    return;
                }
            }
            JTree jTree = VDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            object2 = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            object = (DriveGroup)((DefaultMutableTreeNode)object2).getUserObject();
            double d = Double.parseDouble(VDCreationPanel.this.m_capacitySpinner.getValue() + "");
            long l = KernelConstants.getSizeInBlocks(d, (Integer)VDCreationPanel.this.m_cmbBxUnits.getSelectedItem(), ((DriveGroup)object).getBlockSize());
            if (l == KernelConstants.getSizeInBlocks(VDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)VDCreationPanel.this.m_dMaxSizeAndUnit[1], ((DriveGroup)object).getBlockSize()) || ((DriveGroup)object).isNotExceedingMinimumBlockSize(l)) {
                l = ((DriveGroup)object).getFreeSizeInBlocks();
            }
            byte by = VDCreationPanel.this.m_engine.getLDTargetId();
            byte by2 = (Byte)VDCreationPanel.this.m_cmbBxStripeSize.getSelectedItem();
            String string = VDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                string = VDCreationPanel.this.m_strSuggestedVDName;
            }
            if (string.length() > 15) {
                string = string.substring(0, 15);
            }
            VirtualDrive virtualDrive = new VirtualDrive((DriveGroup)object, by, l, string, by2);
            virtualDrive.setInitState((byte)VDCreationPanel.this.m_cmbBxInitState.getSelectedIndex());
            virtualDrive.setReadPolicy((Byte)VDCreationPanel.this.m_cmbBxReadPolicy.getSelectedItem());
            virtualDrive.setWritePolicy((Byte)VDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            virtualDrive.setIOPolicy((Byte)VDCreationPanel.this.m_cmbBxIOPolicy.getSelectedItem());
            virtualDrive.setAccessPolicy((Byte)VDCreationPanel.this.m_cmbBxAccessPolicy.getSelectedItem());
            virtualDrive.setDiskCachePolicy((Byte)VDCreationPanel.this.m_cmbBxDiskCachePolicy.getSelectedItem());
            boolean bl = VDCreationPanel.this.m_chkBxExposeVd.isSelected();
            virtualDrive.setM_accessToRemoteOs(bl);
            ((DriveGroup)object).addVirtualDrive(virtualDrive);
            VDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
            VDCreationPanel.this.m_dgTreePanel.addVirtualDrive((DefaultMutableTreeNode)object2, virtualDrive);
            VDCreationPanel.this.m_chkBxExposeVd.setSelected(true);
            VDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
        }
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof DriveGroup) {
                if (VDCreationPanel.this.m_engine.canAddNewVirtualDrive() && ((DriveGroup)object).canAddVD()) {
                    VDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(true);
                    VDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    VDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    VDCreationPanel.this.m_selDriveGroup = (DriveGroup)object;
                    VDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
                } else {
                    VDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                    VDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    VDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    VDCreationPanel.this.resetPanel();
                }
            } else if (object instanceof VirtualDrive) {
                VDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                VDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(true);
                VDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(true);
                VirtualDrive virtualDrive = (VirtualDrive)object;
                VDCreationPanel.this.resetVDPanelToVirtualDrive(virtualDrive);
            } else {
                VDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                VDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                VDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                VDCreationPanel.this.resetPanel();
            }
        }
    }

    class DriveGroupTreeModelListener
    implements TreeModelListener {
        DriveGroupTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            VDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            VDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            VDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            VDCreationPanel.this.generateChangeEvent();
        }
    }
}

