/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.advanced;

import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.Span;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.SASAdapter.SASAdapter;
import Services.KernelConstants;
import Utils.Resource;
import java.util.List;

public class VirtualDrive {
    private DriveGroup m_dg = null;
    private long m_lSize = 0L;
    private byte m_bTargetId = 0;
    private String m_strName = null;
    private byte m_bInitState = 0;
    private byte m_bStripeSize = 0;
    private byte m_bReadPolicy = 0;
    private byte m_bWritePolicy = 0;
    private byte m_bIOPolicy = 0;
    private byte m_bAccessPolicy = 0;
    private byte m_bDiskCachePolicy = 0;
    private boolean m_accessToRemoteOs = false;
    private boolean m_isSSCD = false;
    private boolean m_isCSACacheCade = false;

    public VirtualDrive(DriveGroup driveGroup, byte by, long l, String string, byte by2) {
        this.m_dg = driveGroup;
        this.m_bTargetId = by;
        this.m_lSize = this.computeVDSize(l, by2);
        this.m_bStripeSize = by2;
        this.m_strName = string;
        this.m_isSSCD = driveGroup.isSSC();
        this.m_isCSACacheCade = driveGroup.isCSACacheCade();
    }

    public String toString() {
        if (this.m_isCSACacheCade) {
            return Resource.getString("CSA_VIRTUAL_DRIVE_LABEL") + this.m_bTargetId + "," + this.m_strName + ":" + KernelConstants.getConvertedSize(this.m_lSize, this.m_dg.getBlockSize());
        }
        if (this.isSSCD()) {
            return this.getSSCDText();
        }
        return Resource.getString("VIRTUAL_DRIVE_TEXT") + " " + this.m_bTargetId + "," + this.m_strName + ":" + KernelConstants.getConvertedSize(this.m_lSize, this.m_dg.getBlockSize());
    }

    public String getSSCDText() {
        return "CacheCade\u2122 - SSD Caching:" + this.m_bTargetId + "," + this.m_strName + ":" + KernelConstants.getConvertedSize(this.m_lSize, this.m_dg.getBlockSize());
    }

    public String getText() {
        return this.toString();
    }

    public long getSize() {
        return this.m_lSize;
    }

    public String getName() {
        return this.m_strName;
    }

    public byte getTargetId() {
        return this.m_bTargetId;
    }

    public DriveGroup getDriveGroup() {
        return this.m_dg;
    }

    public void setName(String string) {
        this.m_strName = string;
    }

    public void setSize(long l) {
        this.m_lSize = this.computeVDSize(l, this.m_bStripeSize);
    }

    public byte getInitState() {
        return this.m_bInitState;
    }

    public void setInitState(byte by) {
        this.m_bInitState = by;
    }

    public byte getStripeSize() {
        return this.m_bStripeSize;
    }

    public void setStripeSize(byte by) {
        this.m_bStripeSize = by;
        this.m_lSize = this.computeVDSize(this.m_lSize, this.m_bStripeSize);
    }

    public byte getReadPolicy() {
        return this.m_bReadPolicy;
    }

    public void setReadPolicy(byte by) {
        this.m_bReadPolicy = by;
    }

    public byte getWritePolicy() {
        return this.m_bWritePolicy;
    }

    public void setWritePolicy(byte by) {
        this.m_bWritePolicy = by;
    }

    public byte getIOPolicy() {
        return this.m_bIOPolicy;
    }

    public void setIOPolicy(byte by) {
        this.m_bIOPolicy = by;
    }

    public byte getAccessPolicy() {
        return this.m_bAccessPolicy;
    }

    public void setAccessPolicy(byte by) {
        this.m_bAccessPolicy = by;
    }

    public byte getDiskCachePolicy() {
        return this.m_bDiskCachePolicy;
    }

    public void setDiskCachePolicy(byte by) {
        this.m_bDiskCachePolicy = by;
    }

    private long computeVDSize(long l, byte by) {
        long l2 = this.m_dg.getFreeSizeInBlocks() + this.m_lSize;
        if (l2 <= l) {
            l = l2;
        }
        byte by2 = (byte)(this.m_dg.getRaidLevel() & 0xFFFFFFBF);
        int n = this.m_dg.getSpans().get(0).getNumberOfDrives();
        int n2 = 0;
        if (by2 == 0 || by2 == 7) {
            n2 = n;
        } else if (by2 == 1) {
            n2 = 1;
        } else if (by2 == 17) {
            n2 = n / 2;
        } else if (by2 == 16) {
            n2 = n / 2;
        } else if (by2 == 5) {
            n2 = n - 1;
        } else if (by2 == 6) {
            n2 = n - 2;
        }
        long l3 = l * (long)n / (long)n2;
        long l4 = l3 / (long)this.m_dg.getSpanDepth();
        long l5 = (long)Math.pow(2.0, by - 1) * 1024L / (long)this.m_dg.getBlockSize();
        long l6 = l4 / (l5 * (long)n) * ((long)n * l5);
        long l7 = l6 / (long)n;
        long l8 = l7 * (long)n2 * (long)this.m_dg.getSpanDepth();
        return l8;
    }

    public boolean isM_accessToRemoteOs() {
        return this.m_accessToRemoteOs;
    }

    public void setM_accessToRemoteOs(boolean bl) {
        this.m_accessToRemoteOs = bl;
    }

    public void setisSSCD() {
        this.m_isSSCD = true;
    }

    public boolean isSSCD() {
        return this.m_isSSCD;
    }

    public MR_LD_CONFIG getMRLDConfig(long l, long l2, List<MR_ARRAY> list) {
        MR_LD_CONFIG mR_LD_CONFIG = new MR_LD_CONFIG();
        mR_LD_CONFIG.setparams(this.getVirtualDriveParameters());
        mR_LD_CONFIG.setproperties(this.getVirualDriveProperties());
        for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
            MR_SPAN mR_SPAN = mR_LD_CONFIG.getspan()[n];
            mR_SPAN.setstartBlock(l);
            mR_SPAN.setarrayRef(list.get(n).getarrayRef());
            mR_SPAN.setnumBlocks(l2);
        }
        return mR_LD_CONFIG;
    }

    public MR_LD_PARAMETERS getVirtualDriveParameters() {
        MR_LD_PARAMETERS mR_LD_PARAMETERS = new MR_LD_PARAMETERS();
        SASAdapter sASAdapter = (SASAdapter)this.m_dg.getAdapterHelper().getDeviceObject();
        int n = this.m_dg.getRaidLevel() & 0xFFFFFFBF;
        if (n == 17 && sASAdapter.getAdapterType() == 2) {
            n = 1;
        }
        if (n == 16) {
            n = 17;
        }
        mR_LD_PARAMETERS.setPRL((char)n);
        if (n == 5 || n == 6) {
            mR_LD_PARAMETERS.setRLQ('\u0003');
        } else {
            mR_LD_PARAMETERS.setRLQ('\u0000');
        }
        mR_LD_PARAMETERS.setSRL('\u0000');
        mR_LD_PARAMETERS.setstripeSize((char)this.m_bStripeSize);
        List<Span> list = this.m_dg.getSpans();
        mR_LD_PARAMETERS.setnumDrives((char)list.get(0).getNumberOfDrives());
        mR_LD_PARAMETERS.setspanDepth((char)list.size());
        mR_LD_PARAMETERS.setstate('\u0003');
        if (sASAdapter.getAdapterType() == 2 || sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
            mR_LD_PARAMETERS.setinitState('\u0001');
        } else {
            mR_LD_PARAMETERS.setinitState((char)this.m_bInitState);
        }
        mR_LD_PARAMETERS.setEncryptionType(this.m_dg.getEncrptionMethod());
        if (this.m_dg.isSSC()) {
            mR_LD_PARAMETERS.setisSSCd((byte)1);
        } else {
            mR_LD_PARAMETERS.setisSSCd((byte)0);
        }
        if (this.m_dg.isPIEnabled()) {
            mR_LD_PARAMETERS.setPIType((byte)8);
        } else {
            mR_LD_PARAMETERS.setPIType((byte)0);
        }
        if (n == 7) {
            n = 17;
            mR_LD_PARAMETERS.setisSSCd((byte)2);
            mR_LD_PARAMETERS.setPRL((char)n);
            mR_LD_PARAMETERS.setRLQ('\u0001');
        }
        return mR_LD_PARAMETERS;
    }

    public MR_LD_PROPERTIES getVirualDriveProperties() {
        MR_LD_PROPERTIES mR_LD_PROPERTIES = new MR_LD_PROPERTIES();
        AdapterHelper adapterHelper = this.m_dg.getAdapterHelper();
        mR_LD_PROPERTIES.setname(this.m_strName.getBytes());
        byte by = (byte)(this.m_bReadPolicy | this.m_bWritePolicy | this.m_bIOPolicy);
        mR_LD_PROPERTIES.setdefaultCachePolicy((char)by);
        mR_LD_PROPERTIES.setaccessPolicy((char)this.m_bAccessPolicy);
        mR_LD_PROPERTIES.setdiskCachePolicy((char)this.m_bDiskCachePolicy);
        if (this.m_accessToRemoteOs) {
            mR_LD_PROPERTIES.setnonShared((byte)0);
        } else {
            mR_LD_PROPERTIES.setnonShared((byte)1);
        }
        if (!this.m_dg.isSSC()) {
            mR_LD_PROPERTIES.setdefaultPSPolicy(this.m_dg.getPowerSavePolicy());
        } else {
            mR_LD_PROPERTIES.setdefaultPSPolicy((byte)0);
        }
        mR_LD_PROPERTIES.getldRef().settargetId((char)this.m_bTargetId);
        return mR_LD_PROPERTIES;
    }

    public void oldFunc() {
    }

    public void oldFunc2() {
    }

    public void oldFunc3() {
    }
}

