/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class DriveGroupModificationPage
extends DefaultWizardPage
implements ListSelectionListener,
TableModelListener,
HelpInterface {
    private LogicalDriveHelper m_ldHelper = null;
    private AdapterHelper m_adapterHelper = null;
    private RAIDTransitionUnit m_selectedRTU = null;
    private JPanel m_contentPanel = null;
    private JTable m_drivesTable = null;
    private JLabel m_lblDGModifyMsg = null;
    private JLabel m_lblTable = null;
    private PhysicalDriveHelper[] m_selectablePDHelpers = null;
    private SelectableDrivesTableModel m_drivesTableModel = null;
    private int m_iSelectedMode = -1;
    private byte m_bMinPDsToAdd = 0;
    private byte m_bMaxPDsToAdd = (byte)10;
    private byte m_bMinPDsToRemove = 0;
    private byte m_bMaxPDsToRemove = 1;

    @Override
    protected void reinitialise() {
        if (this.m_ldHelper == null) {
            this.m_ldHelper = (LogicalDriveHelper)this.m_hmWizardData.get("LogicalDriveHelper");
            this.m_selectablePDHelpers = (PhysicalDriveHelper[])this.m_hmWizardData.get("SelectablePDHelpers");
            this.m_adapterHelper = (AdapterHelper)this.m_ldHelper.getParent();
            this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_ACCESSING_THE_MODIFY_DRIVE_GROUP_WIZARD" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_INTRODUCTION" : "IR_INTRODUCTION");
            this.m_selectedRTU = (RAIDTransitionUnit)this.m_hmWizardData.get("SelectedRTU");
            this.m_bMinPDsToAdd = this.m_selectedRTU.getMinDrivesToAdd();
            this.m_bMaxPDsToAdd = this.m_selectedRTU.getMaxDrivesToAdd();
            this.m_bMinPDsToRemove = this.m_selectedRTU.getMinDrivesToRemove();
            this.m_bMaxPDsToRemove = this.m_selectedRTU.getMaxDrivesToRemove();
            this.m_iSelectedMode = ((Byte)this.m_hmWizardData.get("SelectedMode")).intValue();
            this.setNextButtonStatus(false);
            try {
                HelpContext.registerHelp(this);
            }
            catch (HelpException helpException) {
                helpException.printStackTrace();
            }
        } else {
            RAIDTransitionUnit rAIDTransitionUnit = (RAIDTransitionUnit)this.m_hmWizardData.get("SelectedRTU");
            if (rAIDTransitionUnit.equals(this.m_selectedRTU)) {
                int n = ((Byte)this.m_hmWizardData.get("SelectedMode")).intValue();
                if (n != this.m_iSelectedMode) {
                    this.updatePanel();
                }
            } else {
                this.updatePanel();
            }
        }
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_contentPanel == null) {
            this.buildPanel();
        }
        return this.m_contentPanel;
    }

    private void updatePanel() {
        byte by;
        String[] stringArray = null;
        this.m_selectedRTU = (RAIDTransitionUnit)this.m_hmWizardData.get("SelectedRTU");
        this.m_bMinPDsToAdd = this.m_selectedRTU.getMinDrivesToAdd();
        this.m_bMaxPDsToAdd = this.m_selectedRTU.getMaxDrivesToAdd();
        this.m_bMinPDsToRemove = this.m_selectedRTU.getMinDrivesToRemove();
        this.m_bMaxPDsToRemove = this.m_selectedRTU.getMaxDrivesToRemove();
        this.m_iSelectedMode = ((Byte)this.m_hmWizardData.get("SelectedMode")).intValue();
        this.setNextButtonStatus(false);
        byte by2 = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
        if (by2 == 17) {
            by2 = 1;
        }
        if ((by = this.m_selectedRTU.getTargetPRLevel()) == 17) {
            by = 1;
        }
        Object[] objectArray = null;
        String string = null;
        if (this.m_iSelectedMode == 1) {
            if (this.m_selectedRTU.getMinDrivesToAdd() == 0) {
                objectArray = new Object[]{by, by2, by};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_ADD_WO_DRIVES", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can either add the drives from the table below or proceed<br>without adding any drives.<br><br></html>"), objectArray);
            } else {
                objectArray = new Object[]{by, by2, by, this.m_selectedRTU.getMinDrivesToAdd()};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_ADD", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you need to add at least {3} drive(s) to the configuration.<br>Use the below table to add the drive(s) and click next to proceed.<br><br></html>"), objectArray);
            }
            this.m_lblDGModifyMsg.setText(string);
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_UG_DRIVES_ADD", "Select the unconfigured drive to (a)dd:"));
            this.m_drivesTableModel = new SelectableDrivesTableModel(this.m_selectablePDHelpers);
            if (this.m_selectedRTU.getMinDrivesToAdd() == 0) {
                this.setNextButtonStatus(true);
            }
        } else {
            if (this.m_selectedRTU.getMinDrivesToRemove() == 0) {
                objectArray = new Object[]{by, by2, by};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_REMOVE_WO_DRIVES", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can either remove the drives from the table below or proceed<br>without removing any drives.<br><br></html>"), objectArray);
            } else {
                objectArray = new Object[]{by, by2, by, this.m_selectedRTU.getMaxDrivesToRemove()};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_REMOVE", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can remove at most {3} drive(s) from the configuration.<br>Use the below table to remove the drive(s) and click next to proceed. You cannot remove a drive which is a part of required drive set for the selected<br>RAID level.<br><br></html>"), objectArray);
            }
            this.m_lblDGModifyMsg.setText(string);
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_DRIVES_REMOVE", " Select the drive to remo(v)e:"));
            this.m_drivesTableModel = new SelectableDrivesTableModel(this.m_ldHelper.getPDListInLd());
            if (this.m_selectedRTU.getMinDrivesToRemove() == 0) {
                this.setNextButtonStatus(true);
            }
        }
        this.m_lblTable.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_lblTable.setDisplayedMnemonic(stringArray[1].charAt(0));
            this.m_lblTable.setLabelFor(this.m_drivesTable);
        }
        this.m_drivesTable.setModel(this.m_drivesTableModel);
        this.m_drivesTableModel.addTableModelListener(this);
        this.m_drivesTable.getColumnModel().getColumn(1).setCellRenderer(new PDTableCellRenderer());
    }

    private void buildPanel() {
        byte by;
        String[] stringArray = null;
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        byte by2 = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
        if (by2 == 17) {
            by2 = 1;
        }
        if ((by = this.m_selectedRTU.getTargetPRLevel()) == 17) {
            by = 1;
        }
        Object[] objectArray = null;
        String string = null;
        if (this.m_iSelectedMode == 1) {
            if (this.m_selectedRTU.getMinDrivesToAdd() == 0) {
                objectArray = new Object[]{by, by2, by};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_ADD_WO_DRIVES", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can either add the drives from the table below or proceed<br>without adding any drives.<br><br></html>"), objectArray);
            } else {
                objectArray = new Object[]{by, by2, by, this.m_selectedRTU.getMinDrivesToAdd()};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_ADD", " <html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you need to add at least {3} drive(s) to the configuration.<br>Use the below table to add the drive(s) and click next to proceed.<br><br></html>"), objectArray);
            }
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_UG_DRIVES_ADD", " Select the unconfigured drive to (a)dd:"));
            this.m_drivesTableModel = new SelectableDrivesTableModel(this.m_selectablePDHelpers);
            if (this.m_selectedRTU.getMinDrivesToAdd() == 0) {
                this.setNextButtonStatus(true);
            }
        } else {
            if (this.m_selectedRTU.getMinDrivesToRemove() == 0) {
                objectArray = new Object[]{by, by2, by};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_REMOVE_WO_DRIVES", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can either add the drives from the table below or proceed<br>without adding any drives.<br><br></html>"), objectArray);
            } else {
                objectArray = new Object[]{by, by2, by, this.m_selectedRTU.getMaxDrivesToRemove()};
                string = MessageFormat.format(Resource.getString("LABEL_DG_MODIFY_REMOVE", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2}, you can remove at most {3} drive(s) from the configuration.<br>Use the below table to remove the drive(s) and click next to proceed. You cannot remove a drive which is a part of required drive set for the selected<br>RAID level.<br><br></html>"), objectArray);
            }
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_DRIVES_REMOVE", "Select the drive to remo(v)e:"));
            this.m_drivesTableModel = new SelectableDrivesTableModel(this.m_ldHelper.getPDListInLd());
            if (this.m_selectedRTU.getMinDrivesToRemove() == 0) {
                this.setNextButtonStatus(true);
            }
        }
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 10, 10);
        this.m_lblDGModifyMsg = new JLabel(string);
        this.m_contentPanel.add((Component)this.m_lblDGModifyMsg, gridBagConstraints);
        this.m_drivesTableModel.addTableModelListener(this);
        this.m_drivesTable = new JTable(this.m_drivesTableModel);
        this.m_drivesTable.setCellSelectionEnabled(false);
        this.m_drivesTable.setColumnSelectionAllowed(false);
        this.m_drivesTable.setRowSelectionAllowed(true);
        this.m_drivesTable.getSelectionModel().addListSelectionListener(this);
        this.m_drivesTable.setSelectionMode(2);
        this.m_drivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_drivesTable.getTableHeader().setResizingAllowed(true);
        this.m_drivesTable.getColumnModel().getColumn(1).setCellRenderer(new PDTableCellRenderer());
        this.m_lblTable = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_lblTable.setDisplayedMnemonic(stringArray[1].charAt(0));
            this.m_lblTable.setLabelFor(this.m_drivesTable);
        }
        ++gridBagConstraints.gridy;
        this.m_contentPanel.add((Component)this.m_lblTable, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JScrollPane jScrollPane = new JScrollPane(this.m_drivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        this.m_contentPanel.add((Component)this.m_lblTable, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 50, 10);
        this.m_contentPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    @Override
    public String getPageID() {
        return "DGModificationPage";
    }

    @Override
    public String getTitle() {
        if (this.m_iSelectedMode == 1) {
            return Resource.getString("RECONFIG_DG_MODIFICATION_PAGE_TITLE_ADD", "Modify Drive Group - Add drive to the current configuration");
        }
        return Resource.getString("RECONFIG_DG_MODIFICATION_PAGE_TITLE_REMOVE", "Modify Drive Group - Remove drive from the current configuration");
    }

    @Override
    public void onNext() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_drivesTableModel.getSelectedPhysicalDrives();
        if (this.m_ldHelper.getEncryptionType() != 1) {
            boolean bl = false;
            for (int n = 0; n < physicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
                if (!physicalDriveHelperArray[n].isEncrypted()) continue;
                bl = true;
                break;
            }
            if (bl && JOptionPane.showConfirmDialog(null, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK", "<html>One or more secured FDE drives are chosen for this operation.<br>Any data on the drives will be permanently lost.<br><br>Are your sure you want to proceed?<br><br></html>"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK", "Confirm instant secure erase"), 0, 2) == 1) {
                return;
            }
        }
        this.m_hmWizardData.put("SelectedPDHelpers", this.m_drivesTableModel.getSelectedPhysicalDrives());
        super.onNext();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        System.out.println("DriveGroupModificationPage.valueChanged()");
        int[] nArray = this.m_drivesTable.getSelectedRows();
        System.out.println("selectedRows1: " + nArray.length);
        System.out.println("selectedRowCount: " + this.m_drivesTable.getSelectedRowCount());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        System.out.println("DriveGroupModificationPage.tableChanged()");
        int n2 = this.m_drivesTableModel.getSelectedRowCount();
        System.out.println("selectedRows: " + n2);
        boolean bl = true;
        int n3 = 0;
        if (this.m_ldHelper.getLdParameters().getstate() == '\u0002' || this.m_ldHelper.getLdParameters().getstate() == '\u0001') {
            for (n = 0; n < this.m_drivesTableModel.m_pdHelpers.length; ++n) {
                if (this.m_drivesTableModel.m_pdHelpers[n].getStatus() != 16 || ((Boolean)this.m_drivesTableModel.getValueAt(n, 0)).booleanValue()) continue;
                ++n3;
            }
        }
        if ((this.m_ldHelper.getLdParameters().getstate() == '\u0002' || this.m_ldHelper.getLdParameters().getstate() == '\u0001') && this.m_iSelectedMode == 2) {
            int n4;
            boolean bl2;
            boolean bl3;
            n = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
            boolean bl4 = bl3 = this.m_selectedRTU.getTargetPRLevel() == 5 || this.m_selectedRTU.getTargetPRLevel() == 6 || this.m_selectedRTU.getTargetPRLevel() == 0;
            if (bl3 && n == 17 && n3 > 0) {
                if (n3 > 1 && this.m_selectedRTU.getTargetPRLevel() == 5) {
                    bl = false;
                } else if (n3 > 2 && this.m_selectedRTU.getTargetPRLevel() == 6) {
                    bl = false;
                }
            }
            boolean bl5 = bl2 = n == 1 || n == 5;
            if (this.m_selectedRTU.getTargetPRLevel() == 0 && bl2 && n3 > 0) {
                for (n4 = 0; n4 < n2; ++n4) {
                    if (this.m_drivesTableModel.getSelectedPhysicalDrives()[n4].getStatus() != 24) continue;
                    bl = false;
                    break;
                }
            }
            boolean bl6 = bl2 = n == 6 || n == 17;
            if (this.m_selectedRTU.getTargetPRLevel() == 0 && bl2) {
                for (n4 = 0; n4 < this.m_drivesTableModel.m_pdHelpers.length; ++n4) {
                    if (this.m_drivesTableModel.m_pdHelpers[n4].getStatus() != 16 || ((Boolean)this.m_drivesTableModel.getValueAt(n4, 0)).booleanValue()) continue;
                    bl = false;
                    break;
                }
            }
        }
        n = 0;
        if (this.m_iSelectedMode == 1) {
            this.setNextButtonStatus(n2 >= this.m_bMinPDsToAdd && n2 <= this.m_bMaxPDsToAdd);
            n = n2 + this.m_ldHelper.getLdParameters().getnumDrives();
        } else if (this.m_iSelectedMode == 2) {
            this.setNextButtonStatus(n2 >= this.m_bMinPDsToRemove && n2 <= this.m_bMaxPDsToRemove && bl);
            n = n2 - this.m_ldHelper.getLdParameters().getnumDrives();
        }
        if (n % 2 != 0 && (this.m_selectedRTU.getTargetPRLevel() == 1 || this.m_selectedRTU.getTargetPRLevel() == 17)) {
            this.setNextButtonStatus(false);
        }
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    private class PDTableCellRenderer
    extends DefaultTableCellRenderer {
        private PDTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 1) {
                PhysicalDriveHelper physicalDriveHelper = null;
                if (DriveGroupModificationPage.this.m_iSelectedMode == 1) {
                    physicalDriveHelper = DriveGroupModificationPage.this.m_selectablePDHelpers[n];
                } else if (DriveGroupModificationPage.this.m_iSelectedMode == 2) {
                    physicalDriveHelper = DriveGroupModificationPage.this.m_ldHelper.getPDListInLd()[n];
                }
                if (physicalDriveHelper != null) {
                    ImageIcon imageIcon = physicalDriveHelper.getIcon();
                    jLabel.setIcon(imageIcon);
                }
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }

    class SelectableDrivesTableModel
    extends AbstractTableModel {
        private PhysicalDriveHelper[] m_pdHelpers = null;
        private boolean[] m_selectedRows = null;

        public SelectableDrivesTableModel(PhysicalDriveHelper[] physicalDriveHelperArray) {
            this.m_pdHelpers = physicalDriveHelperArray;
            this.m_selectedRows = new boolean[physicalDriveHelperArray.length];
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.m_pdHelpers.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            PhysicalDriveHelper physicalDriveHelper = this.m_pdHelpers[n];
            if (n2 == 0) {
                object = new Boolean(this.m_selectedRows[n]);
            }
            if (n2 == 1) {
                object = physicalDriveHelper.getTextForTable()[0];
            } else if (n2 == 2) {
                object = physicalDriveHelper.getTextForTable()[1];
            } else if (n2 == 3) {
                object = physicalDriveHelper.getTextForTable()[2];
            } else if (n2 == 4) {
                object = physicalDriveHelper.getState();
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 1) {
                string = Resource.getString("COL_NAME_AVAILABLE_DRIVES", "Available Drives");
            } else if (n == 2) {
                string = Resource.getString("COL_NAME_TYPE", "Type");
            } else if (n == 3) {
                string = Resource.getString("COL_NAME_CAPACITY", "Capacity");
            } else if (n == 4) {
                string = Resource.getString("COL_NAME_STATUS", "Status");
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.m_selectedRows[n] = (Boolean)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public int getSelectedRowCount() {
            int n = 0;
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                if (!this.m_selectedRows[i]) continue;
                ++n;
            }
            return n;
        }

        public PhysicalDriveHelper[] getSelectedPhysicalDrives() {
            PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[this.getSelectedRowCount()];
            int n = 0;
            for (int i = 0; i < this.m_selectedRows.length; ++i) {
                if (!this.m_selectedRows[i]) continue;
                physicalDriveHelperArray[n++] = this.m_pdHelpers[i];
            }
            return physicalDriveHelperArray;
        }
    }
}

