/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ModeSelectionPage
extends DefaultWizardPage
implements HelpInterface {
    private LogicalDriveHelper m_ldHelper = null;
    private JPanel m_contentPanel = null;
    private JRadioButton m_rdBtnAddDrives = null;
    private JRadioButton m_rdBtnRemoveDrives = null;
    private JRadioButton m_rdbtnMigrateRL = null;
    private JLabel m_lbModeSelMsg = null;
    private RAIDTransitionUnit m_selectedRTU = null;

    @Override
    protected void reinitialise() {
        this.m_ldHelper = (LogicalDriveHelper)this.m_hmWizardData.get("LogicalDriveHelper");
        this.m_strHelpFileName = ((SASAdapter)((AdapterHelper)this.m_ldHelper.getParent()).getDeviceObject()).getAdapterType() == 1 ? "MR_INTRODUCTION" : "IR_INTRODUCTION";
        this.m_selectedRTU = (RAIDTransitionUnit)this.m_hmWizardData.get("SelectedRTU");
        if (this.m_contentPanel != null) {
            this.updatePanel();
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_contentPanel == null) {
            this.buildPanel();
        }
        return this.m_contentPanel;
    }

    private void buildPanel() {
        byte by;
        String[] stringArray = null;
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 10);
        byte by2 = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
        if (by2 == 17) {
            by2 = 1;
        }
        if ((by = this.m_selectedRTU.getTargetPRLevel()) == 17) {
            by = 1;
        }
        Object[] objectArray = new Object[]{by, by2, by};
        String string = MessageFormat.format(Resource.getString("LABEL_MODE_SELECTION_HEADING", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2} you can either Add the drives or Remove the drives or Migrate the<br>RAID level.<br><br></html>"), objectArray);
        this.m_lbModeSelMsg = new JLabel(string);
        this.m_contentPanel.add((Component)this.m_lbModeSelMsg, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("LABEL_CHOOSE_OPERATIONS", "<html>Choose the operations you want to perform:<br><br></html>")), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ADD_DRIVES", "(A)dd drives"));
        this.m_rdBtnAddDrives = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnAddDrives.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)this.m_rdBtnAddDrives, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESC_ADD_DRIVES", "<html>Add drive provides a way to reconstruct the existing storage configuration by adding new physical drives.<br><br></html>")), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REMOVE_DRIVES", "(R)emove drives"));
        this.m_rdBtnRemoveDrives = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnRemoveDrives.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)this.m_rdBtnRemoveDrives, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESC_REMOVE_DRIVES", "<html>Remove drive provides a way to reconstruct the existing storage configuration by removing physical drives.<br><br></html>")), gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_MIGRATE_RL", "(M)igrate RAID level"));
        this.m_rdbtnMigrateRL = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdbtnMigrateRL.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)this.m_rdbtnMigrateRL, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 30, 50, 10);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("DESC_MIGRATE_RL", "<html>Migrate RAID Level provides a way to reconstruct the existing storage configuration without adding or removing the drives.<br>This has been done by changing the RAID Level only.<br><br></html>")), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdBtnAddDrives);
        buttonGroup.add(this.m_rdBtnRemoveDrives);
        buttonGroup.add(this.m_rdbtnMigrateRL);
        if (!this.m_selectedRTU.isNoChnageMode()) {
            this.m_rdbtnMigrateRL.setEnabled(false);
            string = MessageFormat.format(Resource.getString("LABEL_MODE_SELECTION_HEADING_WITHOUT_MIGRATE", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2} you can either Add the drives or  Remove the drives.<br><br></html>"), objectArray);
            this.m_lbModeSelMsg.setText(string);
        }
        this.m_rdBtnAddDrives.setSelected(true);
    }

    @Override
    public void onNext() {
        this.m_iTrigger = 0;
        if (this.m_rdBtnAddDrives.isSelected()) {
            this.m_hmWizardData.put("SelectedMode", (byte)1);
        } else if (this.m_rdBtnRemoveDrives.isSelected()) {
            this.m_hmWizardData.put("SelectedMode", (byte)2);
        } else {
            this.m_hmWizardData.put("SelectedMode", (byte)0);
            this.m_iTrigger = 1;
        }
        super.onNext();
    }

    @Override
    public String getPageID() {
        return "MODESelectionPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("RECONFIG_MODE_SELECTION_PAGE_TITLE", "Modify Drive Group - Choose the operations");
    }

    private void updatePanel() {
        byte by;
        byte by2 = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
        if (by2 == 17) {
            by2 = 1;
        }
        if ((by = this.m_selectedRTU.getTargetPRLevel()) == 17) {
            by = 1;
        }
        Object[] objectArray = new Object[]{by, by2, by};
        String string = "";
        if (!this.m_selectedRTU.isNoChnageMode()) {
            this.m_rdbtnMigrateRL.setEnabled(false);
            string = MessageFormat.format(Resource.getString("LABEL_MODE_SELECTION_HEADING_WITHOUT_MIGRATE", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2} you can either Add the drives or  Remove the drives.<br><br></html>"), objectArray);
        } else {
            this.m_rdbtnMigrateRL.setEnabled(true);
            string = MessageFormat.format(Resource.getString("LABEL_MODE_SELECTION_HEADING", "<html>You have selected RAID {0}. To migrate from RAID {1} to RAID {2} you can either Add the drives or Remove the drives or Migrate the<br>RAID level.<br><br></html>"), objectArray);
        }
        this.m_lbModeSelMsg.setText(string);
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }
}

