/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.ConfigurationHelpers.ReconstructionEngine;
import SASKernel.SASLogical.SASLogicalDrive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class RAIDTransitionUnitGenerator {
    private static final byte RECON_INSE_MODE = 1;
    private static final byte RECON_DELE_MODE = 2;
    private static final byte RECON_NOCH_MODE = 3;
    private LogicalDriveHelper m_ldHelpr = null;
    private AdapterHelper m_adapterHelper = null;
    private SASLogicalDrive m_sasLD = null;
    private static Vector<RAIDTransitionUnit> m_listofRTU = null;
    private static Vector<String> m_strListOfRTU;
    private byte m_sourcePRLevel;
    private short m_currentPDCount;
    private short m_newPDCount;
    private byte[] m_supportedRAIDlevelsInSystem;
    private PhysicalDriveHelper[] m_selectableDrives = null;

    public RAIDTransitionUnitGenerator(LogicalDriveHelper logicalDriveHelper, PhysicalDriveHelper[] physicalDriveHelperArray) {
        this.m_ldHelpr = logicalDriveHelper;
        this.m_adapterHelper = (AdapterHelper)this.m_ldHelpr.getParent();
        this.m_sasLD = (SASLogicalDrive)this.m_ldHelpr.getDeviceObject();
        this.m_selectableDrives = physicalDriveHelperArray;
        this.m_sourcePRLevel = this.m_sasLD.getRAIDLevelInfo().getPRL();
        this.m_currentPDCount = (short)this.m_sasLD.getConstituentPDList().size();
        this.m_newPDCount = (short)(this.m_currentPDCount + (this.m_selectableDrives != null ? this.m_selectableDrives.length : 0));
        m_listofRTU = new Vector();
        m_strListOfRTU = new Vector();
        this.m_supportedRAIDlevelsInSystem = new byte[5];
        this.m_supportedRAIDlevelsInSystem[0] = 0;
        this.m_supportedRAIDlevelsInSystem[1] = 1;
        this.m_supportedRAIDlevelsInSystem[2] = 5;
        this.m_supportedRAIDlevelsInSystem[3] = 17;
        this.m_supportedRAIDlevelsInSystem[4] = 6;
        this.generateRTUList();
    }

    private short getNewPDCountForRem() {
        short s = 0;
        if (this.m_sourcePRLevel == 0) {
            s = this.m_currentPDCount;
        } else if (this.m_sourcePRLevel == 1) {
            s = 1;
        } else if (this.m_sourcePRLevel == 5) {
            s = (short)(this.m_currentPDCount - 1);
        } else if (this.m_sourcePRLevel == 17) {
            s = (short)(this.m_currentPDCount / 2);
        } else if (this.m_sourcePRLevel == 6) {
            s = (short)(this.m_currentPDCount - 2);
        }
        return s;
    }

    private void generateRTUList() {
        byte by = 1;
        ArrayList arrayList = new ArrayList();
        byte[] byArray = null;
        if (this.m_selectableDrives != null) {
            byArray = ReconstructionEngine.getAllowedRaidLevels(this.m_sourcePRLevel, this.m_currentPDCount, this.m_newPDCount, arrayList, by, this.m_sasLD);
        }
        by = 2;
        byte[] byArray2 = ReconstructionEngine.getAllowedRaidLevels(this.m_sourcePRLevel, this.m_currentPDCount, this.getNewPDCountForRem(), arrayList, by, this.m_sasLD);
        byte[] byArray3 = null;
        if (this.m_sourcePRLevel == 6) {
            byArray3 = ReconstructionEngine.getAllowedRaidLevels(this.m_sourcePRLevel, this.m_currentPDCount, (short)(this.m_currentPDCount - 1), arrayList, by, this.m_sasLD);
        }
        by = 3;
        byte[] byArray4 = ReconstructionEngine.getAllowedRaidLevels(this.m_sourcePRLevel, this.m_currentPDCount, this.m_currentPDCount, arrayList, by, this.m_sasLD);
        if (byArray != null) {
            System.out.println("Size of add:" + byArray.length);
        }
        if (byArray2 != null) {
            System.out.println("Size of rem:" + byArray2.length);
        }
        if (byArray3 != null) {
            System.out.println("Size of rem:" + byArray3.length);
        }
        if (byArray4 != null) {
            System.out.println("Size of noc:" + byArray4.length);
        }
        System.out.println("Source RAID:" + this.m_sourcePRLevel);
        for (int i = 0; i < this.m_supportedRAIDlevelsInSystem.length; ++i) {
            int n;
            byte by2 = this.m_supportedRAIDlevelsInSystem[i];
            System.out.println("Inside loop target:" + by2);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (byArray != null && byArray.length != 0) {
                for (n = 0; n < byArray.length; ++n) {
                    if (by2 != byArray[n]) continue;
                    bl = true;
                    break;
                }
            }
            if (byArray2 != null && byArray2.length != 0) {
                for (n = 0; n < byArray2.length; ++n) {
                    if (by2 != byArray2[n]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (byArray4 != null && byArray4.length != 0) {
                for (n = 0; n < byArray4.length; ++n) {
                    if (by2 != byArray4[n]) continue;
                    bl3 = true;
                    break;
                }
            }
            if (byArray3 != null && byArray3.length != 0) {
                for (n = 0; n < byArray3.length; ++n) {
                    if (by2 != byArray3[n]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl && !bl2 && !bl3) continue;
            RAIDTransitionUnit rAIDTransitionUnit = new RAIDTransitionUnit(by2, bl, bl2, bl3);
            rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
            if (this.m_sourcePRLevel == 0) {
                if (by2 == 0) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                } else if (by2 == 1) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    rAIDTransitionUnit.setMaxDrivesToAdd((byte)1);
                } else if (by2 == 5) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                } else if (by2 == 6) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                }
            } else if (this.m_sourcePRLevel == 1) {
                if (by2 == 0) {
                    if (bl && bl2 && bl3) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    } else if ((!bl || !bl3) && bl2 && bl3) {
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                } else if (by2 == 1) {
                    if (this.m_currentPDCount < 4) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)(4 - this.m_currentPDCount));
                    } else if (this.m_currentPDCount % 2 == 0) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                    } else {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    }
                } else if (by2 == 5) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                } else if (by2 == 6) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                }
            } else if (this.m_sourcePRLevel == 5) {
                if (by2 == 0) {
                    if (bl && bl2 && bl3) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    } else if (bl2 && bl3) {
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                } else if (by2 == 1) {
                    if (bl && this.m_currentPDCount % 2 != 0) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    }
                } else if (by2 == 5) {
                    if (bl) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    }
                } else if (by2 == 6 && bl) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                }
            } else if (this.m_sourcePRLevel == 6) {
                if (by2 == 0) {
                    if (bl && bl2 && bl3) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)2);
                    } else if (bl2 && bl3) {
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)2);
                    }
                } else if (by2 == 1) {
                    if (this.m_currentPDCount == 3) {
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                    if (bl && this.m_currentPDCount % 2 != 0) {
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    }
                } else if (by2 == 5) {
                    if (bl2 && bl3) {
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                } else if (by2 == 6 && bl) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                }
            }
            m_listofRTU.add(rAIDTransitionUnit);
        }
        System.out.println("size of RTU :" + m_listofRTU.size());
        Iterator<RAIDTransitionUnit> iterator = m_listofRTU.iterator();
        System.out.println("Iterating through RTU list...");
        while (iterator.hasNext()) {
            RAIDTransitionUnit rAIDTransitionUnit = iterator.next();
            System.out.println("Target    : " + rAIDTransitionUnit.getTargetPRLevel());
            System.out.println("Add       : " + rAIDTransitionUnit.isAddMode());
            System.out.println("Remove \t  : " + rAIDTransitionUnit.isRemoveMode());
            System.out.println("No chnage : " + rAIDTransitionUnit.isNoChnageMode());
        }
    }

    private void toStringPRLList() {
        for (RAIDTransitionUnit rAIDTransitionUnit : m_listofRTU) {
            short s = rAIDTransitionUnit.getTargetPRLevel();
            String string = new String();
            string = s == 0 ? "RAID 0" : (s == 1 ? "RAID 1" : (s == 5 ? "RAID 5" : (s == 17 ? "RAID 1E" : (s == 6 ? "RAID 6" : ""))));
            m_strListOfRTU.add(string);
        }
    }

    public Vector<RAIDTransitionUnit> getListofRTU() {
        return m_listofRTU;
    }
}

