/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;

public class ReconfigurationSummaryGenerator {
    private static final String NEW_LINE = "\n";
    private static final String TABS_2 = "\t";
    private static final String TABS_3 = "\t\t";
    private LogicalDriveHelper m_ldHelper = null;
    private RAIDTransitionUnit m_rtu = null;
    private AdapterHelper m_AdapterHelper = null;
    private int m_iSelectedMode = -1;
    private PhysicalDriveHelper[] m_pdHelpers = null;

    public ReconfigurationSummaryGenerator(LogicalDriveHelper logicalDriveHelper, RAIDTransitionUnit rAIDTransitionUnit, int n, PhysicalDriveHelper[] physicalDriveHelperArray) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_AdapterHelper = (AdapterHelper)this.m_ldHelper.getParent();
        this.m_rtu = rAIDTransitionUnit;
        this.m_iSelectedMode = n;
        this.m_pdHelpers = physicalDriveHelperArray;
    }

    public String getReconigSummary() {
        PhysicalDriveHelper[] physicalDriveHelperArray = null;
        PhysicalDriveHelper[] physicalDriveHelperArray2 = this.m_ldHelper.getPDListInLd();
        if (this.m_iSelectedMode == 1) {
            physicalDriveHelperArray = new PhysicalDriveHelper[physicalDriveHelperArray2.length + this.m_pdHelpers.length];
            System.arraycopy(physicalDriveHelperArray2, 0, physicalDriveHelperArray, 0, physicalDriveHelperArray2.length);
            System.arraycopy(this.m_pdHelpers, 0, physicalDriveHelperArray, physicalDriveHelperArray2.length, this.m_pdHelpers.length);
        } else if (this.m_iSelectedMode == 2) {
            physicalDriveHelperArray = new PhysicalDriveHelper[physicalDriveHelperArray2.length - this.m_pdHelpers.length];
            int n = 0;
            for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
                PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray2[i];
                boolean bl = false;
                for (int j = 0; j < this.m_pdHelpers.length; ++j) {
                    if (!this.m_pdHelpers[j].equals(physicalDriveHelper)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                int n2 = n;
                n = (byte)(n + 1);
                physicalDriveHelperArray[n2] = physicalDriveHelper;
            }
        } else {
            physicalDriveHelperArray = physicalDriveHelperArray2;
        }
        ArrayHelper arrayHelper = this.m_ldHelper.getArrays()[0];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_DG_NAME", "Drive group name:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(Resource.getString("DRIVE_GROUP_TEXT", "Drive Group"));
        stringBuffer.append(": ");
        stringBuffer.append(arrayHelper.getDeviceObject().getID());
        stringBuffer.append(", ");
        stringBuffer.append(this.getRaidLevelString());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID level:"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.getRaidLevelString());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("LABEL_RECONFIG_SUMMARY_VD_NAME", "Virtual drive name:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getName());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY", "Total capacity:"));
        if (!this.m_AdapterHelper.isSolaris11()) {
            stringBuffer.append(TABS_3);
        } else {
            stringBuffer.append(TABS_2);
        }
        stringBuffer.append(this.getDriveGroupCapacity(physicalDriveHelperArray));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("LABEL_RECONFIG_SUMMARY_NO_DRIVES", "Number of drives:"));
        stringBuffer.append(TABS_2);
        stringBuffer.append(physicalDriveHelperArray.length);
        return stringBuffer.toString();
    }

    private String getDriveGroupCapacity(PhysicalDriveHelper[] physicalDriveHelperArray) {
        int n = physicalDriveHelperArray.length;
        byte by = this.m_rtu.getTargetPRLevel();
        int n2 = 0;
        if (by == 0) {
            n2 = n;
        } else if (by == 1) {
            n2 = 1;
        } else if (by == 17) {
            n2 = n / 2;
        } else if (by == 5) {
            n2 = n - 1;
        } else if (by == 6) {
            n2 = n - 2;
        }
        long l = this.getMinCapacity(physicalDriveHelperArray);
        long l2 = l * (long)n2;
        return KernelConstants.getConvertedSize(l2, physicalDriveHelperArray[0].getUserDataBlockSize());
    }

    private long getMinCapacity(PhysicalDriveHelper[] physicalDriveHelperArray) {
        long l = ((SASPhysicalDrive)physicalDriveHelperArray[0].getDeviceObject()).getInformation().getcoercedSize();
        for (int i = 1; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            long l2 = sASPhysicalDrive.getInformation().getcoercedSize();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    private String getRaidLevelString() {
        byte by = this.m_rtu.getTargetPRLevel();
        if (by == 17) {
            by = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("LABEL_RAID_TEXT", "RAID"));
        stringBuffer.append(" ");
        stringBuffer.append(by);
        return stringBuffer.toString();
    }
}

