/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReconfigurationSummaryPanel
extends JPanel {
    private LogicalDriveHelper m_ldHelper = null;
    private ArrayHelper m_arrayHelper = null;
    private JTextArea m_taReconSummary = null;
    private String m_strReconSummary = null;

    public ReconfigurationSummaryPanel(LogicalDriveHelper logicalDriveHelper, String string) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_arrayHelper = this.m_ldHelper.getArrays()[0];
        this.m_strReconSummary = string;
        this.buildPanel();
    }

    public void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 20, 10, 10);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_PAGE_HEADING")), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 10);
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_SUMMARY")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel(Resource.getString("LABEL_CURRENT_SETTINGS")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)new JLabel(Resource.getString("LABEL_POST_MODI_SETTINGS")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 20, 100, 10);
        this.add((Component)this.getCurrentSummaryPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.m_taReconSummary = new JTextArea(this.m_strReconSummary, 6, 50);
        this.m_taReconSummary.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_taReconSummary, 20, 30);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private JPanel getCurrentSummaryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_DG_NAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel(this.m_arrayHelper.toString()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_RAID_LEVEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        byte by = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
        if (by == 17) {
            by = 1;
        }
        jPanel.add((Component)new JLabel(Resource.getString("LABEL_RAID_TEXT") + " " + by), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_SUMMARY_VD_NAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel(((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getName()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel(this.getDriveGroupCapacity()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)new JLabel(Resource.getString("LABEL_RECONFIG_SUMMARY_NO_DRIVES")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("" + this.m_arrayHelper.getPhysicalDrives().length), gridBagConstraints);
        return jPanel;
    }

    public void setReconSummary(String string) {
        if (this.m_taReconSummary != null) {
            this.m_taReconSummary.setText(string);
        }
    }

    private String getDriveGroupCapacity() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers();
        SASArray sASArray = (SASArray)this.m_arrayHelper.getDeviceObject();
        MR_ARRAY mR_ARRAY = sASArray.getInformation();
        int n = mR_ARRAY.getnumDrives();
        byte by = logicalDriveHelperArray[0].getLdParameters().getPRL();
        int n2 = 0;
        if (by == 0) {
            n2 = n;
        } else if (by == 1) {
            n2 = 1;
        } else if (by == 17) {
            n2 = n / 2;
        } else if (by == 5) {
            n2 = n - 1;
        } else if (by == 6) {
            n2 = n - 2;
        }
        return KernelConstants.getConvertedSize(mR_ARRAY.getsize() * (long)n2, this.m_arrayHelper.getBlockSize());
    }
}

