/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.DoubleIcons;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class SelectRAIDLevelPanel
extends JPanel {
    private JTable m_dgDrivesTable = null;
    private DgDrivesTableModel m_dgDrivesTableModel = null;
    private JComboBox m_selectRAIDCombobox = null;
    JLabel raidLevelLabelDescription = new JLabel();
    public JLabel raidLevelIcon = new JLabel();
    private Dimension iconDimensions = new Dimension(32, 32);
    public static final byte RAID_LEVEL_10_IR2 = 16;
    public static final byte RAID_LEVEL_10_IR3 = 32;
    public static final byte RAID_LEVEL_SELECT = -1;
    private LogicalDriveHelper m_ldHelpr = null;
    private PhysicalDriveHelper[] m_selectableDrives = null;
    private Vector<RAIDTransitionUnit> m_vecRTUs = null;
    private PhysicalDriveHelper[] m_sourcePdHelpers = null;

    public SelectRAIDLevelPanel(LogicalDriveHelper logicalDriveHelper, PhysicalDriveHelper[] physicalDriveHelperArray, Vector<RAIDTransitionUnit> vector) {
        this.m_ldHelpr = logicalDriveHelper;
        this.m_selectableDrives = physicalDriveHelperArray;
        this.m_vecRTUs = vector;
        ArrayHelper[] arrayHelperArray = this.m_ldHelpr.getArrays();
        this.m_sourcePdHelpers = arrayHelperArray[0].getPhysicalDrives();
        this.m_dgDrivesTableModel = new DgDrivesTableModel(this.m_sourcePdHelpers);
        this.buildPanel();
    }

    public void buildPanel() {
        String[] stringArray = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)new JLabel(Resource.getString("RECONFIG_RAID_SELECTION_INSTRUCTION")), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 10, 10, 10);
        Object[] objectArray = new Object[]{Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + " " + this.m_ldHelpr.getArrays()[0].getDeviceObject().getID()};
        String string = MessageFormat.format(Resource.getString("LABEL_DG_NAME"), objectArray);
        jPanel.add((Component)new JLabel(string), gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        objectArray = new Object[]{this.m_ldHelpr.getRAIDLevel()};
        String string2 = MessageFormat.format(Resource.getString("LABEL_RAID_LEVEL"), objectArray);
        jPanel.add((Component)new JLabel(string2), gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        objectArray = new Object[]{this.m_ldHelpr.getState()};
        String string3 = MessageFormat.format(Resource.getString("LABEL_VD_STATE"), objectArray);
        jPanel.add((Component)new JLabel(string3), gridBagConstraints2);
        this.m_dgDrivesTable = new JTable(this.m_dgDrivesTableModel);
        this.m_dgDrivesTable.setEnabled(false);
        this.m_dgDrivesTable.getTableHeader().setEnabled(false);
        DGPDTableCellRenderer dGPDTableCellRenderer = new DGPDTableCellRenderer();
        this.m_dgDrivesTable.getColumnModel().getColumn(0).setCellRenderer(dGPDTableCellRenderer);
        this.m_dgDrivesTable.getColumnModel().getColumn(1).setCellRenderer(dGPDTableCellRenderer);
        this.m_dgDrivesTable.getColumnModel().getColumn(2).setCellRenderer(dGPDTableCellRenderer);
        this.m_dgDrivesTable.getColumnModel().getColumn(3).setCellRenderer(dGPDTableCellRenderer);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.m_dgDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, 100));
        jPanel.add((Component)jScrollPane, gridBagConstraints2);
        jPanel.setBorder(BorderFactory.createTitledBorder(new TitledBorder(Resource.getString("LABEL_CURRENT_DG_CONFIG", "Current drive group configuration"))));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_RL", "Select the (R)AID level you want to migrate:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 10, 50, 10);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        boolean bl = false;
        int n = 0;
        for (int n2 = 0; n2 < this.m_vecRTUs.size(); n2 = (int)((byte)(n2 + 1))) {
            System.out.println("raidLevelModel:" + this.m_vecRTUs.get(n2));
            RAIDTransitionUnit rAIDTransitionUnit = this.m_vecRTUs.get(n2);
            byte by = ((SASLogicalDrive)this.m_ldHelpr.getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
            if (rAIDTransitionUnit.getTargetPRLevel() == 1 || rAIDTransitionUnit.getTargetPRLevel() == 17) {
                if (!bl) {
                    bl = true;
                    n = n2;
                    if (VivaldiStartupDialog.OEM_TYPE == 2561 && (by == 5 || by == 6 || by == 1)) continue;
                    defaultComboBoxModel.addElement(rAIDTransitionUnit);
                    continue;
                }
                RAIDTransitionUnit rAIDTransitionUnit2 = (RAIDTransitionUnit)defaultComboBoxModel.getElementAt(n);
                defaultComboBoxModel.removeElementAt(n);
                System.out.println("tmpRtu:" + rAIDTransitionUnit2.isAddMode() + ":" + rAIDTransitionUnit2.isRemoveMode() + ":" + rAIDTransitionUnit2.isNoChnageMode());
                System.out.println("rtuObj:" + rAIDTransitionUnit.isAddMode() + ":" + rAIDTransitionUnit.isRemoveMode() + ":" + rAIDTransitionUnit.isNoChnageMode());
                if (rAIDTransitionUnit.isAddMode()) {
                    if (rAIDTransitionUnit2.isAddMode()) {
                        if (rAIDTransitionUnit2.getMinDrivesToAdd() > rAIDTransitionUnit.getMinDrivesToAdd()) {
                            rAIDTransitionUnit2.setMinDrivesToAdd(rAIDTransitionUnit.getMinDrivesToAdd());
                        }
                        if (rAIDTransitionUnit2.getMaxDrivesToAdd() < rAIDTransitionUnit.getMaxDrivesToAdd()) {
                            rAIDTransitionUnit2.setMaxDrivesToAdd(rAIDTransitionUnit.getMaxDrivesToAdd());
                        }
                    } else {
                        rAIDTransitionUnit2.setAddMode(true);
                        rAIDTransitionUnit2.setMaxDrivesToAdd(rAIDTransitionUnit.getMaxDrivesToAdd());
                        rAIDTransitionUnit2.setMinDrivesToAdd(rAIDTransitionUnit.getMinDrivesToAdd());
                    }
                }
                if (rAIDTransitionUnit.isRemoveMode()) {
                    if (rAIDTransitionUnit2.isRemoveMode()) {
                        if (rAIDTransitionUnit2.getMinDrivesToRemove() > rAIDTransitionUnit.getMinDrivesToRemove()) {
                            rAIDTransitionUnit2.setMinDrivesToRemove(rAIDTransitionUnit.getMinDrivesToRemove());
                        }
                        if (rAIDTransitionUnit2.getMaxDrivesToRemove() < rAIDTransitionUnit.getMaxDrivesToRemove()) {
                            rAIDTransitionUnit2.setMaxDrivesToRemove(rAIDTransitionUnit.getMaxDrivesToRemove());
                        }
                    } else {
                        rAIDTransitionUnit2.setRemoveMode(true);
                        rAIDTransitionUnit2.setMaxDrivesToRemove(rAIDTransitionUnit.getMaxDrivesToRemove());
                        rAIDTransitionUnit2.setMinDrivesToRemove(rAIDTransitionUnit.getMinDrivesToRemove());
                    }
                }
                if (rAIDTransitionUnit.isNoChnageMode()) {
                    rAIDTransitionUnit2.setNoChnageMode(true);
                }
                System.out.println("new tmpRtu:" + rAIDTransitionUnit2.isAddMode() + ":" + rAIDTransitionUnit2.isRemoveMode() + ":" + rAIDTransitionUnit2.isNoChnageMode());
                defaultComboBoxModel.addElement(rAIDTransitionUnit2);
                continue;
            }
            defaultComboBoxModel.addElement(rAIDTransitionUnit);
        }
        defaultComboBoxModel.insertElementAt(Resource.getString("LABEL_RAID_LEVEL_SELECT"), 0);
        this.m_selectRAIDCombobox = new JComboBox(defaultComboBoxModel);
        this.m_selectRAIDCombobox.setSelectedIndex(0);
        this.add((Component)this.m_selectRAIDCombobox, gridBagConstraints);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_selectRAIDCombobox);
        }
        this.raidLevelIcon.setIcon(Resource.getImage(""));
        this.raidLevelIcon.setPreferredSize(this.iconDimensions);
        gridBagConstraints.insets = new Insets(0, 85, 50, 10);
        this.add((Component)this.raidLevelIcon, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 170, 50, 10);
        this.raidLevelLabelDescription.setText(Resource.getString("RAID_DESC", " <html>Pick a RAID level to specify the amount of fault tolerance and performance for<br>the virtual drives.</html>"));
        this.add((Component)this.raidLevelLabelDescription, gridBagConstraints);
    }

    public RAIDTransitionUnit getSelectedRTU() {
        return (RAIDTransitionUnit)this.m_selectRAIDCombobox.getSelectedItem();
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_selectRAIDCombobox.addItemListener(itemListener);
    }

    public String getRaidLevelDescription(byte by) {
        switch (by) {
            case -1: {
                return Resource.getString("RAID_DESC", " <html>Pick a RAID level to specify the amount of fault tolerance and performance for<br>the virtual drives.</html>");
            }
            case 0: {
                return Resource.getString("RAID0_DESC", "<html>This RAID level is suitable for high performance with zero<br> data redundancy.Choose this option only for non-critical data.</html>");
            }
            case 1: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high<br> redundancy and performance.</html>");
            }
            case 17: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high<br> redundancy and performance.</html>");
            }
            case 5: {
                return Resource.getString("RAID5_DESC", "<html>This RAID level is suitable for multi-user environments(database <br>or file system) with large IO size and high proportion of read activity.</html>");
            }
            case 6: {
                return Resource.getString("RAID6_DESC", "<html>This RAID level is suitable for environments requiring redundancy<br> protection beyond RAID 5,but not requiring high write performance.</html>");
            }
            case 64: {
                return Resource.getString("RAID00_DESC", "<html>RAID level 00 is a stripe of stripes.</html>");
            }
            case 16: 
            case 32: 
            case 65: {
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 69: {
                return Resource.getString("RAID50_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed parity of RAID 5.</html>");
            }
            case 70: {
                return Resource.getString("RAID60_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed double parity of RAID 6.</html>");
            }
        }
        return "";
    }

    public ImageIcon getRaidLevelIcon(byte by) {
        switch (by) {
            case -1: {
                return Resource.getImage("");
            }
            case 0: {
                return Resource.getImage("RAID0_ICON");
            }
            case 1: {
                return Resource.getImage("RAID1_ICON");
            }
            case 17: {
                return Resource.getImage("RAID1_ICON");
            }
            case 5: {
                return Resource.getImage("RAID5_ICON");
            }
            case 6: {
                return Resource.getImage("RAID6_ICON");
            }
            case 64: {
                return Resource.getImage("RAID00_ICON");
            }
            case 16: 
            case 32: 
            case 65: {
                return Resource.getImage("RAID10_ICON");
            }
            case 69: {
                return Resource.getImage("RAID50_ICON");
            }
            case 70: {
                return Resource.getImage("RAID60_ICON");
            }
        }
        return Resource.getImage("");
    }

    private class DGPDTableCellRenderer
    extends DefaultTableCellRenderer {
        private DGPDTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setEnabled(false);
            if (n2 == 0) {
                PhysicalDriveHelper physicalDriveHelper = SelectRAIDLevelPanel.this.m_sourcePdHelpers[n];
                ImageIcon imageIcon = physicalDriveHelper.getIcon();
                jLabel.setIcon(imageIcon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }

        @Override
        public Icon getDisabledIcon() {
            if (!this.isEnabled()) {
                Icon icon = this.getIcon();
                if (icon instanceof DoubleIcons) {
                    DoubleIcons doubleIcons = (DoubleIcons)icon;
                    doubleIcons.disableIcons();
                    return doubleIcons;
                }
                return super.getDisabledIcon();
            }
            return null;
        }
    }

    private class DgDrivesTableModel
    extends AbstractTableModel {
        private PhysicalDriveHelper[] m_phyDriveHelpers;

        public DgDrivesTableModel(PhysicalDriveHelper[] physicalDriveHelperArray) {
            this.m_phyDriveHelpers = physicalDriveHelperArray;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.m_phyDriveHelpers.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = this.m_phyDriveHelpers[n].getTextForTable()[0];
            } else if (n2 == 1) {
                string = this.m_phyDriveHelpers[n].getTextForTable()[1];
            } else if (n2 == 2) {
                string = this.m_phyDriveHelpers[n].getTextForTable()[2];
            } else if (n2 == 3) {
                string = this.m_phyDriveHelpers[n].getState();
            }
            return string;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = Resource.getString("LABEL_TABLE_COLUMN_DRIVE", "Drive");
            } else if (n == 1) {
                string = Resource.getString("SORTBYCOMBO_TYPE_TEXT", "Type");
            } else if (n == 2) {
                string = Resource.getString("CAPACITY_TEXT", "Capacity");
            } else if (n == 3) {
                string = Resource.getString("PROPERTY_HOSTSTATUS_TEXT", "Status");
            }
            return string;
        }
    }
}

