/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import java.util.Vector;

public class TargetRaidLevelSelector {
    private LogicalDriveHelper m_ldHelpr = null;
    private AdapterHelper m_adapterHelper = null;
    private SASLogicalDrive m_sasLD = null;
    private Vector<RAIDTransitionUnit> m_vecRTUs = null;
    private PhysicalDriveHelper[] m_selectableDrives = null;
    private LogicalDriveHelper m_ldHelper = null;
    private byte m_sourcePRLevel = (byte)-1;
    private short m_currentPDCount = (short)-1;
    private short m_newPDCount = (short)-1;
    private short m_connectedPDCount = (short)-1;
    private short m_offlinePDCount = 0;
    private boolean m_isDegraded = false;
    private boolean m_canAddDrives = false;

    public TargetRaidLevelSelector(LogicalDriveHelper logicalDriveHelper, PhysicalDriveHelper[] physicalDriveHelperArray) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_adapterHelper = (AdapterHelper)this.m_ldHelper.getParent();
        this.m_selectableDrives = physicalDriveHelperArray;
        this.m_sasLD = (SASLogicalDrive)this.m_ldHelper.getDeviceObject();
        this.m_isDegraded = this.m_sasLD.getState() == 2 || this.m_sasLD.getState() == 1;
        this.m_sourcePRLevel = this.m_sasLD.getInformation().getldConfig().getparams().getPRL();
        this.m_currentPDCount = (short)this.m_sasLD.getInformation().getldConfig().getparams().getnumDrives();
        ArrayHelper[] arrayHelperArray = this.m_ldHelper.getArrays();
        this.m_connectedPDCount = (short)arrayHelperArray[0].getPhysicalDrives().length;
        for (int i = 0; i < this.m_connectedPDCount; ++i) {
            if (arrayHelperArray[0].getPhysicalDrives()[i].getStatus() != 16) continue;
            this.m_offlinePDCount = (short)(this.m_offlinePDCount + 1);
        }
        this.m_canAddDrives = this.m_selectableDrives != null && this.m_selectableDrives.length > 0 && this.m_currentPDCount < 32;
        System.out.println("m_currentPDCount: " + this.m_currentPDCount);
    }

    public Vector<RAIDTransitionUnit> getPossibleRaidLevelsToMigrate() {
        if (this.m_vecRTUs == null) {
            this.m_vecRTUs = new Vector();
        }
        this.checkAndAddR0();
        this.checkAndAddR1();
        this.checkAndAddR1E();
        this.checkAndAddR5();
        this.checkAndAddR6();
        return this.m_vecRTUs;
    }

    private void checkAndAddR0() {
        RAIDTransitionUnit rAIDTransitionUnit = null;
        if (!this.m_isDegraded) {
            if (this.m_sourcePRLevel == 0 && this.m_canAddDrives) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
            } else if (this.m_sourcePRLevel == 1) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, this.m_canAddDrives, true, true);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
            } else if (this.m_sourcePRLevel == 17) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, this.m_canAddDrives, true, true);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2));
                rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
            } else if (this.m_sourcePRLevel == 5) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, this.m_canAddDrives, true, true);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)0);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
            } else if (this.m_sourcePRLevel == 6) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, this.m_canAddDrives, true, true);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)0);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)2);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
            }
            if (rAIDTransitionUnit != null) {
                rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
                this.m_vecRTUs.add(rAIDTransitionUnit);
            }
        } else if (this.m_connectedPDCount == this.m_currentPDCount) {
            if (this.m_sourcePRLevel == 1 || this.m_sourcePRLevel == 5) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, false, true, false);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
            } else if (this.m_sourcePRLevel == 17) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, false, true, false);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2));
            } else if (this.m_sourcePRLevel == 6) {
                rAIDTransitionUnit = new RAIDTransitionUnit(0, false, true, false);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)2);
            }
            if (rAIDTransitionUnit != null) {
                this.m_vecRTUs.add(rAIDTransitionUnit);
            }
        }
    }

    private void checkAndAddR1() {
        RAIDTransitionUnit rAIDTransitionUnit = null;
        if (this.m_isDegraded && this.m_sourcePRLevel == 6) {
            if (this.m_currentPDCount == 3) {
                rAIDTransitionUnit = new RAIDTransitionUnit(1, false, true, false);
                rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
            }
        } else if (this.m_sourcePRLevel == 0 && this.m_currentPDCount == 1 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(1, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
            rAIDTransitionUnit.setMaxDrivesToAdd((byte)1);
        } else if (this.m_sourcePRLevel == 6 && this.m_currentPDCount == 3) {
            rAIDTransitionUnit = new RAIDTransitionUnit(1, false, true, false);
            rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
            rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
        }
        if (rAIDTransitionUnit != null) {
            this.m_vecRTUs.add(rAIDTransitionUnit);
        }
    }

    private void checkAndAddR5() {
        RAIDTransitionUnit rAIDTransitionUnit = null;
        if (this.m_adapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_5() == 0) {
            return;
        }
        if (this.m_sourcePRLevel == 0 && this.m_canAddDrives) {
            if (this.m_currentPDCount == 1) {
                if (this.m_selectableDrives.length >= 2) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(5, true, false, false);
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                }
            } else {
                rAIDTransitionUnit = new RAIDTransitionUnit(5, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
            }
        } else if (this.m_sourcePRLevel == 1 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(5, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
        } else if (this.m_sourcePRLevel == 17) {
            if (this.m_isDegraded) {
                boolean bl;
                boolean bl2 = bl = this.m_canAddDrives && this.m_offlinePDCount < 2;
                if (this.m_currentPDCount == this.m_connectedPDCount) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(5, bl, true, false);
                    rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                } else if (bl) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(5, bl, false, false);
                }
                if (rAIDTransitionUnit != null) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    if (this.m_currentPDCount > 4 && this.m_offlinePDCount > 1) {
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)(this.m_offlinePDCount - 1));
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2 - 1));
                    } else {
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                }
            } else {
                rAIDTransitionUnit = new RAIDTransitionUnit(5, this.m_canAddDrives, true, true);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
                if (this.m_currentPDCount > 4) {
                    rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2 - 1));
                } else {
                    rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                }
            }
        } else if (this.m_sourcePRLevel == 5 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(5, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
        } else if (this.m_sourcePRLevel == 6) {
            rAIDTransitionUnit = this.m_currentPDCount > 3 && !this.m_isDegraded ? new RAIDTransitionUnit(5, this.m_canAddDrives, this.m_currentPDCount != 3, true) : new RAIDTransitionUnit(5, this.m_canAddDrives, false, false);
            if (this.m_canAddDrives) {
                if (this.m_isDegraded) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                } else {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
                }
            }
            if (this.m_currentPDCount != 3) {
                rAIDTransitionUnit.setMinDrivesToRemove((byte)0);
                rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
            }
        }
        if (rAIDTransitionUnit != null) {
            if (rAIDTransitionUnit.isAddMode()) {
                rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
            }
            this.m_vecRTUs.add(rAIDTransitionUnit);
        }
    }

    private void checkAndAddR6() {
        RAIDTransitionUnit rAIDTransitionUnit = null;
        SASAdapter sASAdapter = (SASAdapter)this.m_sasLD.parent();
        if (sASAdapter.getInformation().getraidLevels_MR_CTRL_INFO().getraidLevel_6() == 0) {
            return;
        }
        if (this.m_sourcePRLevel == 0 && this.m_canAddDrives) {
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                if (this.m_currentPDCount == 1) {
                    if (this.m_selectableDrives.length >= 3) {
                        rAIDTransitionUnit = new RAIDTransitionUnit(6, true, false, false);
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)3);
                    }
                } else if (this.m_selectableDrives.length >= 2) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(6, true, false, false);
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                }
            } else if (this.m_selectableDrives.length >= 2) {
                rAIDTransitionUnit = new RAIDTransitionUnit(6, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
            }
        } else if (this.m_sourcePRLevel == 1 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(6, true, false, false);
            byte by = 0;
            by = VivaldiStartupDialog.OEM_TYPE == 2561 ? (byte)2 : 1;
            if (this.m_isDegraded) {
                by = (byte)(by + 1);
            }
            rAIDTransitionUnit.setMinDrivesToAdd(by);
        } else if (this.m_sourcePRLevel == 17) {
            boolean bl;
            boolean bl2 = bl = this.m_currentPDCount != 4 && VivaldiStartupDialog.OEM_TYPE != 2561 && this.m_currentPDCount == this.m_connectedPDCount;
            if (this.m_isDegraded) {
                boolean bl3;
                boolean bl4 = bl3 = this.m_canAddDrives && this.m_offlinePDCount < 3;
                if (bl3 || bl) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(6, bl3, bl, false);
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
                    rAIDTransitionUnit.setMinDrivesToRemove((byte)1);
                    if (this.m_offlinePDCount > 2) {
                        rAIDTransitionUnit.setMinDrivesToRemove((byte)(this.m_offlinePDCount - 2));
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2 - 2));
                    } else {
                        rAIDTransitionUnit.setMaxDrivesToRemove((byte)1);
                    }
                }
            } else {
                rAIDTransitionUnit = new RAIDTransitionUnit(6, this.m_canAddDrives, bl, true);
                if (this.m_canAddDrives) {
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)0);
                }
                if (bl) {
                    rAIDTransitionUnit.setMinDrivesToRemove((byte)0);
                    rAIDTransitionUnit.setMaxDrivesToRemove((byte)(this.m_currentPDCount / 2 - 2));
                }
            }
        } else if (this.m_sourcePRLevel == 5 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(6, true, false, false);
            if (this.m_isDegraded) {
                rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
            } else {
                rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
            }
        } else if (this.m_sourcePRLevel == 6 && this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(6, this.m_canAddDrives, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
        }
        if (rAIDTransitionUnit != null) {
            if (rAIDTransitionUnit.isAddMode()) {
                rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
            }
            this.m_vecRTUs.add(rAIDTransitionUnit);
        }
    }

    private void checkAndAddR1E() {
        boolean bl;
        SASAdapter sASAdapter = (SASAdapter)this.m_sasLD.parent();
        boolean bl2 = bl = this.m_canAddDrives && this.m_selectableDrives.length > 1;
        if (sASAdapter.getInformation().getraidLevels_MR_CTRL_INFO().getRaidLevel_1E0_RLQ0() == 0) {
            return;
        }
        RAIDTransitionUnit rAIDTransitionUnit = null;
        if (this.m_sourcePRLevel == 0 && this.m_canAddDrives && this.m_selectableDrives.length >= this.m_currentPDCount) {
            rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)this.m_currentPDCount);
            rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
        } else if (this.m_sourcePRLevel == 1 && this.m_canAddDrives) {
            if (this.m_isDegraded) {
                if (this.m_selectableDrives.length >= 2) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                }
            } else if (this.m_selectableDrives.length >= 2) {
                rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
            }
        } else if (this.m_sourcePRLevel == 17 && this.m_canAddDrives && this.m_selectableDrives.length >= 2) {
            rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
        } else if (this.m_sourcePRLevel == 5 && this.m_canAddDrives) {
            byte by = (byte)(this.m_currentPDCount - 1);
            byte by2 = (byte)(by - 1);
            if (this.m_selectableDrives.length >= by2) {
                rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd(by2);
            }
        } else if (this.m_sourcePRLevel == 6) {
            if (this.m_currentPDCount >= 4) {
                if (!this.m_isDegraded && this.m_currentPDCount == 4) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(17, bl, false, true);
                    rAIDTransitionUnit.setMinDrivesToRemove((byte)0);
                    rAIDTransitionUnit.setMaxDrivesToRemove((byte)0);
                }
                if (this.m_isDegraded && this.m_currentPDCount == 4) {
                    rAIDTransitionUnit = new RAIDTransitionUnit(17, bl, false, true);
                    rAIDTransitionUnit.setMinDrivesToAdd((byte)2);
                } else if (this.m_currentPDCount > 4) {
                    System.out.println((short)this.m_sasLD.getInformation().getldConfig().getparams().getnumDrives());
                    ArrayHelper[] arrayHelperArray = this.m_ldHelper.getArrays();
                    System.out.println((short)arrayHelperArray[0].getPhysicalDrives().length);
                    short s = this.m_currentPDCount;
                    int n = 2 * (s - 2) - s;
                    if (s - 2 <= (this.m_connectedPDCount + s) / 2 && this.m_selectableDrives != null && n <= this.m_selectableDrives.length) {
                        rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
                        rAIDTransitionUnit.setMinDrivesToAdd((byte)n);
                    }
                }
            } else if (this.m_canAddDrives) {
                rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
                rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
            }
        } else if (this.m_canAddDrives) {
            rAIDTransitionUnit = new RAIDTransitionUnit(17, true, false, false);
            rAIDTransitionUnit.setMinDrivesToAdd((byte)1);
        }
        if (rAIDTransitionUnit != null) {
            this.m_vecRTUs.add(rAIDTransitionUnit);
            rAIDTransitionUnit.setMaxDrivesToAdd((byte)(32 - this.m_currentPDCount));
        }
    }
}

