/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.reconfiguration;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_RECON;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VirtualDriveExpandOperation
extends VivaldiBaseDialog
implements ActionListener,
ChangeListener {
    private ArrayHelper m_arrayHelper = null;
    private LogicalDriveHelper m_ldHelper = null;
    private SASArray m_sasArray = null;
    private SASLogicalDrive m_sasLogicalDrive = null;
    private SASAdapter m_sasAdapter = null;
    private long m_lNewMinSizeOfArray = 0L;
    private JSpinner m_spinPercent = null;
    private SpinnerNumberModel m_spinnerNumberModel = null;
    private JLabel m_lblNewVDSize = null;
    private JButton m_btnOK = null;
    private JButton m_btnCancel = null;
    private long m_lAvailableCapacityToExpand = 0L;

    public VirtualDriveExpandOperation(LogicalDriveHelper logicalDriveHelper, ArrayHelper arrayHelper) {
        super(VivaldiStartupDialog.mainScreen);
        this.m_ldHelper = logicalDriveHelper;
        this.m_arrayHelper = arrayHelper;
        this.m_sasLogicalDrive = (SASLogicalDrive)this.m_ldHelper.getDeviceObject();
        this.m_sasArray = (SASArray)this.m_arrayHelper.getDeviceObject();
        this.m_sasAdapter = (SASAdapter)((AdapterHelper)this.m_arrayHelper.getParent()).getDeviceObject();
        this.m_lNewMinSizeOfArray = this.m_arrayHelper.getNewMinSizeOfArray();
        this.computeAvailableCapacity();
        this.buildUI();
    }

    public void buildUI() {
        String[] stringArray = null;
        this.setTitle(Resource.getString("TITLE_EXPAND_VD", "Expand virtual drive"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + this.m_ldHelper);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Resource.getString("EXPAND_VD_DESC", "<html>Use the default percentage value to occupy the remaining capacity in the drive group or<br>change the percentage if needed. The virtual drive expansion may also expand the<br>drive group if necessary.<br><br>The expansion will occur when you click OK. On click of cancel will terminate this<br>operation.<br><br></html>")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        Object[] objectArray = new Object[]{KernelConstants.getConvertedSize(this.m_sasLogicalDrive.getInformation().getsize(), this.m_arrayHelper.getBlockSize())};
        JLabel jLabel2 = new JLabel(MessageFormat.format(Resource.getString("LABEL_CURRENT_VD_CAPACITY", "<html><b>Current Capacity: {0}</b></html>"), objectArray));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        objectArray = new Object[]{KernelConstants.getConvertedSize(this.m_lAvailableCapacityToExpand, this.m_arrayHelper.getBlockSize())};
        JLabel jLabel3 = new JLabel(MessageFormat.format(Resource.getString("AVAILABLE_CAPACITY_TO_GROW", "<html><b>Available capacity: {0}</b></html>"), objectArray));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.m_spinnerNumberModel = new SpinnerNumberModel(100, 1, 100, 1);
        this.m_spinnerNumberModel.addChangeListener(this);
        this.m_spinPercent = new JSpinner(this.m_spinnerNumberModel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_PERCENT", "(E)nter a percentage of available capacity:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel4.setLabelFor(this.m_spinPercent);
        }
        jPanel2.add(this.m_spinPercent);
        jPanel2.add(new JLabel("%"));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        long l = this.m_lAvailableCapacityToExpand + this.m_sasLogicalDrive.getInformation().getsize();
        objectArray = new Object[]{KernelConstants.getConvertedSize(l, this.m_arrayHelper.getBlockSize())};
        this.m_lblNewVDSize = new JLabel(MessageFormat.format(Resource.getString("LABEL_NEW_VD_SIZE", "<html><b>Capacity of the virtual drive after expansion: {0}</b></html>"), objectArray));
        jPanel.add((Component)this.m_lblNewVDSize, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(this.getSize().width, 50));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.m_btnOK = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_btnCancel = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.m_btnOK);
        jPanel4.add(this.m_btnCancel);
        this.contentPane.add((Component)jPanel, "Center");
        this.contentPane.add((Component)jPanel4, "South");
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private long getVDSizeAfterExpansion(byte by) {
        if (by == 100 || by == 0) {
            return this.getDriveGroupRAIDCapacity();
        }
        return 0L;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        byte by = Byte.parseByte("" + this.m_spinnerNumberModel.getValue());
        double d = 0.0;
        if (by != 100) {
            double d2 = this.m_lAvailableCapacityToExpand * (long)by / 100L;
            double d3 = this.getDriveGroupRAIDCapacity();
            double d4 = d3 - d2;
            d = (double)this.m_sasLogicalDrive.getInformation().getsize() + d2;
        } else {
            d = this.m_lAvailableCapacityToExpand + this.m_sasLogicalDrive.getInformation().getsize();
        }
        Object[] objectArray = new Object[]{KernelConstants.getConvertedSize(d, this.m_arrayHelper.getBlockSize())};
        System.out.println("newVDSize: " + KernelConstants.getConvertedSize(d, this.m_arrayHelper.getBlockSize()));
        this.m_lblNewVDSize.setText(MessageFormat.format(Resource.getString("LABEL_NEW_VD_SIZE", "<html><b>Capacity of the virtual drive after expansion: {0}</b></html>"), objectArray));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_btnCancel)) {
            this.dispose();
        } else if (actionEvent.getSource().equals(this.m_btnOK)) {
            try {
                Object object;
                ArrayList arrayList;
                OperationDetails operationDetails = null;
                if (this.m_lNewMinSizeOfArray > this.m_sasArray.getInformation().getsize() && (arrayList = this.m_sasArray.getPhysicalDriveArrayList()) != null && !arrayList.isEmpty()) {
                    object = this.m_sasArray.getInformation();
                    pd_MR_ARRAY[] pd_MR_ARRAYArray = new pd_MR_ARRAY[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        pd_MR_ARRAYArray[i] = new pd_MR_ARRAY((SASPhysicalDrive)arrayList.get(i));
                    }
                    long l = this.m_arrayHelper.getMinDHSPSize();
                    if (l == 0L || this.m_lNewMinSizeOfArray < l) {
                        l = this.m_lNewMinSizeOfArray;
                    }
                    MR_ARRAY mR_ARRAY = new MR_ARRAY(((MR_ARRAY)object).getarrayRef(), ((MR_ARRAY)object).getnumDrives(), pd_MR_ARRAYArray, l);
                    try {
                        this.m_sasAdapter.fireConfigOperation(new OperationDetails(10, mR_ARRAY));
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                byte by = Byte.parseByte("" + this.m_spinnerNumberModel.getValue());
                object = new MR_RECON();
                byte by2 = this.m_sasLogicalDrive.getInformation().getldConfig().getparams().getPRL();
                if (by2 == 17) {
                    ((MR_RECON)object).setnewRaidLevel((byte)1);
                } else {
                    ((MR_RECON)object).setnewRaidLevel(by2);
                }
                ((MR_RECON)object).setldRef(this.m_sasLogicalDrive.getInformation().getldConfig().getproperties().getldRef());
                ((MR_RECON)object).setoperation((byte)0);
                ((MR_RECON)object).setPercentExpansion(by);
                operationDetails = new OperationDetails(12, object);
                this.m_sasLogicalDrive.fireOperation(operationDetails);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dispose();
        }
    }

    private void computeAvailableCapacity() {
        try {
            long l;
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.m_sasArray.getSLArrayInformation();
            MR_SPAN mR_SPAN = this.m_sasLogicalDrive.getInformation().getldConfig().getspan()[0];
            byte by = (byte)this.m_sasArray.getInformation().getnumDrives();
            byte by2 = this.m_sasLogicalDrive.getInformation().getldConfig().getparams().getPRL();
            long l2 = 0L;
            if (mR_SPAN.getstartBlock() == 0L) {
                l = this.m_lNewMinSizeOfArray * (long)by;
                l2 = sL_ARRAY_INFO_T.getusedBlocks();
                long l3 = l - l2;
                if (by2 == 0) {
                    this.m_lAvailableCapacityToExpand = l3;
                } else if (by2 == 1 || by2 == 17) {
                    this.m_lAvailableCapacityToExpand = l3 / 2L;
                    l2 /= 2L;
                } else if (by2 == 5) {
                    this.m_lAvailableCapacityToExpand = (long)(by - 1) * l3 / (long)by;
                    l2 = (long)(by - 1) * l2 / (long)by;
                } else if (by2 == 6) {
                    this.m_lAvailableCapacityToExpand = (long)(by - 2) * l3 / (long)by;
                    l2 = (long)(by - 2) * l2 / (long)by;
                }
            } else {
                float f = this.getRaidFactor(by2, by);
                long l4 = mR_SPAN.getstartBlock() + mR_SPAN.getnumBlocks();
                l2 = (long)((float)l4 * f);
                long l5 = this.m_lNewMinSizeOfArray - l4;
                this.m_lAvailableCapacityToExpand = (long)((float)l5 * f);
            }
            l = this.m_arrayHelper.getMinDHSPSize();
            if (l != 0L && this.m_lAvailableCapacityToExpand + l2 > l) {
                this.m_lAvailableCapacityToExpand = l - l2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getDriveGroupRAIDCapacity() {
        byte by = (byte)this.m_sasArray.getInformation().getnumDrives();
        byte by2 = this.m_sasLogicalDrive.getInformation().getldConfig().getparams().getPRL();
        float f = this.getRaidFactor(by2, by);
        long l = (long)((float)this.m_lNewMinSizeOfArray * f);
        return l;
    }

    private float getRaidFactor(byte by, byte by2) {
        float f = 0.0f;
        if (by == 0) {
            f = by2;
        } else if (by == 1) {
            f = 1.0f;
        } else if (by == 17) {
            f = (float)by2 / 2.0f;
        } else if (by == 5) {
            f = by2 - 1;
        } else if (by == 6) {
            f = by2 - 2;
        }
        return f;
    }
}

