/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.simple.PDsAndHotspareForDG;
import GUI.venus.configuration.simple.RAIDLevelAndNumVD;
import GUI.venus.configuration.simple.RAIDLevelNumVDAndCapacity;
import GUI.venus.configuration.simple.SimpleConfigConstants;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PossibleConfigurationsForSubGroup
extends SimpleConfigConstants {
    private ArrayList<PhysicalDriveHelper> m_objPhysicalDriveHelpers;
    private AdapterHelper m_objAdapterHelper = null;
    private int m_isOddDriveSupported = 0;
    private long m_lMinDiskSize = 0L;
    private int m_iNumDrives = 0;
    private int m_iRAIDLevel = 0;
    private int m_iMinDriveForRaidLevel = 0;
    private int m_iNumHotSpares = 0;
    private int m_iNumRedundantDrives = 0;
    private int m_iMaxVDCount = 0;
    private long m_lCapacity = 0L;
    private PhysicalDriveHelper m_objHotSpareDrive = null;
    private ArrayList<PhysicalDriveHelper> m_objPDListForDriveGroup = new ArrayList();
    private ArrayList<SimpleConfigParams> m_objPossibleConfigurations = new ArrayList();
    private HashMap<Integer, Vector<Integer>> m_objRAIDLevelToNumVDsMapForSG = new HashMap();
    private HashMap<RAIDLevelAndNumVD, Vector<Long>> m_objRAIDAndNumVDsToCapacitiesMapForSG = new HashMap();
    private HashMap<RAIDLevelNumVDAndCapacity, PDsAndHotspareForDG> m_objRAIDParamsToPDsMapForSG = new HashMap();

    public PossibleConfigurationsForSubGroup(ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_objPhysicalDriveHelpers = arrayList;
        this.m_objAdapterHelper = (AdapterHelper)this.m_objPhysicalDriveHelpers.get(0).getParent();
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() || sASAdapter.getAdapterType() == 2) {
            this.m_isOddDriveSupported = 1;
        }
        this.m_iNumDrives = this.m_objPhysicalDriveHelpers.size();
        this.m_lMinDiskSize = this.m_objPhysicalDriveHelpers.get(0).getSize();
        Vector<Integer> vector = this.getSupportedRAIDLevels(this.m_iNumDrives);
        for (int i = 0; i < vector.size(); ++i) {
            this.m_iRAIDLevel = vector.get(i);
            this.setParamsForRAIDLevel();
            this.findPossibleConfigurations();
        }
    }

    public PossibleConfigurationsForSubGroup(ArrayList<PhysicalDriveHelper> arrayList, int n) {
        this.m_objPhysicalDriveHelpers = arrayList;
        this.m_objAdapterHelper = (AdapterHelper)this.m_objPhysicalDriveHelpers.get(0).getParent();
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() || sASAdapter.getAdapterType() == 2) {
            this.m_isOddDriveSupported = 1;
        }
        this.m_iNumDrives = this.m_objPhysicalDriveHelpers.size();
        this.m_lMinDiskSize = this.m_objPhysicalDriveHelpers.get(0).getSize();
        this.m_iRAIDLevel = n;
        this.setParamsForRAIDLevel();
        this.findPossibleConfigurations();
    }

    public void findPossibleConfigurations() {
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        boolean bl = true;
        bl = sASAdapter.getAdapterType() == 2 ? this.m_objAdapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_1E() != 0 : this.m_objAdapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getRaidLevel_1E_RLQ0() != 0;
        int n = Math.min(this.m_objAdapterHelper.getAdapterInfo().getmaxArrays(), this.m_objAdapterHelper.getAdapterInfo().getmaxLDs());
        this.m_iMaxVDCount = Math.min(n, this.getIntVal((this.m_iNumDrives - this.m_iNumHotSpares) / this.m_iMinDriveForRaidLevel));
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.m_iMaxVDCount; ++i) {
            Vector<Long> vector2 = new Vector<Long>();
            int n2 = i + 1;
            vector.add(n2);
            for (int j = this.m_iMinDriveForRaidLevel; j <= Math.min(32, this.getIntVal((this.m_iNumDrives - this.m_iNumHotSpares) / (i + 1))); ++j) {
                int n3;
                this.m_objPDListForDriveGroup = null;
                this.m_objHotSpareDrive = null;
                if (this.m_iNumHotSpares != 0) {
                    this.assignHotSpare();
                }
                int n4 = this.getMaxDrivesForRAIDLevel(this.m_iRAIDLevel);
                if (this.m_iRAIDLevel == 7) {
                    if (this.m_objAdapterHelper.treatRAID1EasRAID10() && this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() && (j > n4 || j % 2 != 1)) {
                        continue;
                    }
                } else if (this.m_iRAIDLevel == 8) {
                    if (j > n4 || j % 2 != 0) {
                        continue;
                    }
                } else if (j > n4) break;
                if (this.m_iRAIDLevel == 1 || this.m_iRAIDLevel == 2 || this.m_iRAIDLevel == 7 || this.m_iRAIDLevel == 8) {
                    n3 = 0;
                    if (j % 2 == 0) {
                        n3 = 1;
                    }
                    if (this.m_isOddDriveSupported == 0 && n3 == 0) continue;
                    if (sASAdapter.getAdapterType() == 1 ? !bl && j > 2 || bl && j > 2 && 2561 == VivaldiStartupDialog.OEM_TYPE : (sASAdapter.getAdapterType() == 2 ? this.m_iRAIDLevel == 1 && j > 2 || this.m_iRAIDLevel == 7 && !bl : (sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) && this.m_iRAIDLevel == 1 && j > 2)) break;
                }
                n3 = j * n2;
                this.createPDListForDriveGroup(n3);
                this.m_lCapacity = this.m_iRAIDLevel == 1 || this.m_iRAIDLevel == 2 || this.m_iRAIDLevel == 7 || this.m_iRAIDLevel == 8 ? (long)j * this.m_lMinDiskSize / 2L : (long)(j - this.m_iNumRedundantDrives) * this.m_lMinDiskSize;
                vector2.add(this.m_lCapacity);
                SimpleConfigParams simpleConfigParams = new SimpleConfigParams(this.m_iRAIDLevel, this.m_objHotSpareDrive, n2, this.m_lCapacity, this.m_objPDListForDriveGroup);
                this.m_objPossibleConfigurations.add(simpleConfigParams);
                this.m_objRAIDParamsToPDsMapForSG.put(new RAIDLevelNumVDAndCapacity(this.m_iRAIDLevel, n2, this.m_lCapacity), new PDsAndHotspareForDG(this.m_objPDListForDriveGroup, this.m_objHotSpareDrive));
            }
            this.m_objRAIDAndNumVDsToCapacitiesMapForSG.put(new RAIDLevelAndNumVD(this.m_iRAIDLevel, n2), vector2);
        }
        this.m_objRAIDLevelToNumVDsMapForSG.put(this.m_iRAIDLevel, vector);
    }

    public ArrayList<SimpleConfigParams> getPossibleConfigurations() {
        return this.m_objPossibleConfigurations;
    }

    public Vector<Integer> getSupportedRAIDLevels(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_objAdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (this.m_objAdapterHelper.isSWRController()) {
            vector.add(0);
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) {
                vector.add(1);
            }
            if (this.m_objAdapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_5() != 0 && n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) {
                vector.add(3);
            }
        } else if (sASAdapter.getAdapterType() == 1) {
            vector.add(0);
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) {
                vector.add(1);
            }
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1() + 1) {
                vector.add(2);
            }
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5()) {
                vector.add(3);
            }
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5() + 1) {
                vector.add(4);
            }
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                if (n >= 4) {
                    vector.add(5);
                }
                if (n >= 5) {
                    vector.add(6);
                }
            } else {
                if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6()) {
                    vector.add(5);
                }
                if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6() + 1) {
                    vector.add(6);
                }
            }
        } else {
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0()) {
                vector.add(0);
            }
            if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1()) {
                vector.add(1);
            }
            if (sASAdapter.getAdapterType() == 2 && n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) {
                vector.add(7);
            }
            if (sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
                if (this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                    if (this.m_objAdapterHelper.treatRAID1EasRAID10() && n > pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) {
                        vector.add(8);
                    }
                    if (n >= pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) {
                        vector.add(7);
                    }
                } else if (this.m_objAdapterHelper.treatRAID1EasRAID10()) {
                    if (n > pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) {
                        vector.add(8);
                    }
                } else if (n > pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E()) {
                    vector.add(7);
                }
            }
        }
        return vector;
    }

    public Vector<Integer> getNumVDsForRAIDLevelForSG(int n) {
        return this.m_objRAIDLevelToNumVDsMapForSG.get(n);
    }

    public Vector<Long> getCapacitiesForRAIDAndNumVDsForSG(int n, int n2) {
        for (RAIDLevelAndNumVD rAIDLevelAndNumVD : this.m_objRAIDAndNumVDsToCapacitiesMapForSG.keySet()) {
            if (rAIDLevelAndNumVD.getRAIDLevel() != n || rAIDLevelAndNumVD.getNumVirtualDrives() != n2) continue;
            return this.m_objRAIDAndNumVDsToCapacitiesMapForSG.get(rAIDLevelAndNumVD);
        }
        return new Vector<Long>();
    }

    public PDsAndHotspareForDG getPDsAndHotSpareForRAIDParams(int n, int n2, long l) {
        for (RAIDLevelNumVDAndCapacity rAIDLevelNumVDAndCapacity : this.m_objRAIDParamsToPDsMapForSG.keySet()) {
            if (rAIDLevelNumVDAndCapacity.getRAIDLevel() != n || rAIDLevelNumVDAndCapacity.getNumVirtualDrives() != n2 || rAIDLevelNumVDAndCapacity.getCapacity() != l) continue;
            return this.m_objRAIDParamsToPDsMapForSG.get(rAIDLevelNumVDAndCapacity);
        }
        return null;
    }

    private int getIntVal(double d) {
        return (int)d;
    }

    private void setParamsForRAIDLevel() {
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_objAdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        switch (this.m_iRAIDLevel) {
            case 0: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_0();
                this.m_iNumRedundantDrives = 0;
                SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
                if (sASAdapter.getAdapterType() != 2 && sASAdapter.getAdapterType() != 3 && sASAdapter.getAdapterType() != 4) break;
                this.m_iMinDriveForRaidLevel = 2;
                break;
            }
            case 1: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1();
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 2: {
                this.m_iNumHotSpares = 1;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1();
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 7: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_1E();
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 8: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = 4;
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 3: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5();
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 4: {
                this.m_iNumHotSpares = 1;
                this.m_iMinDriveForRaidLevel = pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRAIDLevel_5();
                this.m_iNumRedundantDrives = 1;
                break;
            }
            case 5: {
                this.m_iNumHotSpares = 0;
                this.m_iMinDriveForRaidLevel = VivaldiStartupDialog.OEM_TYPE == 2561 ? 4 : (int)pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6();
                this.m_iNumRedundantDrives = 2;
                break;
            }
            case 6: {
                this.m_iNumHotSpares = 1;
                this.m_iMinDriveForRaidLevel = VivaldiStartupDialog.OEM_TYPE == 2561 ? 4 : (int)pdsForRaidLevels_MR_CTRL_INFO2.getMinPdRaidLevel_6();
                this.m_iNumRedundantDrives = 2;
                break;
            }
        }
    }

    private void assignHotSpare() {
        this.m_objHotSpareDrive = this.m_objPhysicalDriveHelpers.get(this.m_iNumDrives - 1);
    }

    private void createPDListForDriveGroup(int n) {
        this.m_objPDListForDriveGroup = new ArrayList<PhysicalDriveHelper>(this.m_objPhysicalDriveHelpers.subList(0, n));
    }

    private int getMaxDrivesForRAIDLevel(int n) {
        pdsForRaidLevels_MR_CTRL_INFO pdsForRaidLevels_MR_CTRL_INFO2 = this.m_objAdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        switch (n) {
            case 0: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_0();
            }
            case 1: {
                if (this.m_objAdapterHelper.treatRAID1EasRAID10() || this.m_objAdapterHelper.isSWRController()) {
                    return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1();
                }
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1E();
            }
            case 2: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1E() + 1;
            }
            case 3: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_5();
            }
            case 4: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_5() + 1;
            }
            case 5: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRaidLevel_6();
            }
            case 6: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRaidLevel_6() + 1;
            }
            case 7: 
            case 8: {
                return pdsForRaidLevels_MR_CTRL_INFO2.getMaxPdRAIDLevel_1E();
            }
        }
        return 0;
    }
}

