/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.venus.configuration.simple.PDSubgroup;
import GUI.venus.configuration.simple.PDsAndHotspareForDG;
import Services.KernelConstants;

public class SGRAIDParams {
    private PDSubgroup m_objSubgroup;
    private int m_iRAIDLevel = 0;
    private int m_iNumVDs = 0;
    private long m_lCapacity = 0L;
    private PDsAndHotspareForDG m_objPDsAndHotSpare = null;

    public SGRAIDParams(PDSubgroup pDSubgroup, int n, int n2, long l, PDsAndHotspareForDG pDsAndHotspareForDG) {
        this.m_objSubgroup = pDSubgroup;
        this.m_iRAIDLevel = n;
        this.m_iNumVDs = n2;
        this.m_lCapacity = l;
        this.m_objPDsAndHotSpare = pDsAndHotspareForDG;
    }

    public PDSubgroup getSubgroup() {
        return this.m_objSubgroup;
    }

    public int getRAIDLevel() {
        return this.m_iRAIDLevel;
    }

    public int getNumVirtualDrives() {
        return this.m_iNumVDs;
    }

    public long getCapacity() {
        return this.m_lCapacity;
    }

    public PDsAndHotspareForDG getPDSAndHotSpare() {
        return this.m_objPDsAndHotSpare;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nSG, RAIDLevel, Number of VDs, Capacity And PD List+HotSpare \n");
        stringBuffer.append(this.getSubgroup().toString());
        stringBuffer.append("RAID Level = ").append(this.getRAIDLevel());
        stringBuffer.append("Number of VDs = ").append(this.getNumVirtualDrives());
        stringBuffer.append("Capacity = ").append(KernelConstants.getConvertedSize(this.getCapacity()));
        stringBuffer.append(this.m_objPDsAndHotSpare.toString()).append("\n");
        return stringBuffer.toString().toUpperCase();
    }
}

